<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>S14 U</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" type="image/x-icon" href="favicon.png" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/perfect-scrollbar.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/asiel.css" />

    <link rel="stylesheet" href="assets/css/highlight.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="css/bootstrap.css" />

    <link defer rel="stylesheet" type="text/css" media="screen" href="assets/css/animate.css" />
    <script src="assets/js/perfect-scrollbar.min.js"></script>
    <script src="js/bootstrap.js"></script>

    <script defer src="assets/js/popper.min.js"></script>
    <script defer src="assets/js/tippy-bundle.umd.min.js"></script>
    <script defer src="assets/js/sweetalert.min.js"></script>


</head>

<body x-data="main" class="relative overflow-x-hidden font-nunito text-sm font-normal antialiased" :class="[ $store.app.sidebar ? 'toggle-sidebar' : '', $store.app.theme === 'dark' || $store.app.isDarkMode ?  'dark' : '', $store.app.menu, $store.app.layout,$store.app.rtlClass]">
    <?php
    include_once('api/adminFacturas.php');
    $adminFacturas = new AdministradorFormasPago();
    if (isset($_GET['busqueda'])) {
        $facturas = $adminFacturas->dameFacturasBusqueda($_GET['busqueda']);
    } else if (isset($_GET['not'])) {
        $facturas = $adminFacturas->dameFacturasSinTimbrar();
    } else {
        $facturas = $adminFacturas->dameFacturas();
    }

    function fechaComoCadenaFacturas($fecha)
    {
        $dia = substr($fecha, 8, 2);
        $mes = substr($fecha, 5, 2);
        $anio = substr($fecha, 0, 4);

        switch ($mes) {
            case "01":
                $mes = 'Enero';
                break;
            case "02":
                $mes = 'Febrero';
                break;
            case "03":
                $mes = 'Marzo';
                break;
            case  "04":
                $mes = 'Abril';
                break;
            case "05":
                $mes = 'Mayo';
                break;
            case "06":
                $mes = 'Junio';
                break;
            case "07":
                $mes = 'Julio';
                break;
            case "08":
                $mes = 'Agosto';
                break;
            case "09":
                $mes = 'Septiembre';
                break;
            case "10":
                $mes = 'Octubre';
                break;
            case "11":
                $mes = 'Noviembre';
                break;
            case "12":
                $mes = 'Diciembre';
                break;
            default:
                $mes = "NA";
                $dia = "NA";
                $anio = "NA";
        }
        return $dia . '/' . $mes . '/' . $anio;
    }

    ?>

    <!-- sidebar menu overlay -->
    <div x-cloak class="fixed inset-0 z-50 bg-[black]/60 lg:hidden" :class="{'hidden' : !$store.app.sidebar}" @click="$store.app.toggleSidebar()"></div>

    <!-- screen loader -->
    <div class="screen_loader animate__animated fixed inset-0 z-[60] grid place-content-center bg-[#fafafa] dark:bg-[#060818]">
        <div class="containerL">
            <div class="item item-1"></div>
            <div class="item item-2"></div>
            <div class="item item-3"></div>
            <div class="item item-4"></div>
        </div>
    </div>

    <!-- scroll to top button -->
    <div class="fixed bottom-6 z-50 ltr:right-6 rtl:left-6" x-data="scrollToTop">
        <template x-if="showTopButton">
            <button type="button" class="btn btn-outline-primary animate-pulse rounded-full bg-[#fafafa] p-2 dark:bg-[#060818] dark:hover:bg-primary" @click="goToTop">
                <svg width="24" height="24" class="h-4 w-4" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd" d="M12 20.75C12.4142 20.75 12.75 20.4142 12.75 20L12.75 10.75L11.25 10.75L11.25 20C11.25 20.4142 11.5858 20.75 12 20.75Z" fill="currentColor" />
                    <path d="M6.00002 10.75C5.69667 10.75 5.4232 10.5673 5.30711 10.287C5.19103 10.0068 5.25519 9.68417 5.46969 9.46967L11.4697 3.46967C11.6103 3.32902 11.8011 3.25 12 3.25C12.1989 3.25 12.3897 3.32902 12.5304 3.46967L18.5304 9.46967C18.7449 9.68417 18.809 10.0068 18.6929 10.287C18.5768 10.5673 18.3034 10.75 18 10.75L6.00002 10.75Z" fill="currentColor" />
                </svg>
            </button>
        </template>
    </div>

    <!-- start theme customizer section -->
    <?php include "template/header.php" ?>
    <!-- end theme customizer section -->

    <div class="main-container min-h-screen text-black dark:text-white-dark" :class="[$store.app.navbar]">
        <!-- start sidebar section -->
        <?php include "template/barra.php" ?>
        <!-- end sidebar section -->

        <div class="main-content flex flex-col min-h-screen">
            <!-- start header section -->
            <?php include "template/barra_sup.php" ?>

            <!-- end header section -->

            <div class="animate__animated p-6" :class="[$store.app.animation]">
                <!-- start main content section -->

                <div x-data="striped">

                    <h5 class="">Lista de facturas</h5>

                    <div class="panel mt-6">
                        <div class="md:absolute md:top-5 ltr:md:left-5 rtl:md:right-5">
                            <div class="mb-5 flex items-center gap-2">

                                <a href="fac-facturacion.php" class="btn btn-primary gap-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5">
                                        <line x1="12" y1="5" x2="12" y2="19"></line>
                                        <line x1="5" y1="12" x2="19" y2="12"></line>
                                    </svg>
                                    Nueva Factura
                                </a>
                                <a href="fac-facturas.php?not=si" class="btn btn-warning gap-2">
                                    <svg width="24" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M18 8.80745C18 13.7615 13.7333 15 11.6 15C9.73333 15 6 13.7615 6 8.80745C6 6.71017 7.20839 5.35826 8.26099 4.65274C8.79638 4.29388 9.48354 4.55201 9.57296 5.17624C9.75127 6.421 10.8777 7.34944 11.5596 6.27998C12.1424 5.36614 12.3529 4.13169 12.3529 3.38896C12.3529 2.28965 13.503 1.59108 14.4009 2.2646C16.1512 3.5774 18 5.776 18 8.80745Z" stroke="currentColor" stroke-width="1.5"></path>
                                        <path d="M20 15L4 22" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M4 15L9 17.1875M20 22L14.5 19.5938" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M15 10C14.8 10.6667 13.92 12 12 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    </svg>
                                    Facturas sin timbrar (<?php echo $adminFacturas->cuentaFacturasSinTimbrar() ?>)
                                </a>
                            </div>
                        </div>

                        <table id="tableStripe" class="table-striped">

                            <thead>
                                <tr>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">ID Factura</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">Folio Interno</th>


                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">Metodo de Pago</th>

                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="1">Forma de Pago</th>

                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="2">Empresa que factura</th>

                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="3">Total con IVA</th>

                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="4">Estatus de pago</th>

                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="5">Cliente</th>

                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Fecha de Timbrado</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Folio Fiscal</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">RFC</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist" hidden>FFF</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php

                                foreach ($facturas as $factura) {
                                    echo '<tr style="height: 100px;">';
                                    echo '<td  onclick="detonarModal(' . $factura->id . ', ' . "'" . $factura->token . "'" .  ')">' . $factura->id . '</td>';
                                    echo '<td>' . $factura->folio . "-" . $factura->serie . '</td>';

                                    echo '<td>' . $factura->metodo_pago_nombre . '</td>';
                                    echo '<td>' . $factura->forma_pago_nombre . '</td>';
                                    echo '<td>' . $factura->empresa_nombre . '</td>';
                                    echo '<td>$' . number_format($factura->total_iva, 2)  . '</td>';
                                    echo '<td>' . $factura->status_pago . '</td>';
                                    echo '<td>' . $factura->cliente . '</td>';
                                    echo '<td>' . $factura->fecha_timbrado . '</td>';
                                    echo '<td>' . $factura->uuid . '</td>';
                                    echo '<td>' . $factura->empresa_rfc . '</td>';
                                    echo '<td hidden>' . fechaComoCadenaFacturas($factura->fecha_timbrado)  . '</td>';
                                    echo '</tr>';
                                }

                                ?>

                            </tbody>

                        </table>
                    </div>


                </div>
                <!-- end main content section -->

            </div>

            <div class="modal fade fixed inset-0 bg-[black]/60 z-[999]" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content justify-center">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">FACTURA <strong id="tituloModal"></strong></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body" style="height: 400px;">



                            <div id="espacioIframe">

                            </div>


                        </div>
                        <div class="modal-footer">
                            <div style="text-align: center;" id="espacioBotones">




                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- start footer section -->
            <div class="p-6 pt-0 mt-auto text-center dark:text-white-dark ltr:sm:text-left rtl:sm:text-right">
                © <span id="footer-year">2022</span>. Sistema 14 Ultra All rights reserved.
            </div>
            <!-- end footer section -->
        </div>
    </div>

    <script src="assets/js/highlight.min.js"></script>
    <script src="assets/js/alpine-collaspe.min.js"></script>
    <script src="assets/js/alpine-persist.min.js"></script>
    <script defer src="assets/js/alpine-ui.min.js"></script>
    <script defer src="assets/js/alpine-focus.min.js"></script>
    <script defer src="assets/js/alpine.min.js"></script>
    <script src="assets/js/custom.js"></script>
    <script src="assets/js/simple-datatables.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.7/dist/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.3.1/dist/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
    <script>
        function detonarModal(id, token) {
            $("#exampleModal").modal();
            document.getElementById("tituloModal").innerHTML = id;
            document.getElementById("espacioIframe").innerHTML = '<iframe src="https://sistema14.com/api/genera_factura.php?token=' + token + '&per=' + id + '"  style="height: 350px;" class="embed-responsive-item" width="100%"></iframe>';
            document.getElementById("espacioBotones").innerHTML = `
                                        <div class="grid grid-cols-1 gap-2 md:grid-cols-3 lg:grid-cols-4">
                                            <a onclick="favorito(${id}, ${<?php echo $_SESSION["usuario_id"] ?>})" class="btn btn-medium btn-primary"> Favorito </a>
                                            <a class="btn btn-medium btn-primary"><i class="fa fa-pencil" style="color:#fff;">Editar</i></a>
                                            <a href="https://old.sistema14.com/genera_factura.php?token=${token}&per=${id}" class="btn btn-medium btn-danger msgbox-inverse" alt="35704" style="color:#fff !important;" target="_blank"><i class="fa fa-file-pdf-o" style="color:#fff;">Ver PDF</i></a>
                                            <a onclick="facturarApi(${id})" class="btn btn-medium btn-default"><i class="fa fa-file" style="color:#000;">Facturar</i></a>

                                        </div>
                                        <br>
                                        <div class="grid grid-cols-1 gap-2 md:grid-cols-3 lg:grid-cols-4">
                                            <a class="btn btn-medium" data-toggle="modal" data-target=".pdf35704">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                <path d="M14.666 8.334v3.666l1.463-2.215-1.463-1.451zm-3.092 4.167c.66-.384 1.242-.864 1.758-1.447v1.369c-.445.393-.926.731-1.449 1.018l-.309-.94zm-3.255 2.041c-.652.083-1.57.125-2.319.125v-.97c.688 0 1.551-.037 2.152-.113l.167.958zm2.789-.725l-.036.015c-.586.246-1.22.437-1.91.573l-.167-.958c.655-.131 1.257-.315 1.809-.556l.304.926zm10.892-13.817l-3 11-4.064-3.62 3.9-4.117-5.229 3.614-3.607-.877 12-6zm-3.015 14.779c0 4.546-5.777 9.221-8.221 9.221h-8.764v-22h11.527l-4 2h-5.527v18h5.938c4.155 0 2.638-6 2.638-6 3.349.921 6.003.403 6.003-3.21.28.65.406 1.318.406 1.989z"></path>
                                            </svg>
                                            </a>
                                            <a href="https://sistema14.com/api/xml/firmados/XML-factura-${id}.xml" class="btn btn-medium btn-success msgbox-inverse" alt="35704" style="color:#fff !important;" target="_blank">XML</a>
                                            <a onclick="reenviar('${id}')" class="btn btn-medium btn-success msgbox-inverse" alt="35704" style="color:#fff !important;" target="_blank">REENVIAR</a>
                                            <a href="" class="btn btn-medium btn-danger msgbox-inverse" style="color:#fff !important;" target="_blank">CANCELAR</a>

                                        </div>
                                        <br>
                                        <div class="grid grid-cols-1 gap-2 md:grid-cols-3 lg:grid-cols-4">
                                        <a onclick="eliminaFactura(${id})" class="btn btn-medium btn-danger"><i class="fa fa-trash" style="color:#fff;">Eliminar</i></a>
                                        <a href="fac-conta-rep.php?id=${id}" class="btn btn-medium btn-danger"><i class="fa fa-trash" style="color:#fff;">Pagos relacionados</i></a>

                                        </div>



                   

                    
      
`;

        }
    </script>



    <script>
        function reenviar(factura) {

            var reenvio = new FormData();
            reenvio.append("accion", "reenviar");
            reenvio.append("id", factura);
            fetch("api/apiFactura.php", {
                    method: "POST",
                    body: reenvio,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    Swal.fire({
                        title: "Reenviado correctamente",
                        text: "La factura se reenvio correctamente",
                        icon: "susses",
                        confirmButtonText: 'Ok'
                    })

                });

        }
    </script>


    <script>
        function eliminaFactura(factura) {

            Swal.fire({
                title: '¿Estas seguro?',
                text: "¡No podras revertir esto!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Si, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    var formularioFavorito = new FormData();
                    formularioFavorito.append("accion", "eliminar");
                    formularioFavorito.append("factura", factura);
                    fetch("api/apiFactura.php", {
                            method: "POST",
                            body: formularioFavorito,
                        })
                        .then((respuesta) => respuesta.json())
                        .then((data) => {
                            console.log(data);
                            Swal.fire({
                                title: "Eliminado correctamente",
                                text: "La factura se elimino correctamente",
                                icon: "susses",
                                confirmButtonText: 'Ok'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    location.reload();
                                }
                            })

                        });

                } else {
                    Swal.fire({
                        title: "Cancelado",
                        text: "La factura no se elimino",
                        icon: "susses",
                        confirmButtonText: 'Ok'
                    })
                }
            })



        }
    </script>
    <script>
        function facturarApi(id) {
            console.log("Facturar API");
            var formularioFacturar = new FormData();
            formularioFacturar.append("accion", "facturar");
            formularioFacturar.append("id", id);
            formularioFacturar.append("usuario", <?php echo $_SESSION["usuario_id"] ?>);
            formularioFacturar.append("nota", "Agregado desde facturacion");

            fetch("api/apiFactura.php", {
                    method: "POST",
                    body: formularioFacturar,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    if (data.status == 'error') {
                        Swal.fire({
                            title: "Error",
                            text: "No se pudo facturar debido a " + data.message,
                            icon: "error",
                            confirmButtonText: 'Ok'
                        })
                    } else {
                        Swal.fire({
                            title: "Se facturo correctamente",
                            text: "Se facturo correctamente",
                            icon: "suscess",
                            confirmButtonText: 'Ok'
                        })
                    }


                }).catch(function(error) {
                    Swal.fire({
                        title: "Se facturo correctamente",
                        text: "Existieron errores al facturar (Logo empresa)",
                        icon: "suscess",
                        confirmButtonText: 'Ok'
                    })
                });

        }
    </script>
    <script>
        document.addEventListener('alpine:init', () => {
            // main section
            Alpine.data('scrollToTop', () => ({
                showTopButton: false,
                init() {
                    window.onscroll = () => {
                        this.scrollFunction();
                    };
                },

                scrollFunction() {
                    if (document.body.scrollTop > 50 || document.documentElement.scrollTop > 50) {
                        this.showTopButton = true;
                    } else {
                        this.showTopButton = false;
                    }
                },

                goToTop() {
                    document.body.scrollTop = 0;
                    document.documentElement.scrollTop = 0;
                },
            }));

            // theme customization
            Alpine.data('customizer', () => ({
                showCustomizer: false,
            }));

            // sidebar section
            Alpine.data('sidebar', () => ({
                init() {
                    const selector = document.querySelector('.sidebar ul a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.click();
                                });
                            }
                        }
                    }
                },
            }));

            // header section
            Alpine.data('header', () => ({
                init() {
                    const selector = document.querySelector('ul.horizontal-menu a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.classList.add('active');
                                });
                            }
                        }
                    }
                },

                notifications: [{
                        id: 1,
                        profile: 'user-profile.jpeg',
                        message: '<strong class="text-sm mr-1">John Doe</strong>invite you to <strong>Prototyping</strong>',
                        time: '45 min ago',
                    },
                    {
                        id: 2,
                        profile: 'profile-34.jpeg',
                        message: '<strong class="text-sm mr-1">Adam Nolan</strong>mentioned you to <strong>UX Basics</strong>',
                        time: '9h Ago',
                    },
                    {
                        id: 3,
                        profile: 'profile-16.jpeg',
                        message: '<strong class="text-sm mr-1">Anna Morgan</strong>Upload a file',
                        time: '9h Ago',
                    },
                ],

                messages: [{
                        id: 1,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-success-light dark:bg-success text-success dark:text-success-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg></span>',
                        title: 'Congratulations!',
                        message: 'Your OS has been updated.',
                        time: '1hr',
                    },
                    {
                        id: 2,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-info-light dark:bg-info text-info dark:text-info-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="16" x2="12" y2="12"></line><line x1="12" y1="8" x2="12.01" y2="8"></line></svg></span>',
                        title: 'Did you know?',
                        message: 'You can switch between artboards.',
                        time: '2hr',
                    },
                    {
                        id: 3,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-danger-light dark:bg-danger text-danger dark:text-danger-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg></span>',
                        title: 'Something went wrong!',
                        message: 'Send Reposrt',
                        time: '2days',
                    },
                    {
                        id: 4,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-warning-light dark:bg-warning text-warning dark:text-warning-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">    <circle cx="12" cy="12" r="10"></circle>    <line x1="12" y1="8" x2="12" y2="12"></line>    <line x1="12" y1="16" x2="12.01" y2="16"></line></svg></span>',
                        title: 'Warning',
                        message: 'Your password strength is low.',
                        time: '5days',
                    },
                ],

                languages: [{
                        id: 1,
                        key: 'Chinese',
                        value: 'zh',
                    },
                    {
                        id: 2,
                        key: 'Danish',
                        value: 'da',
                    },
                    {
                        id: 3,
                        key: 'English',
                        value: 'en',
                    },
                    {
                        id: 4,
                        key: 'French',
                        value: 'fr',
                    },
                    {
                        id: 5,
                        key: 'German',
                        value: 'de',
                    },
                    {
                        id: 6,
                        key: 'Greek',
                        value: 'el',
                    },
                    {
                        id: 7,
                        key: 'Hungarian',
                        value: 'hu',
                    },
                    {
                        id: 8,
                        key: 'Italian',
                        value: 'it',
                    },
                    {
                        id: 9,
                        key: 'Japanese',
                        value: 'ja',
                    },
                    {
                        id: 10,
                        key: 'Polish',
                        value: 'pl',
                    },
                    {
                        id: 11,
                        key: 'Portuguese',
                        value: 'pt',
                    },
                    {
                        id: 12,
                        key: 'Russian',
                        value: 'ru',
                    },
                    {
                        id: 13,
                        key: 'Spanish',
                        value: 'es',
                    },
                    {
                        id: 14,
                        key: 'Swedish',
                        value: 'sv',
                    },
                    {
                        id: 15,
                        key: 'Turkish',
                        value: 'tr',
                    },
                    {
                        id: 16,
                        key: 'Arabic',
                        value: 'ae',
                    },
                ],

                removeNotification(value) {
                    this.notifications = this.notifications.filter((d) => d.id !== value);
                },

                removeMessage(value) {
                    this.messages = this.messages.filter((d) => d.id !== value);
                },
            }));
            var tabla = null;
            Alpine.data('striped', () => ({
                init() {
                    const tableOptions = {
                        data: {

                        },
                        sortable: false,
                        searchable: true,
                        perPage: 10,
                        perPageSelect: [10, 20, 30, 50, 100],
                        firstLast: true,
                        firstText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M13 19L7 12L13 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.5" d="M16.9998 19L10.9998 12L16.9998 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        lastText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M11 19L17 12L11 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.5" d="M6.99976 19L12.9998 12L6.99976 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        prevText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M15 5L9 12L15 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        nextText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        labels: {
                            perPage: '{select}',
                        },
                        layout: {
                            top: '{search} <div class="flex items-center gap-2"> <button onclick="buscar()" type="button" class="btn btn-danger"> Búsqueda avanzada  </button> </div>',
                            bottom: '{info}{select}{pager}',
                        },


                    };
                    tabla = tableOptions;
                    const datatable1 = new simpleDatatables.DataTable('#tableStripe', tableOptions);
                    datatable1.on('datatable.init', function() {
                        //asignar id al buscador 
                        document.querySelector('.dataTable-input').id = 'buscador';
                    });

                },
            }));
        });
    </script>

    <script>
        function buscar() {
            var cadena = document.getElementById("buscador").value;
            //ir a pagina 
            window.location.href = "fac-facturas.php?busqueda=" + cadena;
        }
    </script>
</body>

</html>