<?php
include_once('../../conectorBDS14.php');

class Proveedor
{

  public $id;
  public $id_empresa;
  public $id_proveedor;
  public $porcentaje_sugerido;
  public $nombre_empresa;
  public $nombre_proveedor;

  public function __construct($id, $id_empresa, $id_proveedor, $porcentaje_sugerido, $nombre_empresa, $nombre_proveedor)
  {
    $this->id = $id;
    $this->id_empresa = $id_empresa;
    $this->id_proveedor = $id_proveedor;
    $this->porcentaje_sugerido = $porcentaje_sugerido;
    $this->nombre_empresa = $nombre_empresa;
    $this->nombre_proveedor = $nombre_proveedor;
  }
}


class ReporteEmpresa
{
  public $id_empresa;
  public $empresa;
  public $id_clave;
  public $razon_social;
  public $total;

  public function __construct($id_empresa, $empresa, $id_clave, $razon_social, $total)
  {
    $this->id_empresa = $id_empresa;
    $this->empresa = $empresa;
    $this->id_clave = $id_clave;
    $this->razon_social = $razon_social;
    $this->total = $total;
  }
}

class ReporteCalculadora{
  public $empresa;
  public $proveedor;
  public $porcentaje;
  public $total;
  public $porcentaje_calculado;


  public function __construct($empresa, $proveedor, $porcentaje, $total)
  {
    $this->empresa = $empresa;
    $this->proveedor = $proveedor;
    $this->porcentaje = $porcentaje;
    $this->total = $total;
  }
}


class AdministradorProveedores extends conectorS14
{



  public function dameCalculadora($empresa, $monto){
    $unoPorciento = $monto * 0.01;
    $sql = "select claves_cortas.razon_social, empresas.razon, proveedores_14.porcentaje_sugerido from proveedores_14
    left join claves_cortas on claves_cortas.id = proveedores_14.id_empresa
    left join empresas on empresas.id = proveedores_14.id_proveedor
    where claves_cortas.rfc = '$empresa'
    order by proveedores_14.porcentaje_sugerido asc;";
    $resultado = $this->ejecutar($sql);
    $reporte = array();
    while ($fila = $resultado->fetch_assoc()) {
      $factor = rand(1, 30) ;
      $unoPorcientoPorcentaje = $fila['porcentaje_sugerido'] * 0.01;
      $factor = $factor * $unoPorcientoPorcentaje;
      $masMenos = rand(0, 1);
      $reporteEmpresa = new ReporteCalculadora($fila['razon_social'], $fila['razon'], $fila['porcentaje_sugerido'], 0);
      if($masMenos == 0){
        $reporteEmpresa->total = $unoPorciento * ($reporteEmpresa->porcentaje - $factor);
        $reporteEmpresa->porcentaje_calculado = -$factor + $reporteEmpresa->porcentaje;
      }
      else{
        $reporteEmpresa->total = $unoPorciento * ($reporteEmpresa->porcentaje + $factor);
        $reporteEmpresa->porcentaje_calculado = $factor + $reporteEmpresa->porcentaje;
      }


      if($reporteEmpresa->total > 1000){
        $frand = rand(1, 10);
        $porcentajeFrand = $frand / $unoPorciento;
        $reporteEmpresa->total += $frand;
        $reporteEmpresa->porcentaje_calculado += $porcentajeFrand;

      }
      else if($reporteEmpresa->total < 10000){
        $frand = rand(1, 1000);
        $porcentajeFrand = $frand / $unoPorciento;
        $reporteEmpresa->total += $frand; 
        $reporteEmpresa->porcentaje_calculado += $porcentajeFrand;

      }
      else if($reporteEmpresa->total < 100000){
        $frand = rand(1, 10000);
        $porcentajeFrand = $frand / $unoPorciento;
        $reporteEmpresa->total += $frand;
        $reporteEmpresa->porcentaje_calculado += $porcentajeFrand;

      }
      else if($reporteEmpresa->total < 1000000){
        $frand = rand(1, 100000);
        $porcentajeFrand = $frand / $unoPorciento;
        $reporteEmpresa->total += $frand;
        $reporteEmpresa->porcentaje_calculado += $porcentajeFrand;
      }

      $centavos = rand(0, 99);
      $reporteEmpresa->total = $reporteEmpresa->total + ($centavos * 0.01);



      array_push($reporte, $reporteEmpresa);
    }
    return $reporte;
  }

  public function dameReporte($empresa){
    $lunesAnterior = date('Y-m-d', strtotime('last monday'));
    $viernesSiguiente = date('Y-m-d', strtotime('next friday'));
    $sql = "SELECT cl.id as id_empresa, cl.razon_social, e.id as id_proveedor, e.razon,  SUM(f.total_iva) as total FROM claves_cortas cl
    left join facturas f on f.id_clave_corta = cl.id
    left join empresas e on f.razon = e.id
    where cl.rfc= '$empresa' and f.metodo_pago = 1 and f.fecha BETWEEN '$lunesAnterior' AND '$viernesSiguiente'
    GROUP by e.id;";
    //echo $sql;
    $resultado = $this->ejecutar($sql);
    $reporte = array();
    while ($fila = $resultado->fetch_assoc()) {
      $reporteEmpresa = new ReporteEmpresa($fila['id_empresa'], $fila['razon_social'],  $fila['id_proveedor'], $fila['razon'], $fila['total']);
      array_push($reporte, $reporteEmpresa);
    }
    return $reporte;
  }

  public function dameProveedorE($empresa, $proveedor){
      $query = "select * from proveedores_14 where id_empresa = $empresa and id_proveedor = $proveedor;";
      $resultado = $this->ejecutar($query);
      $fila = $resultado->fetch_assoc();
      $proveedor = new Proveedor($fila['id'], $fila['id_empresa'], $fila['id_proveedor'], $fila['porcentaje_sugerido'], $fila['nombre_empresa'], $fila['nombre_proveedor']);
      return $proveedor;
  }

  public function dameSumaReporte($empresa){
    $lunesAnterior = date('Y-m-d', strtotime('last monday'));
    $viernesSiguiente = date('Y-m-d', strtotime('next friday'));
    $sql = "SELECT SUM(f.total_iva) as total FROM claves_cortas cl
    left join facturas f on f.id_clave_corta = cl.id
    left join empresas e on f.razon = e.id
    where cl.rfc= '$empresa' and f.metodo_pago = 1  and f.fecha BETWEEN '$lunesAnterior' AND '$viernesSiguiente';";
    $resultado = $this->ejecutar($sql);
    $fila = $resultado->fetch_assoc();
    return $fila['total'];
  }


  public function dameProveedores()
  {
    $query = "select proveedores_14.id, proveedores_14.id_empresa, proveedores_14.id_proveedor, proveedores_14.porcentaje_sugerido, claves_cortas.razon_social as nombre_empresa, empresas.razon as nombre_proveedor from proveedores_14
    left join claves_cortas on proveedores_14.id_empresa = claves_cortas.id
    left join empresas on empresas.id = proveedores_14.id_proveedor;";
    $resultado = $this->ejecutar($query);
    $proveedores = array();
    while ($fila = $resultado->fetch_assoc()) {
      $proveedor = new Proveedor($fila['id'], $fila['id_empresa'], $fila['id_proveedor'], $fila['porcentaje_sugerido'], $fila['nombre_empresa'], $fila['nombre_proveedor']);
      array_push($proveedores, $proveedor);
    }
    return $proveedores;
  }

  public function dameProveedor($id)
  {
    $query = "SELECT * FROM proveedores_14 WHERE id = $id";
    $resultado = $this->ejecutar($query);
    $fila = $resultado->fetch_assoc();
    $proveedor = new Proveedor($fila['id'], $fila['id_empresa'], $fila['id_proveedor'], $fila['porcentaje_sugerido'], $fila['nombre_empresa'], $fila['nombre_proveedor']);
    return $proveedor;
  }

  public function creaProveedor($id_empresa, $id_proveedor, $porcentaje_sugerido)
  {
    $query = "INSERT INTO proveedores_14 (id_empresa, id_proveedor, porcentaje_sugerido) VALUES ('$id_empresa', '$id_proveedor', '$porcentaje_sugerido')";
    $resultado = $this->ejecutar($query);
    //echo $query;

    return $resultado;
  }

  public function eliminarProveedor($id)
  {
    $query = "DELETE FROM proveedores_14 WHERE id = $id;";
    $resultado = $this->ejecutar($query);
    //echo $query;
    return $resultado;
  }

  public function actualizarProveedor($id, $id_empresa, $id_proveedor, $porcentaje_sugerido)
  {
    $query = "UPDATE proveedores_14 SET id_empresa = $id_empresa, id_proveedor = $id_proveedor, porcentaje_sugerido = $porcentaje_sugerido WHERE id = $id";
    $resultado = $this->ejecutar($query);
    return $resultado;
  }
}
