<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Perfil</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" type="image/x-icon" href="favicon.png" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/perfect-scrollbar.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/asiel.css" />

    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css" />
    <link defer rel="stylesheet" type="text/css" media="screen" href="assets/css/animate.css" />
    <script src="assets/js/perfect-scrollbar.min.js"></script>
    <script defer src="assets/js/popper.min.js"></script>
    <script defer src="assets/js/tippy-bundle.umd.min.js"></script>
    <script defer src="assets/js/sweetalert.min.js"></script>
</head>

<body x-data="main" class="relative overflow-x-hidden font-nunito text-sm font-normal antialiased" :class="[ $store.app.sidebar ? 'toggle-sidebar' : '', $store.app.theme === 'dark' || $store.app.isDarkMode ?  'dark' : '', $store.app.menu, $store.app.layout,$store.app.rtlClass]">
    <?php

    session_start();
    include_once('api/adminUsuarios.php');
    $admin = new AdministradorUsuario();
    $usuario = $admin->dameUsuarioId($_SESSION["usuario_id"]);
    $facturas = $admin->cuentaFacturas($usuario->id);
    $totalFac = $admin->cuentaFacturasTotales();
    $porcentaje = ($facturas * 100) / $totalFac;
    $totalAsignados = $admin->cuentaAsignadosTotales();
    $asignados = $admin->cuentaAsignados($usuario->id);
    $porcentajeAsignados = ($asignados * 100) / $totalAsignados;

    ?>
    <!-- sidebar menu overlay -->
    <div x-cloak class="fixed inset-0 z-50 bg-[black]/60 lg:hidden" :class="{'hidden' : !$store.app.sidebar}" @click="$store.app.toggleSidebar()"></div>

    <!-- screen loader -->
    <div class="screen_loader animate__animated fixed inset-0 z-[60] grid place-content-center bg-[#fafafa] dark:bg-[#060818]">
        <div class="containerL">
            <div class="item item-1"></div>
            <div class="item item-2"></div>
            <div class="item item-3"></div>
            <div class="item item-4"></div>
        </div>
    </div>

    <!-- scroll to top button -->
    <div class="fixed bottom-6 z-50 ltr:right-6 rtl:left-6" x-data="scrollToTop">
        <template x-if="showTopButton">
            <button type="button" class="btn btn-outline-primary animate-pulse rounded-full bg-[#fafafa] p-2 dark:bg-[#060818] dark:hover:bg-primary" @click="goToTop">
                <svg width="24" height="24" class="h-4 w-4" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd" d="M12 20.75C12.4142 20.75 12.75 20.4142 12.75 20L12.75 10.75L11.25 10.75L11.25 20C11.25 20.4142 11.5858 20.75 12 20.75Z" fill="currentColor" />
                    <path d="M6.00002 10.75C5.69667 10.75 5.4232 10.5673 5.30711 10.287C5.19103 10.0068 5.25519 9.68417 5.46969 9.46967L11.4697 3.46967C11.6103 3.32902 11.8011 3.25 12 3.25C12.1989 3.25 12.3897 3.32902 12.5304 3.46967L18.5304 9.46967C18.7449 9.68417 18.809 10.0068 18.6929 10.287C18.5768 10.5673 18.3034 10.75 18 10.75L6.00002 10.75Z" fill="currentColor" />
                </svg>
            </button>
        </template>
    </div>

    <!-- start theme customizer section -->
    <?php include "template/header.php" ?>

    <!-- end theme customizer section -->

    <div class="main-container min-h-screen text-black dark:text-white-dark" :class="[$store.app.navbar]">
        <!-- start sidebar section -->
        <?php include "template/barra.php" ?>

        <!-- end sidebar section -->

        <div class="main-content flex flex-col min-h-screen">
            <!-- start header section -->
            <?php include "template/barra_sup.php" ?>

            <!-- end header section -->

            <div class="animate__animated p-6" :class="[$store.app.animation]">
                <!-- start main content section -->
                <div>
                    <ul class="flex space-x-2 rtl:space-x-reverse">
                        <li>
                            <a href="javascript:;" class="text-primary hover:underline">Users</a>
                        </li>
                        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                            <span>Profile</span>
                        </li>
                    </ul>
                    <div class="pt-5">
                        <div class="mb-5 grid grid-cols-1 gap-5 lg:grid-cols-3 xl:grid-cols-4">
                            <div class="panel">
                                <div class="mb-5 flex items-center justify-between">
                                    <h5 class="text-lg font-semibold dark:text-white-light">Perfil de <?php echo $usuario->nombre ?></h5>

                                </div>
                                <div class="mb-5">
                                    <div class="flex flex-col items-center justify-center">
                                        <img src="<?php echo $usuario->imagen ?>" alt="image" class="mb-5 h-24 w-24 rounded-full object-cover" />
                                        <p class="text-xl font-semibold text-primary"><?php echo $usuario->nombre ?></p>
                                    </div>
                                    <ul class="m-auto mt-5 flex max-w-[160px] flex-col space-y-4 font-semibold text-white-dark">
                                        <li class="flex items-center gap-2">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0">
                                                <path d="M2.3153 12.6978C2.26536 12.2706 2.2404 12.057 2.2509 11.8809C2.30599 10.9577 2.98677 10.1928 3.89725 10.0309C4.07094 10 4.286 10 4.71612 10H15.2838C15.7139 10 15.929 10 16.1027 10.0309C17.0132 10.1928 17.694 10.9577 17.749 11.8809C17.7595 12.057 17.7346 12.2706 17.6846 12.6978L17.284 16.1258C17.1031 17.6729 16.2764 19.0714 15.0081 19.9757C14.0736 20.6419 12.9546 21 11.8069 21H8.19303C7.04537 21 5.9263 20.6419 4.99182 19.9757C3.72352 19.0714 2.89681 17.6729 2.71598 16.1258L2.3153 12.6978Z" stroke="currentColor" stroke-width="1.5" />
                                                <path opacity="0.5" d="M17 17H19C20.6569 17 22 15.6569 22 14C22 12.3431 20.6569 11 19 11H17.5" stroke="currentColor" stroke-width="1.5" />
                                                <path opacity="0.5" d="M10.0002 2C9.44787 2.55228 9.44787 3.44772 10.0002 4C10.5524 4.55228 10.5524 5.44772 10.0002 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M4.99994 7.5L5.11605 7.38388C5.62322 6.87671 5.68028 6.0738 5.24994 5.5C4.81959 4.9262 4.87665 4.12329 5.38382 3.61612L5.49994 3.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M14.4999 7.5L14.6161 7.38388C15.1232 6.87671 15.1803 6.0738 14.7499 5.5C14.3196 4.9262 14.3767 4.12329 14.8838 3.61612L14.9999 3.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                            </svg>
                                            <?php echo $usuario->tipoUsuario ?>
                                        </li>

                                        <li class="flex items-center gap-2">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0">
                                                <path opacity="0.5" d="M4 10.1433C4 5.64588 7.58172 2 12 2C16.4183 2 20 5.64588 20 10.1433C20 14.6055 17.4467 19.8124 13.4629 21.6744C12.5343 22.1085 11.4657 22.1085 10.5371 21.6744C6.55332 19.8124 4 14.6055 4 10.1433Z" stroke="currentColor" stroke-width="1.5" />
                                                <circle cx="12" cy="10" r="3" stroke="currentColor" stroke-width="1.5" />
                                            </svg>
                                            <?php echo $usuario->ciudad ?>
                                        </li>
                                        <li>
                                            <a href="javascript:;" class="flex items-center gap-2">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0">
                                                    <path opacity="0.5" d="M2 12C2 8.22876 2 6.34315 3.17157 5.17157C4.34315 4 6.22876 4 10 4H14C17.7712 4 19.6569 4 20.8284 5.17157C22 6.34315 22 8.22876 22 12C22 15.7712 22 17.6569 20.8284 18.8284C19.6569 20 17.7712 20 14 20H10C6.22876 20 4.34315 20 3.17157 18.8284C2 17.6569 2 15.7712 2 12Z" stroke="currentColor" stroke-width="1.5" />
                                                    <path d="M6 8L8.1589 9.79908C9.99553 11.3296 10.9139 12.0949 12 12.0949C13.0861 12.0949 14.0045 11.3296 15.8411 9.79908L18 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                                </svg>
                                                <span class="truncate text-primary"><?php echo $usuario->email ?></span></a>
                                        </li>
                                        <li class="flex items-center gap-2">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5">
                                                <path d="M16.1007 13.359L16.5562 12.9062C17.1858 12.2801 18.1672 12.1515 18.9728 12.5894L20.8833 13.628C22.1102 14.2949 22.3806 15.9295 21.4217 16.883L20.0011 18.2954C19.6399 18.6546 19.1917 18.9171 18.6763 18.9651M4.00289 5.74561C3.96765 5.12559 4.25823 4.56668 4.69185 4.13552L6.26145 2.57483C7.13596 1.70529 8.61028 1.83992 9.37326 2.85908L10.6342 4.54348C11.2507 5.36691 11.1841 6.49484 10.4775 7.19738L10.1907 7.48257" stroke="currentColor" stroke-width="1.5" />
                                                <path opacity="0.5" d="M18.6763 18.9651C17.0469 19.117 13.0622 18.9492 8.8154 14.7266C4.81076 10.7447 4.09308 7.33182 4.00293 5.74561" stroke="currentColor" stroke-width="1.5" />
                                                <path opacity="0.5" d="M16.1007 13.3589C16.1007 13.3589 15.0181 14.4353 12.0631 11.4971C9.10807 8.55886 10.1907 7.48242 10.1907 7.48242" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                            </svg>
                                            <span class="whitespace-nowrap" dir="ltr"><?php echo $usuario->telefono ?></span>
                                        </li>
                                    </ul>

                                </div>
                            </div>
                            <!-- <div class="panel lg:col-span-2 xl:col-span-3">
                                <div class="mb-5">
                                    <h5 class="text-lg font-semibold dark:text-white-light">Task</h5>
                                </div>
                                <div class="mb-5">
                                    <div class="table-responsive font-semibold text-[#515365] dark:text-white-light">
                                        <table class="whitespace-nowrap">
                                            <thead>
                                                <tr>
                                                    <th>Projects</th>
                                                    <th>Progress</th>
                                                    <th>Task Done</th>
                                                    <th class="text-center">Time</th>
                                                </tr>
                                            </thead>
                                            <tbody class="dark:text-white-dark">
                                                <tr>
                                                    <td>Figma Design</td>
                                                    <td>
                                                        <div class="flex h-1.5 w-full rounded-full bg-[#ebedf2] dark:bg-dark/40">
                                                            <div class="w-[29.56%] rounded-full bg-danger"></div>
                                                        </div>
                                                    </td>
                                                    <td class="text-danger">29.56%</td>
                                                    <td class="text-center">2 mins ago</td>
                                                </tr>
                                                <tr>
                                                    <td>Vue Migration</td>
                                                    <td>
                                                        <div class="flex h-1.5 w-full rounded-full bg-[#ebedf2] dark:bg-dark/40">
                                                            <div class="w-1/2 rounded-full bg-info"></div>
                                                        </div>
                                                    </td>
                                                    <td class="text-success">50%</td>
                                                    <td class="text-center">4 hrs ago</td>
                                                </tr>
                                                <tr>
                                                    <td>Flutter App</td>
                                                    <td>
                                                        <div class="flex h-1.5 w-full rounded-full bg-[#ebedf2] dark:bg-dark/40">
                                                            <div class="w-[39%] rounded-full bg-warning"></div>
                                                        </div>
                                                    </td>
                                                    <td class="text-danger">39%</td>
                                                    <td class="text-center">a min ago</td>
                                                </tr>
                                                <tr>
                                                    <td>API Integration</td>
                                                    <td>
                                                        <div class="flex h-1.5 w-full rounded-full bg-[#ebedf2] dark:bg-dark/40">
                                                            <div class="w-[78.03%] rounded-full bg-success"></div>
                                                        </div>
                                                    </td>
                                                    <td class="text-success">78.03%</td>
                                                    <td class="text-center">2 weeks ago</td>
                                                </tr>

                                                <tr>
                                                    <td>Blog Update</td>
                                                    <td>
                                                        <div class="flex h-1.5 w-full rounded-full bg-[#ebedf2] dark:bg-dark/40">
                                                            <div class="w-full rounded-full bg-secondary"></div>
                                                        </div>
                                                    </td>
                                                    <td class="text-success">100%</td>
                                                    <td class="text-center">18 hrs ago</td>
                                                </tr>
                                                <tr>
                                                    <td>Landing Page</td>
                                                    <td>
                                                        <div class="flex h-1.5 w-full rounded-full bg-[#ebedf2] dark:bg-dark/40">
                                                            <div class="w-[19.15%] rounded-full bg-danger"></div>
                                                        </div>
                                                    </td>
                                                    <td class="text-danger">19.15%</td>
                                                    <td class="text-center">5 days ago</td>
                                                </tr>
                                                <tr>
                                                    <td>Shopify Dev</td>
                                                    <td>
                                                        <div class="flex h-1.5 w-full rounded-full bg-[#ebedf2] dark:bg-dark/40">
                                                            <div class="w-[60.55%] rounded-full bg-primary"></div>
                                                        </div>
                                                    </td>
                                                    <td class="text-success">60.55%</td>
                                                    <td class="text-center">8 days ago</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div> -->
                        </div>
                        <div class="grid grid-cols-1 gap-5 md:grid-cols-2">
                            <div class="panel">
                                <div class="mb-5">
                                    <h5 class="text-lg font-semibold dark:text-white-light">Resumen</h5>
                                </div>
                                <div class="space-y-4">
                                    <div class="rounded border border-[#ebedf2] dark:border-0 dark:bg-[#1b2e4b]">
                                        <div class="flex items-center justify-between p-4 py-2">
                                            <div class="grid h-9 w-9 place-content-center rounded-md bg-secondary-light text-secondary dark:bg-secondary dark:text-secondary-light">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0">
                                                    <path d="M3.79424 12.0291C4.33141 9.34329 4.59999 8.00036 5.48746 7.13543C5.65149 6.97557 5.82894 6.8301 6.01786 6.70061C7.04004 6 8.40956 6 11.1486 6H12.8515C15.5906 6 16.9601 6 17.9823 6.70061C18.1712 6.8301 18.3486 6.97557 18.5127 7.13543C19.4001 8.00036 19.6687 9.34329 20.2059 12.0291C20.9771 15.8851 21.3627 17.8131 20.475 19.1793C20.3143 19.4267 20.1267 19.6555 19.9157 19.8616C18.7501 21 16.7839 21 12.8515 21H11.1486C7.21622 21 5.25004 21 4.08447 19.8616C3.87342 19.6555 3.68582 19.4267 3.5251 19.1793C2.63744 17.8131 3.02304 15.8851 3.79424 12.0291Z" stroke="currentColor" stroke-width="1.5" />
                                                    <path opacity="0.5" d="M9 6V5C9 3.34315 10.3431 2 12 2C13.6569 2 15 3.34315 15 5V6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                                    <path opacity="0.5" d="M9.1709 15C9.58273 16.1652 10.694 17 12.0002 17C13.3064 17 14.4177 16.1652 14.8295 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                                </svg>
                                            </div>
                                            <div class="flex flex-auto items-start justify-between font-semibold ltr:ml-4 rtl:mr-4">
                                                <h6 class="text-[13px] text-white-dark dark:text-white-dark">
                                                    Facturas timbradas <span class="block text-base text-[#515365] dark:text-white-light"><?php echo $facturas ?></span>
                                                </h6>
                                                <p class="text-secondary ltr:ml-auto rtl:mr-auto"><?php echo number_format($porcentaje, 2) ?>%</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="rounded border border-[#ebedf2] dark:border-0 dark:bg-[#1b2e4b]">
                                        <div class="flex items-center justify-between p-4 py-2">
                                            <div class="grid h-9 w-9 place-content-center rounded-md bg-info-light text-info dark:bg-info dark:text-info-light">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0">
                                                    <path d="M4.72848 16.1369C3.18295 14.5914 2.41018 13.8186 2.12264 12.816C1.83509 11.8134 2.08083 10.7485 2.57231 8.61875L2.85574 7.39057C3.26922 5.59881 3.47597 4.70292 4.08944 4.08944C4.70292 3.47597 5.59881 3.26922 7.39057 2.85574L8.61875 2.57231C10.7485 2.08083 11.8134 1.83509 12.816 2.12264C13.8186 2.41018 14.5914 3.18295 16.1369 4.72848L17.9665 6.55812C20.6555 9.24711 22 10.5916 22 12.2623C22 13.933 20.6555 15.2775 17.9665 17.9665C15.2775 20.6555 13.933 22 12.2623 22C10.5916 22 9.24711 20.6555 6.55812 17.9665L4.72848 16.1369Z" stroke="currentColor" stroke-width="1.5" />
                                                    <circle opacity="0.5" cx="8.60699" cy="8.87891" r="2" transform="rotate(-45 8.60699 8.87891)" stroke="currentColor" stroke-width="1.5" />
                                                    <path opacity="0.5" d="M11.5417 18.5L18.5208 11.5208" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                                </svg>
                                            </div>
                                            <div class="flex flex-auto items-start justify-between font-semibold ltr:ml-4 rtl:mr-4">
                                                <h6 class="text-[13px] text-white-dark dark:text-white-dark">
                                                    Movimientos asignados <span class="block text-base text-[#515365] dark:text-white-light"><?php echo $asignados ?></span>
                                                </h6>
                                                <p class="text-info ltr:ml-auto rtl:mr-auto"><?php echo number_format($porcentajeAsignados, 2) ?>%</p>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- <div class="rounded border border-[#ebedf2] dark:border-0 dark:bg-[#1b2e4b]">
                                        <div class="flex items-center justify-between p-4 py-2">
                                            <div class="grid h-9 w-9 place-content-center rounded-md bg-warning-light text-warning dark:bg-warning dark:text-warning-light">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0">
                                                    <path d="M2 12C2 8.22876 2 6.34315 3.17157 5.17157C4.34315 4 6.22876 4 10 4H14C17.7712 4 19.6569 4 20.8284 5.17157C22 6.34315 22 8.22876 22 12C22 15.7712 22 17.6569 20.8284 18.8284C19.6569 20 17.7712 20 14 20H10C6.22876 20 4.34315 20 3.17157 18.8284C2 17.6569 2 15.7712 2 12Z" stroke="currentColor" stroke-width="1.5" />
                                                    <path opacity="0.5" d="M10 16H6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                                    <path opacity="0.5" d="M14 16H12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                                    <path opacity="0.5" d="M2 10L22 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                                </svg>
                                            </div>
                                            <div class="flex flex-auto items-start justify-between font-semibold ltr:ml-4 rtl:mr-4">
                                                <h6 class="text-[13px] text-white-dark dark:text-white-dark">
                                                    Dias laborados <span class="block text-base text-[#515365] dark:text-white-light">1000</span>
                                                </h6>
                                                <p class="text-warning ltr:ml-auto rtl:mr-auto">80%</p>
                                            </div>
                                        </div>
                                    </div> -->
                                </div>
                            </div>
                            <div class="panel">
                                <div class="mb-10 flex items-center justify-between">
                                    <h5 class="text-lg font-semibold dark:text-white-light">Imagen de usuario</h5>
                                </div>
                                <div class="group">
                                    <div class="mb-5">
                                        <form id="formulario">
                                            <div class="mb-5 grid grid-cols-1 gap-4 sm:grid-cols-2">
                                                <div>
                                                    <label for="billingName">Imagen</label>
                                                    <input id="file" name="archivo" type="file" class="form-input">
                                                </div>

                                            </div>

                                            <button type="submit" class="btn btn-primary">Cambiar imagen</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <!-- <div class="panel">
                                <div class="mb-5 flex items-center justify-between">
                                    <h5 class="text-lg font-semibold dark:text-white-light">Payment History</h5>
                                </div>
                                <div>
                                    <div class="border-b border-[#ebedf2] dark:border-[#1b2e4b]">
                                        <div class="flex items-center justify-between py-2">
                                            <h6 class="font-semibold text-[#515365] dark:text-white-dark">
                                                March<span class="block text-white-dark dark:text-white-light">Pro Membership</span>
                                            </h6>
                                            <div class="flex items-start justify-between ltr:ml-auto rtl:mr-auto">
                                                <p class="font-semibold">90%</p>
                                                <div x-data="dropdown" @click.outside="open = false" class="dropdown ltr:ml-4 rtl:mr-4">
                                                    <a href="javascript:;" @click="toggle">
                                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-80 hover:opacity-100">
                                                            <circle cx="5" cy="12" r="2" stroke="currentColor" stroke-width="1.5" />
                                                            <circle opacity="0.5" cx="12" cy="12" r="2" stroke="currentColor" stroke-width="1.5" />
                                                            <circle cx="19" cy="12" r="2" stroke="currentColor" stroke-width="1.5" />
                                                        </svg>
                                                    </a>
                                                    <ul x-cloak x-show="open" x-transition x-transition.duration.300ms class="whitespace-nowrap ltr:right-0 rtl:left-0">
                                                        <li><a href="javascript:;" @click="toggle">View Invoice</a></li>
                                                        <li><a href="javascript:;" @click="toggle">Download Invoice</a></li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-b border-[#ebedf2] dark:border-[#1b2e4b]">
                                        <div class="flex items-center justify-between py-2">
                                            <h6 class="font-semibold text-[#515365] dark:text-white-dark">
                                                February <span class="block text-white-dark dark:text-white-light">Pro Membership</span>
                                            </h6>
                                            <div class="flex items-start justify-between ltr:ml-auto rtl:mr-auto">
                                                <p class="font-semibold">90%</p>
                                                <div x-data="dropdown" @click.outside="open = false" class="dropdown ltr:ml-4 rtl:mr-4">
                                                    <a href="javascript:;" @click="toggle">
                                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-80 hover:opacity-100">
                                                            <circle cx="5" cy="12" r="2" stroke="currentColor" stroke-width="1.5" />
                                                            <circle opacity="0.5" cx="12" cy="12" r="2" stroke="currentColor" stroke-width="1.5" />
                                                            <circle cx="19" cy="12" r="2" stroke="currentColor" stroke-width="1.5" />
                                                        </svg>
                                                    </a>
                                                    <ul x-cloak x-show="open" x-transition x-transition.duration.300ms class="whitespace-nowrap ltr:right-0 rtl:left-0">
                                                        <li><a href="javascript:;" @click="toggle">View Invoice</a></li>
                                                        <li><a href="javascript:;" @click="toggle">Download Invoice</a></li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div>
                                        <div class="flex items-center justify-between py-2">
                                            <h6 class="font-semibold text-[#515365] dark:text-white-dark">
                                                January<span class="block text-white-dark dark:text-white-light">Pro Membership</span>
                                            </h6>
                                            <div class="flex items-start justify-between ltr:ml-auto rtl:mr-auto">
                                                <p class="font-semibold">90%</p>
                                                <div x-data="dropdown" @click.outside="open = false" class="dropdown ltr:ml-4 rtl:mr-4">
                                                    <a href="javascript:;" @click="toggle">
                                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-80 hover:opacity-100">
                                                            <circle cx="5" cy="12" r="2" stroke="currentColor" stroke-width="1.5" />
                                                            <circle opacity="0.5" cx="12" cy="12" r="2" stroke="currentColor" stroke-width="1.5" />
                                                            <circle cx="19" cy="12" r="2" stroke="currentColor" stroke-width="1.5" />
                                                        </svg>
                                                    </a>
                                                    <ul x-cloak x-show="open" x-transition x-transition.duration.300ms class="whitespace-nowrap ltr:right-0 rtl:left-0">
                                                        <li><a href="javascript:;" @click="toggle">View Invoice</a></li>
                                                        <li><a href="javascript:;" @click="toggle">Download Invoice</a></li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div> -->
                            <!-- <div class="panel">
                                <div class="mb-5 flex items-center justify-between">
                                    <h5 class="text-lg font-semibold dark:text-white-light">Card Details</h5>
                                </div>
                                <div>
                                    <div class="border-b border-[#ebedf2] dark:border-[#1b2e4b]">
                                        <div class="flex items-center justify-between py-2">
                                            <div class="flex-none">
                                                <img src="assets/images/card-americanexpress.svg" alt="image" />
                                            </div>
                                            <div class="flex flex-auto items-center justify-between ltr:ml-4 rtl:mr-4">
                                                <h6 class="font-semibold text-[#515365] dark:text-white-dark">
                                                    American Express <span class="block text-white-dark dark:text-white-light">Expires on 12/2025</span>
                                                </h6>
                                                <span class="badge bg-success ltr:ml-auto rtl:mr-auto">Primary</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-b border-[#ebedf2] dark:border-[#1b2e4b]">
                                        <div class="flex items-center justify-between py-2">
                                            <div class="flex-none">
                                                <img src="assets/images/card-mastercard.svg" alt="image" />
                                            </div>
                                            <div class="flex flex-auto items-center justify-between ltr:ml-4 rtl:mr-4">
                                                <h6 class="font-semibold text-[#515365] dark:text-white-dark">
                                                    Mastercard <span class="block text-white-dark dark:text-white-light">Expires on 03/2025</span>
                                                </h6>
                                            </div>
                                        </div>
                                    </div>
                                    <div>
                                        <div class="flex items-center justify-between py-2">
                                            <div class="flex-none">
                                                <img src="assets/images/card-visa.svg" alt="image" />
                                            </div>
                                            <div class="flex flex-auto items-center justify-between ltr:ml-4 rtl:mr-4">
                                                <h6 class="font-semibold text-[#515365] dark:text-white-dark">
                                                    Visa <span class="block text-white-dark dark:text-white-light">Expires on 10/2025</span>
                                                </h6>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div> -->
                        </div>
                    </div>
                </div>
                <!-- end main content section -->

            </div>

            <!-- start footer section -->
            <div class="p-6 pt-0 mt-auto text-center dark:text-white-dark ltr:sm:text-left rtl:sm:text-right">
                © <span id="footer-year">2022</span>. Vristo All rights reserved.
            </div>
            <!-- end footer section -->
        </div>
    </div>

    <script src="assets/js/alpine-collaspe.min.js"></script>
    <script src="assets/js/alpine-persist.min.js"></script>
    <script defer src="assets/js/alpine-ui.min.js"></script>
    <script defer src="assets/js/alpine-focus.min.js"></script>
    <script defer src="assets/js/alpine.min.js"></script>
    <script src="assets/js/custom.js"></script>

    <script>
        const formulario = document.getElementById("formulario");


        formulario.addEventListener("submit", function(e) {
            e.preventDefault();
            const enviaDatosContra = new FormData(formulario);
            enviaDatosContra.append("accion", "imagen");
            enviaDatosContra.append("id", "<?php echo $usuario->id ?>");
            fetch("api/apiUsuarios.php", {
                    method: "POST",
                    body: enviaDatosContra,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    Swal.fire(
                        data.estatus,
                        data.mensaje,
                        data.subMensaje
                    ).then(() => {
                        if (data.subMensaje == "success") {
                            location.reload();
                        }
                    });


                });
        });
    </script>
    <script>
        document.addEventListener('alpine:init', () => {
            // main section
            Alpine.data('scrollToTop', () => ({
                showTopButton: false,
                init() {
                    window.onscroll = () => {
                        this.scrollFunction();
                    };
                },

                scrollFunction() {
                    if (document.body.scrollTop > 50 || document.documentElement.scrollTop > 50) {
                        this.showTopButton = true;
                    } else {
                        this.showTopButton = false;
                    }
                },

                goToTop() {
                    document.body.scrollTop = 0;
                    document.documentElement.scrollTop = 0;
                },
            }));

            // theme customization
            Alpine.data('customizer', () => ({
                showCustomizer: false,
            }));

            // sidebar section
            Alpine.data('sidebar', () => ({
                init() {
                    const selector = document.querySelector('.sidebar ul a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.click();
                                });
                            }
                        }
                    }
                },
            }));

            // header section
            Alpine.data('header', () => ({
                init() {
                    const selector = document.querySelector('ul.horizontal-menu a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.classList.add('active');
                                });
                            }
                        }
                    }
                },

                notifications: [{
                        id: 1,
                        profile: 'user-profile.jpeg',
                        message: '<strong class="text-sm mr-1">John Doe</strong>invite you to <strong>Prototyping</strong>',
                        time: '45 min ago',
                    },
                    {
                        id: 2,
                        profile: 'profile-34.jpeg',
                        message: '<strong class="text-sm mr-1">Adam Nolan</strong>mentioned you to <strong>UX Basics</strong>',
                        time: '9h Ago',
                    },
                    {
                        id: 3,
                        profile: 'profile-16.jpeg',
                        message: '<strong class="text-sm mr-1">Anna Morgan</strong>Upload a file',
                        time: '9h Ago',
                    },
                ],

                messages: [{
                        id: 1,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-success-light dark:bg-success text-success dark:text-success-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg></span>',
                        title: 'Congratulations!',
                        message: 'Your OS has been updated.',
                        time: '1hr',
                    },
                    {
                        id: 2,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-info-light dark:bg-info text-info dark:text-info-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="16" x2="12" y2="12"></line><line x1="12" y1="8" x2="12.01" y2="8"></line></svg></span>',
                        title: 'Did you know?',
                        message: 'You can switch between artboards.',
                        time: '2hr',
                    },
                    {
                        id: 3,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-danger-light dark:bg-danger text-danger dark:text-danger-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg></span>',
                        title: 'Something went wrong!',
                        message: 'Send Reposrt',
                        time: '2days',
                    },
                    {
                        id: 4,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-warning-light dark:bg-warning text-warning dark:text-warning-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">    <circle cx="12" cy="12" r="10"></circle>    <line x1="12" y1="8" x2="12" y2="12"></line>    <line x1="12" y1="16" x2="12.01" y2="16"></line></svg></span>',
                        title: 'Warning',
                        message: 'Your password strength is low.',
                        time: '5days',
                    },
                ],

                languages: [{
                        id: 1,
                        key: 'Chinese',
                        value: 'zh',
                    },
                    {
                        id: 2,
                        key: 'Danish',
                        value: 'da',
                    },
                    {
                        id: 3,
                        key: 'English',
                        value: 'en',
                    },
                    {
                        id: 4,
                        key: 'French',
                        value: 'fr',
                    },
                    {
                        id: 5,
                        key: 'German',
                        value: 'de',
                    },
                    {
                        id: 6,
                        key: 'Greek',
                        value: 'el',
                    },
                    {
                        id: 7,
                        key: 'Hungarian',
                        value: 'hu',
                    },
                    {
                        id: 8,
                        key: 'Italian',
                        value: 'it',
                    },
                    {
                        id: 9,
                        key: 'Japanese',
                        value: 'ja',
                    },
                    {
                        id: 10,
                        key: 'Polish',
                        value: 'pl',
                    },
                    {
                        id: 11,
                        key: 'Portuguese',
                        value: 'pt',
                    },
                    {
                        id: 12,
                        key: 'Russian',
                        value: 'ru',
                    },
                    {
                        id: 13,
                        key: 'Spanish',
                        value: 'es',
                    },
                    {
                        id: 14,
                        key: 'Swedish',
                        value: 'sv',
                    },
                    {
                        id: 15,
                        key: 'Turkish',
                        value: 'tr',
                    },
                    {
                        id: 16,
                        key: 'Arabic',
                        value: 'ae',
                    },
                ],

                removeNotification(value) {
                    this.notifications = this.notifications.filter((d) => d.id !== value);
                },

                removeMessage(value) {
                    this.messages = this.messages.filter((d) => d.id !== value);
                },
            }));
        });
    </script>
</body>

</html>