<?php


function parseWhatsappLog($fecha)
{
    $date = new DateTime($fecha);

    // Formatear la fecha
    $formattedDate = $date->format("d-m-Y");

    $filePath = "https://banca.sistema14.com/api/web_" . $formattedDate . ".txt";
    // Verificar si el archivo existe
    /*if (!file_exists($filePath)) {
        return "El archivo no existe.   ".$filePath;
    }*/

    // Leer el contenido del archivo
    $fileContent = file_get_contents($filePath);

    // Expresión regular para extraer los bloques JSON
    $pattern = '/POST data: ({.*?})/s';

    // Array para almacenar los datos JSON encontrados
    $jsonData = [];
    $arrayData = [];

    // Buscar las coincidencias en el archivo
    preg_match_all($pattern, $fileContent, $matches);
    foreach ($matches[1] as $jsonString) {
        $decodedData = json_decode($jsonString, true);
        if ($decodedData !== null) {
            $jsonData[] = $decodedData;
        } else {
            $jsonData[] = $jsonString;
        }
    }
    // Si se encontraron coincidencias, convertirlas a arrays
    /*if (!empty($matches[1])) {
        foreach ($matches[1] as $jsonString) {
            // Eliminar las barras invertidas \ con stripslashes()
            $jsonString = stripslashes($jsonString);
            // Eliminar todas las barras invertidas (\)
            $jsonString = str_replace("\\", "", $jsonString);
            // Decodificar cada cadena JSON y agregarla al array
            $data=json_decode($jsonString, true);
            $jsonData[] = json_decode($jsonString, true);
            // Acceder al campo 'id' dentro de 'statuses'
            $statusId = $data['entry'][0]['changes'][0]['value']['statuses'][0]['id'];
            $status = $data['entry'][0]['changes'][0]['value']['statuses'][0]['status'];
            $fecha = $data['entry'][0]['changes'][0]['value']['statuses'][0]['timestamp'];
            $celular = $data['entry'][0]['changes'][0]['value']['statuses'][0]['recipient_id'];
            $error="";
            if($status=="failed"){
                $error=$data['entry'][0]['changes'][0]['value']['statuses'][1]['recipient_id'];
            }
            $statusId = $data['entry'][0]['changes'][0]['value']['statuses'][0]['id'];
            $arrayData[$statusId]=array($statusId,$celular,$fecha,$status,$error);
        }
    }*/

    // Retornar el array resultante
    return $jsonData;
}

function dameInfoJson($json){

    $json = stripslashes($json);
    // Eliminar todas las barras invertidas (\)
    $json = str_replace("\\", "", $json);

    // Eliminar la parte inicial "POST data: "
    $jsonString = substr($json, strpos($json, '{'));

    // Decodificar la cadena JSON
    $data = json_decode($jsonString, true);

    // Acceder al campo 'id' dentro de 'statuses'
    $statusId = $data['entry'][0]['changes'][0]['value']['statuses'][0]['id'];
    $status = $data['entry'][0]['changes'][0]['value']['statuses'][0]['status'];
    $fecha = date("H:i:s", $data['entry'][0]['changes'][0]['value']['statuses'][0]['timestamp']);;
    $celular = $data['entry'][0]['changes'][0]['value']['statuses'][0]['recipient_id'];
    $error="";
    if($status=="failed"){
        $error=$data['entry'][0]['changes'][0]['value']['statuses'][0]['errors'][0]['message'];
    }
    $statusId = $data['entry'][0]['changes'][0]['value']['statuses'][0]['id'];
    return array("id"=>$statusId,"celular"=>$celular,"fecha"=>$fecha,"estatus"=>$status,"error"=>$error);
    //return $json;
}

function lecturaLogBasica($fecha)
{
    $date = new DateTime($fecha);

    // Formatear la fecha
    $formattedDate = $date->format("d-m-Y");

    $filePath = "https://banca.sistema14.com/api/web_" . $formattedDate . ".txt";
    $data = [];
    $data2 = "";
    $registro = "";
    $contador=0;

    $fileContent = file_get_contents($filePath);

    if ($fileContent !== false) {
        // Dividir el contenido en un array de líneas
        $lines = explode(PHP_EOL, $fileContent);

        // Omitir la primera línea
        array_shift($lines);

        // Procesar las líneas restantes
        foreach ($lines as $line) {
            // Validar si la línea contiene "POST data: "
            if (strpos($line, "POST data: ") !== false) {
                $contador++;
                // Mostrar la línea completa que contiene "POST data: "
                $datos = dameInfoJson($registro);
                if($datos["id"]!=null){
                    $data[$datos["id"]]=$datos;
                }

                $registro = $line;
            } else {
                $registro .= $line;
            }
        }
        
        $datos = dameInfoJson($registro);
        $data[$datos["id"]]=$datos;
    } else {
        $data = "No se pudo leer el archivo.";
    }
    return $data;
}
$fecha = $_POST['fecha'];

$datos = lecturaLogBasica($fecha);
echo json_encode(["mensaje" => "Exito", "status" => "success", "data" => $datos]);
