<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>S14 U</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" type="image/x-icon" href="favicon.png" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/perfect-scrollbar.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/asiel.css" />

    <link rel="stylesheet" href="assets/css/highlight.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="css/bootstrap.css" />

    <link defer rel="stylesheet" type="text/css" media="screen" href="assets/css/animate.css" />
    <script src="assets/js/perfect-scrollbar.min.js"></script>
    <script src="js/bootstrap.js"></script>

    <script defer src="assets/js/popper.min.js"></script>
    <script defer src="assets/js/tippy-bundle.umd.min.js"></script>
    <script defer src="assets/js/sweetalert.min.js"></script>


</head>

<body x-data="main" class="relative overflow-x-hidden font-nunito text-sm font-normal antialiased" :class="[ $store.app.sidebar ? 'toggle-sidebar' : '', $store.app.theme === 'dark' || $store.app.isDarkMode ?  'dark' : '', $store.app.menu, $store.app.layout,$store.app.rtlClass]">
    <?php
    include_once('api/adminFacturas.php');
    $adminFacturas = new AdministradorFormasPago();
    if (isset($_GET['busqueda'])) {
        $facturas = $adminFacturas->dameFacturasPPDBuscadas($_GET['busqueda']);
    } else if (isset($_GET['not'])) {
        $facturas = $adminFacturas->dameFacturasPPDConcluidas();
    } else {
        $facturas = $adminFacturas->dameFacturasPPDSinConcluir();
    }

    function fechaComoCadenaFacturas($fecha)
    {
        $dia = substr($fecha, 8, 2);
        $mes = substr($fecha, 5, 2);
        $anio = substr($fecha, 0, 4);

        switch ($mes) {
            case "01":
                $mes = 'Enero';
                break;
            case "02":
                $mes = 'Febrero';
                break;
            case "03":
                $mes = 'Marzo';
                break;
            case  "04":
                $mes = 'Abril';
                break;
            case "05":
                $mes = 'Mayo';
                break;
            case "06":
                $mes = 'Junio';
                break;
            case "07":
                $mes = 'Julio';
                break;
            case "08":
                $mes = 'Agosto';
                break;
            case "09":
                $mes = 'Septiembre';
                break;
            case "10":
                $mes = 'Octubre';
                break;
            case "11":
                $mes = 'Noviembre';
                break;
            case "12":
                $mes = 'Diciembre';
                break;
            default:
                $mes = "NA";
                $dia = "NA";
                $anio = "NA";
        }
        return $dia . '/' . $mes . '/' . $anio;
    }

    ?>

    <!-- sidebar menu overlay -->
    <div x-cloak class="fixed inset-0 z-50 bg-[black]/60 lg:hidden" :class="{'hidden' : !$store.app.sidebar}" @click="$store.app.toggleSidebar()"></div>

    <!-- screen loader -->
    <div class="screen_loader animate__animated fixed inset-0 z-[60] grid place-content-center bg-[#fafafa] dark:bg-[#060818]">
        <div class="containerL">
            <div class="item item-1"></div>
            <div class="item item-2"></div>
            <div class="item item-3"></div>
            <div class="item item-4"></div>
        </div>
    </div>

    <!-- scroll to top button -->
    <div class="fixed bottom-6 z-50 ltr:right-6 rtl:left-6" x-data="scrollToTop">
        <template x-if="showTopButton">
            <button type="button" class="btn btn-outline-primary animate-pulse rounded-full bg-[#fafafa] p-2 dark:bg-[#060818] dark:hover:bg-primary" @click="goToTop">
                <svg width="24" height="24" class="h-4 w-4" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd" d="M12 20.75C12.4142 20.75 12.75 20.4142 12.75 20L12.75 10.75L11.25 10.75L11.25 20C11.25 20.4142 11.5858 20.75 12 20.75Z" fill="currentColor" />
                    <path d="M6.00002 10.75C5.69667 10.75 5.4232 10.5673 5.30711 10.287C5.19103 10.0068 5.25519 9.68417 5.46969 9.46967L11.4697 3.46967C11.6103 3.32902 11.8011 3.25 12 3.25C12.1989 3.25 12.3897 3.32902 12.5304 3.46967L18.5304 9.46967C18.7449 9.68417 18.809 10.0068 18.6929 10.287C18.5768 10.5673 18.3034 10.75 18 10.75L6.00002 10.75Z" fill="currentColor" />
                </svg>
            </button>
        </template>
    </div>

    <!-- start theme customizer section -->
    <?php include "template/header.php" ?>
    <!-- end theme customizer section -->

    <div class="main-container min-h-screen text-black dark:text-white-dark" :class="[$store.app.navbar]">
        <!-- start sidebar section -->
        <?php include "template/barra.php" ?>
        <!-- end sidebar section -->

        <div class="main-content flex flex-col min-h-screen">
            <!-- start header section -->
            <?php include "template/barra_sup.php" ?>

            <!-- end header section -->

            <div class="animate__animated p-6" :class="[$store.app.animation]">
                <!-- start main content section -->

                <div x-data="striped">

                    <h5 class="mb-5 text-lg font-semibold dark:text-white-light md:absolute md:top-[25px] md:mb-0">Lista de facturas</h5>

                    <div class="panel mt-6">
                        <div class="md:absolute md:top-5 ltr:md:left-5 rtl:md:right-5">
                            <div class="mb-5 flex items-center gap-2">

                                <a href="fac-facturas-ppd.php?not=1" class="btn btn-primary gap-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="24px" width="24px" version="1.1" id="Capa_1" viewBox="0 0 93.576 93.576" xml:space="preserve">
                                        <g>
                                            <path style="fill:#FFE101;" d="M46.783,3C22.641,3,3,22.641,3,46.783C3,70.93,22.641,90.576,46.783,90.576   c24.147,0,43.793-19.646,43.793-43.793C90.576,22.641,70.931,3,46.783,3z M46.783,81.662c-19.227,0-34.868-15.646-34.868-34.879   c0-19.226,15.642-34.867,34.868-34.867c19.231,0,34.878,15.642,34.878,34.867C81.661,66.015,66.015,81.662,46.783,81.662z" />
                                            <path d="M46.783,0C20.987,0,0,20.987,0,46.783c0,25.802,20.987,46.793,46.783,46.793c25.802,0,46.793-20.991,46.793-46.793   C93.576,20.987,72.585,0,46.783,0z M46.783,90.576C22.641,90.576,3,70.93,3,46.783C3,22.641,22.641,3,46.783,3   c24.147,0,43.793,19.641,43.793,43.782C90.576,70.93,70.931,90.576,46.783,90.576z" />
                                            <path style="fill:#FFFFFF;" d="M51.519,53.923c0-0.416-0.097-0.572-0.243-0.708c-0.031-0.029-0.096-0.082-0.213-0.153v1.581   C51.519,54.377,51.519,54.075,51.519,53.923z" />
                                            <path style="fill:#FFFFFF;" d="M42.734,38.013v0.104c0,0.35,0.109,0.479,0.212,0.574c0.025,0.022,0.108,0.09,0.298,0.189v-1.604   c-0.121,0.059-0.188,0.108-0.221,0.137C42.785,37.623,42.734,37.805,42.734,38.013z" />
                                            <path style="fill:#FFFFFF;" d="M46.783,14.916c-17.572,0-31.868,14.296-31.868,31.867c0,17.578,14.296,31.879,31.868,31.879   c17.577,0,31.878-14.301,31.878-31.879C78.661,29.211,64.36,14.916,46.783,14.916z M63.032,53.258c0,1.783-0.126,3.428-0.796,4.887   c-0.683,1.454-1.537,2.724-2.756,3.787c-1.205,1.045-2.716,1.884-4.377,2.495c-1.246,0.456-2.071,0.793-4.071,1.006v4.885h-8   v-4.997c-2-0.328-4.439-0.87-6.502-1.614c-2.508-0.901-4.862-2.113-6.93-3.601L28.4,59.254l6.324-9.352l1.247,0.891   c1.537,1.094,2.986,1.982,4.478,2.641c0.869,0.383,1.583,0.7,2.583,0.949v-3.154c-2-0.431-3.071-0.904-4.419-1.438   c-1.701-0.667-3.119-1.506-4.294-2.49c-1.211-1.006-1.931-2.22-2.562-3.602c-0.625-1.371-0.726-2.988-0.726-4.809v-0.103   c0-1.726,0.126-3.336,0.759-4.786c0.623-1.45,1.461-2.748,2.681-3.85c1.184-1.065,2.614-1.934,4.311-2.582   c1.287-0.492,2.249-0.842,4.249-1.042v-3.21h8v3.414c2,0.284,3.58,0.721,5.092,1.302c1.914,0.741,3.79,1.685,5.413,2.805   l1.211,0.807l-5.797,9.49l-1.296-0.92c-0.992-0.698-2.072-1.291-3.148-1.76c-0.49-0.212-0.475-0.398-1.475-0.563v2.819   c2,0.432,3.203,0.924,4.519,1.47c1.677,0.701,3.123,1.549,4.264,2.522c1.21,1.029,1.925,2.265,2.525,3.671   c0.594,1.402,0.691,3.008,0.691,4.774V53.258z" />
                                            <path d="M46.783,11.916c-19.227,0-34.868,15.642-34.868,34.867c0,19.232,15.642,34.879,34.868,34.879   c19.231,0,34.878-15.646,34.878-34.879C81.661,27.557,66.015,11.916,46.783,11.916z M46.783,78.662   c-17.572,0-31.868-14.301-31.868-31.879c0-17.571,14.296-31.867,31.868-31.867c17.577,0,31.878,14.296,31.878,31.867   C78.661,64.361,64.36,78.662,46.783,78.662z" />
                                            <path style="fill:#FFE101;" d="M57.889,46.988c-0.906-0.772-2.068-1.458-3.454-2.037c-1.46-0.605-3.237-1.145-5.205-1.602   l-1.198-0.27v-9.068l1.875,0.426c1.23,0.284,2.527,0.71,3.817,1.266c0.789,0.345,1.571,0.742,2.321,1.19l2.674-4.353   c-1.101-0.658-2.274-1.229-3.508-1.708c-1.648-0.633-3.672-1.072-5.683-1.304l-1.494-0.153v-3.058h-2v2.968l-1.415,0.097   c-1.806,0.126-3.434,0.459-4.821,0.99c-1.352,0.516-2.501,1.191-3.407,2.008c-0.895,0.808-1.387,1.754-1.842,2.813   c-0.47,1.078-0.515,2.285-0.515,3.595v0.103c0,1.388,0.031,2.587,0.477,3.564c0.447,0.981,0.993,1.813,1.872,2.543   c0.93,0.779,2.062,1.452,3.465,2.002c1.495,0.593,3.149,1.128,5.136,1.594l1.05,0.271v9.178l-1.675-0.308   c-1.749-0.306-3.43-0.829-5.078-1.555c-1.262-0.557-2.522-1.254-3.803-2.08l-2.959,4.386c1.523,0.959,3.189,1.764,4.956,2.398   c2.286,0.826,4.672,1.357,7.15,1.627l1.409,0.146v4.662h2v-4.582l1.476-0.126c1.67-0.153,3.279-0.49,4.672-0.999   c1.314-0.484,2.481-1.139,3.409-1.942c0.9-0.785,1.413-1.724,1.912-2.786c0.482-1.052,0.531-2.275,0.531-3.624v-0.109   c0-1.362-0.008-2.574-0.443-3.601C59.174,48.577,58.743,47.714,57.889,46.988z M46.032,42.967l-1.787-0.515   c-1.677-0.455-2.564-0.946-3.225-1.546c-0.781-0.718-0.989-1.68-0.989-2.79v-0.104c0-1.115,0.306-2.104,1.168-2.861   c0.795-0.688,1.78-1.085,3.389-1.218l1.443-0.134V42.967z M49.704,58.053l-1.671,0.173v-9.329l1.924,0.541   c1.615,0.458,2.687,0.961,3.355,1.582c0.785,0.732,1.195,1.701,1.195,2.805C54.507,55.279,53.879,57.617,49.704,58.053z" />
                                            <path d="M59.834,44.704c-1.142-0.974-2.606-1.821-4.283-2.522c-1.316-0.546-2.519-1.038-4.519-1.47v-2.819   c1,0.165,0.99,0.352,1.48,0.563c1.075,0.469,2.142,1.062,3.135,1.76l1.316,0.92l5.823-9.49l-1.167-0.807   c-1.623-1.12-3.581-2.063-5.495-2.805c-1.513-0.581-3.091-1.018-5.091-1.302v-3.414h-8v3.21c-2,0.2-3.011,0.55-4.298,1.042   c-1.696,0.648-3.166,1.517-4.35,2.582c-1.22,1.102-1.965,2.399-2.588,3.85c-0.633,1.45-0.764,3.061-0.764,4.786v0.103   c0,1.82,0.122,3.438,0.747,4.809c0.631,1.382,1.469,2.596,2.68,3.602c1.175,0.984,2.502,1.823,4.203,2.49   c1.348,0.534,2.37,1.008,4.37,1.438v3.154c-1-0.249-1.716-0.566-2.585-0.949c-1.492-0.658-2.985-1.547-4.522-2.641l-1.23-0.891   l-6.323,9.352l1.189,0.852c2.067,1.487,4.459,2.699,6.966,3.601c2.063,0.744,4.505,1.286,6.505,1.614v4.997h8v-4.885   c2-0.213,2.878-0.55,4.124-1.006c1.66-0.611,3.168-1.45,4.373-2.495c1.219-1.063,1.996-2.333,2.678-3.787   c0.67-1.459,0.825-3.104,0.825-4.887v-0.109c0-1.767-0.088-3.372-0.682-4.774C61.75,46.968,61.044,45.733,59.834,44.704z    M60.032,53.258c0,1.349-0.035,2.572-0.517,3.624c-0.499,1.063-1.104,2.001-2.004,2.786c-0.928,0.804-2.013,1.458-3.328,1.942   c-1.393,0.509-3.032,0.846-4.702,0.999l-1.449,0.126v4.582h-2v-4.662l-1.406-0.146c-2.479-0.27-4.827-0.801-7.113-1.627   c-1.768-0.635-3.445-1.439-4.968-2.398l2.961-4.386c1.281,0.826,2.558,1.523,3.82,2.08c1.648,0.726,3.285,1.249,5.034,1.555   l1.673,0.308v-9.178l-1.074-0.271c-1.986-0.466-3.707-1.001-5.202-1.594c-1.403-0.55-2.563-1.223-3.493-2.002   c-0.879-0.729-1.317-1.562-1.764-2.543c-0.446-0.978-0.467-2.177-0.467-3.564v-0.103c0-1.31,0.042-2.517,0.512-3.595   c0.455-1.059,1.042-2.005,1.937-2.813c0.906-0.816,2.002-1.492,3.354-2.008c1.388-0.531,3.001-0.864,4.807-0.99l1.391-0.097v-2.968   h2v3.058l1.496,0.153c2.011,0.231,3.952,0.671,5.6,1.304c1.234,0.479,2.452,1.05,3.553,1.708l-2.648,4.353   c-0.75-0.448-1.512-0.846-2.301-1.19c-1.29-0.556-2.6-0.981-3.83-1.266l-1.869-0.426v9.068l1.198,0.27   c1.968,0.457,3.726,0.996,5.186,1.602c1.386,0.579,2.557,1.265,3.463,2.037c0.854,0.727,1.29,1.589,1.705,2.561   c0.435,1.026,0.447,2.238,0.447,3.601V53.258z" />
                                            <path d="M49.957,49.438l-1.924-0.541v9.329l1.671-0.173c4.176-0.437,4.807-2.774,4.807-4.229c0-1.104-0.418-2.072-1.203-2.805   C52.64,50.399,51.572,49.896,49.957,49.438z M51.063,53.062c0.117,0.071,0.182,0.124,0.213,0.153   c0.146,0.136,0.243,0.292,0.243,0.708c0,0.151,0,0.454-0.456,0.72V53.062z" />
                                            <path d="M41.201,35.152c-0.862,0.757-1.168,1.746-1.168,2.861v0.104c0,1.11,0.26,2.072,1.042,2.79   c0.661,0.6,1.57,1.091,3.246,1.546l1.712,0.515V33.8l-1.443,0.134C42.98,34.067,41.996,34.463,41.201,35.152z M43.244,38.88   c-0.189-0.1-0.272-0.167-0.298-0.189c-0.103-0.095-0.212-0.225-0.212-0.574v-0.104c0-0.208,0.051-0.391,0.289-0.6   c0.032-0.028,0.1-0.078,0.221-0.137V38.88z" />
                                        </g>
                                    </svg>
                                    Facturas concluidas
                                </a>
                                <a href="fac-facturas-ppd.php" class="btn btn-warning gap-2">
                                    <svg width="24" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M18 8.80745C18 13.7615 13.7333 15 11.6 15C9.73333 15 6 13.7615 6 8.80745C6 6.71017 7.20839 5.35826 8.26099 4.65274C8.79638 4.29388 9.48354 4.55201 9.57296 5.17624C9.75127 6.421 10.8777 7.34944 11.5596 6.27998C12.1424 5.36614 12.3529 4.13169 12.3529 3.38896C12.3529 2.28965 13.503 1.59108 14.4009 2.2646C16.1512 3.5774 18 5.776 18 8.80745Z" stroke="currentColor" stroke-width="1.5"></path>
                                        <path d="M20 15L4 22" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M4 15L9 17.1875M20 22L14.5 19.5938" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M15 10C14.8 10.6667 13.92 12 12 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    </svg>
                                    Facturas sin concluir
                                </a>
                            </div>
                        </div>

                        <table id="tableStripe" class="table-striped">

                            <thead>
                                <tr>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">ID Factura</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">Folio Interno</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">Método de Pago</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="2">Empresa que factura</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="3">Total con IVA</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="5">Cliente</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Fecha de Timbrado</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Folio Fiscal</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">RFC</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Restante factura</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Folios asociados</th>

                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist" hidden>FFF</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php

                                foreach ($facturas as $factura) {
                                    echo '<tr style="height: 100px;">';
                                    echo '<td  onclick="detonarModal(' . $factura->id . ', ' . "'" . $factura->token . "'" .  ')">' . $factura->id . '</td>';
                                    echo '<td>' . $factura->folio . "-" . $factura->serie . '</td>';

                                    echo '<td>' . $factura->metodo_pago_nombre . '</td>';
                                    echo '<td>' . $factura->empresa_nombre . '</td>';
                                    echo '<td>$' . number_format($factura->total_iva, 2)  . '</td>';
                                    echo '<td>' . $factura->cliente . '</td>';
                                    echo '<td>' .fechaComoCadenaFacturas($factura->fecha_timbrado) . '</td>';
                                    echo '<td>' . $factura->uuid . '</td>';
                                    echo '<td>' . $factura->empresa_rfc . '</td>';
                                    echo '<td>$' . number_format($factura->restante, 2)  . '</td>';
                                    echo '<td> <a href="fac-facturas-ppd-detalle.php?id='.$factura->id.'" target="_blank">' . $factura->folios_asociados . '</a></td>';
                                    echo '<td hidden>' . ($factura->fecha_timbrado)  . '</td>';
                                    echo '</tr>';
                                }

                                ?>

                            </tbody>

                        </table>
                    </div>


                </div>
                <!-- end main content section -->

            </div>

            <div class="modal fade fixed inset-0 bg-[black]/60 z-[999]" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content justify-center">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">FACTURA <strong id="tituloModal"></strong></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body" style="height: 400px;">



                            <div id="espacioIframe">

                            </div>


                        </div>
                        <div class="modal-footer">
                            <div style="text-align: center;" id="espacioBotones">




                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- start footer section -->
            <div class="p-6 pt-0 mt-auto text-center dark:text-white-dark ltr:sm:text-left rtl:sm:text-right">
                © <span id="footer-year">2024</span>. Sistema 14 Ultra All rights reserved.
            </div>
            <!-- end footer section -->
        </div>
    </div>

    <script src="assets/js/highlight.min.js"></script>
    <script src="assets/js/alpine-collaspe.min.js"></script>
    <script src="assets/js/alpine-persist.min.js"></script>
    <script defer src="assets/js/alpine-ui.min.js"></script>
    <script defer src="assets/js/alpine-focus.min.js"></script>
    <script defer src="assets/js/alpine.min.js"></script>
    <script src="assets/js/custom.js"></script>
    <script src="assets/js/simple-datatables.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.7/dist/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.3.1/dist/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
    <script>
        function detonarModal(id, token) {
            $("#exampleModal").modal();
            document.getElementById("tituloModal").innerHTML = id;
            document.getElementById("espacioIframe").innerHTML = '<iframe src="https://sistema14.com/api/genera_factura.php?token=' + token + '&per=' + id + '"  style="height: 350px;" class="embed-responsive-item" width="100%"></iframe>';
            document.getElementById("espacioBotones").innerHTML = `
                                        <div class="grid grid-cols-1 gap-2 md:grid-cols-3 lg:grid-cols-4">
                                            <a onclick="favorito(${id}, ${<?php echo $_SESSION["usuario_id"] ?>})" class="btn btn-medium btn-primary"> Favorito </a>
                                            <a class="btn btn-medium btn-primary"><i class="fa fa-pencil" style="color:#fff;">Editar</i></a>
                                            <a href="https://old.sistema14.com/genera_factura.php?token=${token}&per=${id}" class="btn btn-medium btn-danger msgbox-inverse" alt="35704" style="color:#fff !important;" target="_blank"><i class="fa fa-file-pdf-o" style="color:#fff;">Ver PDF</i></a>
                                            <a onclick="facturarApi(${id})" class="btn btn-medium btn-default"><i class="fa fa-file" style="color:#000;">Facturar</i></a>

                                        </div>
                                        <br>
                                        <div class="grid grid-cols-1 gap-2 md:grid-cols-3 lg:grid-cols-4">
                                            <a class="btn btn-medium" data-toggle="modal" data-target=".pdf35704">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                <path d="M14.666 8.334v3.666l1.463-2.215-1.463-1.451zm-3.092 4.167c.66-.384 1.242-.864 1.758-1.447v1.369c-.445.393-.926.731-1.449 1.018l-.309-.94zm-3.255 2.041c-.652.083-1.57.125-2.319.125v-.97c.688 0 1.551-.037 2.152-.113l.167.958zm2.789-.725l-.036.015c-.586.246-1.22.437-1.91.573l-.167-.958c.655-.131 1.257-.315 1.809-.556l.304.926zm10.892-13.817l-3 11-4.064-3.62 3.9-4.117-5.229 3.614-3.607-.877 12-6zm-3.015 14.779c0 4.546-5.777 9.221-8.221 9.221h-8.764v-22h11.527l-4 2h-5.527v18h5.938c4.155 0 2.638-6 2.638-6 3.349.921 6.003.403 6.003-3.21.28.65.406 1.318.406 1.989z"></path>
                                            </svg>
                                            </a>
                                            <a href="https://sistema14.com/api/xml/firmados/XML-factura-${id}.xml" class="btn btn-medium btn-success msgbox-inverse" alt="35704" style="color:#fff !important;" target="_blank">XML</a>
                                            <a onclick="reenviar('${id}')" class="btn btn-medium btn-success msgbox-inverse" alt="35704" style="color:#fff !important;" target="_blank">REENVIAR</a>
                                            <a href="" class="btn btn-medium btn-danger msgbox-inverse" style="color:#fff !important;" target="_blank">CANCELAR</a>

                                        </div>
                                        <br>
                                        <div class="grid grid-cols-1 gap-2 md:grid-cols-3 lg:grid-cols-4">
                                        <a onclick="eliminaFactura(${id})" class="btn btn-medium btn-danger"><i class="fa fa-trash" style="color:#fff;">Eliminar</i></a>
                                        <a href="fac-complementos.php?id=${id}" class="btn btn-medium btn-success"><i class="fa fa-trash" style="color:#fff;">Ver complementos de pago</i></a>
                                        <a href="fac-facturacion-complementos.php?id=${id}" class="btn btn-medium btn-success"><i class="fa fa-trash" style="color:#fff;">Crear complemento</i></a>

                                        </div>



                   

                    
      
`;

        }
    </script>



    <script>
        function reenviar(factura) {

            var reenvio = new FormData();
            reenvio.append("accion", "reenviar");
            reenvio.append("id", factura);
            fetch("api/apiFactura.php", {
                    method: "POST",
                    body: reenvio,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    Swal.fire({
                        title: "Reenviado correctamente",
                        text: "La factura se reenvio correctamente",
                        icon: "susses",
                        confirmButtonText: 'Ok'
                    })

                });

        }
    </script>


    <script>
        function eliminaFactura(factura) {

            Swal.fire({
                title: '¿Estas seguro?',
                text: "¡No podras revertir esto!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Si, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    var formularioFavorito = new FormData();
                    formularioFavorito.append("accion", "eliminar");
                    formularioFavorito.append("factura", factura);
                    fetch("api/apiFactura.php", {
                            method: "POST",
                            body: formularioFavorito,
                        })
                        .then((respuesta) => respuesta.json())
                        .then((data) => {
                            console.log(data);
                            Swal.fire({
                                title: "Eliminado correctamente",
                                text: "La factura se elimino correctamente",
                                icon: "susses",
                                confirmButtonText: 'Ok'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    location.reload();
                                }
                            })

                        });

                } else {
                    Swal.fire({
                        title: "Cancelado",
                        text: "La factura no se elimino",
                        icon: "susses",
                        confirmButtonText: 'Ok'
                    })
                }
            })



        }
    </script>
    <script>
        function facturarApi(id) {
            console.log("Facturar API");
            var formularioFacturar = new FormData();
            formularioFacturar.append("accion", "facturar");
            formularioFacturar.append("id", id);
            formularioFacturar.append("usuario", <?php echo $_SESSION["usuario_id"] ?>);
            formularioFacturar.append("nota", "Agregado desde facturacion");

            fetch("api/apiFactura.php", {
                    method: "POST",
                    body: formularioFacturar,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    if (data.status == 'error') {
                        Swal.fire({
                            title: "Error",
                            text: "No se pudo facturar debido a " + data.message,
                            icon: "error",
                            confirmButtonText: 'Ok'
                        })
                    } else {
                        Swal.fire({
                            title: "Se facturo correctamente",
                            text: "Se facturo correctamente",
                            icon: "suscess",
                            confirmButtonText: 'Ok'
                        })
                    }


                }).catch(function(error) {
                    Swal.fire({
                        title: "Se facturo correctamente",
                        text: "Existieron errores al facturar (Logo empresa)",
                        icon: "suscess",
                        confirmButtonText: 'Ok'
                    })
                });

        }
    </script>
    <script>
        document.addEventListener('alpine:init', () => {
            // main section
            Alpine.data('scrollToTop', () => ({
                showTopButton: false,
                init() {
                    window.onscroll = () => {
                        this.scrollFunction();
                    };
                },

                scrollFunction() {
                    if (document.body.scrollTop > 50 || document.documentElement.scrollTop > 50) {
                        this.showTopButton = true;
                    } else {
                        this.showTopButton = false;
                    }
                },

                goToTop() {
                    document.body.scrollTop = 0;
                    document.documentElement.scrollTop = 0;
                },
            }));

            // theme customization
            Alpine.data('customizer', () => ({
                showCustomizer: false,
            }));

            // sidebar section
            Alpine.data('sidebar', () => ({
                init() {
                    const selector = document.querySelector('.sidebar ul a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.click();
                                });
                            }
                        }
                    }
                },
            }));

            // header section
            Alpine.data('header', () => ({
                init() {
                    const selector = document.querySelector('ul.horizontal-menu a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.classList.add('active');
                                });
                            }
                        }
                    }
                },

                notifications: [{
                        id: 1,
                        profile: 'user-profile.jpeg',
                        message: '<strong class="text-sm mr-1">John Doe</strong>invite you to <strong>Prototyping</strong>',
                        time: '45 min ago',
                    },
                    {
                        id: 2,
                        profile: 'profile-34.jpeg',
                        message: '<strong class="text-sm mr-1">Adam Nolan</strong>mentioned you to <strong>UX Basics</strong>',
                        time: '9h Ago',
                    },
                    {
                        id: 3,
                        profile: 'profile-16.jpeg',
                        message: '<strong class="text-sm mr-1">Anna Morgan</strong>Upload a file',
                        time: '9h Ago',
                    },
                ],

                messages: [{
                        id: 1,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-success-light dark:bg-success text-success dark:text-success-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg></span>',
                        title: 'Congratulations!',
                        message: 'Your OS has been updated.',
                        time: '1hr',
                    },
                    {
                        id: 2,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-info-light dark:bg-info text-info dark:text-info-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="16" x2="12" y2="12"></line><line x1="12" y1="8" x2="12.01" y2="8"></line></svg></span>',
                        title: 'Did you know?',
                        message: 'You can switch between artboards.',
                        time: '2hr',
                    },
                    {
                        id: 3,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-danger-light dark:bg-danger text-danger dark:text-danger-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg></span>',
                        title: 'Something went wrong!',
                        message: 'Send Reposrt',
                        time: '2days',
                    },
                    {
                        id: 4,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-warning-light dark:bg-warning text-warning dark:text-warning-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">    <circle cx="12" cy="12" r="10"></circle>    <line x1="12" y1="8" x2="12" y2="12"></line>    <line x1="12" y1="16" x2="12.01" y2="16"></line></svg></span>',
                        title: 'Warning',
                        message: 'Your password strength is low.',
                        time: '5days',
                    },
                ],

                languages: [{
                        id: 1,
                        key: 'Chinese',
                        value: 'zh',
                    },
                    {
                        id: 2,
                        key: 'Danish',
                        value: 'da',
                    },
                    {
                        id: 3,
                        key: 'English',
                        value: 'en',
                    },
                    {
                        id: 4,
                        key: 'French',
                        value: 'fr',
                    },
                    {
                        id: 5,
                        key: 'German',
                        value: 'de',
                    },
                    {
                        id: 6,
                        key: 'Greek',
                        value: 'el',
                    },
                    {
                        id: 7,
                        key: 'Hungarian',
                        value: 'hu',
                    },
                    {
                        id: 8,
                        key: 'Italian',
                        value: 'it',
                    },
                    {
                        id: 9,
                        key: 'Japanese',
                        value: 'ja',
                    },
                    {
                        id: 10,
                        key: 'Polish',
                        value: 'pl',
                    },
                    {
                        id: 11,
                        key: 'Portuguese',
                        value: 'pt',
                    },
                    {
                        id: 12,
                        key: 'Russian',
                        value: 'ru',
                    },
                    {
                        id: 13,
                        key: 'Spanish',
                        value: 'es',
                    },
                    {
                        id: 14,
                        key: 'Swedish',
                        value: 'sv',
                    },
                    {
                        id: 15,
                        key: 'Turkish',
                        value: 'tr',
                    },
                    {
                        id: 16,
                        key: 'Arabic',
                        value: 'ae',
                    },
                ],

                removeNotification(value) {
                    this.notifications = this.notifications.filter((d) => d.id !== value);
                },

                removeMessage(value) {
                    this.messages = this.messages.filter((d) => d.id !== value);
                },
            }));
            var tabla = null;
            Alpine.data('striped', () => ({
                init() {
                    const tableOptions = {
                        data: {

                        },
                        sortable: true,
                        searchable: true,
                        perPage: 10,
                        perPageSelect: [10, 20, 30, 50, 100],
                        firstLast: true,
                        firstText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M13 19L7 12L13 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.5" d="M16.9998 19L10.9998 12L16.9998 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        lastText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M11 19L17 12L11 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.5" d="M6.99976 19L12.9998 12L6.99976 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        prevText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M15 5L9 12L15 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        nextText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        labels: {
                            perPage: '{select}',
                        },
                        layout: {
                            top: '{search} <div class="flex items-center gap-2"> <button onclick="buscar()" type="button" class="btn btn-danger"> Búsqueda avanzada  </button> </div>',
                            bottom: '{info}{select}{pager}',
                        },


                    };
                    tabla = tableOptions;
                    const datatable1 = new simpleDatatables.DataTable('#tableStripe', tableOptions);
                    datatable1.on('datatable.init', function() {
                        //asignar id al buscador 
                        document.querySelector('.dataTable-input').id = 'buscador';
                    });

                },
            }));
        });
    </script>

    <script>
        function buscar() {
            var cadena = document.getElementById("buscador").value;
            //ir a pagina 
            window.location.href = "fac-facturas-ppd.php?busqueda=" + cadena;
        }
    </script>
</body>

</html>