<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>VRISTO - Multipurpose Tailwind Dashboard Template</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" type="image/x-icon" href="favicon.png" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/perfect-scrollbar.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css" />
    <link defer rel="stylesheet" type="text/css" media="screen" href="assets/css/animate.css" />
    <script src="assets/js/perfect-scrollbar.min.js"></script>
    <script defer src="assets/js/popper.min.js"></script>
    <script defer src="assets/js/tippy-bundle.umd.min.js"></script>
    <script defer src="assets/js/sweetalert.min.js"></script>
    <link rel="stylesheet" type="text/css" href="assets/css/nice-select2.css" />
    <script src="https://code.jquery.com/jquery-3.4.1.slim.min.js" integrity="sha384-J6qa4849blE2+poT4WnyKhv5vZF5SrPo0iEjwBvKU7imGFAV0wwj1yYfoRSJoZ+n" crossorigin="anonymous"></script>
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/2.0.7/css/dataTables.dataTables.min.css">
    <script src="https://cdn.datatables.net/2.0.7/js/dataTables.min.js"></script>
</head>

<body x-data="main" class="relative overflow-x-hidden font-nunito text-sm font-normal antialiased" :class="[ $store.app.sidebar ? 'toggle-sidebar' : '', $store.app.theme === 'dark' || $store.app.isDarkMode ?  'dark' : '', $store.app.menu, $store.app.layout,$store.app.rtlClass]">
    <!-- sidebar menu overlay -->
    <div x-cloak class="fixed inset-0 z-50 bg-[black]/60 lg:hidden" :class="{'hidden' : !$store.app.sidebar}" @click="$store.app.toggleSidebar()"></div>

    <!-- screen loader -->
    <div class="screen_loader animate__animated fixed inset-0 z-[60] grid place-content-center bg-[#fafafa] dark:bg-[#060818]">
        <img src="favicon.png" alt="">

    </div>

    <!-- scroll to top button -->
    <div class="fixed bottom-6 z-50 ltr:right-6 rtl:left-6" x-data="scrollToTop">
        <template x-if="showTopButton">
            <button type="button" class="btn btn-outline-primary animate-pulse rounded-full bg-[#fafafa] p-2 dark:bg-[#060818] dark:hover:bg-primary" @click="goToTop">
                <svg width="24" height="24" class="h-4 w-4" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd" d="M12 20.75C12.4142 20.75 12.75 20.4142 12.75 20L12.75 10.75L11.25 10.75L11.25 20C11.25 20.4142 11.5858 20.75 12 20.75Z" fill="currentColor" />
                    <path d="M6.00002 10.75C5.69667 10.75 5.4232 10.5673 5.30711 10.287C5.19103 10.0068 5.25519 9.68417 5.46969 9.46967L11.4697 3.46967C11.6103 3.32902 11.8011 3.25 12 3.25C12.1989 3.25 12.3897 3.32902 12.5304 3.46967L18.5304 9.46967C18.7449 9.68417 18.809 10.0068 18.6929 10.287C18.5768 10.5673 18.3034 10.75 18 10.75L6.00002 10.75Z" fill="currentColor" />
                </svg>
            </button>
        </template>
    </div>

    <!-- start theme customizer section -->
    <?php include "template/header.php" ?>
    <!-- end theme customizer section -->

    <div class="main-container min-h-screen text-black dark:text-white-dark" :class="[$store.app.navbar]">
        <!-- start sidebar section -->
        <?php include "template/barra.php" ?>
        <!-- end sidebar section -->

        <div class="main-content flex min-h-screen flex-col">
            <!-- start header section -->
            <?php include "template/barra_sup.php" ?>
            <!-- end header section -->

            <div class="animate__animated p-6" :class="[$store.app.animation]">
                <!-- start main content section -->
                <div x-data="sales">
                    <ul class="flex space-x-2 rtl:space-x-reverse">
                        <li>
                            <a href="javascript:;" class="text-primary hover:underline">Dashboard</a>
                        </li>
                        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                            <span>Sales</span>
                        </li>
                    </ul>

                    <?php
                    include "api/adminEmpresas.php";
                    include "api/adminConceptos.php";
                    include "api/adminClientes.php";
                    include "api/adminFormasPago.php";
                    include "api/adminPagos.php";

                    $adminEmpresas = new AdminEmpresas();
                    $adminConceptos = new AdministradorConceptos();
                    $adminClientes = new AdministradorClientes();
                    $adminFormasPago = new AdministradorFormasPago();
                    $adminPagos = new AdministradorPagos();
                    ?>


                    <script>
                        var pagoAsociado = 0;
                        var contadorConceptos = 0;
                        class ConceptoFacturable {
                            constructor(id, limite_superior, limite_inferior, concepto, unidades_maximas_por_factura) {
                                this.id = id;
                                this.limite_superior = parseFloat(limite_superior);
                                this.limite_inferior = parseFloat(limite_inferior);
                                this.concepto = concepto;
                                this.unidades_maximas_por_factura = parseFloat(unidades_maximas_por_factura);
                            }
                        }
                    </script>

                    <div class="pt-5">




                        <?php

                        if (isset($_GET['empresa'])) {
                            $empresa = $adminEmpresas->dameEmpresa($_GET['empresa']);
                            $clientes = $adminClientes->dameClientes();
                            $formasPago = $adminFormasPago->dameFormasPago();
                            $metodosPago = $adminFormasPago->dameMetodosPago();
                            $usosCfdi = $adminFormasPago->dameUsosCfdi();
                            if (isset($_GET['movimiento'])) {
                                $seCargo = 'readonly';
                                $movimiento = $adminPagos->damePago($_GET['movimiento']);
                                $detectado = 1;
                                //echo var_dump($movimiento);
                                // $modalRef = '<a data-toggle="modal" data-target="#barraMovimiento" > DETALLES MOVIMIENTO</a>';
                            } else {
                                $movimiento = null;
                                $detectado = 0;
                            }

                        ?>








                            <div class="panel">
                                <div class="mb-5 flex items-center justify-between">
                                    <h5 class="text-lg font-semibold dark:text-white-light">Facturación <?php echo $empresa->razon ?></h5>

                                </div>
                                <div class="mb-5">
                                    <form class="space-y-5" @submit.prevent="submitForm5()">
                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-2">
                                            <div>
                                                <label for="browserFname">Selecciona cliente</label>
                                                <select onchange="cargarClaves(this.value)" id="seachable-select" name="cliente" style="display: none;">
                                                    <?php
                                                    foreach ($clientes as $cliente) {
                                                        if ($cliente->id == $movimiento->idCliente) {
                                                            echo "<option value='$cliente->id' selected>$cliente->nombre</option>";
                                                        } else {
                                                            echo "<option value='$cliente->id'>$cliente->nombre</option>";
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div>
                                                <label for="browserLname">Razón social</label>
                                                <select name="clave_c" id="clave_c" class="form-select">

                                                </select>
                                            </div>

                                        </div>
                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-4">
                                            <div>
                                                <label for="browserCity">Método de pago </label>
                                                <select name="metodo_pago" id="metodo_pago" class="form-select" onchange="filtrarOpciones(this.value)">
                                                    <?php
                                                    foreach ($metodosPago as $metodoPago) {
                                                        if (isset($_GET['movimiento'])) {
                                                            if ($metodoPago->id == 1) {
                                                                echo "<option value='$metodoPago->id' selected>$metodoPago->metodo_pago</option>";
                                                            }
                                                        } else {
                                                            echo "<option value='$metodoPago->id'>$metodoPago->metodo_pago</option>";
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div>
                                                <label for="browserState">Forma de pago </label>
                                                <select name="forma_pago" id="forma_pago" class="form-select">
                                                    <option value="0">Seleccione</option>
                                                    <?php
                                                    foreach ($formasPago as $formaPago) {
                                                        if (isset($_GET['movimiento'])) {
                                                            if ($formaPago->id == 3) {
                                                                echo "<option value='$formaPago->id' selected>$formaPago->forma_pago</option>";
                                                            } else {
                                                                echo "<option value='$formaPago->id'>$formaPago->forma_pago</option>";
                                                            }
                                                        } else {
                                                            if ($formaPago->id == 23) {
                                                                echo "<option value='$formaPago->id' style='display: none;'>$formaPago->forma_pago</option>";
                                                            } else {
                                                                echo "<option value='$formaPago->id'>$formaPago->forma_pago</option>";
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div>
                                                <label for="browserZip">Tipo de comprobante </label>
                                                <select name="tipo_comprobante" id="tipo_comprobante" required="" class="form-select">
                                                    <option selected="" value=""></option>
                                                    <option value="I" selected>Ingreso</option>
                                                    <option value="E">Egreso</option>
                                                    <option value="T">Traslado</option>
                                                    <option value="N">Nomina</option>
                                                    <option value="P">Pago</option>
                                                </select>
                                            </div>
                                            <div>
                                                <label for="browserCity">Uso De CFDI</label>
                                                <select name="uso_cfdi" id="uso_cfdi" class="form-select">
                                                    <option value="0">Seleccione</option>
                                                    <?php
                                                    foreach ($usosCfdi as $usoCfdi) {

                                                        if (isset($_GET['movimiento'])) {
                                                            if ($usoCfdi->id == 3) {
                                                                echo "<option value='$usoCfdi->id' selected>$usoCfdi->uso_cfdi</option>";
                                                            } else {
                                                                echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                                                            }
                                                        } else {
                                                            echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                                                        }
                                                        //echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-4">

                                            <div>
                                                <label for="browserState">Estatus de pago</label>
                                                <select name="status_pago" id="status_pago" required="" class="form-select" <?php echo $seCargo ?>>

                                                    <?php

                                                    if (isset($_GET['movimiento'])) {
                                                        echo '
                                                   <option value="Pagado" selected>Pagado</option>';
                                                    } else {
                                                        echo ' <option value="No Pagado">No Pagado</option>
                                                    <option value="Pagado" selected>Pagado</option>';
                                                    }


                                                    ?>

                                                </select>
                                            </div>
                                            <div>
                                                <label for="browserZip">Retención 4%</label>
                                                <select name="retencion_transporte" id="retencion_transporte" required="" class="form-select">
                                                    <option value="No">No</option>
                                                    <option value="Si">Si</option>
                                                </select>
                                            </div>


                                            <div>
                                                <label for="browserZip">Moneda</label>
                                                <select name="moneda" id="moneda" required="" class="form-select">
                                                    <option value="1" selected>MXN</option>
                                                    <option value="2">USD</option>
                                                    <option value="3">EUR</option>

                                                </select>
                                            </div>

                                            <div>
                                                <label for="browserZip">Pago asociado</label>
                                                <input type="number" class="form-input" id="pago_asociado" name="pago_asociado" readonly>
                                            </div>

                                            <?php

                                            if (isset($_GET['movimiento'])) {
                                            ?>
                                                <div>
                                                    <label for="browserZip">Monto cargado</label>
                                                    <input type="text" value="$ <?php echo number_format($movimiento->monto, 2) ?>" name="monto-cargado" id="monto-cargado" class="form-input" disabled>
                                                </div>

                                            <?php } ?>



                                        </div>


                                        <div class="grid grid-cols-5">
                                            <div class="col-span-1 mx-0.5 md:mx-2 lg:mx-2">
                                                <button type="submit" onclick="enviarFactura()" id="boton-terminar" class="btn btn-primary w-full h-full">Terminar Factura</button>
                                            </div>
                                            <div class="col-span-1 mx-0.5 md:mx-2 lg:mx-2">
                                                <!-- extra large -->
                                                <div x-data="modal">
                                                    <!-- button -->
                                                    <button type="button" class="btn btn-warning w-full h-full" @click="toggle">Agregar Concepto</button>

                                                    <!-- modal -->
                                                    <div class="fixed inset-0 bg-[black]/60 z-[999]  hidden" :class="open && '!block'">
                                                        <div class="flex items-start justify-center min-h-screen px-4" @click.self="open = false">
                                                            <div x-show="open" x-transition x-transition.duration.300 class="panel border-0 p-0 rounded-lg overflow-hidden w-full max-w-5xl my-8">
                                                                <div class="flex bg-[#fbfbfb] dark:bg-[#121c2c] items-center justify-between px-5 py-3">
                                                                    <h5 class="font-bold text-lg">Conceptos</h5>
                                                                </div>
                                                                <div class="p-5">
                                                                    <div class="dark:text-white-dark/70 text-base font-medium text-[#1f2937]" style="overflow-x: scroll; overflow:auto;">

                                                                        <table id="miTabla" class="table">
                                                                            <thead>
                                                                                <tr>
                                                                                    <th>Código</th>
                                                                                    <th><span class="pull-left">Cve Unidad.</span></th>
                                                                                    <th style="min-width: 220px;">Producto</th>
                                                                                    <th style="min-width: 100px;"><span class="pull-right">Cant.</span></th>
                                                                                    <th style="min-width: 100px;"><span class="pull-right">P/U con IVA</span></th>
                                                                                    <th style="min-width: 100px;"><span class="pull-right">Precio total con IVA</span></th>
                                                                                    <th class="text-center" style="width: 36px;">Agregar</th>

                                                                                </tr>
                                                                            </thead>
                                                                            <tbody>

                                                                            </tbody>
                                                                        </table>
                                                                    </div>
                                                                    <div class="flex justify-end items-center mt-8">
                                                                        <button type="button" class="btn btn-outline-danger" @click="toggle">Cancelar</button>
                                                                        <button type="button" class="btn btn-primary ltr:ml-4 rtl:mr-4" @click="toggle">Guardar</button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-span-1 mx-0.5 md:mx-2 lg:mx-2">
                                                <!-- vertically centered -->
                                                <div class="" x-data="modal">
                                                    <!-- button -->
                                                    <div class="flex items-center">
                                                        <button type="button" class="btn btn-info w-full h-full" @click="toggle">Importar captura</button>
                                                    </div>

                                                    <!-- modal -->
                                                    <div class="fixed inset-0 bg-[black]/60 z-[999] hidden overflow-y-auto" :class="open && '!block'">
                                                        <div class="flex items-center justify-center min-h-screen px-4" @click.self="open = false">
                                                            <div x-show="open" x-transition x-transition.duration.300 class="panel border-0 p-0 rounded-lg overflow-hidden w-full max-w-lg my-8">
                                                                <div class="flex bg-[#fbfbfb] dark:bg-[#121c2c] items-center justify-between px-5 py-3">
                                                                    <h5 class="font-bold text-lg">Importar factura</h5>
                                                                </div>
                                                                <div class="p-5">
                                                                    <div class="dark:text-white-dark/70 text-base font-medium text-[#1f2937]">

                                                                        <textarea name="captura" id="summernote"></textarea>
                                                                        <script>
                                                                            $('#summernote').summernote({
                                                                                placeholder: 'Pega la factura aquí...',
                                                                                tabsize: 2,
                                                                                height: 120,
                                                                                toolbar: false
                                                                            });
                                                                        </script>

                                                                    </div>
                                                                    <div class="flex justify-end items-center mt-8">
                                                                        <button type="button" class="btn btn-outline-danger" onclick="enviarImportado()">Importar</button>
                                                                        <button type="button" class="btn btn-primary ltr:ml-4 rtl:mr-4" @click="toggle">Save</button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-span-1 mx-0.5 md:mx-2 lg:mx-2">
                                                <button type="submit" onclick="crearFactura(<?php echo $movimiento->monto ?>);" class="btn btn-primary w-full h-full">Randomize</button>
                                            </div>

                                        </div>






                                        <!-- script -->
                                        <script>
                                            document.addEventListener("alpine:init", () => {
                                                Alpine.data("modal", (initialOpenState = false) => ({
                                                    open: initialOpenState,

                                                    toggle() {
                                                        this.open = !this.open;
                                                    },
                                                }));
                                            });
                                        </script>





                                        <!-- script -->
                                        <script>
                                            document.addEventListener("alpine:init", () => {
                                                Alpine.data("modal", (initialOpenState = false) => ({
                                                    open: initialOpenState,
                                                    toggle() {
                                                        this.open = !this.open;
                                                    },
                                                }));
                                            });
                                        </script>



                                    </form>
                                </div>

                            </div>

                            <div class="pt-5">

                                <div class="panel">
                                    <div id="resultados" style="overflow-x: scroll; overflow:auto;">
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th>CODIGO SAT</th>
                                                    <th>CANT.</th>
                                                    <th>PRODUCTO</th>
                                                    <th>PRECIO UNIT.</th>
                                                    <th>APLICA IVA.</th>

                                                    <th>PRECIO TOTAL</th>
                                                    <th>PRECIO TOTAL C/IVA</th>
                                                    <th>ACCION</th>
                                                </tr>
                                            </thead>
                                            <tbody id="resultadosTabla">
                                            </tbody>
                                            <tr>
                                                <td class="text-right" colspan="4">SUBTOTAL $</td>
                                                <td></td>
                                                <td></td>
                                                <td class="text-right">
                                                    <p id="subTotal_f"></p>
                                                </td>
                                                <td></td>
                                            </tr>
                                            <tr>
                                                <td class="text-right" colspan="4">IVA (16)% $</td>
                                                <td></td>
                                                <td></td>
                                                <td class="text-right">
                                                    <p id="iva_f"></p>
                                                </td>
                                                <td></td>
                                            </tr>

                                            <tr>
                                                <td class="text-right" colspan="4">TOTAL $</td>
                                                <td></td>
                                                <td></td>
                                                <td class="text-right" id="total_factura" value="">
                                                    <p id="total_f"></p>
                                                </td>
                                                <td></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>







                            <script>
                                document.addEventListener("DOMContentLoaded", function(e) {
                                    // seachable 
                                    var options = {
                                        searchable: true
                                    };
                                    NiceSelect.bind(document.getElementById("seachable-select"), options);
                                });
                            </script>





                        <?php

                        } else {

                            $empresas = $adminEmpresas->dameEmpresasLite();


                        ?>






                            <div class="panel">
                                <div class="mb-5 flex items-center justify-between">
                                    <h5 class="text-lg font-semibold dark:text-white-light">Selecciona empresa </h5>

                                </div>
                                <form action="fac-facturacion.php" method="get">
                                    <div class="mb-5">
                                        <select id="seachable-select" name="empresa" style="display: none;">
                                            <?php
                                            foreach ($empresas as $empresa) {
                                                echo "<option value='$empresa->id'>$empresa->razon</option>";
                                            }
                                            ?>
                                        </select>


                                    </div>

                                    <button type="submit" class="btn btn-success">Ir a facturar </button>
                                </form>
                            </div>

                            <!-- script -->
                            <script>
                                document.addEventListener("DOMContentLoaded", function(e) {
                                    // seachable 
                                    var options = {
                                        searchable: true
                                    };
                                    NiceSelect.bind(document.getElementById("seachable-select"), options);
                                });
                            </script>

                        <?php } ?>





                    </div>
                </div>
            </div>
            <!-- end main content section -->

            <!-- start footer section -->
            <div class="mt-auto p-6 pt-0 text-center dark:text-white-dark ltr:sm:text-left rtl:sm:text-right">
                © <span id="footer-year">2023</span>. Sistema 14 Ultra All rights reserved.
            </div>
            <!-- end footer section -->
        </div>
    </div>

    <script src="assets/js/alpine-collaspe.min.js"></script>
    <script src="assets/js/alpine-persist.min.js"></script>
    <script defer src="assets/js/alpine-ui.min.js"></script>
    <script defer src="assets/js/alpine-focus.min.js"></script>
    <script defer src="assets/js/alpine.min.js"></script>
    <script src="assets/js/custom.js"></script>
    <!-- start hightlight js -->
    <link rel="stylesheet" href="assets/css/highlight.min.css" />
    <script src="assets/js/highlight.min.js"></script>
    <!-- end hightlight js -->
    <script src="assets/js/nice-select2.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/simple-datatables@latest/dist/style.css" rel="stylesheet" type="text/css">
    <script src="https://cdn.jsdelivr.net/npm/simple-datatables@latest" type="text/javascript"></script>
    <script src=" https://cdn.jsdelivr.net/npm/dinero.js@1.9.1/build/umd/dinero.min.js "></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>



    <script>
        var espacioClaves = document.getElementById("clave_c");
        var clavesCortas = [];

        function cargarClaves(cliente) {
            clavesCortas = [];
            espacioClaves.innerHTML = "";
            fetch("api/apiReporteClavesCortas.php?accion=cliente&idCliente=" + cliente, {
                    method: "GET",
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {


                    for (var i = 0; i < data.aaData.length; i++) {
                        var option = document.createElement("option");
                        option.value = data.aaData[i].id;
                        option.textContent = data.aaData[i].rfc + " - " + data.aaData[i].clave_corta + " - " + data.aaData[i].razon_social;
                        espacioClaves.appendChild(option);
                        clavesCortas.push(data.aaData[i]);
                    }

                });
        }
    </script>


    <script>
        obtenerConceptos();
        var conceptosArreglo = [];

        function obtenerConceptos() {
            console.log("Obteniendo conceptos");
            fetch("api/apiReporteConceptos.php?accion=empresa&empresa=<?php echo $empresa->id ?>", {
                    method: "GET",
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    // console.log(data.aaData);
                    conceptos = data.aaData;

                    var datos = [];
                    for (var i = 0; i < conceptos.length; i++) {
                        conceptosArreglo.push(new ConceptoFacturable(conceptos[i].id, conceptos[i].precio_max, conceptos[i].precio_min, conceptos[i].concepto, conceptos[i].unidades_max));
                        var datosFila = [
                            `<span id="${conceptos[i].id}clave_sat">${conceptos[i].clave_sat}</span>`,
                            `<span id="${conceptos[i].id}unidad">${conceptos[i].clave_unidad_medida}</span>`,
                            `<textarea class="form-input" type="text" id="${conceptos[i].id+"concepto"}">${conceptos[i].concepto}</textarea> <p hidden>${conceptos[i].concepto}</p>`,
                            `<input class="form-input" type="number" id="${conceptos[i].id+"cantidad"}" value="1">`,
                            "", // (puedes dejar vacío; no lo uso)
                            `<input class="form-input" type="number" id="${conceptos[i].id+"precio"}" value="${conceptos[i].precio_min}">`,
                            `<button onclick="anadirAFactura(${conceptos[i].id}, 16)" type="button" class="btn btn-primary">Agregar</button>
                                <button onclick="anadirAFactura(${conceptos[i].id}, 0)"  type="button" class="btn btn-primary">Tasa 0</button>
                                <button onclick="anadirAFactura(${conceptos[i].id}, 'exento')" type="button" class="btn btn-primary">Exento</button>`
                        ];
                        datos.push(datosFila);

                    }

                    const tableOptions = {
                        data: {
                            data: datos
                        },
                        sortable: true,
                        searchable: true,
                        perPage: 5,
                        perPageSelect: [5, 10, 20, 30, 50],
                        firstLast: true,

                    };

                    const datatable1 = new simpleDatatables.DataTable('#miTabla', tableOptions);
                    datatable1.data.push(datosFila);
                    datatable1.update();
                    //console.log(conceptosArreglo);
                });
        }
    </script>

    <script>
        /* ============= ESTADO GLOBAL ============= */
        const conceptosSeleccionados = [];
        const $tb = document.getElementById('resultadosTabla');
        const $sub = document.getElementById('subTotal_f');
        const $iva = document.getElementById('iva_f');
        const $tot = document.getElementById('total_f');
        const $retSel = document.getElementById('retencion_transporte');

        /* ====== Insertar “Otras retenciones (4%)” en el resumen ====== */
        (function asegurarFilaOtrasRet() {
            const cont = document.querySelector('#resultados .table') || document.querySelector('#resultados table') || document.querySelector('.table');
            if (!cont) return;
            if (!document.getElementById('otras_ret_row')) {
                const filas = cont.querySelectorAll('tr');
                const filaTotal = filas[filas.length - 1];
                const tr = document.createElement('tr');
                tr.id = 'otras_ret_row';
                tr.innerHTML = `
      <td class="text-right" colspan="4">Otras retenciones (4%) $</td>
      <td></td><td></td>
      <td class="text-right"><p id="otras_ret_f"></p></td>
      <td></td>
    `;
                filaTotal.parentNode.insertBefore(tr, filaTotal);
            }
        })();
        const $otrasRet = document.getElementById('otras_ret_f');

        /* ============= HELPERS ============= */
        const toNumber = v => Number((v ?? 0).toString().replace(/,/g, '')) || 0;
        const money = n => n.toLocaleString('es-MX', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });

        function getRates(iva_mode) {
            const iva_r = (iva_mode === 16) ? 0.16 : 0;
            const ret_r = (($retSel?.value || 'No') === 'Si') ? 0.04 : 0;
            return {
                iva_r,
                ret_r
            };
        }

        function desglosarUnitario(precioUnitarioConIva, iva_mode) {
            if (iva_mode === 16) {
                const base = precioUnitarioConIva / 1.16;
                const iva = base * 0.16;
                return {
                    base,
                    iva
                };
            } else {
                return {
                    base: precioUnitarioConIva,
                    iva: 0
                };
            }
        }

        /* ============= RENDER Y EDICIÓN DE FILAS ============= */
        function renderFila(con) {
            const tr = document.createElement('tr');
            tr.id = `row_${con.uuid}`;
            tr.innerHTML = `
    <td>${con.clave_sat}</td>
    <td><input type="number" min="0.0001" step="0.0001" class="form-input w-24" value="${con.cantidad}" data-k="cantidad"></td>
    <td><textarea class="form-input w-80" data-k="descripcion">${con.descripcion}</textarea></td>
    <td><input type="number" min="0" step="0.01" class="form-input w-28" value="${con.precio_unitario_con_iva}" data-k="precio_unitario_con_iva"></td>
    <td>
      <select class="form-select w-28" data-k="iva_mode">
        <option value="16" ${con.iva_mode===16?'selected':''}>16%</option>
        <option value="0"  ${con.iva_mode===0?'selected':''}>0%</option>
        <option value="exento" ${con.iva_mode==='exento'?'selected':''}>Exento</option>
      </select>
    </td>
    <td class="text-right"><span data-k="total_sin_iva">${money(con.total_sin_iva)}</span></td>
    <td class="text-right"><span data-k="total_con_iva">${money(con.total_final)}</span></td>
    <td><button class="btn btn-danger" data-action="del">Eliminar</button></td>
  `;
            tr.addEventListener('input', e => {
                const k = e.target.getAttribute('data-k');
                const idx = conceptosSeleccionados.findIndex(x => x.uuid === con.uuid);
                if (idx < 0) return;
                if (k === 'cantidad') {
                    conceptosSeleccionados[idx].cantidad = Math.max(0.0001, toNumber(e.target.value));
                    recalcularFilaYTotales(conceptosSeleccionados[idx], 'cantidad');
                } else if (k === 'precio_unitario_con_iva') {
                    conceptosSeleccionados[idx].precio_unitario_con_iva = toNumber(e.target.value);
                    recalcularFilaYTotales(conceptosSeleccionados[idx], 'precio_unitario_con_iva');
                } else if (k === 'descripcion') {
                    conceptosSeleccionados[idx].descripcion = e.target.value;
                } else if (k === 'iva_mode') {
                    const val = e.target.value;
                    conceptosSeleccionados[idx].iva_mode = (val === 'exento') ? 'exento' : Number(val);
                    recalcularFilaYTotales(conceptosSeleccionados[idx], 'iva_mode');
                }
            });
            tr.addEventListener('change', e => {
                if (e.target.getAttribute('data-k') === 'iva_mode') {
                    const idx = conceptosSeleccionados.findIndex(x => x.uuid === con.uuid);
                    const val = e.target.value;
                    conceptosSeleccionados[idx].iva_mode = (val === 'exento') ? 'exento' : Number(val);
                    recalcularFilaYTotales(conceptosSeleccionados[idx], 'iva_mode');
                }
            });
            tr.querySelector('[data-action="del"]').addEventListener('click', () => eliminarConcepto(con.uuid));
            return tr;
        }

        function upsertFila(con) {
            const existing = document.getElementById(`row_${con.uuid}`);
            const nueva = renderFila(con);
            if (existing) $tb.replaceChild(nueva, existing);
            else $tb.appendChild(nueva);
        }

        function eliminarConcepto(uuid) {
            const idx = conceptosSeleccionados.findIndex(x => x.uuid === uuid);
            if (idx >= 0) {
                conceptosSeleccionados.splice(idx, 1);
                const tr = document.getElementById(`row_${uuid}`);
                if (tr) tr.remove();
                recalcularTotales();
            }
            console.table(conceptosSeleccionados);
        }

        /* ============= RECÁLCULOS ============= */
        function recalcLibre(con) {
            const {
                base,
                iva
            } = desglosarUnitario(con.precio_unitario_con_iva, con.iva_mode);
            con.precio_unitario_sin_iva = base;
            con.iva_unitario = iva;

            const baseTotal = base * con.cantidad;
            const ivaTotal = iva * con.cantidad;
            const {
                ret_r
            } = getRates(con.iva_mode);
            const retTotal = baseTotal * ret_r;

            con.total_sin_iva = baseTotal;
            con.total_iva = ivaTotal;
            con.retencion_total = retTotal;
            con.total_final = baseTotal + ivaTotal - retTotal;
        }

        function recalcDesdeObjetivo(con) {
            const objetivo = con.total_objetivo;
            const q = Math.max(0.0001, con.cantidad);
            const {
                iva_r,
                ret_r
            } = getRates(con.iva_mode);
            const denom = 1 + iva_r - ret_r;
            const baseTotal = (denom > 0) ? (objetivo / denom) : 0;
            const baseUnit = baseTotal / q;
            con.precio_unitario_con_iva = (con.iva_mode === 16) ? baseUnit * 1.16 : baseUnit;
            recalcLibre(con);
        }

        function recalcularFilaYTotales(con, changedField) {
            if (con.total_objetivo != null && changedField !== 'precio_unitario_con_iva') {
                recalcDesdeObjetivo(con);
            } else {
                recalcLibre(con);
                if (changedField === 'precio_unitario_con_iva') {
                    con.total_objetivo = con.total_final;
                }
            }
            const tr = document.getElementById(`row_${con.uuid}`);
            if (tr) {
                tr.querySelector('[data-k="total_sin_iva"]').textContent = money(con.total_sin_iva);
                tr.querySelector('[data-k="total_con_iva"]').textContent = money(con.total_final);
                tr.querySelector('[data-k="precio_unitario_con_iva"]').value = Number(con.precio_unitario_con_iva.toFixed(2));
            }
            recalcularTotales();
            console.table(conceptosSeleccionados);
        }

        function recalcularTotales() {
            const subtotal = conceptosSeleccionados.reduce((a, c) => a + c.total_sin_iva, 0);
            const ivaTotal = conceptosSeleccionados.reduce((a, c) => a + c.total_iva, 0);
            const retTotal = conceptosSeleccionados.reduce((a, c) => a + c.retencion_total, 0);
            const total = subtotal + ivaTotal - retTotal;
            $sub.textContent = money(subtotal);
            $iva.textContent = money(ivaTotal);
            $otrasRet.textContent = retTotal ? `-${money(retTotal)}` : money(0);
            $tot.textContent = money(total);
        }

        if ($retSel) {
            $retSel.addEventListener('change', () => conceptosSeleccionados.forEach(c => recalcularFilaYTotales(c, 'ret_global')));
        }

        /* ============= AGREGAR DESDE EL MODAL ============= */
        window.anadirAFactura = function(idConcepto, ivaMode) {
            const clave_sat = (document.getElementById(`${idConcepto}clave_sat`)?.textContent || '').trim();
            const unidad = (document.getElementById(`${idConcepto}unidad`)?.textContent || '').trim();
            const descripcion = document.getElementById(`${idConcepto}concepto`)?.value ?? '';
            const cantidad = Math.max(0.0001, toNumber(document.getElementById(`${idConcepto}cantidad`)?.value ?? 1));
            const totalObjetivo = toNumber(document.getElementById(`${idConcepto}precio`)?.value ?? 0);
            let iva_mode = (ivaMode === 'exento') ? 'exento' : Number(ivaMode);
            const uuid = `${idConcepto}_${Date.now()}`;
            const conceptoAdd = {
                uuid,
                id_concepto: idConcepto,
                clave_sat,
                unidad,
                descripcion,
                cantidad,
                iva_mode,
                precio_unitario_con_iva: 0,
                precio_unitario_sin_iva: 0,
                iva_unitario: 0,
                total_sin_iva: 0,
                total_iva: 0,
                total_final: 0,
                retencion_total: 0,
                total_objetivo: totalObjetivo
            };
            recalcDesdeObjetivo(conceptoAdd);
            conceptosSeleccionados.push(conceptoAdd);
            upsertFila(conceptoAdd);
            recalcularTotales();
            console.table(conceptosSeleccionados);
        };

        /* ============= PAYLOADS Y ENVÍO ============= */
        function obtenerPayloadFactura() {
            return conceptosSeleccionados.map(c => ({
                id_concepto: c.id_concepto,
                clave_sat: c.clave_sat,
                unidad: c.unidad,
                descripcion: c.descripcion,
                cantidad: c.cantidad,
                iva_mode: c.iva_mode,
                precio_unitario_con_iva: Number(c.precio_unitario_con_iva.toFixed(2)),
                precio_unitario_sin_iva: Number(c.precio_unitario_sin_iva.toFixed(6)),
                total_sin_iva: Number(c.total_sin_iva.toFixed(2)),
                total_iva: Number(c.total_iva.toFixed(2)),
                retencion: Number(c.retencion_total.toFixed(2)), // 👈 agregado
                total_final: Number(c.total_final.toFixed(2)),
                total_objetivo: Number((c.total_objetivo ?? c.total_final).toFixed(2))
            }));
        }

        function obtenerResumenTotales() {
            const subtotal = conceptosSeleccionados.reduce((a, c) => a + c.total_sin_iva, 0);
            const ivaTotal = conceptosSeleccionados.reduce((a, c) => a + c.total_iva, 0);
            const retTotal = conceptosSeleccionados.reduce((a, c) => a + c.retencion_total, 0);
            const total = subtotal + ivaTotal - retTotal;
            return {
                subtotal: Number(subtotal.toFixed(2)),
                iva: Number(ivaTotal.toFixed(2)),
                otras_ret_4: Number(retTotal.toFixed(2)),
                total: Number(total.toFixed(2)),
                aplica_ret_4: retTotal > 0
            };
        }

        // --- Utilidad para leer parámetros de la URL ---
        function getUrlParam(name) {
            const url = new URL(window.location.href);
            return url.searchParams.get(name);
        }

        async function enviarFactura() {
            try {
                if (conceptosSeleccionados.length === 0) {
                    alert('Agrega al menos un concepto antes de terminar.');
                    return;
                }

                // --- Totales globales ---
                const subtotal = conceptosSeleccionados.reduce((a, c) => a + c.total_sin_iva, 0);
                const ivaTotal = conceptosSeleccionados.reduce((a, c) => a + c.total_iva, 0);
                const retTotal = conceptosSeleccionados.reduce((a, c) => a + c.retencion_total, 0);
                const total = subtotal + ivaTotal - retTotal;

                // --- Datos del formulario ---
                const cliente = document.querySelector('select[name="cliente"]')?.value || '';
                const razonSocial = document.getElementById('clave_c')?.value || '';
                const metodo_pago = document.getElementById('metodo_pago')?.value || '';
                const forma_pago = document.getElementById('forma_pago')?.value || '';
                const tipo_comprobante = document.getElementById('tipo_comprobante')?.value || '';
                const uso_cfdi = document.getElementById('uso_cfdi')?.value || '';
                const status_pago = document.getElementById('status_pago')?.value || '';
                const retencion_trans = document.getElementById('retencion_transporte')?.value || 'No';
                const moneda = document.getElementById('moneda')?.value || '1';
                const pago_asociado = document.getElementById('pago_asociado')?.value || 0;

                // --- Obtener empresa desde la URL ---
                const empresa = getUrlParam("empresa") || 0;

                // --- Construir arreglo de conceptos ---
                const conceptos = conceptosSeleccionados.map(c => ({
                    id: c.id_concepto.toString(),
                    concepto: c.descripcion,
                    precio: Number(c.total_final.toFixed(2)), // total final del concepto
                    cantidad: c.cantidad.toString(),
                    aplica_iva: c.iva_mode === 16 ? 'si' : 'no',
                    ivaTotal: Number(c.total_iva.toFixed(6)),
                    subTotal: Number(c.total_sin_iva.toFixed(6)),
                    idRel: 0,
                    iva: c.iva_mode === 16 ? 16 : 0,
                    retencion: Number(c.retencion_total.toFixed(6)) // 👈 retención por concepto
                }));

                // --- Construir el objeto completo ---
                const payload = {
                    cliente: cliente,
                    razonSocial: razonSocial,
                    metodo_pago: metodo_pago,
                    forma_pago: forma_pago,
                    tipo_comprobante: tipo_comprobante,
                    uso_cfdi: uso_cfdi,
                    status_pago: status_pago,
                    retencion_transporte: retencion_trans,
                    movimientoAsociado: pago_asociado,
                    usuarioInserta: 0, // 👈 siempre 0
                    empresa: Number(empresa), // 👈 obtenido desde la URL
                    total: Number(total.toFixed(2)),
                    subtotal: Number(subtotal.toFixed(6)),
                    retencion_total: Number(retTotal.toFixed(6)), // 👈 retención global
                    conceptos: conceptos,
                    pago: "",
                    moneda: moneda
                };

                console.log("Payload final:", payload);
                var datosFormulario = new FormData();
                datosFormulario.append('factura', JSON.stringify(payload));
                datosFormulario.append('accion', 'guardar');
                // --- Enviar vía fetch como JSON ---
                const resp = await fetch('api/apiFactura.php', {
                    method: 'POST',
                    headers: {
                        'Accept': 'application/json'
                    },
                    body: datosFormulario
                });

                const data = await resp.text();
                console.log("Respuesta apiFac.php:", data);

                if (window.Swal) {
                    Swal.fire('Factura enviada', 'Se envió la información a apiFac.php correctamente.', 'success');
                }

            } catch (err) {
                console.error("Error al enviar factura:", err);
                if (window.Swal) {
                    Swal.fire('Error', 'Ocurrió un error al enviar la factura.', 'error');
                }
            }
        }
    </script>




</body>

</html>