<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Nueva Factura - S14U</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" type="image/x-icon" href="favicon.png" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/perfect-scrollbar.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css" />
    <link defer rel="stylesheet" type="text/css" media="screen" href="assets/css/animate.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/asiel.css" />
    <script src="assets/js/perfect-scrollbar.min.js"></script>
    <script defer src="assets/js/popper.min.js"></script>
    <script defer src="assets/js/tippy-bundle.umd.min.js"></script>
    <script defer src="assets/js/sweetalert.min.js"></script>
    <link rel="stylesheet" type="text/css" href="assets/css/nice-select2.css" />
    <script src="https://code.jquery.com/jquery-3.4.1.slim.min.js" integrity="sha384-J6qa4849blE2+poT4WnyKhv5vZF5SrPo0iEjwBvKU7imGFAV0wwj1yYfoRSJoZ+n" crossorigin="anonymous"></script>
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
</head>

<body x-data="main" class="relative overflow-x-hidden font-nunito text-sm font-normal antialiased" :class="[ $store.app.sidebar ? 'toggle-sidebar' : '', $store.app.theme === 'dark' || $store.app.isDarkMode ?  'dark' : '', $store.app.menu, $store.app.layout,$store.app.rtlClass]">
    <!-- sidebar menu overlay -->
    <div x-cloak class="fixed inset-0 z-50 bg-[black]/60 lg:hidden" :class="{'hidden' : !$store.app.sidebar}" @click="$store.app.toggleSidebar()"></div>

    <!-- screen loader -->
    <div class="screen_loader animate__animated fixed inset-0 z-[60] grid place-content-center bg-[#fafafa] dark:bg-[#060818]">
        <div class="containerL">
            <div class="item item-1"></div>
            <div class="item item-2"></div>
            <div class="item item-3"></div>
            <div class="item item-4"></div>
        </div>
    </div>

    <!-- scroll to top button -->
    <div class="fixed bottom-6 z-50 ltr:right-6 rtl:left-6" x-data="scrollToTop">
        <template x-if="showTopButton">
            <button type="button" class="btn btn-outline-primary animate-pulse rounded-full bg-[#fafafa] p-2 dark:bg-[#060818] dark:hover:bg-primary" @click="goToTop">
                <svg width="24" height="24" class="h-4 w-4" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd" d="M12 20.75C12.4142 20.75 12.75 20.4142 12.75 20L12.75 10.75L11.25 10.75L11.25 20C11.25 20.4142 11.5858 20.75 12 20.75Z" fill="currentColor" />
                    <path d="M6.00002 10.75C5.69667 10.75 5.4232 10.5673 5.30711 10.287C5.19103 10.0068 5.25519 9.68417 5.46969 9.46967L11.4697 3.46967C11.6103 3.32902 11.8011 3.25 12 3.25C12.1989 3.25 12.3897 3.32902 12.5304 3.46967L18.5304 9.46967C18.7449 9.68417 18.809 10.0068 18.6929 10.287C18.5768 10.5673 18.3034 10.75 18 10.75L6.00002 10.75Z" fill="currentColor" />
                </svg>
            </button>
        </template>
    </div>

    <!-- start theme customizer section -->
    <?php include "template/header.php" ?>
    <!-- end theme customizer section -->

    <div class="main-container min-h-screen text-black dark:text-white-dark" :class="[$store.app.navbar]">
        <!-- start sidebar section -->
        <?php include "template/barra.php" ?>
        <!-- end sidebar section -->

        <div class="main-content flex min-h-screen flex-col">
            <!-- start header section -->
            <?php include "template/barra_sup.php" ?>
            <!-- end header section -->

            <div class="animate__animated p-6" :class="[$store.app.animation]">
                <!-- start main content section -->
                <div x-data="sales">
                    <ul class="flex space-x-2 rtl:space-x-reverse">
                        <li>
                            <a href="index.php" class="text-primary hover:underline">Inicio</a>
                        </li>
                        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                            <span>Facturación</span>
                        </li>
                    </ul>

                    <div class="pt-5">




                        <?php
                        include "api/adminEmpresas.php";
                        include "api/adminConceptos.php";
                        include "api/adminClientes.php";
                        include "api/adminFormasPago.php";
                        include "api/adminPagos.php";

                        $adminEmpresas = new AdminEmpresas();
                        $adminConceptos = new AdministradorConceptos();
                        $adminClientes = new AdministradorClientes();
                        $adminFormasPago = new AdministradorFormasPago();
                        $adminPagos = new AdministradorPagos();
                        ?>

                        <!-- ############ PAGE START-->

                        <?php

                        if (isset($_GET['empresa'])) {
                            $empresa = $adminEmpresas->dameEmpresa($_GET['empresa']);
                            $clientes = $adminClientes->dameClientes();
                            $formasPago = $adminFormasPago->dameFormasPago();
                            $metodosPago = $adminFormasPago->dameMetodosPago();
                            $usosCfdi = $adminFormasPago->dameUsosCfdi();
                            if (isset($_GET['movimiento'])) {
                                $seCargo = 'readonly';
                                $movimiento = $adminPagos->damePago($_GET['movimiento']);
                                $detectado = 1;
                                //echo var_dump($movimiento);
                                // $modalRef = '<a data-toggle="modal" data-target="#barraMovimiento" > DETALLES MOVIMIENTO</a>';
                            } else {
                                $movimiento = null;
                                $detectado = 0;
                            }

                        ?>








                            <div class="panel">
                                <div class="mb-5 flex items-center justify-between">
                                    <h5 class="text-lg font-semibold dark:text-white-light">Facturación <?php echo $empresa->razon ?></h5>

                                </div>
                                <div class="mb-5">
                                    <div class="space-y-5">
                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-2">
                                            <div>
                                                <label for="browserFname">Selecciona cliente</label>
                                                <select onchange="cargarClaves(this.value)" id="seachable-select" name="cliente" style="display: none;">
                                                    <?php
                                                    foreach ($clientes as $cliente) {
                                                        if ($cliente->id == $movimiento->idCliente) {
                                                            echo "<option value='$cliente->id' selected>$cliente->nombre</option>";
                                                        } else {
                                                            echo "<option value='$cliente->id'>$cliente->nombre</option>";
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div>
                                                <label for="browserLname">Razón social</label>
                                                <select name="clave_c" id="clave_c" class="form-select">

                                                </select>
                                            </div>

                                        </div>
                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-4">
                                            <div>
                                                <label for="browserCity">Método de pago </label>
                                                <select name="metodo_pago" id="metodo_pago" class="form-select">
                                                    <?php
                                                    foreach ($metodosPago as $metodoPago) {
                                                        if (isset($_GET['movimiento'])) {
                                                            if ($metodoPago->id == 2) {
                                                                echo "<option value='$metodoPago->id' selected>$metodoPago->metodo_pago</option>";
                                                            }
                                                        } else {
                                                            echo "<option value='$metodoPago->id'>$metodoPago->metodo_pago</option>";
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div>
                                                <label for="browserState">Forma de pago </label>
                                                <select name="forma_pago" id="forma_pago" class="form-select">
                                                    <option value="0">Seleccione</option>
                                                    <?php
                                                    foreach ($formasPago as $formaPago) {
                                                        if (isset($_GET['movimiento'])) {
                                                            if ($formaPago->id == 23) {
                                                                echo "<option value='$formaPago->id' selected>$formaPago->forma_pago</option>";
                                                            } else {
                                                                echo "<option value='$formaPago->id'>$formaPago->forma_pago</option>";
                                                            }
                                                        } else {
                                                            echo "<option value='$formaPago->id'>$formaPago->forma_pago</option>";
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div>
                                                <label for="browserZip">Tipo de comprobante </label>
                                                <select name="tipo_comprobante" id="tipo_comprobante" required="" class="form-select">
                                                    <option selected="" value=""></option>
                                                    <option value="I" selected>Ingreso</option>
                                                    <option value="E">Egreso</option>
                                                    <option value="T">Traslado</option>
                                                    <option value="N">Nomina</option>
                                                    <option value="P">Pago</option>
                                                </select>
                                            </div>
                                            <div>
                                                <label for="browserCity">Uso De CFDI</label>
                                                <select name="uso_cfdi" id="uso_cfdi" class="form-select">
                                                    <option value="0">Seleccione</option>
                                                    <?php
                                                    foreach ($usosCfdi as $usoCfdi) {

                                                        if (isset($_GET['movimiento'])) {
                                                            if ($usoCfdi->id == 3) {
                                                                echo "<option value='$usoCfdi->id' selected>$usoCfdi->uso_cfdi</option>";
                                                            } else {
                                                                echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                                                            }
                                                        } else {
                                                            echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                                                        }
                                                        //echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-4">

                                            <div>
                                                <label for="browserState">Estatus de pago</label>
                                                <select name="status_pago" id="status_pago" required="" class="form-select" <?php echo $seCargo ?>>

                                                    <?php

                                                    if (isset($_GET['movimiento'])) {
                                                        echo '
                                                        <option value="No Pagado">No Pagado</option>';
                                                    } else {
                                                        echo ' <option value="No Pagado">No Pagado</option>
                                                    <option value="Pagado" selected>Pagado</option>';
                                                    }


                                                    ?>

                                                </select>
                                            </div>
                                            <div>
                                                <label for="browserZip">Retención 4%</label>
                                                <select name="retencion_transporte" id="retencion_transporte" required="" class="form-select">
                                                    <option value="No">No</option>
                                                    <option value="Si">Si</option>
                                                </select>
                                            </div>


                                            <div>
                                                <label for="browserZip">Moneda</label>
                                                <select name="moneda" id="moneda" required="" class="form-select">
                                                    <option value="1" selected>MXN</option>
                                                    <option value="2">USD</option>
                                                    <option value="3">EUR</option>

                                                </select>
                                            </div>





                                        </div>

                                        <button type="submit" onclick="enviarFactura()" id="boton-terminar" class="btn btn-primary !mt-6">Terminar Factura</button>


                                        <!-- extra large -->
                                        <div x-data="modal">
                                            <!-- button -->
                                            <button type="button" class="btn btn-warning" @click="toggle">Agregar Concepto</button>

                                            <!-- modal -->
                                            <div class="fixed inset-0 bg-[black]/60 z-[999]  hidden" :class="open && '!block'">
                                                <div class="flex items-start justify-center min-h-screen px-4" @click.self="open = false">
                                                    <div x-show="open" x-transition x-transition.duration.300 class="panel border-0 p-0 rounded-lg overflow-hidden w-full max-w-5xl my-8">
                                                        <div class="flex bg-[#fbfbfb] dark:bg-[#121c2c] items-center justify-between px-5 py-3">
                                                            <h5 class="font-bold text-lg">Conceptos</h5>
                                                        </div>
                                                        <div class="p-5">
                                                            <div class="dark:text-white-dark/70 text-base font-medium text-[#1f2937]">

                                                                <table id="miTabla" class="table">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>Código</th>
                                                                            <th><span class="pull-left">Cve Unidad.</span></th>
                                                                            <th>Producto</th>
                                                                            <th><span class="pull-right">Cant.</span></th>
                                                                            <th><span class="pull-right">P/U con IVA</span></th>
                                                                            <th><span class="pull-right">Precio total con IVA</span></th>
                                                                            <th class="text-center" style="width: 36px;">Agregar</th>

                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>

                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                            <div class="flex justify-end items-center mt-8">
                                                                <button type="button" class="btn btn-outline-danger" @click="toggle">Discard</button>
                                                                <button type="button" class="btn btn-primary ltr:ml-4 rtl:mr-4" @click="toggle">Save</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>




                                        <!-- script -->
                                        <script>
                                            document.addEventListener("alpine:init", () => {
                                                Alpine.data("modal", (initialOpenState = false) => ({
                                                    open: initialOpenState,

                                                    toggle() {
                                                        this.open = !this.open;
                                                    },
                                                }));
                                            });
                                        </script>



                                        <!-- vertically centered -->
                                        <div class="mb-5" x-data="modal">
                                            <!-- button -->
                                            <div class="flex items-center">
                                                <button type="button" class="btn btn-info" @click="toggle">Importar captura</button>
                                            </div>

                                            <!-- modal -->
                                            <div class="fixed inset-0 bg-[black]/60 z-[999] hidden overflow-y-auto" :class="open && '!block'">
                                                <div class="flex items-center justify-center min-h-screen px-4" @click.self="open = false">
                                                    <div x-show="open" x-transition x-transition.duration.300 class="panel border-0 p-0 rounded-lg overflow-hidden w-full max-w-lg my-8">
                                                        <div class="flex bg-[#fbfbfb] dark:bg-[#121c2c] items-center justify-between px-5 py-3">
                                                            <h5 class="font-bold text-lg">Importar factura</h5>
                                                        </div>
                                                        <div class="p-5">
                                                            <div class="dark:text-white-dark/70 text-base font-medium text-[#1f2937]">

                                                                <textarea name="captura" id="summernote"></textarea>
                                                                <script>
                                                                    $('#summernote').summernote({
                                                                        placeholder: 'Pega la factura aquí...',
                                                                        tabsize: 2,
                                                                        height: 120,
                                                                        toolbar: false
                                                                    });
                                                                </script>

                                                            </div>
                                                            <div class="flex justify-end items-center mt-8">
                                                                <button type="button" class="btn btn-outline-danger" onclick="enviarImportado()">Importar</button>
                                                                <button type="button" class="btn btn-primary ltr:ml-4 rtl:mr-4" @click="toggle">Save</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- script -->
                                        <script>
                                            document.addEventListener("alpine:init", () => {
                                                Alpine.data("modal", (initialOpenState = false) => ({
                                                    open: initialOpenState,
                                                    toggle() {
                                                        this.open = !this.open;
                                                    },
                                                }));
                                            });
                                        </script>

                                        <button type="submit" onclick="crearFactura(<?php echo $movimiento->monto ?>);" class="btn btn-primary !mt-6">Randomize </button>



                                    </div>
                                </div>

                            </div>


                            <br>

                            <div class="panel">
                                <div class="mb-5 flex items-center justify-between">
                                    <h5 class="text-lg font-semibold dark:text-white-light">Datos de complemento</h5>

                                </div>
                                <form id="agregar-complemento">
                                    <div class="mb-5">

                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-2">
                                            <div style="display: none;">
                                                <label for="browserFname">Método de pago</label>
                                                <input type="text" value="1" id="metodo_pago_c">
                                            </div>

                                            <div>
                                                <label for="browserLname">Forma de pago</label>
                                                <select name="forma_pago_c" id="forma_pago_c" class="form-input">
                                                    <option value="" disabled selected>Selecciona una opción</option>
                                                    <?php
                                                    foreach ($formasPago as $formaPago) {
                                                        if (isset($_GET['movimiento'])) {
                                                            if ($formaPago->id == 3) {
                                                                echo "<option value='$formaPago->id' selected>$formaPago->forma_pago</option>";
                                                            } else {
                                                                echo "<option value='$formaPago->id'>$formaPago->forma_pago</option>";
                                                            }
                                                        } else {
                                                            echo "<option value='$formaPago->id'>$formaPago->forma_pago</option>";
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>

                                            <div>
                                                <label for="browserCity">Monto</label>
                                                <input type="text" class="form-input" value="<?php echo $movimiento->monto ?>" name="monto_c" id="monto_c" placeholder="$" readonly>
                                            </div>


                                        </div>
                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-2">

                                            <div>
                                                <label for="browserFname">Tipo de comprobante</label>
                                                <select id="tipo_comprobante_c" name="tipo_comprobante_c" class="form-input">
                                                    <option value="" disabled selected>Selecciona una opción</option>
                                                    <option selected="" value=""></option>
                                                    <option value="I" selected>Ingreso</option>
                                                    <option value="E">Egreso</option>
                                                    <option value="T">Traslado</option>
                                                    <option value="N">Nomina</option>
                                                    <option value="P">Pago</option>
                                                </select>
                                            </div>

                                            <div>
                                                <label for="browserLname">Uso de CFDI</label>
                                                <select name="uso_cfdi_c" id="uso_cfdi_c" class="form-select">
                                                    <option value="" disabled selected>Selecciona una opción</option>
                                                    <?php
                                                    foreach ($usosCfdi as $usoCfdi) {

                                                        if (isset($_GET['movimiento'])) {
                                                            if ($usoCfdi->id == 3) {
                                                                echo "<option value='$usoCfdi->id' selected>$usoCfdi->uso_cfdi</option>";
                                                            } else {
                                                                echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                                                            }
                                                        } else {
                                                            echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                                                        }
                                                        //echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                                                    }
                                                    ?>
                                                </select>
                                            </div>

                                        </div>
                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-2">
                                            <div>
                                                <label for="browserCity">Fecha</label>
                                                <input type="date" class="form-input" value="<?php echo $movimiento->fecha_banco ?>" name="fecha_c" id="fecha_c">
                                            </div>



                                        </div>


                                    </div>





                                </form>




                            </div>




                            <div class="pt-5">

                                <div class="panel">
                                    <div id="resultados">
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th>CÓDIGO SAT</th>
                                                    <th>CANT.</th>
                                                    <th>PRODUCTO</th>
                                                    <th>PRECIO UNIT.</th>
                                                    <th>APLICA IVA.</th>

                                                    <th>PRECIO TOTAL</th>
                                                    <th>PRECIO TOTAL C/IVA</th>
                                                    <th>ACCIÓN</th>
                                                </tr>
                                            </thead>
                                            <tbody id="resultadosTabla">
                                            </tbody>
                                            <tr>
                                                <td class="text-right" colspan="4">SUBTOTAL $</td>
                                                <td></td>
                                                <td></td>
                                                <td class="text-right">
                                                    <p id="subTotal_f"></p>
                                                </td>
                                                <td></td>
                                            </tr>
                                            <tr>
                                                <td class="text-right" colspan="4">IVA (16)% $</td>
                                                <td></td>
                                                <td></td>
                                                <td class="text-right">
                                                    <p id="iva_f"></p>
                                                </td>
                                                <td></td>
                                            </tr>

                                            <tr>
                                                <td class="text-right" colspan="4">TOTAL $</td>
                                                <td></td>
                                                <td></td>
                                                <td class="text-right" id="total_factura" value="">
                                                    <p id="total_f"></p>
                                                </td>
                                                <td></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>







                            <script>
                                document.addEventListener("DOMContentLoaded", function(e) {
                                    // seachable 
                                    var options = {
                                        searchable: true
                                    };
                                    NiceSelect.bind(document.getElementById("seachable-select"), options);
                                });
                            </script>





                        <?php

                        } else {

                            $empresas = $adminEmpresas->dameEmpresasLite();


                        ?>






                            <div class="panel">
                                <div class="mb-5 flex items-center justify-between">
                                    <h5 class="text-lg font-semibold dark:text-white-light">Selecciona empresa </h5>

                                </div>
                                <form action="fac-facturacion.php" method="get">
                                    <div class="mb-5">
                                        <select id="seachable-select" name="empresa" style="display: none;">
                                            <?php
                                            foreach ($empresas as $empresa) {
                                                echo "<option value='$empresa->id'>$empresa->razon</option>";
                                            }
                                            ?>
                                        </select>


                                    </div>

                                    <button type="submit" class="btn btn-success">Ir a facturar </button>
                                </form>
                            </div>

                            <!-- script -->
                            <script>
                                document.addEventListener("DOMContentLoaded", function(e) {
                                    // seachable 
                                    var options = {
                                        searchable: true
                                    };
                                    NiceSelect.bind(document.getElementById("seachable-select"), options);
                                });
                            </script>

                        <?php } ?>





                    </div>
                </div>
            </div>
            <!-- end main content section -->

            <!-- start footer section -->
            <div class="mt-auto p-6 pt-0 text-center dark:text-white-dark ltr:sm:text-left rtl:sm:text-right">
                © <span id="footer-year">2023</span>. Sistema 14 Ultra All rights reserved.
            </div>
            <!-- end footer section -->
        </div>
    </div>

    <script src="assets/js/alpine-collaspe.min.js"></script>
    <script src="assets/js/alpine-persist.min.js"></script>
    <script defer src="assets/js/alpine-ui.min.js"></script>
    <script defer src="assets/js/alpine-focus.min.js"></script>
    <script defer src="assets/js/alpine.min.js"></script>
    <script src="assets/js/custom.js"></script>
    <!-- start hightlight js -->
    <link rel="stylesheet" href="assets/css/highlight.min.css" />
    <script src="assets/js/highlight.min.js"></script>
    <!-- end hightlight js -->
    <script src="assets/js/nice-select2.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/simple-datatables@latest/dist/style.css" rel="stylesheet" type="text/css">
    <script src="https://cdn.jsdelivr.net/npm/simple-datatables@latest" type="text/javascript"></script>
    <script src=" https://cdn.jsdelivr.net/npm/dinero.js@1.9.1/build/umd/dinero.min.js "></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script>
        $(document).ready(function() {
            if (<?php echo  intval($movimiento->idCliente) ?> != 0) {
                cargarClaves(<?php echo $movimiento->idCliente ?>);
            }
        });
    </script>
    <script>
        var pagoAsociado = 0;
        var contadorConceptos = 0;
        class ConceptoFacturable {
            constructor(id, limite_superior, limite_inferior, concepto, unidades_maximas_por_factura) {
                this.id = id;
                this.limite_superior = parseFloat(limite_superior);
                this.limite_inferior = parseFloat(limite_inferior);
                this.concepto = concepto;
                this.unidades_maximas_por_factura = parseFloat(unidades_maximas_por_factura);
            }
        }
    </script>

    <script>
        class conceptoCalculo {
            constructor(id, concepto, precio, cantidad, aplica_iva, ivaTotal, subTotal, idRel) {
                this.id = id;
                this.concepto = concepto;
                this.precio = precio;
                this.cantidad = cantidad;
                this.aplica_iva = aplica_iva;
                this.ivaTotal = ivaTotal;
                this.subTotal = subTotal;
                this.idRel = idRel;
            }
        }
    </script>

    <script>
        function elimiarConceptoDeFactura(id) {
            const arregloFiltrado = factura.conceptos.filter(registro => registro.id !== id);
            factura.conceptos = arregloFiltrado;
        }
    </script>

    <script>
        var total = 0;
        var totalIva = 0;
        var subTotal = 0;
        var conceptosObg = [];
        var facturasFavoritas = [];
        var porcentajeIVA = 16; // Porcentaje del IVA
        var conceptos = [];
        var factura = {
            conceptos: []
        };
        var campoTotal = document.getElementById("total_f");
        var campoIva = document.getElementById("iva_f");
        var campoSubTotal = document.getElementById("subTotal_f");

        function anadirAFacturaImportada(clave_sat, cantidad, precio, conceptoSt) {
            var contadorAux = contadorConceptos;
            var noAsignado = false;
            var concepto = conceptos.find(x => x.clave_sat == clave_sat);
            if (concepto == undefined || concepto == null || concepto == "") {
                concepto = new conceptoCalculo(0, "No asignado", precio, cantidad, 0, 0, 0, contadorAux);
                noAsignado = true;
            }
            concepto.cantidad = cantidad;
            concepto.precio = precio;
            concepto.concepto = conceptoSt;
            var decimales = 2;
            var factor = Math.pow(10, decimales);
            var precioSinIVA = (concepto.precio * concepto.cantidad) / (1 + porcentajeIVA / 100);
            var valorIVA = (concepto.precio * concepto.cantidad) - precioSinIVA;
            concepto.ivaTotal = valorIVA;

            // Obtener la referencia a la tabla
            var tabla = document.getElementById("resultadosTabla");

            // Crear una nueva fila
            var fila = document.createElement("tr");
            fila.id = "ff" + contadorAux;
            if (noAsignado) {
                fila.style = "background-color: red;";
            }

            // Crear y añadir las celdas a la fila
            var celda1 = document.createElement("td");
            celda1.textContent = concepto.clave_sat;
            fila.appendChild(celda1);

            var celda2 = document.createElement("td");
            celda2.textContent = concepto.cantidad;
            fila.appendChild(celda2);

            var celda3 = document.createElement("td");
            celda3.textContent = concepto.concepto;
            fila.appendChild(celda3);

            var celda4 = document.createElement("td");
            celda4.textContent = concepto.precio;
            fila.appendChild(celda4);

            var celda5 = document.createElement("td");
            celda5.textContent = concepto.aplica_iva;
            fila.appendChild(celda5);

            if (concepto.aplica_iva == 'si') {
                concepto.ivaTotal = valorIVA;
                var conceptoIva = valorIVA;
                var ivaConceptoTotal = (concepto.precio * concepto.cantidad) - conceptoIva;
                concepto.subTotal = ivaConceptoTotal;
            } else {
                var ivaConceptoTotal = (concepto.precio * concepto.cantidad);
                concepto.subTotal = ivaConceptoTotal;
                concepto.ivaTotal = 0;
            }

            var celda6 = document.createElement("td");
            celda6.textContent = parseFloat(concepto.subTotal.toFixed(2));
            fila.appendChild(celda6);

            var celda7 = document.createElement("td");
            var multA = concepto.precio * concepto.cantidad;
            celda7.textContent = parseFloat(multA.toFixed(2));
            fila.appendChild(celda7);
            var celda8 = document.createElement("td");
            var botonEliminar = document.createElement("button");
            botonEliminar.addEventListener("click", function() {
                eliminarConcepto(contadorAux); // Llamada a la función eliminarConcepto con el ID como argumento
            });
            botonEliminar.textContent = "Eliminar";
            celda8.appendChild(botonEliminar);
            fila.appendChild(celda8);




            factura.conceptos.push(concepto);
            // Añadir la fila a la tabla
            tabla.appendChild(fila);
            var conceptoCal = new conceptoCalculo(concepto.id, concepto.concepto, concepto.precio, concepto.cantidad, concepto.aplica_iva, concepto.ivaTotal, concepto.subTotal, contadorAux);
            conceptosObg.push(conceptoCal);
            contadorConceptos++;

            calculaTotalesObj();
        }

        function anadirAFacturaDesdeGemerador(id, cantidad, precio, concepto) {

            var contadorAux = contadorConceptos;

            var concepto = conceptos.find(x => x.id == id);
            concepto.cantidad = cantidad;
            concepto.precio = precio;
            var decimales = 2;
            var factor = Math.pow(10, decimales);
            var precioSinIVA = (concepto.precio * concepto.cantidad) / (1 + porcentajeIVA / 100);
            var valorIVA = (concepto.precio * concepto.cantidad) - precioSinIVA;
            concepto.ivaTotal = valorIVA;

            // Obtener la referencia a la tabla
            var tabla = document.getElementById("resultadosTabla");

            // Crear una nueva fila
            var fila = document.createElement("tr");
            fila.id = "ff" + contadorAux;
            // Crear y añadir las celdas a la fila
            var celda1 = document.createElement("td");
            celda1.textContent = concepto.clave_sat;
            fila.appendChild(celda1);

            var celda2 = document.createElement("td");
            celda2.textContent = concepto.cantidad;
            fila.appendChild(celda2);

            var celda3 = document.createElement("td");
            celda3.textContent = concepto.concepto;
            fila.appendChild(celda3);

            var celda4 = document.createElement("td");
            let precioFormateado = "$" + concepto.precio.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
            celda4.textContent = precioFormateado;
            fila.appendChild(celda4);

            var celda5 = document.createElement("td");
            celda5.textContent = concepto.aplica_iva;
            fila.appendChild(celda5);

            if (concepto.aplica_iva == 'si') {
                concepto.ivaTotal = valorIVA;
                var conceptoIva = valorIVA;
                var ivaConceptoTotal = (concepto.precio * concepto.cantidad) - conceptoIva;
                concepto.subTotal = ivaConceptoTotal;
            } else {
                var ivaConceptoTotal = (concepto.precio * concepto.cantidad);
                concepto.subTotal = ivaConceptoTotal;
                concepto.ivaTotal = 0;
            }

            var celda6 = document.createElement("td");
            ivaConceptoTotal = parseFloat(ivaConceptoTotal);
            let conIvaformateado = "$" + ivaConceptoTotal.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
            celda6.textContent = (conIvaformateado);
            fila.appendChild(celda6);

            var celda7 = document.createElement("td");
            var conIva = concepto.precio * concepto.cantidad;
            conIva = "$" + conIva.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
            celda7.textContent = conIva;
            fila.appendChild(celda7);

            var celda8 = document.createElement("td");
            var botonEliminar = document.createElement("button");

            botonEliminar.addEventListener("click", function() {
                eliminarConcepto(contadorAux); // Llamada a la función eliminarConcepto con el ID como argumento
            });
            botonEliminar.textContent = "Eliminar";
            celda8.appendChild(botonEliminar);
            fila.appendChild(celda8);




            factura.conceptos.push(concepto);
            // Añadir la fila a la tabla
            tabla.appendChild(fila);
            contadorConceptos++;
            var conceptoCal = new conceptoCalculo(concepto.id, concepto.concepto, concepto.precio, concepto.cantidad, concepto.aplica_iva, concepto.ivaTotal, concepto.subTotal, contadorAux);
            conceptosObg.push(conceptoCal);
            calculaTotalesObj();
        }

        function anadirAFactura(id, ivaCon) {

            var contadorAux = contadorConceptos;
            var concepto = conceptos.find(x => x.id == id);
            concepto.cantidad = document.getElementById(id + "cantidad").value;
            var precioAjuste = document.getElementById(id + "precio").value;
            concepto.precio = precioAjuste / concepto.cantidad;
            concepto.concepto = document.getElementById(id + "concepto").value;
            var decimales = 2;
            var factor = Math.pow(10, decimales);
            var precioSinIVA = (concepto.precio * concepto.cantidad) / (1 + ivaCon / 100);
            var valorIVA = (concepto.precio * concepto.cantidad) - precioSinIVA;


            concepto.ivaTotal = valorIVA;

            // Obtener la referencia a la tabla
            var tabla = document.getElementById("resultadosTabla");

            // Crear una nueva fila
            var fila = document.createElement("tr");
            fila.id = "ff" + contadorAux;


            // Crear y añadir las celdas a la fila
            var celda1 = document.createElement("td");
            celda1.textContent = concepto.clave_sat;
            fila.appendChild(celda1);

            var celda2 = document.createElement("td");
            celda2.textContent = concepto.cantidad;
            fila.appendChild(celda2);

            var celda3 = document.createElement("td");
            celda3.textContent = concepto.concepto;
            fila.appendChild(celda3);

            var celda4 = document.createElement("td");
            var multA = concepto.precio / concepto.cantidad;
            celda4.textContent = concepto.precio;
            fila.appendChild(celda4);

            var celda5 = document.createElement("td");
            celda5.textContent = concepto.aplica_iva;
            fila.appendChild(celda5);

            if (concepto.aplica_iva == 'si') {
                concepto.ivaTotal = valorIVA;
                var conceptoIva = valorIVA;
                var ivaConceptoTotal = (concepto.precio * concepto.cantidad) - conceptoIva;
                concepto.subTotal = ivaConceptoTotal;
            } else {
                var ivaConceptoTotal = (concepto.precio * concepto.cantidad);
                concepto.subTotal = ivaConceptoTotal;
                concepto.ivaTotal = 0;
            }

            var celda6 = document.createElement("td");
            celda6.textContent = parseFloat(ivaConceptoTotal.toFixed(4));
            fila.appendChild(celda6);

            var celda7 = document.createElement("td");
            celda7.textContent = concepto.precio * concepto.cantidad;
            fila.appendChild(celda7);

            var celda8 = document.createElement("td");
            var botonEliminar = document.createElement("button");

            botonEliminar.addEventListener("click", function() {
                eliminarConcepto(contadorAux); // Llamada a la función eliminarConcepto con el ID como argumento
            });
            botonEliminar.textContent = "Eliminar";
            celda8.appendChild(botonEliminar);
            fila.appendChild(celda8);


            factura.conceptos.push(concepto);
            // Añadir la fila a la tabla
            tabla.appendChild(fila);
            contadorConceptos++;

            var conceptoCal = new conceptoCalculo(concepto.id, concepto.concepto, concepto.precio, concepto.cantidad, concepto.aplica_iva, concepto.ivaTotal, concepto.subTotal, contadorAux);
            conceptoCal.iva = ivaCon;
            conceptosObg.push(conceptoCal);
            calculaTotalesObj();
        }

        function eliminarConcepto(contador) {

            var index = conceptosObg.findIndex(function(concepto) {
                return concepto.idRel == contador;
            });
            console.log(index);

            if (index !== -1) {
                conceptosObg.splice(index, 1);
                factura.conceptos.splice(index, 1);
            }


            var fila = document.getElementById("ff" + contador);
            fila.remove();
            calculaTotalesObj();

        }



        function calculaTotales() {

            total = 0;
            totalIva = 0;
            subTotal = 0;
            for (var i = 0; i < factura.conceptos.length; i++) {
                total += factura.conceptos[i].precio * factura.conceptos[i].cantidad;
                subTotal += factura.conceptos[i].subTotal;
                totalIva += factura.conceptos[i].ivaTotal;
                console.log(factura.conceptos[i].precio + " multiplicado por " + factura.conceptos[i].cantidad + " es igual a " + factura.conceptos[i].precio * factura.conceptos[i].cantidad);
            }
            total = parseFloat(total.toFixed(4));
            totalIva = parseFloat(totalIva.toFixed(4));
            subTotal = parseFloat(subTotal.toFixed(4));
            campoTotal.textContent = "$ " + total + " ($ " + parseFloat(total.toFixed(2)) + ")";
            campoIva.textContent = "$ " + totalIva + " ($ " + parseFloat(totalIva.toFixed(2)) + ")";
            campoSubTotal.textContent = "$ " + subTotal + " ($ " + parseFloat(subTotal.toFixed(2)) + ")";
            console.log(factura);
            //generaXML();
        }

        function calculaTotalesObj() {

            total = 0;
            totalIva = 0;
            subTotal = 0;
            for (var i = 0; i < conceptosObg.length; i++) {
                total += conceptosObg[i].precio * conceptosObg[i].cantidad;
                subTotal += conceptosObg[i].subTotal;
                totalIva += conceptosObg[i].ivaTotal;

            }
            total = parseFloat(total.toFixed(4));
            totalIva = parseFloat(totalIva.toFixed(4));
            subTotal = parseFloat(subTotal.toFixed(4));

            let totalFor = "$" + total.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
            let totalIvaFor = "$" + totalIva.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
            let totalSubFor = "$" + subTotal.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');


            campoTotal.textContent = totalFor;
            campoIva.textContent = totalIvaFor;
            campoSubTotal.textContent = totalSubFor;
            console.log(factura);
            // generaXML();
        }
    </script>

    <script>
        var facturas = [];

        function enviarComplemento(factura) {
            var clienteId = document.getElementById('seachable-select').value;
            var claveEmpresa = document.getElementById('clave_c').value;
            var metodoPagoC = document.getElementById('metodo_pago_c').value;
            var formaPagoC = document.getElementById('forma_pago_c').value;
            var tipoComprobante = document.getElementById('tipo_comprobante_c').value;
            var usoCfdiC = document.getElementById('uso_cfdi_c').value;
            var fechaC = document.getElementById('fecha_c').value;
            var montoC = "<?php echo floatval($movimiento->monto)  ?>";

            facturas.push(factura);

            var datosComplemento = new FormData();
            datosComplemento.append('cliente', clienteId);
            datosComplemento.append('clave_c', claveEmpresa);
            datosComplemento.append('metodo_pago', metodoPagoC);
            datosComplemento.append('forma_pago', formaPagoC);
            datosComplemento.append('tipo_comprobante', tipoComprobante);
            datosComplemento.append('uso_cfdi', usoCfdiC);
            datosComplemento.append('fecha', fechaC);
            datosComplemento.append('monto', montoC);
            datosComplemento.append('facturas', JSON.stringify(facturas));
            datosComplemento.append("accion", "agregar");
            datosComplemento.append("pago", "<?php echo intval($_GET['movimiento']) ?>");
            datosComplemento.append("empresa", "<?php echo $_GET['empresa'] ?>");
            fetch("api/apiComplementos.php", {
                    method: "POST",
                    body: datosComplemento,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    Swal.fire({
                        icon: data.status,
                        title: data.mensaje,
                        showConfirmButton: true
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Redirigir a la página index
                            window.location.href = "fac-facturas.php"; // Cambia "index.php" por la URL de tu página index
                        }
                    });
                });
        }
    </script>


    <script>
        obtenerConceptos();
        var conceptosArreglo = [];

        function obtenerConceptos() {
            console.log("Obteniendo conceptos");
            fetch("api/apiReporteConceptos.php?accion=empresa&empresa=<?php echo $empresa->id ?>", {
                    method: "GET",
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    // console.log(data.aaData);
                    conceptos = data.aaData;

                    var datos = [];
                    for (var i = 0; i < conceptos.length; i++) {
                        conceptosArreglo.push(new ConceptoFacturable(conceptos[i].id, conceptos[i].precio_max, conceptos[i].precio_min, conceptos[i].concepto, conceptos[i].unidades_max));
                        var datosFila = [
                            conceptos[i].clave_sat,
                            conceptos[i].clave_unidad_medida,
                            `<textarea class="form-input" type="text" id="${conceptos[i].id+"concepto"}">${conceptos[i].concepto}</textarea> <p hidden>${conceptos[i].concepto}</p>`,

                            `<input class="form-input" type="number" id="${conceptos[i].id+"cantidad"}" value="1">`,
                            "",
                            `<input class="form-input" type="number" id="${conceptos[i].id+"precio"}" value="${conceptos[i].precio_min}">`,
                            `<button onclick="anadirAFactura(${conceptos[i].id}, 16)" type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal4">Agregar</button>
                            <button onclick="anadirAFactura(${conceptos[i].id}, 0)" type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal4">Taza 0</button>`
                        ];
                        datos.push(datosFila);

                    }

                    const tableOptions = {
                        data: {
                            data: datos
                        },
                        sortable: true,
                        searchable: true,
                        perPage: 5,
                        perPageSelect: [5, 10, 20, 30, 50],
                        firstLast: true,

                    };

                    const datatable1 = new simpleDatatables.DataTable('#miTabla', tableOptions);
                    datatable1.data.push(datosFila);
                    datatable1.update();
                    //console.log(conceptosArreglo);
                });
        }
    </script>


    <script>
        function cargarFavorita(id) {
            var factura = facturasFavoritas.find(x => x.id == id);
            console.log(factura);
            var conceptos = factura.conceptos;
            for (var i = 0; i < conceptos.length; i++) {
                anadirAFacturaImportada(conceptos[i].clave_sat, conceptos[i].cantidad, conceptos[i].precioUnitario, conceptos[i].concepto);
            }
        }
    </script>

    <script>
        function cargarFavoritas() {
            var espacioFavoritas = document.getElementById("espacioFavoritas");
            var envioFav = new FormData();
            envioFav.append("accion", 'fav');
            envioFav.append("usuario", <?php echo $_SESSION["usuario_id"] ?>);
            envioFav.append("empresa", <?php echo $_GET["empresa"] ?>);
            fetch("api/apiReporteFacturas.php?accion=fav&usuario=<?php echo $_SESSION["usuario_id"] ?>&empresa=<?php echo $_GET["empresa"] ?>", {
                    method: "POST",
                    body: envioFav
                }).then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);

                    for (var i = 0; i < data.aaData.length; i++) {
                        console.log(data.aaData[i]);
                        facturasFavoritas.push(data.aaData[i]);
                        espacioFavoritas.innerHTML += `
                         <div   onclick="cargarFavorita(${data.aaData[i].id})" class="col-sm-12 col-md-12 col-lg-12">
                            <div class="box-color p-a primary">
                              <div class="pull-right m-l">
                                <span class="w-40 dker text-center rounded">
                                  <i class="fa fa-download"></i>
                                </span>
                              </div>
                              <div class="clear">
                                <h4 class="m-0 text-md">$ ${data.aaData[i].total_factura} <span class="text-sm">${data.aaData[i].empresa_nombre}</span></h4>
                                <small class="text-muted">${data.aaData[i].cliente}</small>
                              </div>
                            </div>
                          </div>
            `;

                    }

                });
        }
    </script>

    <script>
        $(document).ready(function() {
            cargarFavoritas();
            if (<?php echo $detectado ?> == 1) {
                achievementUnlocked("Monto procesado: <? echo "$" . number_format($movimiento->monto, 2)  ?>");

            } else {

            }
            //$('#summernote').summernote({
            //    height: 300,
            //    toolbar: false
            //});
            // $('#miTabla').DataTable({
            //     "lengthMenu": [5, 10, 25, 50, 75, 100], // Cantidad de filas a mostrar en el menú
            //     "pageLength": 5, // Cantidad de filas a mostrar por defecto
            //     "language": {
            //         "sProcessing": "Procesando...",
            //         "sLengthMenu": "Mostrar _MENU_ registros",
            //         "sZeroRecords": "No se encontraron resultados",
            //         "sEmptyTable": "Ningún dato disponible en esta tabla",
            //         "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
            //         "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
            //         "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            //         "sInfoPostFix": "",
            //         "sSearch": "Buscar:",
            //         "sUrl": "",
            //         "sInfoThousands": ",",
            //         "sLoadingRecords": "Cargando...",
            //         "oPaginate": {
            //             "sFirst": "Primero",
            //             "sLast": "Último",
            //             "sNext": "Siguiente",
            //             "sPrevious": "Anterior"
            //         },
            //         "oAria": {
            //             "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
            //             "sSortDescending": ": Activar para ordenar la columna de manera descendente"
            //         }
            //     }

            // });
        });
    </script>

    <script>
        var espacioClaves = document.getElementById("clave_c");
        var clavesCortas = [];

        function cargarClaves(cliente) {
            clavesCortas = [];
            espacioClaves.innerHTML = "";
            fetch("api/apiReporteClavesCortas.php?accion=cliente&idCliente=" + cliente, {
                    method: "GET",
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {


                    for (var i = 0; i < data.aaData.length; i++) {
                        var option = document.createElement("option");
                        option.value = data.aaData[i].id;
                        option.textContent = data.aaData[i].rfc + " - " + data.aaData[i].clave_corta + " - " + data.aaData[i].razon_social;
                        espacioClaves.appendChild(option);
                        clavesCortas.push(data.aaData[i]);
                    }

                });
        }
    </script>

    <script>
        function generarParDeLetrasAleatorias() {
            var letras = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'; // Letras disponibles
            var letra1 = letras.charAt(Math.floor(Math.random() * letras.length)); // Generar la primera letra aleatoria
            var letra2 = letras.charAt(Math.floor(Math.random() * letras.length)); // Generar la segunda letra aleatoria
            var parDeLetras = letra1 + letra2; // Concatenar las dos letras
            return parDeLetras;
        }

        function agregarCero(numero) {
            if (numero < 10) {
                return numero.toString().padStart(2, '0');
            }
            return numero.toString();
        }

        function obtenerFechaActual() {
            var fecha = new Date();
            var anio = fecha.getFullYear();
            var mes = (fecha.getMonth() + 1).toString().padStart(2, '0');
            var dia = fecha.getDate().toString().padStart(2, '0');
            var fechaFormateada = anio + '-' + mes + '-' + dia;
            return fechaFormateada;
        }
    </script>

    <script>
        var xmlString = "";

        function generaXML() {

            var serie = generarParDeLetrasAleatorias();
            var folio = Math.floor(Math.random() * (100000 - 99999 + 1)) + 100000;
            var fecha = new Date();
            var fechaFormato = obtenerFechaActual();
            var hora = fecha.getHours() + ":" + fecha.getMinutes() + ":" + fecha.getSeconds();
            var formaPago = document.getElementById("forma_pago").value;
            var tipoComprovante = document.getElementById("tipo_comprobante").value;
            var metodoPago = document.getElementById("metodo_pago").value;
            var claveCorta = document.getElementById("clave_c").value;
            var claveCortaObjeto = clavesCortas.find(clave => clave.id == claveCorta);
            var usoDeCfdi = document.getElementById("uso_cfdi").value;

            // Crear un nuevo documento XML
            var doc = document.implementation.createDocument("http://www.sat.gob.mx/cfd/4", "cfdi:Comprobante", null);

            // Añadir los atributos al elemento raíz
            var comprobante = doc.documentElement;
            comprobante.setAttribute("xmlns:cfdi", "http://www.sat.gob.mx/cfd/4");
            comprobante.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            comprobante.setAttribute("xsi:schemaLocation", "http://www.sat.gob.mx/cfd/4 http://www.sat.gob.mx/sitio_internet/cfd/4/cfdv40.xsd");
            comprobante.setAttribute("Version", "4.0");
            comprobante.setAttribute("Serie", serie);
            comprobante.setAttribute("Folio", folio);
            comprobante.setAttribute("Fecha", fechaFormato + "T" + hora);
            comprobante.setAttribute("FormaPago", agregarCero(formaPago));
            comprobante.setAttribute("CondicionesDePago", "En una sola exhibicion");
            comprobante.setAttribute("SubTotal", subTotal);
            comprobante.setAttribute("Moneda", "MXN");
            comprobante.setAttribute("Total", total);
            comprobante.setAttribute("TipoDeComprobante", tipoComprovante);
            comprobante.setAttribute("Exportacion", "01");
            comprobante.setAttribute("MetodoPago", metodoPago);
            comprobante.setAttribute("LugarExpedicion", "<?php echo $empresa->cp ?>");

            // Añadir los elementos hijos
            var emisor = doc.createElement("cfdi:Emisor");
            emisor.setAttribute("Rfc", "<?php echo $empresa->rfc ?>");
            emisor.setAttribute("Nombre", "<?php echo $empresa->razon ?>");
            emisor.setAttribute("RegimenFiscal", "601");
            comprobante.appendChild(emisor);

            var receptor = doc.createElement("cfdi:Receptor");
            receptor.setAttribute("Rfc", claveCortaObjeto.rfc);
            receptor.setAttribute("Nombre", claveCortaObjeto.razon_social);
            receptor.setAttribute("DomicilioFiscalReceptor", claveCortaObjeto.cp);
            receptor.setAttribute("RegimenFiscalReceptor", claveCortaObjeto.regimen_fiscal);
            receptor.setAttribute("UsoCFDI", usoDeCfdi);
            comprobante.appendChild(receptor);

            var conceptos = doc.createElement("cfdi:Conceptos");
            comprobante.appendChild(conceptos);


            for (var i = 0; i < factura.conceptos.length; i++) {
                var concepto = doc.createElement("cfdi:Concepto");
                concepto.setAttribute("ClaveProdServ", factura.conceptos[i].clave_sat);
                concepto.setAttribute("Cantidad", factura.conceptos[i].cantidad);
                concepto.setAttribute("ClaveUnidad", factura.conceptos[i].clave_unidad_medida);
                concepto.setAttribute("Descripcion", factura.conceptos[i].concepto);
                concepto.setAttribute("ValorUnitario", factura.conceptos[i].subTotal);
                concepto.setAttribute("Importe", factura.conceptos[i].subTotal * factura.conceptos[i].cantidad);
                concepto.setAttribute("ObjetoImp", "02");

                var impuestos = doc.createElement("cfdi:Impuestos");
                var traslados = doc.createElement("cfdi:Traslados");
                var traslado = doc.createElement("cfdi:Traslado");
                traslado.setAttribute("Base", factura.conceptos[i].subTotal * factura.conceptos[i].cantidad);
                traslado.setAttribute("Importe", factura.conceptos[i].ivaTotal * factura.conceptos[i].cantidad);
                traslado.setAttribute("Impuesto", "002");
                traslado.setAttribute("TasaOCuota", factura.conceptos[i].impuesto / 100);
                traslado.setAttribute("TipoFactor", "Tasa");

                traslados.appendChild(traslado);
                impuestos.appendChild(traslados);
                concepto.appendChild(impuestos);
                conceptos.appendChild(concepto);
            }

            // Añadir los complementos
            var impuestosTotales = doc.createElement("cfdi:Impuestos");
            impuestosTotales.setAttribute("TotalImpuestosTrasladados", totalIva);
            var trasladosTotales = doc.createElement("cfdi:Traslados");
            var trasladoTotal = doc.createElement("cfdi:Traslado");
            trasladoTotal.setAttribute("Impuesto", "002");
            trasladoTotal.setAttribute("TipoFactor", "Tasa");
            trasladoTotal.setAttribute("TasaOCuota", "0.160000");
            trasladoTotal.setAttribute("Importe", totalIva);
            trasladoTotal.setAttribute("Base", subTotal);

            trasladosTotales.appendChild(trasladoTotal);
            impuestosTotales.appendChild(trasladosTotales);
            comprobante.appendChild(impuestosTotales);

            // Convertir el documento en una cadena XML
            var xmlSerializer = new XMLSerializer();
            xmlString = xmlSerializer.serializeToString(doc);

            //console.log(xmlString);
            // Obtener el elemento <pre> donde se mostrará el XML
            var xmlOutput = document.getElementById("xmlOutput");

            var formattedXml = vkbeautify.xml(xmlString);
            // Establecer el contenido del <pre> con el XML
            xmlOutput.textContent = formattedXml;

        }
    </script>

    <script>
        function enviarXmlFactura() {
            var envio = new FormData();
            envio.append("facturaXML", xmlString);
            envio.append("id", <?php echo $empresa->id ?>);
            envio.append("accion", "facturar");

            fetch("api/apiFactura.php", {
                    method: "POST",
                    body: envio
                }).then((respuesta) => respuesta.json())
                .then((data) => {

                });

        }
    </script>

    <script>
        function asignarPagoScript(id) {
            console.log(id);
            pagoAsociado = id;

            Swal.fire({
                title: 'Asignar este pago? ',
                text: "Se enviara la factura asociada al pago " + id,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Terminar'
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire(
                        'Terminado!',
                        'La factura se ha guardado.',
                        'success'
                    )

                    enviarFactura();

                }
            })


        }
    </script>

    <script>
        function seleccionarMonto() {

            var tablaResultadosPago = document.getElementById("resultadosTablaPagos");
            tablaResultadosPago.innerHTML = "";
            var datosEnvioP = new FormData();
            datosEnvioP.append("monto", total);
            datosEnvioP.append("accion", "pagosMonto");
            fetch("api/apiPagosT.php", {
                    method: "POST",
                    body: datosEnvioP,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data[0]);


                    data[0].forEach(dato => {
                        const fila = document.createElement('tr');
                        fila.innerHTML = `
            <td>${dato.id}</td>
            <td>${dato.tipo_movimiento}</td>
            <td>${dato.fecha_banco}</td>
            <td>${dato.fecha_captura}</td>
            <td>${dato.nombreCliente}</td>
            <td>$ ${dato.monto}</td>
            <td>${dato.id_factura}</td>
            <td><button class="btn btn-info" onclick="asignarPagoScript(${dato.id})" >SELECCONAR</button></td>
          `;
                        tablaResultadosPago.appendChild(fila);
                    });

                });


        }
    </script>

    <script>
        function enviarFactura() {
            var botonTerminar = document.getElementById("boton-terminar");
            //desaparecer boton 
            botonTerminar.style.display = "none";
            //$('#loader').modal('show'); // abrir
            var cliente = document.getElementById("seachable-select").value;
            var razonSocial = document.getElementById("clave_c").value;
            var metodo_pago = document.getElementById("metodo_pago").value;
            var forma_pago = document.getElementById("forma_pago").value;
            var tipo_comprobante = document.getElementById("tipo_comprobante").value;
            var uso_cfdi = document.getElementById("uso_cfdi").value;
            var status_pago = document.getElementById("status_pago").value;
            var retencion_transporte = document.getElementById("retencion_transporte").value;
            var moneda = document.getElementById("moneda").value;
            var movimientoAsociado = <?php echo intval($movimiento->id)  ?>;
            var usuarioInserta = <?php echo $_SESSION["usuario_id"] ?>;
            var empresa = <?php echo $empresa->id ?>;


            var facturaEnvio = {
                "cliente": cliente,
                "razonSocial": razonSocial,
                "metodo_pago": metodo_pago,
                "forma_pago": forma_pago,
                "tipo_comprobante": tipo_comprobante,
                "uso_cfdi": uso_cfdi,
                "status_pago": status_pago,
                "retencion_transporte": retencion_transporte,
                "movimientoAsociado": movimientoAsociado,
                "usuarioInserta": usuarioInserta,
                "empresa": empresa,
                "total": total,
                "subtotal": subTotal,
                "conceptos": conceptosObg,
                "pago": pagoAsociado,
                "moneda": moneda,
                "pago": <?php echo intval($movimiento->id) ?>
            };

            if (conceptosObg.length) {




                var envio = new FormData();
                envio.append("factura", JSON.stringify(facturaEnvio));
                envio.append("accion", "guardar");

                fetch("api/apiFactura.php", {
                        method: "POST",
                        body: envio
                    }).then((respuesta) => respuesta.json())
                    .then((data) => {

                        console.log(data);
                        enviarComplemento(data);

                    }).catch((error) => {
                        //$('#loader').modal('hide'); // cerrar
                        swal.fire({
                            title: "Error al facturar",
                            text: "Algo salio mal en la facturacion",
                            icon: "error",
                        }).then((value) => {

                        });
                    });

            } else {
                swal.fire({
                    title: "No se puede facturar sin elementos",
                    text: "Error",
                    icon: "error",
                    button: "Aceptar",
                });
            }

        }
    </script>



    <script>
        // Función para crear la factura basada en el monto dado y los conceptos facturables
        function crearFactura(monto) {
            factura.conceptos = [];
            var espacioConceptos = document.getElementById("resultadosTabla");
            espacioConceptos.innerHTML = "";
            var restante = monto;
            var conceptos = conceptosArreglo;
            maxConceptos = 10;
            // Limita la cantidad de conceptos a utilizar dentro del rango establecido
            const cantidadConceptos = Math.max(2, Math.min(maxConceptos, conceptos.length));
            conceptos = conceptos.slice(0, cantidadConceptos);

            // Calcula la suma de los precios de los conceptos
            const sumaPrecios = conceptos.reduce((total, concepto) => total + concepto.limite_superior, 0);

            // Calcula el factor de escala para ajustar las unidades en función del monto y la suma de precios
            const factorEscala = 1;

            // Calcula la cantidad de unidades para cada concepto basado en el factor de escala
            let unidadesTotales = 0;
            const unidadesConceptos = conceptos.map(concepto => {
                const unidades = Math.floor(Math.random() * (concepto.unidades_maximas_por_factura - 1 + 1) + 1);
                unidadesTotales += unidades;
                return {
                    id: concepto.id,
                    unidades: unidades,
                    total: (concepto.limite_superior * factorEscala * unidades).toFixed(2)
                };
            });

            // Imprime la factura
            console.log("Factura:");
            let sumaCalculo = 0;
            unidadesConceptos.forEach(concepto => {

                if (sumaCalculo < monto) {
                    if (concepto.total < restante) {
                        console.log(`${concepto.concepto}: ${concepto.unidades} unidades - Total: $${concepto.total}`);
                        sumaCalculo += parseFloat(concepto.total);
                        restante = restante - concepto.total;
                        anadirAFacturaDesdeGemerador(concepto.id, concepto.unidades, (concepto.total / concepto.unidades), concepto.concepto)
                    }

                }

            });

            console.log("Suma de cálculos: $" + sumaCalculo.toFixed(2));
            restanteFactura(restante);
        }


        var intentos = 0;

        function restanteFactura(restante) {
            var seleccion = Math.floor(Math.random() * (conceptosArreglo.length - 1 + 1) + 1);
            var concepto = conceptosArreglo[seleccion];
            //var unidades = Math.floor(Math.random() * (concepto.unidades_maximas_por_factura - 1 + 1) + 1);
            var unidades = 1;
            var total = restante.toFixed(2);
            if (intentos < 100) {
                if (((total / unidades) > concepto.limite_superior) || ((total / unidades) < concepto.limite_inferior)) {
                    intentos++;
                    restanteFactura(restante);
                } else {
                    anadirAFacturaDesdeGemerador(concepto.id, unidades, (total / unidades), concepto.concepto);
                }
            }


        }
    </script>

    <script>
        function enviarImportado() {
            var captura = document.getElementById("summernote").value;
            var envio = new FormData();
            envio.append("captura", captura);
            envio.append("empresa", "<?php echo $_GET['empresa'] ?>");
            fetch("api/apiInfoImportacion.php", {
                    method: "POST",
                    body: envio
                }).then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    for (var f = 0; f < data.length; f++) {
                        anadirAFacturaImportada(data[f].codigoSat, parseFloat(data[f].cantidad), parseFloat(data[f].precioUnitario), data[f].concepto);
                    }
                });
        }
    </script>

    <script>
        function achievementUnlocked(text) {
            var hasClass = $('.ach').hasClass('achieved');
            if (hasClass) return;
            $('.title').html("Movimiento detectado!!");
            $('.detail').html(text);
            $('.ach').addClass("achieved");
            setTimeout(function() {
                $('.ach').removeClass("achieved");
            }, 5000)
        }
        if (plants.grown >= 500) {
            achievementUnlocked("Monto procesado: <?php echo $movimiento->monto ?>");
        }
    </script>
    <script>
        document.addEventListener('alpine:init', () => {
            // main section
            Alpine.data('scrollToTop', () => ({
                showTopButton: false,
                init() {
                    window.onscroll = () => {
                        this.scrollFunction();
                    };
                },

                scrollFunction() {
                    if (document.body.scrollTop > 50 || document.documentElement.scrollTop > 50) {
                        this.showTopButton = true;
                    } else {
                        this.showTopButton = false;
                    }
                },

                goToTop() {
                    document.body.scrollTop = 0;
                    document.documentElement.scrollTop = 0;
                },
            }));

            // theme customization
            Alpine.data('customizer', () => ({
                showCustomizer: false,
            }));

            // sidebar section
            Alpine.data('sidebar', () => ({
                init() {
                    const selector = document.querySelector('.sidebar ul a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.click();
                                });
                            }
                        }
                    }
                },
            }));

            // header section
            Alpine.data('header', () => ({
                init() {
                    const selector = document.querySelector('ul.horizontal-menu a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.classList.add('active');
                                });
                            }
                        }
                    }
                },

                notifications: [{
                        id: 1,
                        profile: 'user-profile.jpeg',
                        message: '<strong class="text-sm mr-1">John Doe</strong>invite you to <strong>Prototyping</strong>',
                        time: '45 min ago',
                    },
                    {
                        id: 2,
                        profile: 'profile-34.jpeg',
                        message: '<strong class="text-sm mr-1">Adam Nolan</strong>mentioned you to <strong>UX Basics</strong>',
                        time: '9h Ago',
                    },
                    {
                        id: 3,
                        profile: 'profile-16.jpeg',
                        message: '<strong class="text-sm mr-1">Anna Morgan</strong>Upload a file',
                        time: '9h Ago',
                    },
                ],

                messages: [{
                        id: 1,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-success-light dark:bg-success text-success dark:text-success-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg></span>',
                        title: 'Congratulations!',
                        message: 'Your OS has been updated.',
                        time: '1hr',
                    },
                    {
                        id: 2,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-info-light dark:bg-info text-info dark:text-info-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="16" x2="12" y2="12"></line><line x1="12" y1="8" x2="12.01" y2="8"></line></svg></span>',
                        title: 'Did you know?',
                        message: 'You can switch between artboards.',
                        time: '2hr',
                    },
                    {
                        id: 3,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-danger-light dark:bg-danger text-danger dark:text-danger-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg></span>',
                        title: 'Something went wrong!',
                        message: 'Send Reposrt',
                        time: '2days',
                    },
                    {
                        id: 4,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-warning-light dark:bg-warning text-warning dark:text-warning-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">    <circle cx="12" cy="12" r="10"></circle>    <line x1="12" y1="8" x2="12" y2="12"></line>    <line x1="12" y1="16" x2="12.01" y2="16"></line></svg></span>',
                        title: 'Warning',
                        message: 'Your password strength is low.',
                        time: '5days',
                    },
                ],

                languages: [{
                        id: 1,
                        key: 'Chinese',
                        value: 'zh',
                    },
                    {
                        id: 2,
                        key: 'Danish',
                        value: 'da',
                    },
                    {
                        id: 3,
                        key: 'English',
                        value: 'en',
                    },
                    {
                        id: 4,
                        key: 'French',
                        value: 'fr',
                    },
                    {
                        id: 5,
                        key: 'German',
                        value: 'de',
                    },
                    {
                        id: 6,
                        key: 'Greek',
                        value: 'el',
                    },
                    {
                        id: 7,
                        key: 'Hungarian',
                        value: 'hu',
                    },
                    {
                        id: 8,
                        key: 'Italian',
                        value: 'it',
                    },
                    {
                        id: 9,
                        key: 'Japanese',
                        value: 'ja',
                    },
                    {
                        id: 10,
                        key: 'Polish',
                        value: 'pl',
                    },
                    {
                        id: 11,
                        key: 'Portuguese',
                        value: 'pt',
                    },
                    {
                        id: 12,
                        key: 'Russian',
                        value: 'ru',
                    },
                    {
                        id: 13,
                        key: 'Spanish',
                        value: 'es',
                    },
                    {
                        id: 14,
                        key: 'Swedish',
                        value: 'sv',
                    },
                    {
                        id: 15,
                        key: 'Turkish',
                        value: 'tr',
                    },
                    {
                        id: 16,
                        key: 'Arabic',
                        value: 'ae',
                    },
                ],

                removeNotification(value) {
                    this.notifications = this.notifications.filter((d) => d.id !== value);
                },

                removeMessage(value) {
                    this.messages = this.messages.filter((d) => d.id !== value);
                },
            }));

            // content section
            Alpine.data('sales', () => ({
                init() {
                    isDark = this.$store.app.theme === 'dark' || this.$store.app.isDarkMode ? true : false;
                    isRtl = this.$store.app.rtlClass === 'rtl' ? true : false;

                    const revenueChart = null;
                    const salesByCategory = null;
                    const dailySales = null;
                    const totalOrders = null;

                    // revenue
                    setTimeout(() => {
                        this.revenueChart = new ApexCharts(this.$refs.revenueChart, this.revenueChartOptions);
                        this.$refs.revenueChart.innerHTML = '';
                        this.revenueChart.render();

                        // sales by category
                        this.salesByCategory = new ApexCharts(this.$refs.salesByCategory, this.salesByCategoryOptions);
                        this.$refs.salesByCategory.innerHTML = '';
                        this.salesByCategory.render();

                        // daily sales
                        this.dailySales = new ApexCharts(this.$refs.dailySales, this.dailySalesOptions);
                        this.$refs.dailySales.innerHTML = '';
                        this.dailySales.render();

                        // total orders
                        this.totalOrders = new ApexCharts(this.$refs.totalOrders, this.totalOrdersOptions);
                        this.$refs.totalOrders.innerHTML = '';
                        this.totalOrders.render();
                    }, 300);

                    this.$watch('$store.app.theme', () => {
                        isDark = this.$store.app.theme === 'dark' || this.$store.app.isDarkMode ? true : false;

                        this.revenueChart.updateOptions(this.revenueChartOptions);
                        this.salesByCategory.updateOptions(this.salesByCategoryOptions);
                        this.dailySales.updateOptions(this.dailySalesOptions);
                        this.totalOrders.updateOptions(this.totalOrdersOptions);
                    });

                    this.$watch('$store.app.rtlClass', () => {
                        isRtl = this.$store.app.rtlClass === 'rtl' ? true : false;
                        this.revenueChart.updateOptions(this.revenueChartOptions);
                    });
                },

                // revenue
                get revenueChartOptions() {
                    return {
                        series: [{
                                name: 'Income',
                                data: [16800, 16800, 15500, 17800, 15500, 17000, 19000, 16000, 15000, 17000, 14000, 17000],
                            },
                            {
                                name: 'Expenses',
                                data: [16500, 17500, 16200, 17300, 16000, 19500, 16000, 17000, 16000, 19000, 18000, 19000],
                            },
                        ],
                        chart: {
                            height: 325,
                            type: 'area',
                            fontFamily: 'Nunito, sans-serif',
                            zoom: {
                                enabled: false,
                            },
                            toolbar: {
                                show: false,
                            },
                        },
                        dataLabels: {
                            enabled: false,
                        },
                        stroke: {
                            show: true,
                            curve: 'smooth',
                            width: 2,
                            lineCap: 'square',
                        },
                        dropShadow: {
                            enabled: true,
                            opacity: 0.2,
                            blur: 10,
                            left: -7,
                            top: 22,
                        },
                        colors: isDark ? ['#2196f3', '#e7515a'] : ['#1b55e2', '#e7515a'],
                        markers: {
                            discrete: [{
                                    seriesIndex: 0,
                                    dataPointIndex: 6,
                                    fillColor: '#1b55e2',
                                    strokeColor: 'transparent',
                                    size: 7,
                                },
                                {
                                    seriesIndex: 1,
                                    dataPointIndex: 5,
                                    fillColor: '#e7515a',
                                    strokeColor: 'transparent',
                                    size: 7,
                                },
                            ],
                        },
                        labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                        xaxis: {
                            axisBorder: {
                                show: false,
                            },
                            axisTicks: {
                                show: false,
                            },
                            crosshairs: {
                                show: true,
                            },
                            labels: {
                                offsetX: isRtl ? 2 : 0,
                                offsetY: 5,
                                style: {
                                    fontSize: '12px',
                                    cssClass: 'apexcharts-xaxis-title',
                                },
                            },
                        },
                        yaxis: {
                            tickAmount: 7,
                            labels: {
                                formatter: (value) => {
                                    return value / 1000 + 'K';
                                },
                                offsetX: isRtl ? -30 : -10,
                                offsetY: 0,
                                style: {
                                    fontSize: '12px',
                                    cssClass: 'apexcharts-yaxis-title',
                                },
                            },
                            opposite: isRtl ? true : false,
                        },
                        grid: {
                            borderColor: isDark ? '#191e3a' : '#e0e6ed',
                            strokeDashArray: 5,
                            xaxis: {
                                lines: {
                                    show: true,
                                },
                            },
                            yaxis: {
                                lines: {
                                    show: false,
                                },
                            },
                            padding: {
                                top: 0,
                                right: 0,
                                bottom: 0,
                                left: 0,
                            },
                        },
                        legend: {
                            position: 'top',
                            horizontalAlign: 'right',
                            fontSize: '16px',
                            markers: {
                                width: 10,
                                height: 10,
                                offsetX: -2,
                            },
                            itemMargin: {
                                horizontal: 10,
                                vertical: 5,
                            },
                        },
                        tooltip: {
                            marker: {
                                show: true,
                            },
                            x: {
                                show: false,
                            },
                        },
                        fill: {
                            type: 'gradient',
                            gradient: {
                                shadeIntensity: 1,
                                inverseColors: !1,
                                opacityFrom: isDark ? 0.19 : 0.28,
                                opacityTo: 0.05,
                                stops: isDark ? [100, 100] : [45, 100],
                            },
                        },
                    };
                },

                // sales by category
                get salesByCategoryOptions() {
                    return {
                        series: [985, 737, 270],
                        chart: {
                            type: 'donut',
                            height: 460,
                            fontFamily: 'Nunito, sans-serif',
                        },
                        dataLabels: {
                            enabled: false,
                        },
                        stroke: {
                            show: true,
                            width: 25,
                            colors: isDark ? '#0e1726' : '#fff',
                        },
                        colors: isDark ? ['#5c1ac3', '#e2a03f', '#e7515a', '#e2a03f'] : ['#e2a03f', '#5c1ac3', '#e7515a'],
                        legend: {
                            position: 'bottom',
                            horizontalAlign: 'center',
                            fontSize: '14px',
                            markers: {
                                width: 10,
                                height: 10,
                                offsetX: -2,
                            },
                            height: 50,
                            offsetY: 20,
                        },
                        plotOptions: {
                            pie: {
                                donut: {
                                    size: '65%',
                                    background: 'transparent',
                                    labels: {
                                        show: true,
                                        name: {
                                            show: true,
                                            fontSize: '29px',
                                            offsetY: -10,
                                        },
                                        value: {
                                            show: true,
                                            fontSize: '26px',
                                            color: isDark ? '#bfc9d4' : undefined,
                                            offsetY: 16,
                                            formatter: (val) => {
                                                return val;
                                            },
                                        },
                                        total: {
                                            show: true,
                                            label: 'Total',
                                            color: '#888ea8',
                                            fontSize: '29px',
                                            formatter: (w) => {
                                                return w.globals.seriesTotals.reduce(function(a, b) {
                                                    return a + b;
                                                }, 0);
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        labels: ['Apparel', 'Sports', 'Others'],
                        states: {
                            hover: {
                                filter: {
                                    type: 'none',
                                    value: 0.15,
                                },
                            },
                            active: {
                                filter: {
                                    type: 'none',
                                    value: 0.15,
                                },
                            },
                        },
                    };
                },

                // daily sales
                get dailySalesOptions() {
                    return {
                        series: [{
                                name: 'Sales',
                                data: [44, 55, 41, 67, 22, 43, 21],
                            },
                            {
                                name: 'Last Week',
                                data: [13, 23, 20, 8, 13, 27, 33],
                            },
                        ],
                        chart: {
                            height: 160,
                            type: 'bar',
                            fontFamily: 'Nunito, sans-serif',
                            toolbar: {
                                show: false,
                            },
                            stacked: true,
                            stackType: '100%',
                        },
                        dataLabels: {
                            enabled: false,
                        },
                        stroke: {
                            show: true,
                            width: 1,
                        },
                        colors: ['#e2a03f', '#e0e6ed'],
                        responsive: [{
                            breakpoint: 480,
                            options: {
                                legend: {
                                    position: 'bottom',
                                    offsetX: -10,
                                    offsetY: 0,
                                },
                            },
                        }, ],
                        xaxis: {
                            labels: {
                                show: false,
                            },
                            categories: ['Sun', 'Mon', 'Tue', 'Wed', 'Thur', 'Fri', 'Sat'],
                        },
                        yaxis: {
                            show: false,
                        },
                        fill: {
                            opacity: 1,
                        },
                        plotOptions: {
                            bar: {
                                horizontal: false,
                                columnWidth: '25%',
                            },
                        },
                        legend: {
                            show: false,
                        },
                        grid: {
                            show: false,
                            xaxis: {
                                lines: {
                                    show: false,
                                },
                            },
                            padding: {
                                top: 10,
                                right: -20,
                                bottom: -20,
                                left: -20,
                            },
                        },
                    };
                },

                // total orders
                get totalOrdersOptions() {
                    return {
                        series: [{
                            name: 'Sales',
                            data: [28, 40, 36, 52, 38, 60, 38, 52, 36, 40],
                        }, ],
                        chart: {
                            height: 290,
                            type: 'area',
                            fontFamily: 'Nunito, sans-serif',
                            sparkline: {
                                enabled: true,
                            },
                        },
                        stroke: {
                            curve: 'smooth',
                            width: 2,
                        },
                        colors: isDark ? ['#00ab55'] : ['#00ab55'],
                        labels: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10'],
                        yaxis: {
                            min: 0,
                            show: false,
                        },
                        grid: {
                            padding: {
                                top: 125,
                                right: 0,
                                bottom: 0,
                                left: 0,
                            },
                        },
                        fill: {
                            opacity: 1,
                            type: 'gradient',
                            gradient: {
                                type: 'vertical',
                                shadeIntensity: 1,
                                inverseColors: !1,
                                opacityFrom: 0.3,
                                opacityTo: 0.05,
                                stops: [100, 100],
                            },
                        },
                        tooltip: {
                            x: {
                                show: false,
                            },
                        },
                    };
                },
            }));
        });
    </script>
</body>

</html>