import mysql.connector
import re
from datetime import datetime
import sys

# Configuración de la base de datos
db_config = {
    'user': 'advs_14',
    'password': 'advperro2',
    'host': 'localhost',
    'database': 'advs_14'
}

# Función para limpiar el texto
def clean_text(text):
    return text.replace('\n', ' ').replace('\r', '')

# Función para validar la fecha
def is_valid_date(year, month, day):
    try:
        datetime(year, month, day)
        return True
    except ValueError:
        return False

import re

# Función para verificar si la fecha es válida
def is_valid_date(year, month, day):
    try:
        from datetime import datetime
        datetime(year, month, day)
        return True
    except ValueError:
        return False

# Función para extraer fechas buscando el mes y luego los números cercanos

def is_valid_date(year, month, day):
    """Verifica si una fecha es válida."""
    try:
        datetime(year, month, day)
        return True
    except ValueError:
        return False


def detect_dates(text):
    text = text.lower()  # Transformar todo el texto a minúsculas
    
    # Diccionario para convertir los meses en números
    month_map = {
        "enero": 1, "febrero": 2, "marzo": 3, "abril": 4,
        "mayo": 5, "junio": 6, "julio": 7, "agosto": 8,
        "septiembre": 9, "octubre": 10, "noviembre": 11, "diciembre": 12
    }
    
    words = text.split()  # Dividir el texto en palabras
    month_found = None
    month_position = None
    
    # Buscar el mes en las palabras del texto
    for index, word in enumerate(words):
        if word in month_map:
            month_found = month_map[word]
            month_position = index
            break
    
    if month_found is None:
        return "No se encontró una fecha válida."
    
    # Buscar números en el texto
    numbers = re.findall(r'\d+', text)
    
    if numbers:
        # Variables para guardar el día y el año
        day = None
        year = None
        
        # Buscar hacia adelante desde la posición del mes para encontrar el año
        for i in range(month_position + 1, len(words)):
            if words[i].isdigit() and len(words[i]) == 4:  # Probable año
                year = int(words[i])
                break
        
        # Buscar hacia atrás desde la posición del mes para encontrar el día
        for i in range(month_position - 1, -1, -1):
            if words[i].isdigit() and 1 <= int(words[i]) <= 31:  # Probable día
                day = int(words[i])
                break
        
        # Si encontramos tanto un día como un año, devolvemos la fecha formateada
        if day and year:
            if is_valid_date(year, month_found, day):
                # Formato YYYY-MM-DD
                return f"{year}-{str(month_found).zfill(2)}-{str(day).zfill(2)}"
    
    return "No se encontró una fecha válida."

# Función para conectar a la base de datos y obtener los datos
def fetch_data(id_doc):
    connection = mysql.connector.connect(**db_config)
    cursor = connection.cursor()
    query = """
    SELECT id, raw_data, ruta_doc, id_documento, procesado, proc_data
    FROM advs_14.`data`
    WHERE procesado = 0 AND id_documento = %s;
    """
    cursor.execute(query, (id_doc,))
    data = cursor.fetchall()
    cursor.close()
    connection.close()
    return data

# Función para conectar a la base de datos e insertar datos
def insert_date(record_id, date, id_documento):
    connection = mysql.connector.connect(**db_config)
    cursor = connection.cursor()
    query = """
    INSERT INTO advs_14.fechas (fecha, id_pagina, id_documento)
    VALUES (%s, %s, %s);
    """
    cursor.execute(query, (date, record_id, id_documento))
    connection.commit()
    cursor.close()
    connection.close()

# Función principal para procesar los datos y extraer fechas
def process_data(id_doc):
    data = fetch_data(id_doc)
    for record in data:
        record_id, raw_text, ruta_doc, id_documento, procesado, proc_data = record
        raw_text = clean_text(raw_text)
        print(f"Procesando registro ID: {record_id}")
        date = detect_dates(raw_text)
        if date != "No se encontró una fecha válida.":
            print("Fecha encontrada:", date)
            print("-" * 50)
            
            id_pagina = 0  # Aquí se debe definir cómo obtener el valor correcto si es necesario
            # Insertar la fecha en la tabla `fechas`
            insert_date(record_id, date, id_documento)
        else:
            print("No se encontró una fecha válida.")
            print("-" * 50)

# Ejecución del script
if __name__ == "__main__":
    if len(sys.argv) != 2:
        print("Uso: python3 /var/www/html/scaner/tensor.py <id_doc>")
        sys.exit(1)

    id_doc = sys.argv[1]
    process_data(id_doc)