<!doctype html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- loader-->
  <link href="assets/css/pace.min.css" rel="stylesheet" />
  <script src="assets/js/pace.min.js"></script>

  <!--plugins-->
  <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
  <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
  <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
  <!--plugins-->
  <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
  <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
  <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
  <link href="assets/plugins/input-tags/css/tagsinput.css" rel="stylesheet" />

  <!-- CSS Files -->
  <link href="assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
  <link href="assets/css/icons.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">

  <!--Theme Styles-->
  <link href="assets/css/dark-theme.css" rel="stylesheet" />
  <link href="assets/css/semi-dark.css" rel="stylesheet" />
  <link href="assets/css/header-colors.css" rel="stylesheet" />

  <title>Moderación </title>
</head>

<body>


  <!--start wrapper-->
  <div class="wrapper">

    <?php include "template/barra.php"  ?>

    <!--start top header-->
    <?php include "template/header.php" ?>
    <!--end top header-->
    <?php
    include_once("api/adminDocumentos.php");
    $adminDocumentos = new AdministradorDocumentos();
    $documento = $adminDocumentos->dameDocumentoNoAprovado();
    //si no existe un documento lo lleva al index 
    if ($documento == null || $documento->id == "") {
      //header("Location: index.php");
      //con js 
      //echo "<script>window.location.href = 'index.php';</script>";
    }

    function eliminarCadenasSimilares($cadenas)
    {
      $resultado = [];

      // Ordena las cadenas por longitud en orden descendente
      usort($cadenas, function ($a, $b) {
        return strlen($b) - strlen($a);
      });

      foreach ($cadenas as $cadena) {
        $agregar = true;

        foreach ($resultado as $res) {
          // Compara si la cadena actual está contenida en alguna de las ya almacenadas
          if (strpos($res, $cadena) !== false) {
            $agregar = false;
            break;
          }
        }

        if ($agregar) {
          $resultado[] = $cadena;
        }
      }

      return $resultado;
    }
    function eliminarCadenasConMasDe5Palabras($cadenas)
    {
      return array_filter($cadenas, function ($cadena) {
        // Divide la cadena en palabras usando espacios como delimitador
        $palabras = explode(' ', $cadena);
        // Cuenta el número de palabras
        return count($palabras) <= 6;
      });
    }

    function eliminar_palabras_cortas($array)
    {
      // Iterar sobre cada elemento del arreglo
      foreach ($array as &$texto) {
        // Dividir el texto en palabras
        $palabras = explode(' ', $texto);

        // Filtrar palabras que tengan menos de 3 letras
        $palabras_filtradas = array_filter($palabras, function ($palabra) {
          return strlen($palabra) >= 3;
        });

        // Reunir las palabras filtradas en un texto de vuelta
        $texto = implode(' ', $palabras_filtradas);
      }

      return $array;
    }

    function elimina_titulos($cadena)
    {
      $titulos = array(
        "sr ",
        "Sr ",
        "SR ",
        "sr. ",
        "Sr. ",
        "SR. ",
        "sra ",
        "Sra ",
        "SRA ",
        "sra. ",
        "Sra. ",
        "SRA. ",
        "srta ",
        "Srta ",
        "SRTA ",
        "srta. ",
        "Srta. ",
        "SRTA. ",
        "dr ",
        "Dr ",
        "DR ",
        "dr. ",
        "Dr. ",
        "DR. ",
        "dra ",
        "Dra ",
        "DRA ",
        "dra. ",
        "Dra. ",
        "DRA. ",
        "ing ",
        "Ing ",
        "ING ",
        "ing. ",
        "Ing. ",
        "ING. ",
        "lic ",
        "Lic ",
        "LIC ",
        "lic. ",
        "Lic. ",
        "LIC. ",
        "mtro ",
        "Mtro ",
        "MTRO ",
        "mtro. ",
        "Mtro. ",
        "MTRO. ",
        "arq ",
        "Arq ",
        "ARQ ",
        "arq. ",
        "Arq. ",
        "ARQ. "
      );

      $cadena = str_replace($titulos, "", $cadena);
      return $cadena;
    }


    //echo json_encode($documento);

    ?>
    <style>
      .bg-primary {
        background-color: #d35400 !important;
      }

      .badge {
        font-weight: 100 !important;
      }


      
    </style>
    <?php
    function reemplazarNombreArchivo($ruta)
    {
      // Obtener el directorio del archivo
      $directorio = pathinfo($ruta, PATHINFO_DIRNAME);
      // Definir el nuevo nombre del archivo
      $nuevoNombre = 'procesado.pdf';
      // Construir la nueva ruta
      $nuevaRuta = $directorio . DIRECTORY_SEPARATOR . $nuevoNombre;
      return $nuevaRuta;
    }
    $urlLimpia = reemplazarNombreArchivo($documento->ruta);
    $urlLimpia = str_replace("/var/www/html/16/ultra/sistema/documentos/", "", $urlLimpia);



    function formatearFecha($fecha)
    {
      $fechaSplit = explode('-', $fecha);
      $dia = $fechaSplit[2];
      switch ($fechaSplit[1]) {
        case '01':
          $mes = 'Enero';
          break;
        case '02':
          $mes = 'Febrero';
          break;
        case '03':
          $mes = 'Marzo';
          break;
        case '04':
          $mes = 'Abril';
          break;
        case '05':
          $mes = 'Mayo';
          break;
        case '06':
          $mes = 'Junio';
          break;
        case '07':
          $mes = 'Julio';
          break;
        case '08':
          $mes = 'Agosto';
          break;
        case '09':
          $mes = 'Septiembre';
          break;
        case '10':
          $mes = 'Octubre';
          break;
        case '11':
          $mes = 'Noviembre';
          break;
        case '12':
          $mes = 'Diciembre';
          break;
      }
      $anio = $fechaSplit[0];
      return $dia . ' de ' . $mes . ' de ' . $anio;
    }


    ?>
    <!-- start page content wrapper-->
    <div class="page-content-wrapper">
      <!-- start page content-->
      <div class="page-content">

        <!--start breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
          <div class="breadcrumb-title pe-3">Dashboard</div>
          <div class="ps-3">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb mb-0 p-0 align-items-center">
                <li class="breadcrumb-item"><a href="javascript:;">
                    <ion-icon name="home-outline"></ion-icon>
                  </a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">eCommerce</li>
              </ol>
            </nav>
          </div>
          <div class="ms-auto">
            <div class="btn-group">
              <button type="button" class="btn btn-outline-primary">Settings</button>
              <button type="button"
                class="btn btn-outline-primary split-bg-primary dropdown-toggle dropdown-toggle-split"
                data-bs-toggle="dropdown"> <span class="visually-hidden">Toggle Dropdown</span>
              </button>
              <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end"> <a class="dropdown-item"
                  href="javascript:;">Action</a>
                <a class="dropdown-item" href="javascript:;">Another action</a>
                <a class="dropdown-item" href="javascript:;">Something else here</a>
                <div class="dropdown-divider"></div> <a class="dropdown-item" href="javascript:;">Separated link</a>
              </div>
            </div>
          </div>
        </div>
        <!--end breadcrumb-->



        <div class="card">
          <div class="card-header">
            <h6 class="mb-0">Meta datos del documento</h6>
          </div>
          <div class="card-body">
            <div class="row">
              <!-- Campo 1 -->
              <div class="col-md-6 mb-4">
                <label for="campo1" class="form-label">Numero documento</label>
                <input type="text" value="<?php echo intval($documento->numeros[0]->numero) ?>" class="form-control" id="campo1" placeholder="Ingrese numero">
              </div>
              <!-- Campo 2 -->
              <div class="col-md-3 mb-4">
                <label for="campoMuestra" class="form-label">Fecha documento</label>
                <input type="text"
                  value="<?php echo formatearFecha($documento->fechas[0]->fecha); ?>"
                  class="form-control"
                  id="campoMuestra"
                  readonly>
              </div>
              <div class="col-md-3 mb-4">
                <label for="campo2" class="form-label">.</label>
                <input type="date"
                  value="<?php echo $documento->fechas[0]->fecha; ?>"
                  class="form-control"
                  id="campo2"
                  onchange="actualizarCampoMuestra(this.value)">
              </div>

              <script>
                function actualizarCampoMuestra(valor) {
                  document.getElementById('campoMuestra').value = formatearFecha(valor);
                }
              </script>
              <script>
                function formatearFecha(fecha) {
                  const meses = [
                    'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio',
                    'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'
                  ];
                  const [anio, mes, dia] = fecha.split('-');
                  return `${dia} de ${meses[parseInt(mes) - 1]} de ${anio}`;
                }
              </script>

              <!-- Select con opción "Otro" -->
              <div class="col-md-12 mb-12">
                <label for="campo2" class="form-label">Interesado (S)</label>

                <?php
                $nombresArray = [];
                foreach ($documento->nombres as $nombre) {
                  $nombresArray[] = $nombre->nombre;
                }
                $nombresArray = eliminar_palabras_cortas($nombresArray);
                $nombresArray = eliminarCadenasSimilares($nombresArray);
                $nombresArray = eliminarCadenasConMasDe5Palabras($nombresArray);
                $contador = 0;
                foreach ($nombresArray as $nombre) {
                  //comas en todos menos en el ultimo 
                  if ($contador == count($nombresArray) - 1) {
                    $interesados .= elimina_titulos($nombre);
                  } else {
                    $interesados .= elimina_titulos($nombre) . ", ";
                  }




                  $contador++;
                }


                ?>


                <input type="text" id="campo3" class="form-control" data-role="tagsinput" value="<?php echo $interesados ?>">

              </div>


              <!-- <div class="mb-3">
												<label class="form-label">Basic</label>
											</div> -->
              <!-- Campo de entrada adicional que aparece al seleccionar "Otro" -->
              <div class="col-md-4 mb-3" id="otroInputContainer" style="display: none;">
                <label for="otroInput" class="form-label">Especifique otro</label>
                <input type="text" class="form-control" id="otroInput" placeholder="Ingrese otra opción">
              </div>
            </div>
          </div>
        </div>


        <div class="card">
          <div class="card-header">
            <div class="row">
              <div class="col-md-6">
                <h6 class="mb-0">Documento <?php echo $documento->nombreOriginal ?></h6>

              </div>
              <div class="col-md-6" style="text-align: right;">
                <button class="btn btn-primary">Aprobar</button>

                <button class="btn btn-danger">Rechazar</button>
              </div>
            </div>
          </div>
          <div class="card-body" style="height: 500px;">
            <iframe src="<?php echo $urlLimpia ?>" frameborder="0" style="width: 100%; height: 100%;"></iframe>


          </div>
          <div class="card-footer">

          </div>
        </div>





      </div>
      <!-- end page content-->
    </div>
    <!--end page content wrapper-->


    <!--start footer-->
    <footer class="footer">
      <div class="footer-text">
        Copyright © 2023. All right reserved.
      </div>
    </footer>
    <!--end footer-->


    <!--Start Back To Top Button-->
    <a href="javaScript:;" class="back-to-top">
      <ion-icon name="arrow-up-outline"></ion-icon>
    </a>
    <!--End Back To Top Button-->

    <!--start switcher-->
    <div class="switcher-body">
      <button class="btn btn-primary btn-switcher shadow-sm" type="button" data-bs-toggle="offcanvas"
        data-bs-target="#offcanvasScrolling" aria-controls="offcanvasScrolling">
        <ion-icon name="color-palette-outline" class="me-0"></ion-icon>
      </button>
      <div class="offcanvas offcanvas-end shadow border-start-0 p-2" data-bs-scroll="true" data-bs-backdrop="false"
        tabindex="-1" id="offcanvasScrolling">
        <div class="offcanvas-header border-bottom">
          <h5 class="offcanvas-title" id="offcanvasScrollingLabel">Theme Customizer</h5>
          <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>
        </div>
        <div class="offcanvas-body">
          <h6 class="mb-0">Theme Variation</h6>
          <hr>
          <div class="form-check form-check-inline">
            <input class="form-check-input" type="radio" name="inlineRadioOptions" id="LightTheme" value="option1" checked>
            <label class="form-check-label" for="LightTheme">Light</label>
          </div>
          <div class="form-check form-check-inline">
            <input class="form-check-input" type="radio" name="inlineRadioOptions" id="DarkTheme" value="option2">
            <label class="form-check-label" for="DarkTheme">Dark</label>
          </div>
          <div class="form-check form-check-inline">
            <input class="form-check-input" type="radio" name="inlineRadioOptions" id="SemiDark" value="option3">
            <label class="form-check-label" for="SemiDark">Semi Dark</label>
          </div>
          <hr />
          <h6 class="mb-0">Header Colors</h6>
          <hr />
          <div class="header-colors-indigators">
            <div class="row row-cols-auto g-3">
              <div class="col">
                <div class="indigator headercolor1" id="headercolor1"></div>
              </div>
              <div class="col">
                <div class="indigator headercolor2" id="headercolor2"></div>
              </div>
              <div class="col">
                <div class="indigator headercolor3" id="headercolor3"></div>
              </div>
              <div class="col">
                <div class="indigator headercolor4" id="headercolor4"></div>
              </div>
              <div class="col">
                <div class="indigator headercolor5" id="headercolor5"></div>
              </div>
              <div class="col">
                <div class="indigator headercolor6" id="headercolor6"></div>
              </div>
              <div class="col">
                <div class="indigator headercolor7" id="headercolor7"></div>
              </div>
              <div class="col">
                <div class="indigator headercolor8" id="headercolor8"></div>
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>
    <!--end switcher-->


    <!--start overlay-->
    <div class="overlay nav-toggle-icon"></div>
    <!--end overlay-->

  </div>
  <!--end wrapper-->


  <!-- JS Files-->
  <script src="assets/js/jquery.min.js"></script>
  <script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
  <script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
  <script src="assets/js/bootstrap.bundle.min.js"></script>
  <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
  <!--plugins-->
  <script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
  <script src="assets/plugins/apexcharts-bundle/js/apexcharts.min.js"></script>
  <script src="assets/plugins/easyPieChart/jquery.easypiechart.js"></script>
  <script src="assets/plugins/chartjs/chart.min.js"></script>
  <script src="assets/js/index.js"></script>
  <!-- Main JS-->
  <script src="assets/js/main.js"></script>
  <!--plugins-->
  <script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
  <script src="assets/plugins/input-tags/js/tagsinput.js"></script>


</body>

</html>