import mysql.connector
import fitz  # PyMuPDF
from PIL import Image  # <-- Importación de Pillow
import io
import os

# Conectar a la base de datos
db_config = {
    'user': 'advs',
    'password': 'advperro2',
    'host': 'localhost',
    'database': 'advs'
}

def obtener_info_pdf():
    try:
        connection = mysql.connector.connect(**db_config)
        cursor = connection.cursor()
        cursor.execute("SELECT id, ruta FROM documentos WHERE procesado = 0 LIMIT 1")
        result = cursor.fetchone()
        return result  # Retorna una tupla (id, ruta) o None si no hay resultados
    except mysql.connector.Error as err:
        print(f"Error: {err}")
        return None
    finally:
        if connection.is_connected():
            cursor.close()
            connection.close()

def marcar_procesado(id_pdf):
    try:
        connection = mysql.connector.connect(**db_config)
        cursor = connection.cursor()
        query = "UPDATE advs.documentos SET procesado = 1 WHERE id = %s"
        valores = (int(id_pdf),)
        cursor.execute(query, valores)
        connection.commit()
        print(f"Documento marcado como procesado: {id_pdf}")
    except mysql.connector.Error as err:
        print(f"Error: {err}")
    finally:
        if connection.is_connected():
            cursor.close()
            connection.close()

def main():
    # Obtener la información del PDF
    pdf_info = obtener_info_pdf()
    if not pdf_info:
        print("No se encontró un archivo PDF sin procesar.")
        exit()

    id_pdf, pdf_path = pdf_info

    # Directorio donde se encuentra el PDF
    output_dir = os.path.dirname(pdf_path)

    # Nombre del archivo de salida para las rutas de las imágenes
    output_file = os.path.join(output_dir, 'imgs.txt')

    # Abrir el archivo PDF
    pdf_document = fitz.open(pdf_path)

    # Lista para almacenar las rutas de las imágenes extraídas
    imagenes_originales = []

    # Abrir el archivo de salida para escribir las rutas de las imágenes
    with open(output_file, 'w') as file:
        # Recorrer todas las páginas del PDF
        for page_num in range(len(pdf_document)):
            page = pdf_document.load_page(page_num)
            images = page.get_images(full=True)

            for img_index, img in enumerate(images):
                xref = img[0]
                base_image = pdf_document.extract_image(xref)
                image_bytes = base_image["image"]
                image_ext = base_image["ext"]
                image = Image.open(io.BytesIO(image_bytes))

                # Crear el nombre del archivo para la imagen extraída
                image_filename = f"pagina_{page_num+1}_imagen_{img_index+1}.{image_ext}"
                image_filepath = os.path.join(output_dir, image_filename)
                imagenes_originales.append(image_filepath)

                # Guardar la imagen en el disco
                image.save(image_filepath)

                # Escribir la ruta de la imagen en el archivo de salida
                file.write(image_filepath + '\n')
                print(f"Imagen guardada: {image_filepath}")

    # Marcar el documento como procesado
    marcar_procesado(id_pdf)

if __name__ == "__main__":
    main()