import mysql.connector
import fitz  # PyMuPDF
from PIL import Image, ImageEnhance
import cv2
import pytesseract
import io
import os
import random
import subprocess
import tempfile
from multiprocessing import Pool, cpu_count
from reportlab.pdfgen import canvas
from reportlab.lib.pagesizes import letter

# Conectar a la base de datos
db_config = {
    'user': 'advs',
    'password': 'advperro2',
    'host': 'localhost',
    'database': 'advs'
}

def process_image_for_ocr(args):
    image_path, output_dir, contador = args

    # Verificar si el archivo de imagen existe
    if not os.path.exists(image_path):
        raise FileNotFoundError(f"El archivo de imagen no existe: {image_path}")

    # Crear un archivo temporal único
    with tempfile.NamedTemporaryFile(delete=False, suffix='.png') as temp_file:
        temp_path = temp_file.name

    # Cargar la imagen
    img = Image.open(image_path)

    # Convertir la imagen a escala de grises
    img = img.convert('L')

    # Aumentar el contraste
    enhancer = ImageEnhance.Contrast(img)
    img = enhancer.enhance(2)

    # Guardar la imagen temporalmente
    img.save(temp_path)

    # Cargar la imagen con OpenCV para más procesamiento
    img_cv = cv2.imread(temp_path, cv2.IMREAD_GRAYSCALE)

    if img_cv is None or img_cv.size == 0:
        raise ValueError(f"La imagen procesada está vacía o no se pudo leer: {temp_path}")

    # Aplicar un umbral para que el blanco sea blanco y el negro sea negro
    _, img_cv = cv2.threshold(img_cv, 0, 255, cv2.THRESH_BINARY + cv2.THRESH_OTSU)

    # Guardar la imagen procesada
    processed_image_path = os.path.join(output_dir, f"processed_image{contador}.png")
    success = cv2.imwrite(processed_image_path, img_cv)

    if not success:
        raise IOError(f"No se pudo guardar la imagen procesada: {processed_image_path}")

    return processed_image_path

def obtener_info_pdf():
    try:
        connection = mysql.connector.connect(**db_config)
        cursor = connection.cursor()
        cursor.execute("SELECT id, ruta FROM documentos WHERE procesado = 0 LIMIT 1")
        result = cursor.fetchone()
        return result  # Retorna una tupla (id, ruta) o None si no hay resultados
    except mysql.connector.Error as err:
        print(f"Error: {err}")
        return None
    finally:
        if connection.is_connected():
            cursor.close()
            connection.close()

# Obtener la información del PDF
pdf_info = obtener_info_pdf()
if not pdf_info:
    print("No se encontró un archivo PDF sin procesar.")
    exit()

id_pdf, pdf_path = pdf_info

# Directorio donde se encuentra el PDF
output_dir = os.path.dirname(pdf_path)

# Generar un número aleatorio
random_number = random.randint(1000, 9999)

# Nombre del archivo de salida para las rutas de las imágenes
output_file = os.path.join(output_dir, f'img_{random_number}.txt')

# Abrir el archivo PDF
pdf_document = fitz.open(pdf_path)
contador = 0

# Lista para almacenar los argumentos de las imágenes para el procesamiento paralelo
args_list = []

# Abrir el archivo de salida para escribir las rutas de las imágenes
with open(output_file, 'w') as file:
    # Recorrer todas las páginas del PDF
    for page_num in range(len(pdf_document)):
        page = pdf_document.load_page(page_num)
        images = page.get_images(full=True)

        for img_index, img in enumerate(images):
            xref = img[0]
            base_image = pdf_document.extract_image(xref)
            image_bytes = base_image["image"]
            image_ext = base_image["ext"]
            image = Image.open(io.BytesIO(image_bytes))

            # Crear el nombre del archivo para la imagen extraída
            image_filename = f"pagina_{page_num+1}_imagen_{img_index+1}.{image_ext}"
            image_filepath = os.path.join(output_dir, image_filename)

            # Guardar la imagen
            contador += 1
            image.save(image_filepath)
            
            # Agregar los argumentos a la lista para el procesamiento paralelo
            args_list.append((image_filepath, output_dir, contador))

# Procesar las imágenes en paralelo utilizando multiprocessing
try:
    with Pool(cpu_count()) as pool:
        processed_image_paths = pool.map(process_image_for_ocr, args_list)
except Exception as e:
    print(f"Error en el procesamiento paralelo: {e}")

# Escribir las rutas de las imágenes procesadas en el archivo de salida
with open(output_file, 'a') as file:
    for processed_image_path in processed_image_paths:
        file.write(processed_image_path + '\n')
        print(f"Imagen procesada guardada: {processed_image_path}")

# Generar el PDF con las imágenes procesadas
procesado_pdf_path = os.path.join(output_dir, "procesado.pdf")
c = canvas.Canvas(procesado_pdf_path, pagesize=letter)
for image_path in processed_image_paths:
    c.drawImage(image_path, 0, 0, width=letter[0], height=letter[1])
    c.showPage()
c.save()

print(f"PDF generado con las imágenes procesadas: {procesado_pdf_path}")

# Ejecutar el script lectura.py pasando el nombre del archivo de salida y el ID del PDF
cadena_compuesta = output_file + "|" + str(id_pdf) + "|" + output_dir
subprocess.run(['python3', '/var/www/html/scaner/lectura.py', cadena_compuesta])