<?php

function extraerTextoPorPagina($archivoPdf) {
    // Crear un directorio para los archivos de texto
    $directorioTexto = 'textos_pagina/';
    if (!is_dir($directorioTexto)) {
        mkdir($directorioTexto, 0777, true);
    }
    
    // Obtener el número total de páginas en el PDF
    $numPaginas = obtenerNumeroPaginas($archivoPdf);
    
    // Array para almacenar el texto de cada página
    $textoPorPagina = [];
    
    // Extraer texto página por página
    for ($pagina = 1; $pagina <= $numPaginas; $pagina++) {
        // Nombre del archivo de texto temporal
        $archivoTexto = "$directorioTexto/pagina_$pagina.txt";
        
        // Comando para convertir una página específica a texto
        $comando = "pdftotext -f $pagina -l $pagina $archivoPdf $archivoTexto";
        
        // Ejecutar el comando
        exec($comando);
        
        // Leer el archivo de texto
        $textoPorPagina[$pagina] = file_get_contents($archivoTexto);
    }
    
    // Eliminar los archivos de texto temporales
    array_map('unlink', glob("$directorioTexto/*.txt"));
    rmdir($directorioTexto);
    
    // Ejecutar el comando Java
    
    
    return $textoPorPagina;
}

function obtenerNumeroPaginas($archivoPdf) {
    // Comando para obtener el número total de páginas del PDF
    $comando = "pdfinfo $archivoPdf | grep Pages | awk '{print $2}'";
    $numPaginas = trim(shell_exec($comando));
    return (int) $numPaginas;
}

// Uso de la función
$archivoPdf = '/var/www/html/scaner/documentos/66ba3c7364af3/66ba3c7364af3.pdf'; // Cambia a la ruta de tu archivo PDF
$textoPorPagina = extraerTextoPorPagina($archivoPdf);

// Imprimir el texto de cada página
foreach ($textoPorPagina as $pagina => $texto) {
    echo "Texto de la página $pagina:\n";
    echo $texto;
    echo "\n\n";
}
$comandoJava = 'java -jar /var/www/html/scaner/java-app/AnMonSk.jar';
exec($comandoJava);

?>




