<?php include_once 'api/adminEmpresas.php' ?>
<?php
$adminEmpresas = new AdminEmpresas();
$empresas = $adminEmpresas->dameEmpresasLite();
function recortarCadena($texto)
{
    if (strlen($texto) > 16) {
        return substr($texto, 0, 16) . '...';
    }
    return $texto;
}
?>

<div class="am-sideleft">
    <ul class="nav am-sideleft-tab">
        <li class="nav-item">
            <a href="#mainMenu" class="nav-link active" style="width: 200%;"><i class="icon ion-ios-home-outline tx-24"></i></a>
        </li>
        <li class="nav-item" style="opacity: 0; z-index: -100;">
            <a href="#mainMenu" class="nav-link active" style="width: 200%;"><i class="icon ion-ios-home-outline tx-24"></i></a>
        </li>
        <li class="nav-item">
            <a href="#emailMenu" class="nav-link" style="width: 200%;">
                <svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 4h12M6 4v16M6 4H5m13 0v16m0-16h1m-1 16H6m12 0h1M6 20H5M9 7h1v1H9V7Zm5 0h1v1h-1V7Zm-5 4h1v1H9v-1Zm5 0h1v1h-1v-1Zm-3 4h2a1 1 0 0 1 1 1v4h-4v-4a1 1 0 0 1 1-1Z" />
                </svg>
            </a>
        </li>

    </ul>

    <div class="tab-content">
        <div id="mainMenu" class="tab-pane active">
            <ul class="nav am-sideleft-menu">


                <!-- Grupos -->
                <li class="nav-item">
                    <a href="grupos.php" class="nav-link">
                        <i class="icon ion-ios-people-outline"></i>
                        <span>Grupos</span>
                    </a>
                </li>

                <!-- Reportes -->
                <li class="nav-item">
                    <a href="#" class="nav-link with-sub">
                        <i class="icon ion-ios-pie-outline"></i>
                        <span>Reportes</span>
                    </a>
                    <ul class="nav-sub">
                        <!-- <li class="nav-item"><a href="rep-acceso.php" class="nav-link">Acceso al sistema</a></li> -->
                        <li class="nav-item"><a href="reportes-bitacora.php" class="nav-link">Bitácora general</a></li>
                        <li class="nav-item"><a href="reportes-contra.php" class="nav-link">Conta 14</a></li>
                        <li class="nav-item"><a href="reportes-contra-interno.php" class="nav-link">Conta 14 (Interno)</a></li>
                        <li class="nav-item"><a href="reportes-pagos-saldo.php" class="nav-link">Pagos con cuenta pendiente</a></li>
                        <li class="nav-item"><a href="reportes-timbres.php" class="nav-link">Timbres</a></li>
                        <li class="nav-item"><a href="reportes-facturas-eliminadas.php" class="nav-link">Reporte de facturas eliminadas</a></li>
                        <li class="nav-item"><a href="reportes-facturas-canceladas.php" class="nav-link">Facturas canceladas</a></li>
                        <li class="nav-item"><a href="reportes-banking.php" class="nav-link">Banking</a></li>
                        <li class="nav-item"><a href="reportes-correos-factura.php" class="nav-link">Correos de facturas</a></li>
                        <li class="nav-item"><a href="reportes-correos-contexto.php" class="nav-link">Correos contextuales</a></li>
                    </ul>
                </li>

                <!-- Catálogos -->
                <li class="nav-item">
                    <a href="#" class="nav-link with-sub">
                        <i class="icon ion-ios-list-outline"></i>
                        <span>Catálogos</span>
                    </a>
                    <ul class="nav-sub">
                        <li class="nav-item"><a href="catalogos-empresas.php" class="nav-link">Empresas</a></li>
                        <li class="nav-item"><a href="catalogos-conceptos.php" class="nav-link">Conceptos facturables</a></li>
                        <li class="nav-item"><a href="catalogos-bancos.php" class="nav-link">Bancos</a></li>
                        <li class="nav-item"><a href="catalogos-carteras.php" class="nav-link">Carteras</a></li>
                        <li class="nav-item"><a href="catalogos-claves.php" class="nav-link">Claves cortas</a></li>
                        <!-- <li class="nav-item"><a href="cat-unidades.php" class="nav-link">Claves unidades</a></li> -->
                        <!-- <li class="nav-item"><a href="cat-formas.php" class="nav-link">Formas de pago</a></li> -->
                        <li class="nav-item"><a href="cat-usuarios.php" class="nav-link">Usuarios del sistema</a></li>
                        <li class="nav-item"><a href="catalogos-grupos.php" class="nav-link">Grupos de clientes</a></li>
                        <li class="nav-item"><a href="cat-fondeadoras.php" class="nav-link">Ejecuciones de fondeadoras</a></li>
                        <li class="nav-item"><a href="proveedor.php" class="nav-link">Proveedores</a></li>
                        <li class="nav-item"><a href="cat-fisicas.php" class="nav-link">Cuentas especiales</a></li>
                        <li class="nav-item"><a href="cat-contactos-banca.php" class="nav-link">Salida de contactos</a></li>
                        <li class="nav-item"><a href="cat-conceptos-pre.php" class="nav-link">Conceptos maderables</a></li>
                    </ul>
                </li>

                <!-- Facturación -->
                <li class="nav-item">
                    <a href="#" class="nav-link with-sub">
                        <i class="icon ion-ios-paper-outline"></i>
                        <span>Facturación</span>
                    </a>
                    <ul class="nav-sub">
                        <li class="nav-item"><a href="facturas-nueva.php" class="nav-link">Nueva Factura</a></li>
                        <li class="nav-item"><a href="facturas.php" class="nav-link">Facturación</a></li>
                        <li class="nav-item"><a href="facturas-complementos.php" class="nav-link">Complementos de pago</a></li>
                        <!-- <li class="nav-item"><a href="fac-conta-rel.php" class="nav-link">Relacionar pago</a></li> -->
                        <!-- <li class="nav-item"><a href="fac-carga.php" class="nav-link">Carga de facturas externas</a></li> -->
                        <li class="nav-item"><a href="facturas-ppd.php" class="nav-link">Facturas PPD</a></li>
                        <li class="nav-item"><a href="fac-facturas-eliminadas.php" class="nav-link">Facturas eliminadas</a></li>
                    </ul>
                </li>

                <!-- Movimientos -->
                <li class="nav-item">
                    <a href="#" class="nav-link with-sub">
                        <i class="icon ion-ios-shuffle"></i>
                        <span>Movimientos</span>
                    </a>
                    <ul class="nav-sub">
                        <li class="nav-item"><a href="movimientos-asignados.php" class="nav-link">Movimientos asignados</a></li>
                        <li class="nav-item"><a href="movimientos-sin-asignar.php" class="nav-link">Movimientos sin asignar</a></li>
                        <li class="nav-item"><a href="mov-totales.php" class="nav-link">Ingreso de pagos</a></li>
                        <li class="nav-item"><a href="mov-reasigna.php" class="nav-link">Re-asignación de movimientos</a></li>
                        <li class="nav-item"><a href="movimientos-traspasos.php" class="nav-link">Traspaso entre carteras</a></li>
                        <li class="nav-item"><a href="movimientos-stp.php" class="nav-link">Movimientos de STP</a></li>
                    </ul>
                </li>

                <!-- Capturas -->
                <li class="nav-item">
                    <a href="#" class="nav-link with-sub">
                        <i class="icon ion-ios-camera-outline"></i>
                        <span>Capturas</span>
                    </a>
                    <ul class="nav-sub">
                        <li class="nav-item"><a href="capturas.php" class="nav-link">Capturas</a></li>
                        <li class="nav-item"><a href="capturas-manuales.php" class="nav-link">Capturas manuales</a></li>
                        <li class="nav-item"><a href="capturas-eliminadas.php" class="nav-link">Capturas eliminadas</a></li>
                    </ul>
                </li>



                <!-- Estadísticas / Meta datos -->
                <li class="nav-item">
                    <a href="#" class="nav-link with-sub">
                        <i class="icon ion-ios-analytics-outline"></i>
                        <span>Estadísticas / Meta datos</span>
                    </a>
                    <ul class="nav-sub">
                        <li class="nav-item"><a href="estadisticas-cliente.php" class="nav-link">Ganancias por cliente</a></li>
                        <li class="nav-item"><a href="metricas-ganancias-fac.php" class="nav-link">Estadísticas para clientes</a></li>
                        <li class="nav-item"><a href="estadisticas-general.php" class="nav-link">Ganancias generales</a></li>
                        <li class="nav-item"><a href="estadisticas-general-dia.php" class="nav-link">Ganancias generales por día</a></li>
                        <li class="nav-item"><a href="metricas-uso-stp.php" class="nav-link">Uso de STP</a></li>
                        <li class="nav-item"><a href="estadisticas-facturas.php" class="nav-link">Facturas</a></li>
                        <li class="nav-item"><a href="usoSTP.php" class="nav-link">Cuentas Frecuentes (STP)</a></li>
                        <li class="nav-item"><a href="metricas-facturas-mes.php" class="nav-link">Cantidad facturada por cliente</a></li>
                    </ul>
                </li>



            </ul>
        </div>

        <div id="emailMenu" class="tab-pane">
            <div class="pd-x-20 pd-y-10">
                <a href="" class="btn btn-orange btn-block btn-compose">Empresas</a>
            </div>
            <ul class="nav am-sideleft-menu">

                <?php
                foreach ($empresas as $empresa) {


                ?>


                    <li class="nav-item">
                        <a href="empresa-detalle.php?empresa=<?= $empresa->id ?>" class="nav-link">

                            <!-- <img src="<?= $empresa->logo ?>"
                                alt="Logo"
                                style="width:25px; height:25px; border-radius:50%; object-fit:cover; padding: 2px"> -->
                            <span><?= recortarCadena($empresa->razon) ?></span>
                        </a>
                    </li><!-- nav-item -->

                <?php } ?>

            </ul>


        </div><!-- #emailMenu -->
        <div id="chatMenu" class="tab-pane">
            <div class="chat-search-bar">
                <input type="search" class="form-control wd-150" placeholder="Search chat...">
                <button class="btn btn-secondary"><i class="fa fa-search"></i></button>
            </div><!-- chat-search-bar -->

            <label class="pd-x-15 tx-uppercase tx-11 mg-t-20 tx-orange mg-b-10 tx-medium">Recent Chat History</label>
            <div class="list-group list-group-chat">
                <a href="#" class="list-group-item">
                    <div class="d-flex align-items-center">
                        <img src="../img/img6.jpg" class="wd-32 rounded-circle" alt="">
                        <div class="mg-l-10">
                            <h6>Russell M. Evans</h6>
                            <span>Tuesday, 10:33am</span>
                        </div>
                    </div><!-- d-flex -->
                    <p>Nor again is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain...</p>
                </a><!-- list-group-item -->
                <a href="#" class="list-group-item">
                    <div class="d-flex align-items-center">
                        <img src="../img/img7.jpg" class="wd-32 rounded-circle" alt="">
                        <div class="mg-l-10">
                            <h6>James F. Sears</h6>
                            <span>Monday, 4:21pm</span>
                        </div>
                    </div><!-- d-flex -->
                    <p>But who has any right to find fault with a man who chooses to enjoy a pleasure that has...</p>
                </a><!-- list-group-item -->
                <a href="#" class="list-group-item">
                    <div class="d-flex align-items-center">
                        <img src="../img/img8.jpg" class="wd-32 rounded-circle" alt="">
                        <div class="mg-l-10">
                            <h6>Sharon R. Rowe</h6>
                            <span>Sunday, 7:45pm</span>
                        </div>
                    </div><!-- d-flex -->
                    <p>But I must explain to you how all this mistaken idea of denouncing pleasure and praising...</p>
                </a><!-- list-group-item -->
                <a href="#" class="list-group-item">
                    <div class="d-flex align-items-center">
                        <img src="../img/img9.jpg" class="wd-32 rounded-circle" alt="">
                        <div class="mg-l-10">
                            <h6>Ruby M. Martin</h6>
                            <span>Sunday, 7:45pm</span>
                        </div>
                    </div><!-- d-flex -->
                    <p>But I must explain to you how all this mistaken idea of denouncing pleasure and praising...</p>
                </a><!-- list-group-item -->
                <a href="#" class="list-group-item">
                    <div class="d-flex align-items-center">
                        <img src="../img/img10.jpg" class="wd-32 rounded-circle" alt="">
                        <div class="mg-l-10">
                            <h6>Joslyn C. Mayo</h6>
                            <span>Sunday, 7:45pm</span>
                        </div>
                    </div><!-- d-flex -->
                    <p>But I must explain to you how all this mistaken idea of denouncing pleasure and praising...</p>
                </a><!-- list-group-item -->
            </div><!-- list-group -->
            <span class="d-block pd-15 tx-12">Loading messages...</span>

        </div><!-- #chatMenu -->
        <div id="settingMenu" class="tab-pane">
            <div class="pd-x-15">
                <label class="tx-uppercase tx-11 mg-t-10 tx-orange mg-b-15 tx-medium">Quick Settings</label>
                <div class="bd pd-15">
                    <h6 class="tx-13 tx-normal tx-gray-800">Daily Newsletter</h6>
                    <p class="tx-12">Get notified when someone else is trying to access your account.</p>
                    <div class="toggle toggle-light warning"></div>
                </div><!-- bd -->

                <div class="bd pd-15 mg-t-15">
                    <h6 class="tx-13 tx-normal tx-gray-800">Call Phones</h6>
                    <p class="tx-12">Make calls to friends and family right from your account.</p>
                    <div class="toggle toggle-light warning"></div>
                </div><!-- bd -->

                <div class="bd pd-15 mg-t-15">
                    <h6 class="tx-13 tx-normal tx-gray-800">Login Notifications</h6>
                    <p class="tx-12">Get notified when someone else is trying to access your account.</p>
                    <div class="toggle toggle-light warning"></div>
                </div><!-- bd -->

                <div class="bd pd-15 mg-t-15">
                    <h6 class="tx-13 tx-normal tx-gray-800">Phone Approvals</h6>
                    <p class="tx-12">Use your phone when login as an extra layer of security.</p>
                    <div class="toggle toggle-light warning"></div>
                </div><!-- bd -->
            </div>
        </div><!-- #settingMenu -->
    </div><!-- tab-content -->
</div><!-- am-sideleft -->