<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14 Reporte correos</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/highlightjs/github.css" rel="stylesheet">
  <link href="../lib/datatables/jquery.dataTables.css" rel="stylesheet">
  <link href="../lib/select2/css/select2.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>

    <?php
    include_once('api/adminUtil.php');
    $adminUtil = new AdministradorUtil();
    $facturasCorreos = $adminUtil->dameFacturasCorreos();
    function formateFecha($fecha)
    {
      $fechaCompletaExplode = explode(" ", $fecha);
      $fecha = $fechaCompletaExplode[0];
      $hora = $fechaCompletaExplode[1];
      $dia = explode("-", $fecha)[2];
      $mes = explode("-", $fecha)[1];
      $anio = explode("-", $fecha)[0];

      switch ($mes) {
        case 1:
          $mes = 'Enero';
          break;
        case 2:
          $mes = 'Febrero';
          break;
        case 3:
          $mes = 'Marzo';
          break;
        case 4:
          $mes = 'Abril';
          break;

        case 5:
          $mes = 'Mayo';
          break;
        case 6:
          $mes = 'Junio';
          break;
        case 7:
          $mes = 'Julio';
          break;
        case 8:
          $mes = 'Agosto';
          break;
        case 9:
          $mes = 'Septiembre';
          break;
        case 10:
          $mes = 'Octubre';
          break;
        case 11:
          $mes = 'Noviembre';
          break;
        case 12:
          $mes = 'Diciembre';
          break;
      }

      return "$dia de $mes del $anio a las $hora";
    }

    ?>

    <div class="am-pagebody">

      <div class="card pd-20 pd-sm-40">
        <h6 class="card-body-title">Reporte conta 14</h6>
        <p class="mg-b-20 mg-sm-b-30">Reporte de relaciones entre facturas y pagos de sistema 14.</p>

        <div class="table-wrapper">
          <table id="datatable1" class="table display responsive nowrap">
            <thead>
              <tr>
                <th>id</th>
                <th>Correo de origen </th>
                <th>Correo destino</th>
                <th>Mensaje de petición </th>
                <th>Mensaje respuesta </th>
                <th>Hora de petición </th>
                <th>Hora de respuesta </th>
              </tr>
            </thead>
            <tbody>
              <?php

              foreach ($facturasCorreos as $fila) {
                $fila->tamplate = str_replace("%", '', $fila->tamplate);
                $fila->respuesta = str_replace("%", "", $fila->respuesta);
                $fila->respuesta = str_replace('"respuesta"', "", $fila->respuesta);
                $fechaExp = explode(" ", $fila->fecha_envia);
                $fecha = $fechaExp[0];
                $fechaSemiExp = explode("-", $fecha);
                $dia = $fechaSemiExp[2];
                $mes = $fechaSemiExp[1];
                $anio = $fechaSemiExp[0];

                //reemplazar AAAA por anio DD por dia MM por mes en template y respuesta
                $fila->tamplate = str_replace("AAAA", $anio, $fila->tamplate);
                $fila->tamplate = str_replace("DD", $dia, $fila->tamplate);
                $fila->tamplate = str_replace("MM", $mes, $fila->tamplate);
                $fila->respuesta = str_replace("AAAA", $anio, $fila->respuesta);
                $fila->respuesta = str_replace("DD", $dia, $fila->respuesta);
                $fila->respuesta = str_replace("MM", $mes, $fila->respuesta);
                $fila->respuesta = str_replace("$$", '', $fila->respuesta);
                $fila->tamplate = str_replace("$$", '', $fila->tamplate);


                echo "<tr>";
                echo "<td>" . $fila->id . "</td>";
                echo "<td>" . $fila->nombre_empresa_origen . "</td>";
                echo "<td>" . $fila->nombre_empresa_destino . "</td>";
                echo "<td>" . $fila->tamplate . "</td>";
                echo "<td>" . $fila->respuesta . "</td>";
                echo "<td>" . formateFecha($fila->fecha_envia) . "</td>";
                echo "<td>" . formateFecha($fila->fecha_recibe) . "</td>";
                echo "</tr>";
              }

              ?>

            </tbody>
          </table>
        </div><!-- table-wrapper -->
      </div><!-- card -->







    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->


  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/highlightjs/highlight.pack.js"></script>
  <script src="../lib/datatables/jquery.dataTables.js"></script>
  <script src="../lib/datatables-responsive/dataTables.responsive.js"></script>
  <script src="../lib/select2/js/select2.min.js"></script>

  <script src="../js/amanda.js"></script>
  <script>
    $(function() {
      'use strict';

      $('#datatable1').DataTable({
        responsive: true,
        language: {
          searchPlaceholder: 'Search...',
          sSearch: '',
          lengthMenu: '_MENU_ items/page',
        }
      });
      // Select2
      $('.dataTables_length select').select2({
        minimumResultsForSearch: Infinity
      });

    });
  </script>
</body>

</html>