<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14 Reporte Conta14 Interno</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/highlightjs/github.css" rel="stylesheet">
  <link href="../lib/datatables/jquery.dataTables.css" rel="stylesheet">
  <link href="../lib/select2/css/select2.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>

    <?php
    include_once 'api/adminPagos.php';
    include_once 'api/adminFacturas.php';
    $adminPagos = new AdministradorPagos();
    $pagos = $adminPagos->damePagosInternos();
    $adminFacturas = new AdministradorFormasPago();
    $facturas = $adminFacturas->dameFacturasInternas();
    $montosListados = array();


    function damePagoPorMonto($monto, $pagos)
    {
      foreach ($pagos as $pago) {
        if ($pago->monto == $monto) {
          return $pago;
        }
      }
      return null;
    }


    function fechaComoCadenaFacturas($fecha)
    {
      $dia = substr($fecha, 8, 2);
      $mes = substr($fecha, 5, 2);
      $anio = substr($fecha, 0, 4);

      switch ($mes) {
        case "01":
          $mes = 'Enero';
          break;
        case "02":
          $mes = 'Febrero';
          break;
        case "03":
          $mes = 'Marzo';
          break;
        case  "04":
          $mes = 'Abril';
          break;
        case "05":
          $mes = 'Mayo';
          break;
        case "06":
          $mes = 'Junio';
          break;
        case "07":
          $mes = 'Julio';
          break;
        case "08":
          $mes = 'Agosto';
          break;
        case "09":
          $mes = 'Septiembre';
          break;
        case "10":
          $mes = 'Octubre';
          break;
        case "11":
          $mes = 'Noviembre';
          break;
        case "12":
          $mes = 'Diciembre';
          break;
        default:
          $mes = "NA";
          $dia = "NA";
          $anio = "NA";
      }
      return $dia . '/' . $mes . '/' . $anio;
    }
    ?>

    <div class="am-pagebody">

      <div class="card pd-20 pd-sm-40">
        <h6 class="card-body-title">Reporte conta 14</h6>
        <p class="mg-b-20 mg-sm-b-30">Reporte de relaciones entre facturas y pagos de sistema 14.</p>

        <div class="table-wrapper">
          <table id="datatable1" class="table display responsive nowrap">
            <thead>
              <tr>
                <th>Factura</th>
                <th>Fecha factura</th>
                <th>Folio fiscal</th>
                <th>Importe factura</th>
                <th>Pago</th>
                <th>Monto pago</th>
                <th>Fecha Pago</th>
                <th>Empresa</th>
                <th>Cuenta</th>
                <th>Detalles pago</th>
              </tr>
            </thead>
            <tbody>
              <?php

              foreach ($facturas as $factura) {
                $pago = damePagoPorMonto($factura->total_iva, $pagos);
                $color = 'black';
                //verificar si el monto esta en el arreglo 
                if (in_array($factura->total_iva, $montosListados)) {
                  $color = 'red';
                }



                echo '<tr style="color: ' . $color . ';">';
                echo '<td>' . $factura->id . '</td>';
                echo '<td>' . $factura->fecha . '</td>';
                echo '<td>' . $factura->uuid . '</td>';

                echo '<td>$' . number_format($factura->total_iva, 2)  . '</td>';
                echo '<td>' . $pago->id . '</td>';
                echo '<td>$' . number_format($pago->monto, 2)  . '</td>';
                echo '<td>' . $pago->fecha_banco . '</td>';

                echo '<td>' . $pago->nombreEmpresa . '</td>';

                echo '<td>' . $pago->bancoNombreCorto . '</td>';

                echo '<td>' . $pago->detalle . ' ' . $pago->descripcion . ' ' . $pago->descripcion_detallada . '</td>';
                echo '</tr>';
                $montosListados[] = $factura->total_iva;
              }


              ?>

            </tbody>
          </table>
        </div><!-- table-wrapper -->
      </div><!-- card -->







    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->


  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/highlightjs/highlight.pack.js"></script>
  <script src="../lib/datatables/jquery.dataTables.js"></script>
  <script src="../lib/datatables-responsive/dataTables.responsive.js"></script>
  <script src="../lib/select2/js/select2.min.js"></script>

  <script src="../js/amanda.js"></script>
  <script>
    $(function() {
      'use strict';

      $('#datatable1').DataTable({
        responsive: true,
        language: {
          searchPlaceholder: 'Search...',
          sSearch: '',
          lengthMenu: '_MENU_ items/page',
        }
      });

      $('#datatable2').DataTable({
        bLengthChange: false,
        searching: false,
        responsive: true
      });

      // Select2
      $('.dataTables_length select').select2({
        minimumResultsForSearch: Infinity
      });

    });
  </script>
</body>

</html>