<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/rickshaw/rickshaw.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>
    <?php
    include_once('api/adminPagos.php');

    $adminPagos = new AdministradorPagos();

    if (isset($_GET['busqueda'])) {
      $pagosTraspaso = $adminPagos->damePagosTraspasoBusqueda($_GET['busqueda']);
    } else {
      $pagosTraspaso = $adminPagos->damePagosTraspaso();
    }

    function fechaComoCadenaTraspasos($fecha)
    {
      $dia = substr($fecha, 8, 2);
      $mes = substr($fecha, 5, 2);
      $anio = substr($fecha, 0, 4);
      switch ($mes) {
        case "01":
          $mes = 'Enero';
          break;
        case "02":
          $mes = 'Febrero';
          break;
        case "03":
          $mes = 'Marzo';
          break;
        case "04":
          $mes = 'Abril';
          break;
        case "05":
          $mes = 'Mayo';
          break;
        case "06":
          $mes = 'Junio';
          break;
        case "07":
          $mes = 'Julio';
          break;
        case "08":
          $mes = 'Agosto';
          break;
        case "09":
          $mes = 'Septiembre';
          break;
        case "10":
          $mes = 'Octubre';
          break;
        case "11":
          $mes = 'Noviembre';
          break;
        case "12":
          $mes = 'Diciembre';
          break;
        default:
          $mes = "NA";
          $dia = "NA";
          $anio = "NA";
      }
      return $dia . '/' . $mes . '/' . $anio;
    }
    ?>
    <div class="am-pagebody">
      <div class="col-12">
        <div class="card mg-t-20">
          <div class="card-header d-flex align-items-center justify-content-between flex-wrap">
            <h6 class="mg-b-0">Traspaso entre carteras</h6>

            <div class="d-flex align-items-center gap-2">
              <!-- Buscador -->
              <div class="input-group input-group-sm mr-2" style="max-width:320px;">
                <input type="text" id="mySearch" class="form-control" placeholder="Buscar...">
                <div class="input-group-append">
                  <button class="btn btn-outline-primary" type="button" onclick="busquedaGeneral()">Buscar</button>
                </div>
              </div>

              <!-- Acciones -->
              <button type="button" class="btn btn-danger btn-sm mr-2" onclick="deleteSelected()">
                Eliminar seleccionados
              </button>

              <a href="mov-traspasos-form.php" class="btn btn-primary btn-sm">
                Nuevo Traspaso
              </a>
            </div>
          </div>

          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-striped table-hover table-bordered">
                <thead class="thead-dark">
                  <tr>
                    <th class="text-center" style="width:38px;">
                      <input type="checkbox" id="chkAll" onclick="toggleAll(this)">
                    </th>
                    <th>ID</th>
                    <th>Fecha asignación</th>
                    <th>Cliente</th>
                    <th>Cartera/Asignado</th>
                    <th class="text-right">Monto</th>
                    <th>Detalle</th>
                    <th style="width:120px;" class="text-center">Acciones</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (!empty($pagosTraspaso)): ?>
                    <?php foreach ($pagosTraspaso as $p): ?>
                      <tr id="row_<?php echo $p->id; ?>">
                        <td class="text-center align-middle">
                          <input type="checkbox" class="chk-item" value="<?php echo $p->id; ?>">
                        </td>
                        <td class="align-middle"><?php echo $p->id; ?></td>
                        <td class="align-middle"><?php echo fechaComoCadenaTraspasos($p->fecha_asignacion); ?></td>
                        <td class="align-middle"><?php echo $p->nombreCliente; ?></td>
                        <td class="align-middle"><?php echo $p->clienteAsignado; ?></td>
                        <td class="align-middle text-right">$<?php echo number_format($p->monto, 2); ?></td>
                        <td class="align-middle"><?php echo $p->detalle; ?></td>
                        <td class="text-center align-middle">
                          <button class="btn btn-sm btn-danger" onclick="eliminarTraspaso(<?php echo $p->id; ?>)">
                            Eliminar
                          </button>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="8" class="text-center">No hay traspasos.</td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>

        </div>
      </div>







    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->

  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/d3/d3.js"></script>
  <script src="../lib/rickshaw/rickshaw.min.js"></script>
  <script src="http://maps.google.com/maps/api/js?key=AIzaSyAEt_DBLTknLexNbTVwbXyq2HSf2UbRBU8"></script>
  <script src="../lib/gmaps/gmaps.js"></script>
  <script src="../lib/Flot/jquery.flot.js"></script>
  <script src="../lib/Flot/jquery.flot.pie.js"></script>
  <script src="../lib/Flot/jquery.flot.resize.js"></script>
  <script src="../lib/flot-spline/jquery.flot.spline.js"></script>

  <script src="../js/amanda.js"></script>
  <script src="../js/ResizeSensor.js"></script>
  <script src="../js/dashboard.js"></script>

  <!-- SweetAlert2 (añádelo debajo de tus otros <script> ya existentes) -->
  <!-- SweetAlert2 -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <script>
    function busquedaGeneral() {
      const valor = document.getElementById('mySearch')?.value || '';
      window.location.href = 'mov-traspasos-c.php?busqueda=' + encodeURIComponent(valor);
    }

    // Seleccionar/deseleccionar todos
    function toggleAll(master) {
      document.querySelectorAll('.chk-item').forEach(chk => chk.checked = master.checked);
    }

    // Eliminar uno
    function eliminarTraspaso(id) {
      const enviaDatosTraspaso = new FormData();
      enviaDatosTraspaso.append('accion', 'eliminarTraspaso');
      enviaDatosTraspaso.append('idTraspaso', id);

      Swal.fire({
        title: '¿Quieres eliminar el traspaso ' + id + '?',
        text: 'Se eliminará de forma permanente.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'ELIMINAR',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (!result.isConfirmed) return;

        fetch('api/apiPagosT.php', {
            method: 'POST',
            body: enviaDatosTraspaso
          })
          .then(r => r.json())
          .then(data => {
            Swal.fire(
              data?.[0]?.estatus || 'Hecho',
              data?.[0]?.mensaje || 'El traspaso fue eliminado.',
              data?.[0]?.subMensaje || ''
            );
            const fila = document.getElementById('row_' + id);
            if (fila) fila.remove();
          })
          .catch(err => {
            console.error(err);
            Swal.fire('Error', 'No se pudo eliminar el traspaso.', 'error');
          });
      });
    }

    // Eliminar seleccionados (batch)
    function deleteSelected() {
      const ids = Array.from(document.querySelectorAll('.chk-item:checked')).map(chk => chk.value);
      if (ids.length === 0) {
        Swal.fire('Sin selección', 'Selecciona al menos un traspaso para eliminar.', 'info');
        return;
      }

      Swal.fire({
        title: '¿Eliminar ' + ids.length + ' traspaso(s)?',
        text: 'Esta acción no se puede deshacer.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'ELIMINAR',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (!result.isConfirmed) return;

        // Procesar en serie para simplificar (y respetar tu API actual)
        (async () => {
          for (const id of ids) {
            await eliminarTraspasoSilent(id);
          }
          Swal.fire('Listo', 'Se eliminaron los traspasos seleccionados.', 'success');
        })();
      });
    }

    // Variante silenciosa que no abre modales por cada ID (usada en batch)
    function eliminarTraspasoSilent(id) {
      const enviaDatosTraspaso = new FormData();
      enviaDatosTraspaso.append('accion', 'eliminarTraspaso');
      enviaDatosTraspaso.append('idTraspaso', id);

      return fetch('api/apiPagosT.php', {
          method: 'POST',
          body: enviaDatosTraspaso
        })
        .then(r => r.json())
        .then(() => {
          const fila = document.getElementById('row_' + id);
          if (fila) fila.remove();
        })
        .catch(err => console.error('Error eliminando ' + id, err));
    }
  </script>



</body>

</html>