<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/rickshaw/rickshaw.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>
    <?php
    include_once('api/adminPagos.php');
    $adminPagos = new AdministradorPagos();
    if (isset($_GET["busqueda"])) {
      $movimientos = $adminPagos->damePagosBuscados($_GET["busqueda"]);
    } else {
      $movimientos = $adminPagos->damePagosAsignados();
    }
    ?>
    <div class="am-pagebody">
      <div class="col-12">
        <div class="card mg-t-20">
          <div class="card-header d-flex align-items-center justify-content-between">
            <h6 class="card-title mg-b-0">Movimientos asignados</h6>

            <!-- Buscador opcional (si tu template/buscador no lo trae ya) -->
            <div class="input-group input-group-sm" style="max-width:300px;">
              <input type="text" id="mySearch" class="form-control" placeholder="Buscar...">
              <div class="input-group-append">
                <button class="btn btn-primary" type="button" onclick="busquedaGeneral()">Buscar</button>
              </div>
            </div>
          </div>

          <div class="card-body">
            <div class="table-responsive">
              <table id="tableStripe" class="table table-striped table-hover table-bordered">
                <thead class="thead-dark">
                  <tr>
                    <th>ID <?php echo $_SESSION["usuario_id"]; ?></th>
                    <th>Empresa</th>
                    <th>Cliente</th>
                    <th>Cantidad</th>
                    <th>Saldo acreditable</th>
                    <th>Tipo Movimiento</th>
                    <th>Banco</th>
                    <th>Fecha Banco</th>
                    <th>Fecha Asignación</th>
                    <th>Detalles</th>
                    <th>Asignó</th>
                    <th>Acciones</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($movimientos as $movimiento): ?>
                    <tr id="row<?php echo $movimiento->id; ?>">
                      <td><?php echo $movimiento->id; ?></td>
                      <td><?php echo $movimiento->empresa; ?></td>
                      <td><?php echo $movimiento->nombreCliente; ?></td>
                      <td>$<?php echo number_format($movimiento->monto, 2); ?></td>
                      <td>$<?php echo number_format($movimiento->saldo_acreditable, 2); ?></td>
                      <td><?php echo $movimiento->tipo_movimiento; ?></td>
                      <td><?php echo $movimiento->banco; ?></td>
                      <td><?php echo $movimiento->fecha_banco; ?></td>
                      <td><?php echo $movimiento->fecha_asignacion; ?></td>
                      <td><?php echo $movimiento->detalle . ' ' . $movimiento->descripcion . ' ' . $movimiento->descripcion_detallada; ?></td>
                      <td><?php echo $movimiento->usuario_asigna; ?></td>
                      <td>
                        <button type="button" class="btn btn-sm btn-danger"
                          onclick="desasignar(<?php echo $movimiento->id; ?>)">
                          Des-asignar
                        </button>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>






    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->

  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/d3/d3.js"></script>
  <script src="../lib/rickshaw/rickshaw.min.js"></script>
  <script src="http://maps.google.com/maps/api/js?key=AIzaSyAEt_DBLTknLexNbTVwbXyq2HSf2UbRBU8"></script>
  <script src="../lib/gmaps/gmaps.js"></script>
  <script src="../lib/Flot/jquery.flot.js"></script>
  <script src="../lib/Flot/jquery.flot.pie.js"></script>
  <script src="../lib/Flot/jquery.flot.resize.js"></script>
  <script src="../lib/flot-spline/jquery.flot.spline.js"></script>

  <script src="../js/amanda.js"></script>
  <script src="../js/ResizeSensor.js"></script>
  <script src="../js/dashboard.js"></script>

  <!-- SweetAlert2 (añádelo debajo de tus otros <script> ya existentes) -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
  function desasignar(id) {
    Swal.fire({
      title: '¿Desea des-asignar el movimiento?',
      text: 'Se desasignará y quedará como no asignado.',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Des-asignar',
      cancelButtonText: 'Cancelar'
    }).then((result) => {
      if (result.isConfirmed) {
        const datos = new FormData();
        datos.append('accion', 'desasignarMovimiento');
        datos.append('id', id);

        fetch('api/apiPagosT.php', {
          method: 'POST',
          body: datos
        })
        .then(resp => resp.json())
        .then(data => {
          // Esperando estructura: [{ estatus, mensaje, subMensaje }]
          Swal.fire(
            data?.[0]?.estatus || 'Hecho',
            data?.[0]?.mensaje || 'Movimiento des-asignado',
            data?.[0]?.subMensaje || ''
          );

          // Remueve la fila en la tabla
          const fila = document.getElementById('row' + id);
          if (fila) fila.remove();
        })
        .catch(err => {
          console.error(err);
          Swal.fire('Error', 'No se pudo des-asignar el movimiento.', 'error');
        });
      }
    });
  }

  function busquedaGeneral() {
    const valor = document.getElementById('mySearch')?.value || '';
    window.location.href = 'mov-movimientos-asignados-c.php?busqueda=' + encodeURIComponent(valor);
  }
</script>




</body>

</html>