<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

  <!-- Twitter -->
  <meta name="twitter:site" content="@themepixels">
  <meta name="twitter:creator" content="@themepixels">
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Amanda">
  <meta name="twitter:description" content="Premium Quality and Responsive UI for Dashboard.">
  <meta name="twitter:image" content="http://themepixels.me/amanda/img/amanda-social.png">

  <!-- Facebook -->
  <meta property="og:url" content="http://themepixels.me/amanda">
  <meta property="og:title" content="Bracket">
  <meta property="og:description" content="Premium Quality and Responsive UI for Dashboard.">

  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@sweetalert2/theme-dark@5/dark.css">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <!-- Meta -->
  <meta name="description" content="Premium Quality and Responsive UI for Dashboard.">
  <meta name="author" content="ThemePixels">


  <title>Amanda Responsive Bootstrap 4 Admin Template</title>

  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">

  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>
  <style>
    /* Loader simple centrado sobre el cuadro */
    .signin-loading {
      position: absolute;
      inset: 0;
      display: none;
      place-items: center;
      background: rgba(0, 0, 0, .15);
      border-radius: 8px;
      z-index: 10;
    }

    .signin-loading.show {
      display: grid;
    }

    .spinner {
      width: 36px;
      height: 36px;
      border: 3px solid rgba(255, 255, 255, .4);
      border-top-color: #fff;
      border-radius: 50%;
      animation: spin 0.9s linear infinite;
    }

    @keyframes spin {
      to {
        transform: rotate(360deg);
      }
    }

    /* Fade suave para cambio de formularios sin alterar ancho */
    .fade-in {
      animation: fadeIn .25s ease;
    }

    @keyframes fadeIn {
      from {
        opacity: 0
      }

      to {
        opacity: 1
      }
    }
  </style>
  <?php
  session_start();
  $_SESSION[$session_id] = null;
  $_SESSION[$session_usuario] = null;
  $_SESSION["usuario"] = null;
  $_SESSION["admindif_admin_id"] = null;
  $_SESSION["usuario_id"] = null;
  $_SESSION["tipo_usuario"] =  null;
  $_SESSION["id_cliente_14"] = null;
  ?>
  <div class="am-signin-wrapper">
    <div class="am-signin-box" style="position:relative;">
      <!-- loader -->
      <div id="signinLoader" class="signin-loading">
        <div class="spinner"></div>
      </div>

      <div class="row no-gutters">
        <div class="col-lg-5">
          <div><img src="https://sistema14.com/assets/images/logo.png" alt=""></div>
        </div>

        <div class="col-lg-7">
          <!-- Formulario inicial -->
          <div id="form-login">
            <h5 class="tx-gray-800 mg-b-25">Ingresa con tu cuenta.</h5>

            <div class="form-group">
              <label class="form-control-label">Email:</label>
              <input id="email" type="email" name="email" class="form-control" placeholder="Ingresa tu correo electrónico" autocomplete="username" required>
            </div>

            <div class="form-group">
              <label class="form-control-label">Contraseña:</label>
              <input id="password" type="password" name="password" class="form-control" placeholder="Ingresa tu contraseña" autocomplete="current-password" required>
            </div>

            <div class="form-group mg-b-20"><a href="#">Re iniciar contraseña</a></div>

            <button type="button" class="btn btn-block btn-primary" id="btnIngresar">Ingresar</button>
          </div>

          <!-- Formulario 2FA (oculto al inicio) -->
          <div id="form-2fa" style="display:none;">
            <h5 class="tx-gray-800 mg-b-25">Verificación en dos pasos</h5>

            <div class="form-group">
              <label class="form-control-label">Código 2FA:</label>
              <input id="twofa" type="text" name="twofa" class="form-control" placeholder="Ingresa tu código de verificación" inputmode="numeric" autocomplete="one-time-code" required>
            </div>

            <button type="button" class="btn btn-block btn-success" id="btnConfirmar">Confirmar</button>
          </div>
        </div><!-- col-7 -->
      </div><!-- row -->

      <p class="tx-center tx-white-5 tx-12 mg-t-15">Copyright &copy; 2025. All Rights Reserved.</p>
    </div><!-- signin-box -->
  </div><!-- am-signin-wrapper -->
  <script>
    document.addEventListener("DOMContentLoaded", function() {
      // 1) Focus automático en email al entrar
      document.getElementById("email").focus();

      const formLogin = document.getElementById("form-login");
      const form2fa = document.getElementById("form-2fa");
      const btnIngresar = document.getElementById("btnIngresar");
      const btnConfirmar = document.getElementById("btnConfirmar");
      const inputTwofa = document.getElementById("twofa");

      // 2) Al dar clic en "Ingresar", mostrar 2FA y poner focus en campo
      btnIngresar.addEventListener("click", function() {
        formLogin.style.display = "none";
        form2fa.style.display = "block";
        inputTwofa.focus();
      });

      // 3) Detectar Enter: depende de cuál formulario esté visible
      document.addEventListener("keydown", function(e) {
        if (e.key === "Enter") {
          e.preventDefault(); // evita submit automático

          if (formLogin.style.display !== "none") {
            btnIngresar.click();
          } else if (form2fa.style.display !== "none") {
            btnConfirmar.click();
          }
        }
      });
    });
  </script>
  <script>
    const $ = (sel) => document.querySelector(sel);
    const formLogin = $('#form-login');
    const form2fa = $('#form-2fa');
    const loader = $('#signinLoader');
    const btnIngresar = $('#btnIngresar');
    const btnConfirmar = $('#btnConfirmar');

    // 1) Mostrar 2FA con fade al presionar "Ingresar"
    btnIngresar.addEventListener('click', () => {
      formLogin.style.display = 'none';
      form2fa.style.display = 'block';
      form2fa.classList.remove('fade-in'); // reset anim
      // forzar reflow para reiniciar animación
      void form2fa.offsetWidth;
      form2fa.classList.add('fade-in');
      $('#twofa')?.focus();
    });

    // 2) Enviar login al presionar "Confirmar" (segunda vez)
    btnConfirmar.addEventListener('click', enviarLogin);

    async function enviarLogin() {
      // Evitar dobles clics
      if (btnConfirmar.disabled) return;

      const email = $('#email')?.value?.trim();
      const password = $('#password')?.value;
      const twofa = $('#twofa')?.value?.trim();

      if (!email || !password || !twofa) {
        toast('Completa email, contraseña y 2FA.', 'warning');
        return;
      }

      btnConfirmar.disabled = true;
      btnConfirmar.innerText = 'Enviando...';
      loader.classList.add('show');

      try {
        const fd = new FormData();
        // Ajusta los nombres si tu backend espera otras claves
        fd.append('usuario', email);
        fd.append('password', password);
        fd.append('2fa', twofa);

        const resp = await fetch('api/adminLogin.php', {
          method: 'POST',
          body: fd,
          credentials: 'include' // por si tu backend setea cookie de sesión
        });

        // Intenta parsear JSON; si no es JSON, maneja texto
        let data;
        const ct = resp.headers.get('content-type') || '';
        if (ct.includes('application/json')) {
          data = await resp.json();
        } else {
          const text = await resp.text();
          // Normaliza a objeto mínimo si el backend devuelve texto plano
          data = {
            estatus: resp.estatus,
            mensaje: resp.mensaje
          };
        }

        if (data.estatus === 'exito') {
          toast('Autenticado con éxito', 'success');
          // Redirigir tras un instante para que se vea el toast
          setTimeout(() => {
            window.location.href = 'index.php';
          }, 700);
        } else {
          toast(data.mensaje || 'Credenciales o código 2FA inválidos.', 'error');
        }
      } catch (err) {
        console.error(err);
        toast('Error de red o servidor. Intenta de nuevo.', 'error');
      } finally {
        loader.classList.remove('show');
        btnConfirmar.disabled = false;
        btnConfirmar.innerText = 'Confirmar';
      }
    }

    // SweetAlert2 toast en esquina superior derecha
    function toast(title, icon = 'info') {
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 1600,
        timerProgressBar: true
      });
      Toast.fire({
        icon,
        title
      });
    }
  </script>

  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>

  <script src="../js/amanda.js"></script>
</body>

</html>