<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14 Bancos</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/highlightjs/github.css" rel="stylesheet">
  <link href="../lib/datatables/jquery.dataTables.css" rel="stylesheet">
  <link href="../lib/select2/css/select2.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">
    <?php include "api/adminComplementos.php" ?>

    <?php include_once 'template/buscador.php' ?>
    <?php
    $adminComplementos = new AdministradorPPD();
    ?>

    <?php

    if (isset($_GET['inicio'])) {
      $complementos = $adminComplementos->dameComplementosPagoFecha($_GET['inicio'], $_GET['fin']);
    } else {
      $complementos = $adminComplementos->dameComplementosPago();
    }

    function formatearFecha($fecha)
    {
      $fechaExp = explode("-", $fecha);
      $dia  = $fechaExp[2];
      $mes  = $fechaExp[1];
      $anio = $fechaExp[0];

      switch ($mes) {
        case '01':
          $mes = 'Enero';
          break;
        case '02':
          $mes = 'Febrero';
          break;
        case '03':
          $mes = 'Marzo';
          break;
        case '04':
          $mes = 'Abril';
          break;
        case '05':
          $mes = 'Mayo';
          break;
        case '06':
          $mes = 'Junio';
          break;
        case '07':
          $mes = 'Julio';
          break;
        case '08':
          $mes = 'Agosto';
          break;
        case '09':
          $mes = 'Septiembre';
          break;
        case '10':
          $mes = 'Octubre';
          break;
        case '11':
          $mes = 'Noviembre';
          break;
        case '12':
          $mes = 'Diciembre';
          break;
      }

      return $dia . " de " . $mes . " de " . $anio;
    }
    ?>


    <div class="am-pagebody">
      <div class="card pd-20 pd-sm-40">
        <div class="d-flex justify-content-between align-items-center">
          <h6 class="card-body-title">Bancos de empresas</h6>
          <div class="btn-group" role="group" aria-label="Basic example">
            <button type="button" class="btn btn-secondary pd-x-25 active">General Settings</button>
            <button type="button" class="btn btn-secondary pd-x-25">Privacy Settings</button>
            <button type="button" class="btn btn-secondary pd-x-25">Account Settings</button>
          </div>
        </div>
        <p class="mg-b-20 mg-sm-b-30">Lista de bancos de las empresas.</p>
        <div class="table-wrapper">
          <table id="datatable" class="table display responsive nowrap">
            <table id="tableStripe" class="table-striped">
              <thead>
                <!-- NUEVA COLUMNA: seleccionar todos -->
                <th style="width:28px;">
                  <input type="checkbox" id="selectAll" class="form-checkbox" />
                </th>
                <th>id</th>
                <th>Método de pago </th>
                <th>Forma de pago </th>
                <th>Empresa </th>
                <th>Monto</th>
                <th>uuid</th>
                <th>Folio/Serie </th>
                <th>Cliente</th>
                <th>Fecha de timbrado</th>
                <th>Acciones</th>
              </thead>
              <tbody>
                <?php
                foreach ($complementos as $complemento) {
                  echo "<tr>";
                  // NUEVA COLUMNA: checkbox por fila (antes del id)
                  echo '<td><input type="checkbox" class="form-checkbox chk-comp" value="' . htmlspecialchars($complemento->id, ENT_QUOTES, 'UTF-8') . '"></td>';

                  echo "<td>" . $complemento->id . "</td>";
                  echo "<td>" . $complemento->metodo_pago . "</td>";
                  echo "<td>" . $complemento->forma_pago . "</td>";
                  echo "<td>" . $complemento->razon . "</td>";
                  echo "<td>$" . number_format($complemento->total_factura, 2) . "</td>";
                  echo "<td>" . $complemento->uuid . "</td>";
                  echo "<td>" . $complemento->folio . " " . $complemento->serie .  "</td>";

                  echo "<td>" . $complemento->nombre . "</td>";
                  echo "<td>" . formatearFecha($complemento->fecha_timbrado)  . "</td>";

                  if ($complemento->uuid == '') {
                    echo '<td>
';
                ?>

                    <!-- (todo tu bloque original del modal + scripts Alpine) -->
                    <!-- vertically centered -->
                    <div class="mb-5" x-data="modal">
                      <!-- button -->
                      <div class="flex items-center justify-center">
                        <button type="button" class="btn btn-info" @click="toggle">Timbrar</button>
                      </div>

                      <!-- modal -->
                      <div class="fixed inset-0 bg-[black]/60 z-[999] hidden overflow-y-auto" :class="open && '!block'">
                        <div class="flex items-center justify-center min-h-screen px-4" @click.self="open = false">
                          <div x-show="open" x-transition x-transition.duration.300 class="panel border-0 p-0 rounded-lg overflow-hidden w-full max-w-lg my-8">
                            <div class="flex bg-[#fbfbfb] dark:bg-[#121c2c] items-center justify-between px-5 py-3">
                              <h5 class="font-bold text-lg">Timbre para <?php echo $complemento->id ?></h5>
                            </div>
                            <div class="p-5">
                              <div class="dark:text-white-dark/70 text-base font-medium text-[#1f2937]">
                                <p>Seleccione el método de timbrado de su factura. </p>
                              </div>
                              <div class="flex justify-center items-center mt-8">
                                <div class="flex center inline-flex align-middle">
                                  <button onclick="timbreOp(1, <?php echo $complemento->id ?>)" type="button" class="btn btn-dark ltr:rounded-r-none rtl:rounded-l-none">Típico</button>
                                  <button onclick="timbreOp(2, <?php echo $complemento->id ?>)" type="button" class="btn btn-dark rounded-none">Taza 0</button>
                                  <button onclick="timbreOp(3, <?php echo $complemento->id ?>)" type="button" class="btn btn-dark rounded-none">Sin IVA</button>
                                  <button onclick="timbreOp(4, <?php echo $complemento->id ?>)" type="button" class="btn btn-dark ltr:rounded-l-none rtl:rounded-r-none">Retención 4%</button>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <!-- script -->
                    <script>
                      document.addEventListener("alpine:init", function() {
                        Alpine.data("modal", function(initialOpenState) {
                          if (typeof initialOpenState === 'undefined') initialOpenState = false;
                          return {
                            open: initialOpenState,
                            toggle: function() {
                              this.open = !this.open;
                            }
                          };
                        });
                      });
                    </script>

                <?php
                    echo '
                    <button onclick="eliminar(' . $complemento->id . ')" class="btn btn-warning gap-2">Eliminar</button>
                    <a href="fac-complementos-detalle.php?id=' . $complemento->id . '" class="btn btn-primary gap-2">Detalles</a>
                    <a href="https://old.sistema14.com/gen_fact_complemento_pdf.php?id=' . $complemento->id . '" target="_blank" class="btn btn-error gap-2">PDF</a>
                </td>';
                  } else {
                    echo '<td>
                    <button onclick="reenviar(' . $complemento->id . ')" class="btn btn-success gap-2">Reenviar</button>
                    <a href="https://old.sistema14.com/gen_fact_complemento_pdf.php?id=' . $complemento->id . '" class="btn btn-error gap-2" target="_blank">PDF</a>
                    <a href="https://sistema14.com/api/xml/firmados-comp/XML-complemento-' . $complemento->id . '-' . $complemento->uuid . '.xml" class="btn btn-error gap-2" target="_blank">XML</a>
                    <a href="fac-complementos-detalle.php?id=' . $complemento->id . '" class="btn btn-primary gap-2">Detalles</a>
                </td>';
                  }

                  echo "</tr>";
                }
                ?>
              </tbody>
            </table>
          </table>
        </div><!-- table-wrapper -->
      </div><!-- card -->







    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->


  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/highlightjs/highlight.pack.js"></script>
  <script src="../lib/datatables/jquery.dataTables.js"></script>
  <script src="../lib/datatables-responsive/dataTables.responsive.js"></script>
  <script src="../lib/select2/js/select2.min.js"></script>

  <script src="../js/amanda.js"></script>
  <script>
    $(function() {
      'use strict';

      $('#datatable1').DataTable({
        responsive: true,
        language: {
          searchPlaceholder: 'Search...',
          sSearch: '',
          lengthMenu: '_MENU_ items/page',
        }
      });

      $('#datatable2').DataTable({
        bLengthChange: false,
        searching: false,
        responsive: true
      });

      // Select2
      $('.dataTables_length select').select2({
        minimumResultsForSearch: Infinity
      });

    });
  </script>

  <script>
    $(document).ready(function() {
      $('#datatable').DataTable({
        responsive: true, // tabla adaptable
        pageLength: 10, // número de registros por página
        lengthMenu: [5, 10, 25, 50, 100],
        language: {
          url: "https://cdn.datatables.net/plug-ins/1.13.6/i18n/es-MX.json" // Español México
        }
      });
    });
  </script>
</body>

</html>