<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/rickshaw/rickshaw.min.css" rel="stylesheet">

  <!-- include summernote css/js -->
  <script src="https://code.jquery.com/jquery-3.4.1.slim.min.js" integrity="sha384-J6qa4849blE2+poT4WnyKhv5vZF5SrPo0iEjwBvKU7imGFAV0wwj1yYfoRSJoZ+n" crossorigin="anonymous"></script>
  <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>

  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>

    <div class="am-pagebody">
      <div class="card pd-20 pd-sm-40">
        <h6 class="card-body-title">Captura de bancos</h6>
        <p class="mg-b-20 mg-sm-b-30">Pega la captura del banco en el area de texto.</p>

        <!-- Textarea de Summernote -->
        <textarea name="captura" id="summernote"></textarea>
        <script>
          $('#summernote').summernote({
            placeholder: 'Pega la captura de banco aquí... ',
            tabsize: 2,
            height: 120,
            toolbar: false

          });
        </script>

        <!-- Botones abajo separados -->
        <div class="row mt-3">
          <div class="col-sm-6">
            <button type="button" class="btn btn-info w-100" onclick="enviarCaptura()">Análisis</button>
          </div>
          <div class="col-sm-6">
            <button type="button" class="btn btn-success w-100" onclick="guardarCaptura()">Capturar</button>
          </div>
        </div>
      </div>
      <br>

      <div class="card pd-20 pd-sm-40">
        <h6 class="card-body-title">Resumen de captura</h6>
        <p class="mg-b-20 mg-sm-b-30">Verifica los movimientos y el total del banco.</p>

        <div class="table-responsive">
          <table class="table table-bordered mg-b-0">
            <thead>
              <tr>
                <th>Nuevos movimientos</th>
                <th>Movimientos repetidos</th>
                <th>Depositos</th>
                <th>Retiros</th>
              </tr>
            </thead>
            <tbody id="tablaKpis">

             
            </tbody>
          </table>
        </div>
        <br>
        <div class="table-responsive">
          <table class="table table-bordered mg-b-0">
            <thead>
              <tr>
                <th>Fecha movimiento</th>
                <th>Descripcion movimiento</th>
                <th>Saldo</th>
                <th>Referencia</th>
                <th>Descripción detallada</th>
                <th>Tipo de movimiento</th>
                <th>Claves cortas identificadas</th>
                <th>Cliente asociado</th>
                <th>Cantidad</th>
                <th>Estatus</th>
              </tr>
            </thead>
            <tbody id="tablaResumen">


            </tbody>
          </table>
        </div>


      </div>



    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->

  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/d3/d3.js"></script>
  <script src="../lib/rickshaw/rickshaw.min.js"></script>
  <script src="http://maps.google.com/maps/api/js?key=AIzaSyAEt_DBLTknLexNbTVwbXyq2HSf2UbRBU8"></script>
  <script src="../lib/gmaps/gmaps.js"></script>
  <script src="../lib/Flot/jquery.flot.js"></script>
  <script src="../lib/Flot/jquery.flot.pie.js"></script>
  <script src="../lib/Flot/jquery.flot.resize.js"></script>
  <script src="../lib/flot-spline/jquery.flot.spline.js"></script>
  <script src="../js/amanda.js"></script>
  <script src="../js/ResizeSensor.js"></script>
  <script src="../js/dashboard.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <script>
    // =====================
    // Captura → API → Tablas
    // Requiere: jQuery y Summernote (#summernote)
    // Llena:    <tbody id="tablaResumen">…</tbody>
    // KPIs:     <tbody id="tablaKpis"><tr><td>…</td><td>…</td><td>…</td><td>…</td></tr></tbody>
    // =====================

    var identificados = [];

    // ---------- Utils de UI ----------
    function setLoadingMovimientos(isLoading) {
      var tb = document.getElementById('tablaResumen');
      if (!tb) return;
      if (isLoading) {
        tb.innerHTML =
          '<tr><td colspan="10" class="text-center">' +
          '<div class="d-flex align-items-center justify-content-center" style="gap:8px;">' +
          '<div class="spinner-border" role="status" aria-hidden="true" style="width:1.5rem;height:1.5rem;"></div>' +
          '<span>Cargando movimientos…</span>' +
          '</div>' +
          '</td></tr>';
      } else {
        tb.innerHTML = '';
      }
    }

    function setLoadingKpis(isLoading) {
      var tb = document.getElementById('tablaKpis');
      if (!tb) return;
      if (isLoading) {
        tb.innerHTML =
          '<tr>' +
          '<td>—</td><td>—</td><td>—</td><td>—</td>' +
          '</tr>';
      }
    }

    // ---------- Helpers de datos ----------
    function toArrayMaybe(v) {
      if (Array.isArray(v)) return v;
      if (v === null || v === undefined) return [];
      return [v];
    }

    function safeGet(obj, keys, fb) {
      for (var i = 0; i < keys.length; i++) {
        var k = keys[i];
        if (obj && Object.prototype.hasOwnProperty.call(obj, k)) return obj[k];
      }
      return fb;
    }

    function formatCurrency(num) {
      var n = Number(num);
      if (isNaN(n)) return (num == null || num === '') ? '—' : String(num);
      return n.toLocaleString('es-MX', {
        style: 'currency',
        currency: 'MXN',
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
      });
    }

    function cleanDate(s) {
      if (!s && s !== 0) return '—';
      return String(s).replace(/^[-]+/, ''); // quita prefijos "--"
    }

    // ---------- Render KPIs ----------
    function renderKpis(data) {
      var tb = document.getElementById('tablaKpis');
      if (!tb) return;

      var nuevos = parseInt(safeGet(data, ['movimientoNuevo'], 0), 10);
      var detectados = parseInt(safeGet(data, ['movimientosDetectados'], 0), 10);
      var depositos = parseInt(safeGet(data, ['depositos'], 0), 10);
      var retiros = parseInt(safeGet(data, ['retiros'], 0), 10);
      var repetidosAPI = parseInt(safeGet(data, ['deposito_repetido'], 0), 10);

      // Heurística: repetidos = detectados - nuevos + repetidosAPI (no negativo)
      var repetidos = detectados - nuevos;
      if (repetidos < 0) repetidos = 0;
      repetidos += isNaN(repetidosAPI) ? 0 : repetidosAPI;

      tb.innerHTML =
        '<tr>' +
        '<td>' + nuevos + '</td>' +
        '<td>' + repetidos + '</td>' +
        '<td>' + depositos + '</td>' +
        '<td>' + retiros + '</td>' +
        '</tr>';
    }

    // ---------- Render Movimientos ----------
    function renderResumenTabla(data) {
      var tbody = document.getElementById('tablaResumen');
      if (!tbody) return;

      // Tolerar typos del backend
      var fechas = toArrayMaybe(safeGet(data, ['fechasMovimeinto', 'fechasMovimiento', 'fechas', 'fecha'], []));
      var descripciones = toArrayMaybe(safeGet(data, ['descipcionesMovimientos', 'descripcionesMovimientos', 'descripciones'], []));
      var saldos = toArrayMaybe(safeGet(data, ['saldosMovimientos', 'saldos'], []));
      var referencias = toArrayMaybe(safeGet(data, ['referenciasMovimientos', 'referencias'], []));
      var descripDets = toArrayMaybe(safeGet(data, ['descrip_detsMovimientos', 'descripcionDetallada', 'descripcionesDetalladas'], []));
      var tipos = toArrayMaybe(safeGet(data, ['tiposMovieintos', 'tiposMovimientos', 'tipos'], []));
      var cantidades = toArrayMaybe(safeGet(data, ['cantidades', 'montos'], []));
      var estatusHtml = toArrayMaybe(safeGet(data, ['repetido', 'estatus'], []));
      var clavesCortas = safeGet(data, ['clavesCortas'], []); // [{cliente, clave, razon}, ...]

      // Cuántos movimientos pintar (usa el mayor largo de arrays base)
      var len = Math.max(
        fechas.length, descripciones.length, saldos.length, referencias.length,
        tipos.length, cantidades.length, estatusHtml.length
      );
      if (len === 0) {
        if (descripDets.length) len = descripDets.length;
        else if (Array.isArray(clavesCortas)) len = clavesCortas.length;
      }

      // Agrupa descripcion_detallada si viene duplicada por movimiento (p.ej. 8 para 4 movimientos)
      var descDetPorMovimiento = [];
      if (descripDets.length && len > 0 && (descripDets.length % len === 0)) {
        var groupSize = descripDets.length / len;
        for (var i = 0; i < len; i++) {
          var start = i * groupSize;
          var end = start + groupSize;
          descDetPorMovimiento[i] = descripDets.slice(start, end).join(' | ');
        }
      } else {
        for (var j = 0; j < len; j++) {
          descDetPorMovimiento[j] = (j < descripDets.length && descripDets[j]) ? descripDets[j] :
            (descripDets.length ? descripDets[descripDets.length - 1] : '—');
        }
      }

      // Limpia tabla
      tbody.innerHTML = '';

      var frag = document.createDocumentFragment();
      identificados = [];

      for (var k = 0; k < len; k++) {
        var tr = document.createElement('tr');

        var fecha = (k < fechas.length && fechas[k]) ? cleanDate(fechas[k]) : (fechas.length ? cleanDate(fechas[fechas.length - 1]) : '—');
        var descMov = (k < descripciones.length && descripciones[k]) ? descripciones[k] : (descripciones.length ? descripciones[descripciones.length - 1] : '—');
        var saldo = (k < saldos.length && saldos[k]) ? saldos[k] : (saldos.length ? saldos[saldos.length - 1] : '');
        var ref = (k < referencias.length && referencias[k]) ? referencias[k] : (referencias.length ? referencias[referencias.length - 1] : '—');
        var det = descDetPorMovimiento[k] || '—';
        var tipo = (k < tipos.length && tipos[k]) ? tipos[k] : (tipos.length ? tipos[tipos.length - 1] : '—');
        var cantidad = (k < cantidades.length && cantidades[k]) ? cantidades[k] : (cantidades.length ? cantidades[cantidades.length - 1] : '');
        var estatus = (k < estatusHtml.length && estatusHtml[k]) ? estatusHtml[k] : (estatusHtml.length ? estatusHtml[estatusHtml.length - 1] : '');

        var ccObj = (Array.isArray(clavesCortas) && clavesCortas.length) ? (clavesCortas[k] || clavesCortas[clavesCortas.length - 1]) : null;
        var claveCorta = (ccObj && ccObj.clave) ? ccObj.clave : 'NA';
        var clienteAsoc = (ccObj && ccObj.cliente) ? ccObj.cliente : '0';

        // Celdas
        appendCell(tr, fecha); // Fecha movimiento
        appendCell(tr, descMov); // Descripción movimiento
        appendCell(tr, formatCurrency(saldo)); // Saldo
        appendCell(tr, ref); // Referencia
        appendCell(tr, det); // Descripción detallada
        appendCell(tr, tipo); // Tipo
        appendCell(tr, claveCorta); // Claves cortas identificadas
        appendCell(tr, clienteAsoc); // Cliente asociado
        appendCell(tr, formatCurrency(cantidad)); // Cantidad (MONEDA)
        appendCellHTML(tr, estatus || ''); // Estatus (HTML)

        identificados.push({
          fecha: fecha,
          descripcion: descMov,
          saldo: saldo,
          referencia: ref,
          descripcion_detallada: det,
          tipo: tipo,
          cantidad: cantidad,
          clave: claveCorta,
          cliente: clienteAsoc
        });

        frag.appendChild(tr);
      }

      // Fila de totalNuevo (si viene)
      var totalNuevo = safeGet(data, ['totalNuevo'], null);
      if (totalNuevo !== null && totalNuevo !== undefined) {
        var trTot = document.createElement('tr');
        trTot.innerHTML =
          '<td colspan="8" class="text-right font-weight-bold">Total nuevo</td>' +
          '<td class="font-weight-bold">' + formatCurrency(totalNuevo) + '</td>' +
          '<td></td>';
        frag.appendChild(trTot);
      }

      tbody.appendChild(frag);
    }

    // TD texto
    function appendCell(tr, text) {
      var td = document.createElement('td');
      td.textContent = (text == null ? '—' : text);
      tr.appendChild(td);
    }
    // TD HTML
    function appendCellHTML(tr, html) {
      var td = document.createElement('td');
      td.innerHTML = html || '';
      tr.appendChild(td);
    }

    // ---------- Acción principal ----------
    function enviarCaptura() {
      identificados = [];

      // loader ON
      setLoadingMovimientos(true);
      setLoadingKpis(true);

      var captura = $('#summernote').val();
      var nombreCorto = <?php echo json_encode(isset($_GET['cuenta']) ? $_GET['cuenta'] : ""); ?>;
      var razon = <?php echo json_encode(isset($_GET['empresa']) ? $_GET['empresa'] : ""); ?>;

      var envioDatosCaptura = new FormData();
      envioDatosCaptura.append('accion', 'capTemporal');
      envioDatosCaptura.append('captura', String(captura || ''));
      envioDatosCaptura.append('nombre_corto', String(nombreCorto || ''));
      envioDatosCaptura.append('razon', String(razon || ''));

      fetch('api/apiCap.php', {
          method: 'POST',
          body: envioDatosCaptura
        })
        .then(function(res) {
          return res.json();
        })
        .then(function(data) {
          renderResumenTabla(data);
          renderKpis(data);
        })
        .catch(function(err) {
          console.error('Error API:', err);
          var tb = document.getElementById('tablaResumen');
          if (tb) tb.innerHTML =
            '<tr><td colspan="10" class="text-center text-danger">No se pudo procesar la captura.</td></tr>';
          setLoadingKpis(false);
        })
        .finally(function() {
          // loader OFF (en movimientos lo apaga renderResumenTabla al limpiar)
          // aquí sólo aseguramos que si falló, no quede spinner
          var tb = document.getElementById('tablaResumen');
          if (tb && tb.innerHTML.indexOf('spinner-border') !== -1) {
            tb.innerHTML = '';
          }
        });
    }
  </script>
    <script>
        function guardarCaptura() {

            var captura = $("#summernote").val();
            var nombre_corto = <?php echo $_GET['cuenta'] ?>;
            var razon = <?php echo $_GET['empresa'] ?>;

            var envioDatosCapturaGuardar = new FormData();
            envioDatosCapturaGuardar.append("accion", "agregarCaptura");
            envioDatosCapturaGuardar.append("captura", "" + captura);
            envioDatosCapturaGuardar.append("nombre_corto", "" + nombre_corto);
            envioDatosCapturaGuardar.append("razon", "" + razon);


            fetch("api/apiCapturas.php", {
                    method: "POST",
                    body: envioDatosCapturaGuardar,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    //en caso de ok cierre la ventana 

                    Swal.fire(
                        data.estatus,
                        data.mensaje,
                        data.subMensaje
                    ).then((result) => {
                        if (result.isConfirmed) {

                            //redirigir a empresas 
                            window.location.href = "empresa-detalle.php?empresa=<?=$_GET['empresa']?>"; 
                            


                        }
                    })

                });




        }
    </script>





</body>

</html>