<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14 Claves C</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/highlightjs/github.css" rel="stylesheet">
  <link href="../lib/datatables/jquery.dataTables.css" rel="stylesheet">
  <link href="../lib/select2/css/select2.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>

    <?php
    include_once('api/adminClavesCortas.php');
    $adminCalvesCortas = new AdministradorClavesCortas();
    $clavesCortas = $adminCalvesCortas->dameClavesCortas();
    ?>
    <div class="am-pagebody">
      <div class="card pd-20 pd-sm-40">
        <div class="d-flex justify-content-between align-items-center">
          <h6 class="card-body-title">Bancos de empresas</h6>
          <a class="btn btn-primary btn-sm" href="catalogos-claves-formulario.php">Agregar</a>
        </div>
        <p class="mg-b-20 mg-sm-b-30">Lista de bancos de las empresas.</p>
        <div class="table-wrapper">
          <table id="datatable1" class="table display responsive nowrap">
            <thead>
              <tr>
                <th>Cliente</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">Clave Corta</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="1">Razón Social</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="2">RFC</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="3">CP</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="4">Regimen Fiscal</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="5">Domicilio</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="6">Facturación Automática</th>
                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Acciones</th>
              </tr>
            </thead>
            <tbody>
              <?php

              foreach ($clavesCortas as $clave) {
                echo '<tr id="row' . $clave->id . '">
                  <td>' . $clave->nombreCliente . '</td>
                  <td>' . $clave->clave_corta . '</td>
                  <td>' . $clave->razon_social . '</td>
                  <td>' . $clave->rfc . '</td>
                  <td>' . $clave->cp . '</td>
                  <td>' . $clave->regimen_fiscal . '</td>                  
                  <td>' . $clave->domicilio . '</td>

                  <td>' . $clave->facturacion_automatica . '</td>

                  <td>
                <a href="catalogos-claves-formulario.php?id=' . $clave->id . '" class="btn btn-sm btn-block info text-u-c">Editar</a>
                <a onclick="eliminarClave(' . $clave->id . ')" class="btn btn-sm btn-block danger text-u-c">Eliminar</a>
                </td>
                </tr>';
              }


              ?>
            </tbody>
          </table>
        </div><!-- table-wrapper -->
      </div><!-- card -->







    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->


  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/highlightjs/highlight.pack.js"></script>
  <script src="../lib/datatables/jquery.dataTables.js"></script>
  <script src="../lib/datatables-responsive/dataTables.responsive.js"></script>
  <script src="../lib/select2/js/select2.min.js"></script>

  <script src="../js/amanda.js"></script>
  <script>
    $(function() {
      'use strict';

      $('#datatable1').DataTable({
        responsive: true,
        language: {
          searchPlaceholder: 'Search...',
          sSearch: '',
          lengthMenu: '_MENU_ items/page',
        }
      });

      $('#datatable2').DataTable({
        bLengthChange: false,
        searching: false,
        responsive: true
      });

      // Select2
      $('.dataTables_length select').select2({
        minimumResultsForSearch: Infinity
      });

    });
  </script>
</body>

</html>