<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14 Bancos</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/highlightjs/github.css" rel="stylesheet">
  <link href="../lib/datatables/jquery.dataTables.css" rel="stylesheet">
  <link href="../lib/select2/css/select2.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>

    <?php
    include_once('api/adminBancos.php');
    include_once('api/adminEmpresas.php');
    $adminEmpresas = new AdminEmpresas();
    $adminBancos = new AdministradorBanco();
    $topbancos = $adminBancos->dameTop5bancos();
    $bancos = $adminBancos->dameBancos();
    ?>
    <div class="am-pagebody">
      <div class="card pd-20 pd-sm-40">
        <div class="d-flex justify-content-between align-items-center">
          <h6 class="card-body-title">Bancos de empresas</h6>
          <a class="btn btn-primary btn-sm" href="catalogos-bancos-formulario.php">Agregar</a>
        </div>
        <p class="mg-b-20 mg-sm-b-30">Lista de bancos de las empresas.</p>
        <div class="table-wrapper">
          <table id="datatable1" class="table display responsive nowrap">
            <thead>
              <tr>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">*Empresa</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="1">Banco</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="2">Generar Alerta tras (Cantidad en Horas)</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="3">("Número de cuenta")</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="4">Clabe Interbancaria</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="5">Nombre Corto</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="6">Moneda</th>
                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="6">Estatus</th>
                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="6">Saldo</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Acciones</th>
              </tr>
            </thead>
            <tbody>
              <?php
              foreach ($bancos as $banco) {
                $saldo = $adminEmpresas->dameRetirosYDepositos($banco->id);
                echo "<tr>";
                echo "<td>" . $banco->empresaNombre . "</td>";
                echo "<td>" . $banco->banco . "</td>";
                echo "<td>" . $banco->alerta . "</td>";
                echo "<td>" . $banco->numero_cuenta . "</td>";
                echo "<td>" . $banco->clabe_interbancaria . "</td>";
                echo "<td>" . $banco->nombre_corto . "</td>";
                echo "<td>" . $banco->moneda . "</td>";
                echo "<td>" . $banco->status_banco . "</td>";
                echo "<td>$" . number_format($saldo, 2) . "</td>";
                echo "<td>" . $banco->botonRuta . "</td>";

                echo "</tr>";
              }
              ?>
            </tbody>
          </table>
        </div><!-- table-wrapper -->
      </div><!-- card -->







    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->


  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/highlightjs/highlight.pack.js"></script>
  <script src="../lib/datatables/jquery.dataTables.js"></script>
  <script src="../lib/datatables-responsive/dataTables.responsive.js"></script>
  <script src="../lib/select2/js/select2.min.js"></script>

  <script src="../js/amanda.js"></script>
  <script>
    $(function() {
      'use strict';

      $('#datatable1').DataTable({
        responsive: true,
        language: {
          searchPlaceholder: 'Search...',
          sSearch: '',
          lengthMenu: '_MENU_ items/page',
        }
      });

      $('#datatable2').DataTable({
        bLengthChange: false,
        searching: false,
        responsive: true
      });

      // Select2
      $('.dataTables_length select').select2({
        minimumResultsForSearch: Infinity
      });

    });
  </script>
</body>

</html>