<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/rickshaw/rickshaw.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>

    <div class="am-pagebody">
      <?php
      include_once('api/adminPagos.php');
      $adminPagos = new AdministradorPagos();
      $pagos = $adminPagos->damePagosCapMan();
      ?>

      <div class="col-12">
        <div class="card mg-t-20">
          <div class="card-header d-flex align-items-center justify-content-between flex-wrap">
            <h6 class="mg-b-0">Capturas Manuales</h6>

            <a href="cap-capturas-manual-form.php" class="btn btn-primary btn-sm">
              Nueva captura
            </a>
          </div>

          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-striped table-hover table-bordered">
                <thead class="thead-dark">
                  <tr>
                    <th>ID</th>
                    <th>Empresa</th>
                    <th>Cuenta Bancaria</th>
                    <th>Tipo de movimiento</th>
                    <th class="text-right">Monto</th>
                    <th hidden>monto_raw</th>
                    <th>Fecha</th>
                    <th>Detalles</th>
                    <th style="width:120px;" class="text-center">Acciones</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  if (!empty($pagos)) {
                    foreach ($pagos as $pago) {
                      echo '<tr id="cc' . $pago->id_captura . '">';
                      echo '<td>' . $pago->id_captura . '</td>';
                      echo '<td>' . $pago->nombreEmpresa . '</td>';
                      echo '<td>' . $pago->nombre_corto . '</td>';
                      echo '<td>' . $pago->tipo_movimiento . '</td>';
                      echo '<td class="text-right">$' . number_format($pago->monto, 2) . '</td>';
                      echo '<td hidden>' . $pago->monto . '</td>';
                      echo '<td>' . $pago->fecha_banco . '</td>';
                      echo '<td>' . $pago->detalle . '</td>';
                      echo '<td class="text-center">';
                      echo '  <button type="button" class="btn btn-danger btn-sm" onclick="eliminarCap(' . $pago->id_captura . ')">Eliminar</button>';
                      echo '</td>';
                      echo '</tr>';
                    }
                  } else {
                    echo '<tr><td colspan="9" class="text-center">No hay capturas manuales.</td></tr>';
                  }
                  ?>
                </tbody>
              </table>
            </div>
          </div>

        </div>
      </div>











    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->

  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/d3/d3.js"></script>
  <script src="../lib/rickshaw/rickshaw.min.js"></script>
  <script src="http://maps.google.com/maps/api/js?key=AIzaSyAEt_DBLTknLexNbTVwbXyq2HSf2UbRBU8"></script>
  <script src="../lib/gmaps/gmaps.js"></script>
  <script src="../lib/Flot/jquery.flot.js"></script>
  <script src="../lib/Flot/jquery.flot.pie.js"></script>
  <script src="../lib/Flot/jquery.flot.resize.js"></script>
  <script src="../lib/flot-spline/jquery.flot.spline.js"></script>

  <script src="../js/amanda.js"></script>
  <script src="../js/ResizeSensor.js"></script>
  <script src="../js/dashboard.js"></script>

  <!-- SweetAlert2 (añádelo debajo de tus otros <script> ya existentes) -->

  <!-- SweetAlert2 (si ya lo cargas en otra vista, omite esta línea) -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <!-- Si SweetAlert2 no está ya cargado en tu layout, incluye esta línea: -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <script>
    function eliminarCap(captura) {
      var fila = document.getElementById('cc' + captura);

      Swal.fire({
        title: '¿Estás seguro?',
        text: 'Eliminar captura ' + captura,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
      }).then(function(result) {
        if (!result.isConfirmed) return;

        var datos = new FormData();
        datos.append('id', captura);
        datos.append('accion', 'eliminaCap');

        fetch('api/apiPagosT.php', {
            method: 'POST',
            body: datos
          })
          .then(function(response) {
            return response.json();
          })
          .then(function(data) {
            // La API a veces responde como objeto y a veces como array
            var resp = data && (data.estatus ? data : (data[0] ? data[0] : null));

            if (resp && (resp.subMensaje === 'success' || resp.icon === 'success')) {
              if (fila && fila.parentNode) {
                fila.parentNode.removeChild(fila);
              }
            }

            Swal.fire(
              (resp && resp.estatus) ? resp.estatus : 'Resultado',
              (resp && resp.mensaje) ? resp.mensaje : 'Operación completada',
              (resp && resp.subMensaje) ? resp.subMensaje : 'info'
            );
          })
          .catch(function(err) {
            console.error(err);
            Swal.fire('Error', 'No se pudo eliminar la captura.', 'error');
          });
      });
    }
  </script>





</body>

</html>