<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/rickshaw/rickshaw.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>

    <div class="am-pagebody">
      <?php
      include_once('api/adminCapturas.php');
      $adminCapturas = new AdministradorCapturas();
      $capturas = $adminCapturas->dameCapturasEliminadas();
      ?>


      <div class="col-12">
        <div class="card mg-t-20">
          <div class="card-header d-flex align-items-center justify-content-between flex-wrap">
            <h6 class="mg-b-0">Capturas eliminadas</h6>
          </div>

          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-striped table-hover table-bordered">
                <thead class="thead-dark">
                  <tr>
                    <th>ID</th>
                    <th>Empresa</th>
                    <th>*Cuenta Bancaria</th>
                    <th>Fecha</hth>
                    <th>Hora</th>
                    <th style="width:160px;" class="text-center">Acciones</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  if (!empty($capturas)) {
                    foreach ($capturas as $captura) {
                      echo '<tr id="cc' . $captura->id . '">';
                      echo '  <td class="align-middle">' . $captura->id . '</td>';
                      echo '  <td class="align-middle">' . $captura->razon . '</td>';
                      echo '  <td class="align-middle">' . $captura->nombre_corto . '</td>';
                      echo '  <td class="align-middle">' . $captura->fecha . '</td>';
                      echo '  <td class="align-middle">' . $captura->hora . '</td>';
                      echo '  <td class="text-center align-middle">';
                      echo '    <a href="cap-ver-eliminada.php?id=' . $captura->id . '" target="_blank" class="btn btn-primary btn-sm">Ver Captura</a>';
                      echo '  </td>';
                      echo '</tr>';
                    }
                  } else {
                    echo '<tr><td colspan="6" class="text-center">No hay capturas eliminadas.</td></tr>';
                  }
                  ?>
                </tbody>
              </table>
            </div>
          </div>

        </div>
      </div>











    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->

  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/d3/d3.js"></script>
  <script src="../lib/rickshaw/rickshaw.min.js"></script>
  <script src="http://maps.google.com/maps/api/js?key=AIzaSyAEt_DBLTknLexNbTVwbXyq2HSf2UbRBU8"></script>
  <script src="../lib/gmaps/gmaps.js"></script>
  <script src="../lib/Flot/jquery.flot.js"></script>
  <script src="../lib/Flot/jquery.flot.pie.js"></script>
  <script src="../lib/Flot/jquery.flot.resize.js"></script>
  <script src="../lib/flot-spline/jquery.flot.spline.js"></script>

  <script src="../js/amanda.js"></script>
  <script src="../js/ResizeSensor.js"></script>
  <script src="../js/dashboard.js"></script>

  <!-- SweetAlert2 (añádelo debajo de tus otros <script> ya existentes) -->

  <!-- SweetAlert2 (si ya lo cargas en otra vista, omite esta línea) -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <script>
    function buscarCapturas() {
      var v = document.getElementById('mySearch') ? document.getElementById('mySearch').value : '';
      // Ajusta la ruta si tu listado vive en otro archivo con soporte de búsqueda
      window.location.href = 'cap-capturas-c.php?busqueda=' + encodeURIComponent(v);
    }

    function eliminarCap(id) {
      var fila = document.getElementById('cc' + id);

      Swal.fire({
        title: '¿Eliminar captura ' + id + '?',
        text: 'Esta acción no se puede deshacer.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
      }).then(function(result) {
        if (!result.isConfirmed) return;

        var datos = new FormData();
        datos.append('id', id);
        datos.append('accion', 'eliminaCap');

        fetch('api/apiPagosT.php', {
            method: 'POST',
            body: datos
          })
          .then(function(r) {
            return r.json();
          })
          .then(function(data) {
            // Soporta respuesta como objeto {estatus, mensaje, subMensaje}
            // o arreglo [{estatus, mensaje, subMensaje}]
            var resp = data && (data.estatus ? data : (data[0] ? data[0] : null));

            if (resp && (resp.subMensaje === 'success' || resp.icon === 'success')) {
              if (fila) fila.parentNode.removeChild(fila);
            }

            Swal.fire(
              (resp && resp.estatus) ? resp.estatus : 'Resultado',
              (resp && resp.mensaje) ? resp.mensaje : 'Operación completada',
              (resp && resp.subMensaje) ? resp.subMensaje : 'info'
            );
          })
          .catch(function(err) {
            console.error(err);
            Swal.fire('Error', 'No se pudo eliminar la captura.', 'error');
          });
      });
    }
  </script>





</body>

</html>