<?php
header('Content-Type: application/json');
include_once("adminClientes.php");
$adminClientes = new AdministradorClientes();
$clientes = $adminClientes->dameClientes();
$hoy = date("Y-m-d H:i:s", strtotime('-6 hours'));
$hoyFecha = date("Y-m-d", strtotime('-6 hours'));
$diaSemana = date("w", strtotime('-6 hours'));
$diasFestivos = array();
$diasFestivos[] = "2024-02-05";
$diasFestivos[] = "2024-03-18";
$diasFestivos[] = "2024-05-01";
$diasFestivos[] = "2024-06-02";
$diasFestivos[] = "2024-09-16";
$diasFestivos[] = "2024-10-01";
$diasFestivos[] = "2024-11-18";
$diasFestivos[] = "2024-12-25";

$data = [];

$llave = 'asd3123gldfglasd1234';
$llaveGet = $_GET['llave'];

if ($llaveGet !== $llave) {
    echo json_encode(['error' => 'Llave de acceso inválida']);
    exit;
}


if ($diaSemana != 0 && $diaSemana != 6 && !in_array($hoyFecha, $diasFestivos)) {

  foreach ($clientes as $cliente) {
    if ($cliente->notificar_saldo) {
      $saldo = floatval($adminClientes->dameSaldoInmediato($cliente->id));
      $conteo = intval($adminClientes->cuentaMovimientosHoy($cliente->id));

      $data[] = [
          'cliente' => limpiarNombre($cliente->nombre),
          'saldo' => $saldo,
          'conteo' => $conteo,
          'numero' => $cliente->telefono
      ];
    }
  }
  echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}
else{
  echo "Es fin de semana o dia festivo ";
}

function limpiarNombre($nombre)
{
  $nombre = str_replace("á", "a", $nombre);
  $nombre = str_replace("é", "e", $nombre);
  $nombre = str_replace("í", "i", $nombre);
  $nombre = str_replace("ó", "o", $nombre);
  $nombre = str_replace("ú", "u", $nombre);
  $nombre = str_replace("Á", "A", $nombre);
  $nombre = str_replace("É", "E", $nombre);
  $nombre = str_replace("Í", "I", $nombre);
  $nombre = str_replace("Ó", "O", $nombre);
  $nombre = str_replace("Ú", "U", $nombre);
  $nombre = str_replace("ñ", "n", $nombre);
  $nombre = str_replace("Ñ", "N", $nombre);
  $nombre = str_replace("ü", "u", $nombre);
  $nombre = str_replace("Ü", "U", $nombre);
  $nombre = str_replace("Ü", "U", $nombre);
  $nombre = str_replace("'", "", $nombre);
  $nombre = str_replace('"', "", $nombre);




  return $nombre;
}
