<?php

include_once("adminClientes.php");
$adminClientes = new AdministradorClientes();
$clientes = $adminClientes->dameClientes();
$hoy = date("Y-m-d H:i:s", strtotime('-6 hours'));
$hoyFecha = date("Y-m-d", strtotime('-6 hours'));
$diaSemana = date("w", strtotime('-6 hours'));
echo "dia de la semana " . $diaSemana . "<br>";
$diasFestivos = array();
$diasFestivos[] = "2024-02-05";
$diasFestivos[] = "2024-03-18";
$diasFestivos[] = "2024-05-01";
$diasFestivos[] = "2024-06-02";
$diasFestivos[] = "2024-09-16";
$diasFestivos[] = "2024-10-01";
$diasFestivos[] = "2024-11-18";
$diasFestivos[] = "2024-12-25";




if ($diaSemana != 0 && $diaSemana != 6 && !in_array($hoyFecha, $diasFestivos)) {

  foreach ($clientes as $cliente) {
    if ($cliente->notificar_saldo) {
      $saldo = floatval($adminClientes->dameSaldoInmediato($cliente->id));
      $conteo = intval($adminClientes->cuentaMovimientosHoy($cliente->id));
      echo "Cliente: " . $cliente->id . "  con saldo " . $saldo . "  con movimientos  " . $conteo . " <br>";
      echo "<br><br>";
      echo $hoy;
      echo "<br><br>";

      enviarMensaje(limpiarNombre($cliente->nombre), $saldo, $conteo, "3322408912");
      enviarMensaje(limpiarNombre($cliente->nombre), $saldo, $conteo, "3312287004");


      enviarMensaje(limpiarNombre($cliente->nombre), $saldo, $conteo, "3325132734");
    }
  }
}
else{
  echo "Es fin de semana o dia festivo ";
}

function limpiarNombre($nombre)
{
  $nombre = str_replace("á", "a", $nombre);
  $nombre = str_replace("é", "e", $nombre);
  $nombre = str_replace("í", "i", $nombre);
  $nombre = str_replace("ó", "o", $nombre);
  $nombre = str_replace("ú", "u", $nombre);
  $nombre = str_replace("Á", "A", $nombre);
  $nombre = str_replace("É", "E", $nombre);
  $nombre = str_replace("Í", "I", $nombre);
  $nombre = str_replace("Ó", "O", $nombre);
  $nombre = str_replace("Ú", "U", $nombre);
  $nombre = str_replace("ñ", "n", $nombre);
  $nombre = str_replace("Ñ", "N", $nombre);
  $nombre = str_replace("ü", "u", $nombre);
  $nombre = str_replace("Ü", "U", $nombre);
  $nombre = str_replace("Ü", "U", $nombre);
  $nombre = str_replace("'", "", $nombre);
  $nombre = str_replace('"', "", $nombre);




  return $nombre;
}

function enviarMensaje($nombre, $saldo, $conteo, $numero)
{
  //  "to": "523315448344",

  $curl = curl_init();

  curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://graph.facebook.com/v17.0/130840453454957/messages',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => '
{
  "messaging_product": "whatsapp",
  "to": "52' . $numero . '",
  "type": "template",
  "template": {
    "name": "s_saldos_s",
    "language": {
      "code": "es"
    },
    "components": [
          
         {
        "type": "body",
        "index": 0,
        "parameters": [
            {
                "type": "text",
                "text": "' . $nombre . '"
            },
             {
                "type": "text",
                "text": "$ ' . number_format($saldo, 2)  . '"
            }
            ,
             {
                "type": "text",
                "text": "' . $conteo . '"
            }
        ]
    }
    ]
  }
}',
    CURLOPT_HTTPHEADER => array(
      'Authorization: Bearer EABraG1mmqU0BOZC8i15L0OwPgtNGpagYtrx86JH5LdZC9y1SREr0VJbkj1ZAmkEZBhfwmuVXwQ7rd2jTMfpSjv0Yi7RURgWP0GZAM8LEi7nMb04ZAsBZAsoPFYQHygsvEZCoLprd598xYgRPnDXMifLpjMHm15xyz9QRUZC1jpgtIOsn6hd2vN1D1z2CHMRTEHQ0ubrKwfaffFpfEJlSZB',
      'Content-Type: application/json'
    ),
  ));

  $response = curl_exec($curl);

  curl_close($curl);
  echo $response;
  //esperar 2 segundos 
  sleep(2);
}
