<?php
include_once 'adminEmpresas.php';
include_once 'adminClavesCortas.php';
function procesarArchivosXML()
{
  $adminEmpresas = new AdminEmpresas();
  $adminClaves = new AdministradorClavesCortas();
  $resultados = array(); // Array para almacenar los resultados de cada archivo XML

  // Verificar si se han enviado archivos
  if (isset($_FILES['archivos'])) {
    // Obtener la cantidad de archivos enviados
    $num_archivos = count($_FILES['archivos']['name']);


    $facturas = array();

    // Iterar sobre cada archivo enviado
    for ($i = 0; $i < $num_archivos; $i++) {
      // Verificar si hubo algún error al subir el archivo
      if ($_FILES['archivos']['error'][$i] == UPLOAD_ERR_OK && $_FILES['archivos']['type'][$i] == "text/xml") {
        // Obtener el nombre temporal del archivo
        $archivo_tmp = $_FILES['archivos']['tmp_name'][$i];

        // Leer el contenido del archivo XML
        $contenido_xml = file_get_contents($archivo_tmp);

        // Descomponer el XML en un objeto SimpleXMLElement
        $xml = simplexml_load_string($contenido_xml);

        // Almacenar el objeto SimpleXMLElement resultante en el array de resultados

        $TipoDeComprobante = $xml->attributes()->TipoDeComprobante . "";
        $version =  $xml->attributes()->Version . "";
        $formaPago =  $xml->attributes()->FormaPago . "";
        $rfcEmisor = $xml->children('cfdi', true)->Emisor->attributes()->Rfc . "";
        $rfcReceptor = $xml->children('cfdi', true)->Receptor->attributes()->Rfc . "";
        $nombreEmisor = $xml->children('cfdi', true)->Emisor->attributes()->Nombre . "";
        $nombreReceptor = $xml->children('cfdi', true)->Receptor->attributes()->Nombre . "";
        $folioFactura = $xml->attributes()->Folio . "";
        $serieFactura = $xml->attributes()->Serie . "";
        $metodoPago = $xml->attributes()->MetodoPago . "";
        $usoCfdi =  $xml->children('cfdi', true)->Receptor->attributes()->UsoCFDI . "";
        $folioFiscal =  $xml->children('cfdi', true)->Complemento->children('tfd', true)->attributes()->UUID . "";
        $fechaTimbrado =  $xml->attributes()->Fecha . "";
        $subTotal =  $xml->attributes()->SubTotal . "";
        $total =  $xml->attributes()->Total . "";

        $fechaT = array();

        $fechaT = explode('T', $fechaTimbrado);

        $fechaTimbrado = $fechaT[0];
        $hora = $fechaT[1];


        if ($metodoPago == 'PPD') {
          $metodoPago = 2;
        } else {
          $metodoPago = 1;
        }


        switch ($formaPago) {
          case '99':
            $formaPago = 23;
            break;
          case '03':
            $formaPago = 3;
            break;
        }
        switch ($usoCfdi) {
          case 'G03':
            $usoCfdi = 3;
            break;
        }

        $empresa = $adminEmpresas->dameEmpresaRfc($rfcEmisor);
        $claveCorta = $adminClaves->dameClaveCortaRfc($rfcReceptor);

        $facturaArray = array(

          'rfc_emisor' => $rfcEmisor,
          'rfc_receptor' => $rfcReceptor,
          'nombre_emisor' => $nombreEmisor,
          'nombre_receptor' => $nombreReceptor,
          'folio_factura' => $folioFactura,
          'serie_factura' => $serieFactura,
          'metodo_pago' => $metodoPago,
          'usoCfdi' => $usoCfdi,
          'folio_fiscal' => $folioFiscal,
          'fecha_timbrado' => $fechaTimbrado,
          'hora_timbrado' => $hora,
          'sub_total' => $subTotal,
          'total' => $total,
          'version' => $version,
          'forma_pago' => $formaPago,
          'tipo_comprobante' => $TipoDeComprobante,
          'empresa_id' => $empresa->id,
          'empresa_nombre' => $empresa->razon,
          'clave_corta' => $claveCorta->id,
          'cliente_id' => $claveCorta->id_cliente,
          'nombre_clave' => $claveCorta->razon_social

        );


        $resultados[] = $facturaArray;
      } else {
        // Si no se pudo subir el archivo XML correctamente, registrar un error en los resultados
        $resultados[] = "Error al subir el archivo XML $i";
      }
    }
  }

  // Devolver el array de resultados
  return $resultados;
}

// Llamar a la función para procesar los archivos XML
$resultados = procesarArchivosXML();

// Imprimir los resultados
//echo "<pre>";
echo json_encode($resultados);
//echo "</pre>";
