<?php
// Configuración de conexión
$host = 'localhost';
$db = 'iohanes_14';
$user = 'iohanes_14';
$pass = 'bSh4_(+L*)sY';
$llave = 'asd3123gldfglasd1234';
$llaveGet = $_GET['llave'];
// Parámetros de filtro
$cuenta = 130;
$fecha = date('Y-m-d'); // Usa la fecha actual. Cambia si lo deseas
$fechaMenos7Dias = date('Y-m-d', strtotime('-7 days'));

try {
    if ($llaveGet !== $llave) {
        echo json_encode(['error' => 'Llave de acceso inválida']);
        exit;
    }
    // Conectar a la base de datos con PDO
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Preparar la consulta
    $sql = "
    SELECT 
        captura_edo_cta.*, 
        pre_ejecuta_plantilla.folio, 
        CASE 
            WHEN TRIM(pre_ejecuta_plantilla.clabe) = '' OR pre_ejecuta_plantilla.clabe IS NULL 
            THEN 'tarjeta' 
            ELSE pre_ejecuta_plantilla.clabe 
        END AS clabe
    FROM captura_edo_cta
    INNER JOIN pre_ejecuta_plantilla
        ON captura_edo_cta.referencia = pre_ejecuta_plantilla.folio
    WHERE cuenta = :cuenta
      AND retiro > 1
      AND fecha BETWEEN :fechaMenos7Dias AND :fecha
";


    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':cuenta' => $cuenta,
        ':fecha' => $fecha,
        ':fechaMenos7Dias' => $fechaMenos7Dias
    ]);

    // Obtener los resultados
    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Imprimir como JSON
    header('Content-Type: application/json');
    echo json_encode($resultados, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    // Manejo de error
    echo json_encode(['error' => 'Error en la conexión: ' . $e->getMessage()]);
}
