<?php
header('Content-Type: application/json');
include_once 'adminClientes.php';
include_once 'adminPagos.php';
$adminPagos = new AdministradorPagos();
$adminClientes = new AdministradorClientes();
$clientes = $adminClientes->dameClientesConTelefono();

$saldos = array();
foreach ($clientes as $cliente) {
    $cliente->pagos = $adminPagos->damePagosSinAsignarNotificarCliente($cliente->id);
    $cliente->ajustes = $adminPagos->dameAjustesNoNotificadosUsuario($cliente->id);
    foreach ($cliente->pagos as $pago) {
        $pago->saldo = $adminPagos->marcaNotificado($pago->id);
    }
    foreach ($cliente->ajustes as $ajuste) {
        $ajuste->saldo = $adminPagos->marcarNotificadoAjuste($ajuste->id);
    }
}

echo json_encode($clientes);
