<?php

include '../../../funciones.php';
$con = conectar();
include "../../../phpqrcode/qrlib.php";
include("../../../fpdf.php");

class PDF extends FPDF
{
    function Header()
    {
        // Puedes usar esto si necesitas color de marca:
        // $color = obten("color");
    }

    function Footer()
    {
        $this->SetY(-1);
        // Colores por grupo si quisieras usarlos (dejados como referencia)
        $grupo = "blan";
        switch ($grupo) {
            case 'blan': $this->SetFillColor(252, 255, 255, 255); break;
            case 'na':   $this->SetFillColor(245, 134, 52); break;
            case 've':   $this->SetFillColor(18, 139, 5); break;
            case 'ro':   $this->SetFillColor(255, 0, 0); break;
            case 'za':   $this->SetFillColor(10, 40, 82); break;
        }
        // Ejemplo de pie de página (opcional)
        // $this->SetFont('Arial','I',8);
        // $this->Cell(0,0.5, 'Pagina '.$this->PageNo().'/{nb}', 0, 0, 'C');
    }
}

// --------------------
// Helpers para entrada
// --------------------
function get_ids_from_request() {
    // 1) ids como arreglo POST: ids[]=1&ids[]=2...
    if (isset($_POST['ids']) && is_array($_POST['ids'])) {
        return $_POST['ids'];
    }

    // 2) ids como CSV en POST/GET: "1,2,3"
    $rawIds = null;
    if (isset($_POST['ids']) && is_string($_POST['ids'])) {
        $rawIds = $_POST['ids'];
    } elseif (isset($_GET['ids']) && is_string($_GET['ids'])) {
        $rawIds = $_GET['ids'];
    }
    if ($rawIds !== null && trim($rawIds) !== '') {
        return preg_split('/\s*,\s*/', trim($rawIds));
    }

    // 3) JSON crudo en el body: {"ids":[1,2,3]}
    $body = file_get_contents('php://input');
    if ($body) {
        $json = json_decode($body, true);
        if (is_array($json) && isset($json['ids'])) {
            return is_array($json['ids']) ? $json['ids'] : array();
        }
    }

    return array();
}

function sanitize_ids($ids) {
    $clean = array();
    if (!is_array($ids)) return $clean;
    foreach ($ids as $id) {
        $v = intval($id);
        if ($v > 0 && !in_array($v, $clean, true)) {
            $clean[] = $v;
        }
    }
    return $clean;
}

// -------------------- Entrada: ids (POST) --------------------
$ids = sanitize_ids(get_ids_from_request());

if (empty($ids)) {
    http_response_code(400);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'status' => 'error',
        'message' => 'Falta el arreglo POST "ids" con al menos un id de factura (puede ser arreglo, CSV o JSON).'
    ]);
    exit;
}

// --------------------
// Preparar PDF
// --------------------
$pdf = new PDF("P", "cm", "Letter");
$pdf->AliasNbPages();
$pdf->SetAutoPageBreak(true, 1);

// Asegurar directorio para QR
$directorioQR = __DIR__ . "/qr_fac/";
if (!is_dir($directorioQR)) {
    @mkdir($directorioQR, 0775, true);
}

// --------------------
// Render de cada factura
// --------------------
foreach ($ids as $factura) {

    // Obtén encabezado de la factura
    $query = "
    SELECT 
        claves_cortas.razon_social AS razon_cliente,
        claves_cortas.rfc AS rfc_cliente,
        claves_cortas.domicilio AS domicilio_cliente,
        facturas.tipo_comprobante,
        facturas.uuid, 
        facturas.num_certificado_sat,
        facturas.num_certificado,
        facturas.fecha_timbrado,
        facturas.hora_timbrado,
        empresas.regimen,
        facturas.total_iva,
        facturas_folios.folio,
        empresas.razon,
        empresas.rfc, 
        formas_pago.forma_pago, 
        metodos_pago.metodo_pago, 
        catalogo_monedas.moneda, 
        catalogo_monedas.id as id_moneda,  
        facturas.serie as serie2, 
        facturas.folio as folio2,  
        facturas.sello_cfd,
        facturas.sello_sat,
        empresas.logo,
        facturas.certificado_fact,
        facturas.fecha_timbrado,
        facturas.hora_timbrado,
        catalogo_usos_cfdi.cod_sat as codigo_uso_cfdi,
        catalogo_usos_cfdi.uso_cfdi,
        retencion_transporte
    FROM facturas 
    LEFT JOIN claves_cortas ON (facturas.id_clave_corta=claves_cortas.id)
    LEFT JOIN empresas ON (empresas.id=facturas.razon)
    LEFT JOIN formas_pago ON (formas_pago.id=facturas.`forma_pago`)
    LEFT JOIN metodos_pago ON (metodos_pago.id=facturas.`metodo_pago`)
    LEFT JOIN catalogo_monedas ON (catalogo_monedas.id=facturas.`moneda`)
    LEFT JOIN catalogo_usos_cfdi ON (catalogo_usos_cfdi.id=facturas.`uso_cfdi`)
    LEFT JOIN facturas_folios ON (facturas.id=facturas_folios.id_factura)
    WHERE facturas.id = '".intval($factura)."'
    ";

    $rs = mysql_query($query, $con);
    if (!$rs || mysql_num_rows($rs) === 0) {
        // Si no hay factura, saltar
        continue;
    }
    $row = mysql_fetch_array($rs);

    // Versión por regla previa
    $version = ($factura > 29000) ? "4.0" : "3.3";

    // Folio final
    $folioFinal = "XXXXXXXXXX";
    if (!empty($row['folio2'])) {
        $folioFinal = $row['folio2'] . "    Serie: " . $row['serie2'];
    } else {
        $folioFinal = $row['folio'];
    }
    $retencion = $row["retencion_transporte"];

    // Nueva página para la factura actual
    $pdf->AddPage();

    // Logo
    $logo = $row["logo"];
    $logo = str_replace("//", "/", $logo);
    $logoUrl = "https://sistema14.com/" . ltrim($logo, '/');
    // Medidas dinámicas del logo
    $ancho = 6; $largo = 6; // valores por defecto
    if (@$imgInfo = @getimagesize($logoUrl)) {
        list($width, $height, $type) = $imgInfo;
        $ancho = $width / 100;
        $largo = $height / 100;
        if ($ancho > 6) { $ancho *= 0.8; $largo *= 0.8; }
        if ($ancho > 9) { $ancho *= 0.7; $largo *= 0.7; }
    }

    // Fuente Exo si existe el archivo (evitar error si falta)
    @ $pdf->AddFont('Exo', '', 'Exo2.0-Thin-webfont.php');

    $pdf->Image($logoUrl, 0.5, 0, $ancho, $largo);

    $pdf->Ln(0.5);
    $pdf->Cell(8.2);
    $pdf->SetFont("Exo", "", 11);
    $pdf->SetFillColor(125, 125, 125);
    $pdf->Cell(11, 4, utf8_decode(("")), 1, 0, "R", false);
    $pdf->Ln(4.8);

    $pdf->SetFont("Exo", "", 6);
    $pdf->Ln(-4.8);
    $pdf->Cell(8.5);
    $pdf->SetFont("Exo", "", 9);
    $pdf->Cell(1, 1, utf8_decode(("Tipo de comprobante:")), 0, 0, "L", false);
    $pdf->SetFont("Exo", "", 8);
    $pdf->Cell(8);

    $tipo_comprobante = $row["tipo_comprobante"];
    if ($tipo_comprobante == "I") $tipo_comprobante = "Ingreso";
    elseif ($tipo_comprobante == "E") $tipo_comprobante = "Egreso";
    elseif ($tipo_comprobante == "T") $tipo_comprobante = "Traslado";
    elseif ($tipo_comprobante == "N") $tipo_comprobante = "Nomina";
    elseif ($tipo_comprobante == "P") $tipo_comprobante = "Pago";

    $pdf->Cell(1, 1, utf8_decode($tipo_comprobante), 0, 0, "R", false);

    $pdf->Ln(0.5);
    $pdf->Cell(8.5);
    $pdf->SetFont("Exo", "", 9);
    $pdf->Cell(1, 1, utf8_decode(("Folio Fiscal:")), 0, 0, "L", false);
    $pdf->SetFont("Exo", "", 8);
    $pdf->Cell(8);
    $pdf->Cell(1, 1, utf8_decode($row["uuid"]), 0, 0, "R", false);

    $pdf->Ln(0.5);
    $pdf->Cell(8.5);
    $pdf->SetFont("Exo", "", 9);
    $pdf->Cell(1, 1, utf8_decode(("Certificado SAT:")), 0, 0, "L", false);
    $pdf->SetFont("Exo", "", 8);
    $pdf->Cell(8);
    $pdf->Cell(1, 1, utf8_decode($row["num_certificado_sat"]), 0, 0, "R", false);

    $pdf->Ln(0.5);
    $pdf->Cell(8.5);
    $pdf->SetFont("Exo", "", 9);
    $pdf->Cell(1, 1, utf8_decode(("Certificado del emisor:")), 0, 0, "L", false);
    $pdf->SetFont("Exo", "", 8);
    $pdf->Cell(8);
    $pdf->Cell(1, 1, utf8_decode($row["num_certificado"]), 0, 0, "R", false);

    $pdf->Ln(0.5);
    $pdf->Cell(8.5);
    $pdf->SetFont("Exo", "", 9);
    $pdf->Cell(1, 1, utf8_decode(("Fecha y hora de certificación:")), 0, 0, "L", false);
    $pdf->SetFont("Exo", "", 8);
    $pdf->Cell(8);
    $pdf->Cell(1, 1, utf8_decode(($row["fecha_timbrado"]) . "T" . $row["hora_timbrado"]), 0, 0, "R", false);

    $pdf->Ln(0.5);
    $pdf->Cell(8.5);
    $pdf->SetFont("Exo", "", 9);
    $pdf->Cell(1, 1, utf8_decode(("Régimen fiscal:")), 0, 0, "L", false);
    $pdf->SetFont("Exo", "", 8);
    $pdf->Cell(8);
    $pdf->Cell(1, 1, utf8_decode($row["regimen"]), 0, 0, "R", false);

    $pdf->Ln(1.2);
    $pdf->Cell(0.05);
    $pdf->SetFont("Arial", "", 9);
    $pdf->SetTextColor(125, 125, 125);
    $pdf->SetFillColor(238, 238, 238);
    $pdf->Cell(19.2, 0.6, (utf8_decode("Emisor: " . $row["rfc"] . "		                       	CFDI - Versión: " . $version . "                   		                           Folio Interno:   		" . $folioFinal)), 0, 0, "L", true);

    $pdf->Ln(1);
    $pdf->SetFont("Arial", "", 8);
    $pdf->SetTextColor(125, 125, 125);
    $pdf->Cell(0.5, 0.3, (utf8_decode($row["razon"])), 0, 0, "L", false);

    $pdf->Ln(0.8);
    $pdf->SetFont("Arial", "B", 8);
    $pdf->SetTextColor(125, 125, 125);
    $pdf->Cell(0.5, 0.3, (utf8_decode("Método de Pago:")), 0, 0, "L", false);
    $pdf->SetFont("Arial", "", 8);
    $pdf->Ln(-0.3);
    $pdf->Cell(4);
    $pdf->MultiCell(3, 0.5, utf8_decode($row["metodo_pago"]));

    $pdf->Ln(-.7);
    $pdf->Cell(8.5);
    $pdf->SetFont("Arial", "B", 8);
    $pdf->SetTextColor(125, 125, 125);
    $pdf->Cell(0.5, 0.3, (utf8_decode("Forma de Pago:")), 0, 0, "L", false);
    $pdf->SetFont("Arial", "", 8);
    $pdf->Ln(-0.07);
    $pdf->Cell(11.5);
    $pdf->MultiCell(3, 0.5, utf8_decode($row["forma_pago"]));

    $pdf->Ln(-0.40);
    $pdf->Cell(14.5);
    $pdf->SetFont("Arial", "B", 8);
    $pdf->SetTextColor(125, 125, 125);
    $pdf->Cell(0.5, 0.3, (utf8_decode("Moneda:")), 0, 0, "L", false);
    $pdf->SetFont("Arial", "", 8);
    $pdf->Ln(-0.07);
    $pdf->Cell(16.5);
    $pdf->MultiCell(2, 0.5, utf8_decode($row["moneda"]));

    $pdf->Ln(0.2);
    $pdf->SetFont("Arial", "B", 8);
    $pdf->SetTextColor(125, 125, 125);
    $pdf->Cell(0.5, 0.3, (utf8_decode("Condición de Pago:")), 0, 0, "L", false);
    $pdf->SetFont("Arial", "", 8);
    $pdf->Ln(-0.1);
    $pdf->Cell(4);
    $pdf->MultiCell(3, 0.5, utf8_decode("[01] - Contado"));

    $pdf->Ln(-0.39);
    $pdf->Cell(8.5);
    $pdf->SetFont("Arial", "B", 8);
    $pdf->SetTextColor(125, 125, 125);
    $pdf->Cell(0.5, 0.3, (utf8_decode("Régimen Fiscal:")), 0, 0, "L", false);
    $pdf->SetFont("Arial", "", 8);
    $pdf->Ln(-0.07);
    $pdf->Cell(11.5);
    $pdf->MultiCell(6, 0.5, utf8_decode($row["regimen"]));

    $pdf->Ln(0);
    $pdf->Cell(0.05);
    $pdf->SetFont("Arial", "", 9);
    $pdf->SetTextColor(125, 125, 125);
    $pdf->SetFillColor(238, 238, 238);
    $pdf->Cell(19.2, 0.6, ("Receptor: " . $row["rfc_cliente"]), 0, 0, "L", true);

    $pdf->Ln(0.8);
    $pdf->Cell(0.1);
    $pdf->SetFont("Arial", "", 8);
    $pdf->MultiCell(9, 0.5, utf8_decode($row["razon_cliente"]));

    $pdf->Ln(-0.5);
    $pdf->Cell(9.2);
    $pdf->SetFont("Arial", "", 8);
    $pdf->MultiCell(10, 0.5, utf8_decode($row["domicilio_cliente"]));

    $pdf->Ln(0.5);
    $pdf->SetFont("Arial", "B", 8);
    $pdf->MultiCell(10.2, 0.5, utf8_decode("Uso de CFDI: [" . $row["codigo_uso_cfdi"] . "] " . $row["uso_cfdi"]));

    $pdf->Ln(0);
    $pdf->Cell(0.05);
    $pdf->SetFont("Arial", "", 9);
    $pdf->SetTextColor(125, 125, 125);
    $pdf->SetFillColor(238, 238, 238);
    $pdf->Cell(19.2, 0.6, (""), 0, 0, "L", true);

    $pdf->Ln(0);
    $pdf->Cell(0.05);
    $pdf->SetFont("Arial", "", 8);
    $pdf->SetTextColor(100, 100, 100);
    $pdf->SetFillColor(238, 238, 238);

    $pdf->Cell(1.4, 0.6, ("Cantidad"), 1, 0, "L", true);
    $pdf->Cell(1, 0.6, ("Unidad"), 1, 0, "L", true);
    $pdf->Cell(2.1, 0.6, ("Clave_U_Sat"), 1, 0, "L", true);
    $pdf->Cell(2.3, 0.6, (utf8_decode("No Identificación")), 1, 0, "L", true);
    $pdf->Cell(2.1, 0.6, ("Clave ProdServ"), 1, 0, "L", true);
    $pdf->Cell(6, 0.6, (utf8_decode("Descripcion")), 1, 0, "L", true);
    $pdf->Cell(2, 0.6, ("P/U"), 1, 0, "L", true);
    $pdf->Cell(2.5, 0.6, ("Importe"), 1, 0, "L", true);
    $pdf->Ln(0.08);

    $subTotalFinal = 0;
    $ivaFinal = 0;

    $qDet = "
    SELECT 
        detalle_factura.concepto,
        conceptos.clave_unidad_medida,
        conceptos.`clave_producto`,
        detalle_factura.cantidad,
        conceptos.clave_sat,
        detalle_factura.`precio_unitario`,
        detalle_factura.`precio_neto`,
        detalle_factura.`precio_con_iva`,
        detalle_factura.precio_neto_iva
    FROM detalle_factura 
    LEFT JOIN conceptos ON (conceptos.id = detalle_factura.`id_producto`) 
    WHERE id_factura = '".intval($factura)."'
    ";
    $sql_query = mysql_query($qDet, $con);

    $letrero0 = '16% IVA';
    while ($rows = mysql_fetch_array($sql_query)) {
        $letreroIva = '';

        $subTotalFinal += floatval($rows["precio_neto"]);
        $ivaFinal     += floatval($rows["precio_neto_iva"]) - floatval($rows["precio_neto"]);

        if (intval($ivaFinal) == 0) {
            $letrero0 = ' IVA (NaN %):';
            $letreroIva = '(+) IVA Exento';
        }

        $pdf->Ln(0.6);
        $pdf->Cell(0.05);
        $pdf->SetFont("Arial", "", 8);
        $pdf->SetTextColor(100, 100, 100);
        $pdf->SetFillColor(255, 255, 255);
        $pdf->Cell(1.4, 0.6, utf8_decode($rows["cantidad"]), 0, 0, "L", true);
        $pdf->Cell(1,   0.6, "", 0, 0, "L", true);
        $pdf->Cell(2.1, 0.6, utf8_decode($rows["clave_unidad_medida"]), 0, 0, "L", true);
        $pdf->Cell(2.3, 0.6, utf8_decode($rows["clave_producto"]), 0, 0, "L", true);
        $pdf->Cell(2.1, 0.6, utf8_decode($rows["clave_sat"]), 0, 0, "L", true);
        $pdf->Cell(6,   0.6, utf8_decode(""), 0, 0, "L", true);

        $pdf->Cell(2,   0.6, "$" . number_format($rows["precio_unitario"], 2), 0, 0, "L", true);
        $pdf->Cell(2.5, 0.6, "$" . number_format($rows["precio_neto"], 2),     0, 0, "L", true);
        $pdf->Cell(-10.5);
        $pdf->MultiCell(6, 0.3, utf8_decode($rows["concepto"] . " " . $letreroIva));
    }

    $pdf->Ln(0.5);
    $pdf->Cell(0.05);
    $pdf->SetFont("Arial", "", 9);
    $pdf->SetTextColor(125, 125, 125);
    $pdf->SetFillColor(238, 238, 238);
    $pdf->Cell(19.2, 2.7, (""), 0, 0, "L", true);

    $pdf->SetFont("Arial", "", 9);
    $pdf->Ln(0.15);
    $pdf->Cell(14.5);
    $pdf->SetFont("Arial", "", 8);
    $pdf->SetTextColor(125, 125, 125);

    $subtotal = number_format(($row["total_iva"] / 1.16), 2);
    $iva      = number_format($row["total_iva"] - ($row["total_iva"] / 1.16), 2);

    $cadenaSubTotal = "$" . number_format(($subTotalFinal), 2);
    $cadenaRetencion = "$" . number_format(($subTotalFinal * .04), 2);
    $cadenaIva = "$" . number_format(($ivaFinal), 2);

    if ($retencion == "Si") {
        $total = number_format($row["total_iva"] - ($subTotalFinal * .04), 2);
        $total_letra = $row["total_iva"] - ($subTotalFinal * .04);
    } else {
        $total = number_format($row["total_iva"], 2);
        $total_letra = $row["total_iva"];
    }

    $pdf->Cell(2.5, 0.3, (utf8_decode("Subtotal:")), 0, 0, "L", false);
    $pdf->Cell(2,   0.3, $cadenaSubTotal, 0, 0, "R", false);

    $pdf->Ln(0.5);
    $pdf->Cell(14.5);
    $pdf->Cell(2.5, 0.3, (utf8_decode("Descuento:")), 0, 0, "L", false);
    $pdf->Cell(2,   0.3, (utf8_decode("$0.0")), 0, 0, "R", false);

    $pdf->Ln(0.5);
    $pdf->Cell(14.5);
    $pdf->Cell(2.5, 0.3, (utf8_decode("Subtotal Neto:")), 0, 0, "L", false);
    $pdf->Cell(2,   0.3, $cadenaSubTotal, 0, 0, "R", false);

    $pdf->Ln(0.5);
    $pdf->Cell(14.5);
    $pdf->Cell(2.5, 0.3, (utf8_decode("(+) " . $letrero0)), 0, 0, "L", false);
    $pdf->Cell(2,   0.3, $cadenaIva, 0, 0, "R", false);

    if ($retencion == "Si") {
        $pdf->Ln(0.5);
        $pdf->Cell(14.5);
        $pdf->Cell(2.5, 0.3, (utf8_decode("(-) IVA RETENIDO (4%)")), 0, 0, "L", false);
        $pdf->Cell(2,   0.3, $cadenaRetencion, 0, 0, "R", false);
    }

    $pdf->SetFont("Arial", "B", 9);
    $pdf->Ln(0.8);
    $pdf->Cell(0.1);
    $pdf->Cell(14.45, 0.5, (utf8_decode("Total con letra: ") . utf8_decode(numtoletrasEsp($total_letra, $row['id_moneda']))), 0, 0, "C", false);

    $pdf->Cell(2.2, 0.5, (utf8_decode("Total:")), 0, 0, "L", false);
    $pdf->Cell(2,   0.5, "$" . $total, 0, 0, "L", false);

    // QR SAT
    $menos_8 = substr($row["sello_cfd"], -8);
    $construye = 'https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?id=' . $row["uuid"] . '&re=' . $row["rfc"] . '&rr=' . $row["rfc_cliente"] . '&tt=' . $row["total_iva"] . '&fe=' . $menos_8;
    $contenido = $construye;

    $nombreArchivo = "factura" . $factura . ".png";
    $rutaArchivo = $directorioQR . $nombreArchivo;
    $rutaRel = "qr_fac/" . $nombreArchivo; // relativo para FPDF

    QRcode::png($contenido, $rutaArchivo);

    $pdf->Image($rutaRel, ($pdf->GetX() - 18.5), ($pdf->GetY() + .5), 3, 3);
    $pdf->Ln(0.5);
    $pdf->Cell(0.1);
    $pdf->Cell(19, 0.001, (utf8_decode("")), 1, 0, "L", false);
    $pdf->Ln(0.1);
    $pdf->SetFont("Arial", "B", 7);
    $pdf->Cell(3.5);
    $pdf->Cell(0.5, 0.3, (utf8_decode("Sello Digital del CFDI")), 0, 0, "L", false);
    $pdf->Ln(0.3);
    $pdf->Cell(3.5);
    $pdf->SetFont("Arial", "", 7);
    $pdf->MultiCell(15.7, 0.3, utf8_decode($row["sello_cfd"]));

    $pdf->Ln(0.1);
    $pdf->SetFont("Arial", "B", 7);
    $pdf->Cell(3.5);
    $pdf->Cell(0.5, 0.3, (utf8_decode("Sello del SAT")), 0, 0, "L", false);
    $pdf->Ln(0.3);
    $pdf->Cell(3.5);
    $pdf->SetFont("Arial", "", 7);
    $pdf->MultiCell(15.7, 0.3, utf8_decode($row["sello_sat"]));

    $pdf->Ln(0.1);
    $pdf->SetFont("Arial", "B", 7);
    $pdf->Cell(0.5, 0.3, (utf8_decode("Cadena Original del complemento de certificación digital del SAT")), 0, 0, "L", false);
    $pdf->Ln(0.3);
    $pdf->SetFont("Arial", "", 7);
    $pdf->MultiCell(19.2, 0.3, utf8_decode("||1.1|" . $row["uuid"] . "|" . $row["fecha_timbrado"] . "T" . $row["hora_timbrado"] . "|" . $row["rfc_cliente"] . "|" . $row["sello_cfd"] . "|" . $row["num_certificado"] . "||"));

    $pdf->Ln(0.1);
    $pdf->SetFont("Arial", "B", 7);
    $pdf->Cell(5, 0.3, (utf8_decode("No de Serie del Certificado del SAT:")), 0, 0, "L", false);
    $pdf->SetFont("Arial", "", 7);
    $pdf->Cell(5, 0.3, (utf8_decode($row["num_certificado_sat"])), 0, 0, "L", false);

    $pdf->SetFont("Arial", "B", 7);
    $pdf->Cell(5, 0.3, (utf8_decode("Fecha y hora de certificación:")), 0, 0, "L", false);
    $pdf->SetFont("Arial", "", 7);
    $pdf->Cell(5, 0.3, (utf8_decode($row["fecha_timbrado"]) . "T" . $row["hora_timbrado"]), 0, 0, "L", false);

    $pdf->Ln(0.35);
    $pdf->Cell(19, 0.001, (utf8_decode("")), 1, 0, "L", false);
    $pdf->Ln(0.35);
    $pdf->Cell(5, 0.3, (utf8_decode("Este documento es una representación impresa de un CFDI")), 0, 0, "L", false);
} // fin foreach ids

// --------------------
// Salida del PDF
// --------------------
header('Content-Type: application/pdf');
$pdf->Output();
exit;


// ----------------------------------------
// Utilidad de formato (dejada por compat)
// ----------------------------------------
function number_format_drop_zero_decimals($n, $n_decimals)
{
    return ((floor($n) == round($n, $n_decimals)) ? number_format($n) : number_format($n, $n_decimals));
}
