<?php
 include_once "adminAsistencias.php";
include_once 'notificador.php';





 function llegoTarde($horaEntrada, $horaLimite) {
  $horaLimite = date('H:i:s', strtotime('+10 minutes', strtotime($horaLimite)));

  // Convertir las horas en formato "00:00:00" a segundos
  $segundosHoraEntrada = strtotime($horaEntrada);
  $segundosHoraLimite = strtotime($horaLimite);

  // Verificar si la hora de entrada es posterior a la hora límite
  if ($segundosHoraEntrada > $segundosHoraLimite) {
      return true; // Llegó tarde
  } else {
      return false; // No llegó tarde
  }
}

function seFueTemprano($horaSalida, $horaLimite) {
  // Convertir las horas en formato "00:00:00" a segundos
  $segundosHoraSalida = strtotime($horaSalida);
  $segundosHoraLimite = strtotime($horaLimite);

  // Verificar si la hora de salida es anterior a la hora límite
  if ($segundosHoraSalida < $segundosHoraLimite) {
      return true; // Se fue temprano
  } else {
      return false; // No se fue temprano
  }
}


function diferenciaHorasEnMinutos($hora1, $hora2) {
  // Convertir las horas a timestamps
  $timestampHora1 = strtotime($hora1);
  $timestampHora2 = strtotime($hora2);

  // Calcular la diferencia en segundos
  $diferenciaSegundos = abs($timestampHora2 - $timestampHora1);

  // Convertir la diferencia de segundos a minutos
  $diferenciaMinutos = $diferenciaSegundos / 60;

  return $diferenciaMinutos;
}


function obtenerDiaSemana($fecha) {
  // Convertir la fecha a timestamp
  $timestamp = strtotime($fecha);
  
  // Obtener el día de la semana como número (0 para domingo, 1 para lunes, etc.)
  $numero_dia = date("w", $timestamp);
  
  // Definir un arreglo con los nombres de los días de la semana
  $dias_semana = array("Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado");
  
  // Obtener el nombre del día de la semana usando el número obtenido
  $nombre_dia = $dias_semana[$numero_dia];
  
  return $nombre_dia;
}

 function formatearFecha($fecha)
 {
     $fecha = explode(" ", $fecha);


     $fecha = $fecha[0];

     $fecha = explode("-", $fecha);
     $mes = $fecha[1];
     switch ($mes) {
         case 1:
             $mes = "Enero";
             break;
         case 2:
             $mes = "Febrero";
             break;
         case 3:
             $mes = "Marzo";
             break;
         case 4:
             $mes = "Abril";
             break;
         case 5:
             $mes = "Mayo";
             break;
         case 6:
             $mes = "Junio";
             break;

         case 7:
             $mes = "Julio";
             break;
         case 8:
             $mes = "Agosto";
             break;
         case 9:
             $mes = "Septiembre";
             break;
         case 10:
             $mes = "Octubre";
             break;
         case 11:
             $mes = "Noviembre";
             break;
         case 12:
             $mes = "Diciembre";
             break;
     }
     $fecha = $fecha[2] . "/" . $mes . "/" . $fecha[0];
     return $fecha;
 }




 function generaReporte(){
  $adminAsistencias = new AdministradorChecador();
  $asistencias = $adminAsistencias->dameAsistenciasUltimaSemana();
  $reporte = '
  
  
<table id="tableStripe" class="table-striped" border="1px">

<thead>
  <th>Día</th>
  <th>Fecha</th>
  <th>Empleado</th>
  <th>Entro</th>
  <th>Entrada</th>
  <th>Salio</th>
  <th>Salida</th>

</thead>
<tbody>
';

  foreach ($asistencias as $asistencia) {

    $nota = '';
    $minutosTarde = 0;
    $minutosAntes = 0;
    $minutosExtras = 0;
    if($asistencia->salida == 'Sin Salida'){
      $nota .= 'No marco salida';
    }
    else{
      if(seFueTemprano($asistencia->salida, $asistencia->salidaO)){
        $minutosAntes = diferenciaHorasEnMinutos($asistencia->salida, $asistencia->salidaO);
        $nota .= ' Se fue temprano ' . number_format($minutosAntes, 0)  . ' minutos antes ';
      }
      else{
        $minutosExtras += diferenciaHorasEnMinutos($asistencia->salida, $asistencia->salidaO);
      }
    }

    if(llegoTarde($asistencia->entrada, $asistencia->entradaO)){
      $minutosTarde  = diferenciaHorasEnMinutos($asistencia->entrada, $asistencia->entradaO);
      $nota .= ' Llego tarde ' . number_format($minutosTarde, 0)  . " minutos ";

    }
    else{
      $minutosExtras += diferenciaHorasEnMinutos($asistencia->entrada, $asistencia->entradaO);
    }


    if($nota != ''){
      if($asistencia->fecha == date('Y-m-d')){
        $adminAsistencias->agregaIncidencias($asistencia->empleado, $asistencia->entrada, date('Y-m-d'), $nota, 'NA');
      }
      $reporte .='
      <tr>
  
      <td>'.obtenerDiaSemana($asistencia->fecha).'</td>

        <td>'.formatearFecha($asistencia->fecha).'</td>
        <td>'.$asistencia->nombreEmpleado.'</td>
        <td>'.$asistencia->entrada.'</td>
        <td>'.$asistencia->entradaO.'</td>
        <td>'.$asistencia->salida.'</td>
        <td>'.$asistencia->salidaO.'</td>
  
      </tr>
  
    ';
    }


  }

  $reporte .= '
</table>
  
  
  
  ';


  return $reporte;
 
}




echo generaReporte();
//mailerNot('iohanes@gmail.com', 'Asistencias', 'Asistencias del a semana', generaReporte(), '', '', '');
?>





