<?php
include_once "adminFacturasSEC.php";
include_once "adminClavesCortas.php";
include_once "adminEmpresas.php";
$adminFacturas = new AdministradorFacturas();
$adminEmpresas = new AdminEmpresas();
$adminClavesCortas = new AdministradorClavesCortas();
$facturas = $adminFacturas->dameFacturasSinEx();
$conector = new conectorS14();
echo "<h1>Facturas sin EX</h1>";
if (empty($facturas)) {
    echo "No hay facturas sin EX.";
} else {
    echo "Total de facturas sin EX: " . count($facturas) . "<br>";
}

?>


<table>

    <thead>
        <tr>
            <th>Empresa emite</th>
            <th>Empresa recibe</th>
            <th>Correo emite</th>
            <th>Correo Recibe</th>
            <th>Template usado</th>
            <th>Fecha envía</th>
            <th>Fecha recibe</th>
        </tr>
    </thead>


    <?php
    $hoy = date('Y-m-d H:i:s');
    $dia = date('d');
    $mes = date('m');
    $anio = date('Y');
    foreach ($facturas as $factura) {

        $empresaEmite = $adminEmpresas->dameEmpresaLite($factura->razon);
        $claveCorta = $adminClavesCortas->dameClaveCorta($factura->id_clave_corta);
        $empresaRecive = $adminEmpresas->dameEmpresaRfcLite($claveCorta->rfc);
        $horaEnvio = sumarTiempo($hoy);
        $horaRecibe = sumarTiempo($horaEnvio);
        $fila = damePlantilla();
        $plantilla = $fila['template'];
        $respuesta = $fila['respuesta'];
        //Solicito factura del depósito por %%%%% realizado el día //////.
        $plantilla = str_replace("%%%%%", "$" . number_format($factura->total_iva, 2), $plantilla);
        $plantilla = str_replace("//////", formateaFecha($factura->fecha), $plantilla);
        $plantilla = str_replace("DD", $dia, $plantilla);
        $plantilla = str_replace("MM", $mes, $plantilla);
        $plantilla = str_replace("AAAA", $anio, $plantilla);

        $respuesta = str_replace("%%%%%", "$" . number_format($factura->total_iva, 2), $respuesta);
        $respuesta = str_replace("//////", formateaFecha($factura->fecha), $respuesta);
        $respuesta = str_replace("DD", $dia, $respuesta);
        $respuesta = str_replace("MM", $mes, $respuesta);
        $respuesta = str_replace("AAAA", $anio, $respuesta);
        echo "<tr>";
        echo "<td>" . $empresaEmite->razon . "</td>";
        echo "<td>" . $empresaRecive->razon . "</td>";
        echo "<td>" . $empresaEmite->correo_conta . "</td>";
        echo "<td>" . $empresaRecive->correo_conta . "</td>";
        echo "<td>" . $plantilla . "</td>";
        echo "<td>" . $respuesta . "</td>";
        echo "<td>" . $horaEnvio . "</td>";
        echo "<td>" . $horaRecibe . "</td>";
        echo "</tr>";
        if ($plantilla == "No se pudo obtener la plantilla.") {
            echo "No se pudo obtener la plantilla, no se enviará el correo.";
            continue;
        }
        //SELECT id, correo_origen, correo_destino, tamplate, empresa_origen, empresa_destino, fecha_inserta, fecha_envia, fecha_recibe, estado, monto FROM iohanes_14.facturas_correo;
        $query = "INSERT INTO facturas_correo (correo_origen, correo_destino, tamplate, empresa_origen, empresa_destino, fecha_inserta, fecha_envia, fecha_recibe, estado, monto, respuesta) 
                  VALUES ('{$empresaEmite->correo_conta}', '{$empresaRecive->correo_conta}', '$plantilla', '{$empresaEmite->id}', '{$empresaRecive->id}', '$hoy', '$horaEnvio', '$horaRecibe', '0', {$factura->total_iva}, '$respuesta')";
        $resultado = $conector->ejecutar($query);
        $adminFacturas->marcarFacturaEx($factura->id, 1);
    }


    function generaTiempo()
    {
        //retorna una cantidad de segundos entre 10 minutos y 24 horas 
        $minutos = rand(10, 1440); // 10 minutos a 24 horas
        $segundos = $minutos * 60; // convertir minutos a segundos  
        return $segundos;
    }

    function horaAleatoria()
    {
        $dias = rand(1, 3);
        $hora = rand(9, 17);
        $minuto = rand(0, 59);
        $segundo = rand(0, 59);
        return date('Y-m-d H:i:s', strtotime("+$dias days $hora:$minuto:$segundo"));
    }

    function damePlantilla()
    {
        $conector = new conectorS14();
        //seleccionar la primera plantilla que se encuentre en la tabla templates_correo
        $query = "SELECT * FROM templates_correo LIMIT 1"; // Asumiendo que quieres la primera plantilla
        $resultado = $conector->ejecutar($query);
        if ($resultado) {
            $fila = mysqli_fetch_array($resultado);
            //elimina la pantilla usada 
            $deleteQuery = "DELETE FROM templates_correo WHERE id = " . $fila['id'];
            $conector->ejecutar($deleteQuery);
            return $fila; // Asumiendo que el contenido de la plantilla está en la columna 'contenido'

        } else {
            return "No se pudo obtener la plantilla.";
        }
        return "Plantilla de prueba";
    }

    

    function sumarTiempo($fecha)
{
    $inicio = strtotime($fecha);
    // Entre 20 minutos (1200 s) y 3 días (259200 s)
    $suma = mt_rand(1200, 259200);
    $nueva = $inicio + $suma;

    // Saltar fines de semana si cae en sábado (6) o domingo (7)
    while (in_array((int) date('N', $nueva), array(6, 7))) {
        $nueva = strtotime('+1 day', $nueva);
    }

    // Obtener hora actual del resultado
    $hora = (int) date('H', $nueva);

    // Si está fuera del rango laboral, ajustar al horario permitido
    if ($hora < 9 || $hora > 17) {
        // Si pasa de las 17:59 → siguiente día hábil
        if ($hora > 17) {
            $nueva = strtotime('+1 day', $nueva);
            while (in_array((int) date('N', $nueva), array(6, 7))) {
                $nueva = strtotime('+1 day', $nueva);
            }
        }
        // Asignar hora y minutos aleatorios dentro del horario laboral
        $horaRandom = mt_rand(9, 17);
        $minutoRandom = mt_rand(0, 59);
        $segundoRandom = mt_rand(0, 59);
        $nueva = strtotime(date('Y-m-d', $nueva) . ' ' . sprintf('%02d:%02d:%02d', $horaRandom, $minutoRandom, $segundoRandom));
    }

    return date('Y-m-d H:i:s', $nueva);
}




    function formateaFecha($fecha)
    {
        $fechaExplode = explode("-", $fecha);
        $dia = $fechaExplode[2];
        $mes = $fechaExplode[1];
        $anio = $fechaExplode[0];
        switch ($mes) {
            case '01':
                $mes = 'Enero';
                break;
            case '02':
                $mes = 'Febrero';
                break;
            case '03':
                $mes = 'Marzo';
                break;
            case '04':
                $mes = 'Abril';
                break;
            case '05':
                $mes = 'Mayo';
                break;
            case '06':
                $mes = 'Junio';
                break;
            case '07':
                $mes = 'Julio';
                break;
            case '08':
                $mes = 'Agosto';
                break;
            case '09':
                $mes = 'Septiembre';
                break;
            case '10':
                $mes = 'Octubre';
                break;
            case '11':
                $mes = 'Noviembre';
                break;
            case '12':
                $mes = 'Diciembre';
                break;
        }
        return "$dia de $mes del $anio";
    }


    ?>

</table>