<?php

include_once('../../../conectorBDS14.php');
class TipoCambio
{
  public $id;
  public $fecha;
  public $hora;
  public $tipo_cambio;

  function __construct($id, $fecha, $hora, $tipo_cambio)
  {
    $this->id = $id;
    $this->fecha = $fecha;
    $this->hora = $hora;
    $this->tipo_cambio = $tipo_cambio;
  }
}

class EstadisticasUsoStp
{
  public $semana;
  public $conteoEn;
  public $conteoWk;
  public $conteoZa;
  public $conteoTo;
}

class ClienteUtil
{
  public $nombre;
  public $id;

  public function __construct($nombre, $id)
  {
    $this->nombre = $nombre;
    $this->id = $id;
  }
}

class CuentasUtil
{
  public $id;
  public $nombre_corto;

  public function __construct($id, $nombre_corto)
  {
    $this->id = $id;
    $this->nombre_corto = $nombre_corto;
  }
}

class EstadCliente
{
  public $id;
  public $nombre;
  public $aportacion;

  public function __construct($id, $nombre, $aportacion)
  {
    $this->id = $id;
    $this->nombre = $nombre;
    $this->aportacion = $aportacion;
  }
}

class EstadTiempo
{
  public $anio;
  public $mes;
  public $aportacion;
  public $cadena;

  public function __construct($anio, $mes, $aportacion)
  {
    $this->anio = $anio;
    $this->mes = $mes;
    $this->aportacion = $aportacion;
  }
}

class EstadisticaDia
{
  public $dia;
  public $monto;

  public function __construct($dia, $monto)
  {
    $this->dia = $dia;
    $this->monto = $monto;
  }
}


class CatalogoBancoStp
{
  public $id;
  public $cve_id;
  public $nombre_corto;
  public $razon_social_completa;
  public $cve_banxico;

  public function __construct($id, $cve_id, $nombre_corto, $razon_social_completa, $cve_banxico)
  {
    $this->id = $id;
    $this->cve_id = $cve_id;
    $this->nombre_corto = $nombre_corto;
    $this->razon_social_completa = $razon_social_completa;
    $this->cve_banxico = $cve_banxico;
  }
}

class Diferencias
{
  public $id;
  public $monto;
  public $fecha;
  public $mensaje;

  public function __construct($id, $monto, $fecha, $mensaje)
  {
    $this->id = $id;
    $this->monto = $monto;
    $this->fecha = $fecha;
    $this->mensaje = $mensaje;
  }
}

class EstadisticaFactura
{
  public $semana;
  public $facturasManuales;
  public $facturasAutomaticas;
}


class TimbresReporte
{
  public $id;
  public $id_factura;
  public $uuid;
  public $usuario_timbro;
  public $fecha_timbrado;
  public $conteo;
}

class FacturasCorreo{
  //SELECT id, correo_origen, correo_destino, tamplate, empresa_origen, empresa_destino, fecha_inserta, fecha_envia, fecha_recibe, estado, monto, respuesta
  public $id;
  public $correo_origen;
  public $correo_destino;
  public $tamplate;
  public $empresa_origen;
  public $empresa_destino;
  public $fecha_inserta;
  public $fecha_envia;
  public $fecha_recibe;
  public $estado;
  public $monto;
  public $respuesta;
  public $nombre_empresa_origen;
  public $nombre_empresa_destino;

  public function __construct($id, $correo_origen, $correo_destino, $tamplate, $empresa_origen, $empresa_destino, $fecha_inserta, $fecha_envia, $fecha_recibe, $estado, $monto, $respuesta)
  {
    $this->id = $id;
    $this->correo_origen = $correo_origen;
    $this->correo_destino = $correo_destino;
    $this->tamplate = $tamplate;
    $this->empresa_origen = $empresa_origen;
    $this->empresa_destino = $empresa_destino;
    $this->fecha_inserta = $fecha_inserta;
    $this->fecha_envia = $fecha_envia;
    $this->fecha_recibe = $fecha_recibe;
    $this->estado = $estado;
    $this->monto = $monto;
    $this->respuesta = $respuesta;
  }
}


//SELECT id, id_empresa, id_proveedor, correo_origen, correo_destino, mensaje, fecha_entrega, fecha_respuesta FROM iohanes_14.contexto_correo;

class ContextoCorreo{
  public $id;
  public $id_empresa;
  public $id_proveedor;
  public $correo_origen;
  public $correo_destino;
  public $mensaje;
  public $fecha_entrega;
  public $fecha_respuesta;
  public $nombreEmpresa;
  public $nombreEmpresaCorta;
  public $estado;

  public function __construct($id, $id_empresa, $id_proveedor, $correo_origen, $correo_destino, $mensaje, $fecha_entrega, $fecha_respuesta)
  {
    $this->id = $id;
    $this->id_empresa = $id_empresa;
    $this->id_proveedor = $id_proveedor;
    $this->correo_origen = $correo_origen;
    $this->correo_destino = $correo_destino;
    $this->mensaje = $mensaje;
    $this->fecha_entrega = $fecha_entrega;
    $this->fecha_respuesta = $fecha_respuesta;
  }
}

class AdministradorUtil extends conectorS14
{


  public function dameContextoCorreo()
  {
    $sql = "
    SELECT  contexto_correo.*, empresas.razon as nombreEmpresa, claves_cortas.razon_social as nombreEmpresaCorta
    FROM iohanes_14.contexto_correo
    inner join empresas on empresas.id = contexto_correo.id_proveedor
    inner join claves_cortas on claves_cortas.id = contexto_correo.id_empresa
    ";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new ContextoCorreo(
        $row['id'],
        $row['id_empresa'],
        $row['id_proveedor'],
        $row['correo_origen'],
        $row['correo_destino'],
        $row['mensaje'],
        $row['fecha_entrega'],
        $row['fecha_respuesta']
      );
      $item->nombreEmpresa = $row['nombreEmpresa'];
      $item->nombreEmpresaCorta = $row['nombreEmpresaCorta'];
      $items[] = $item;
    } 
    return $items;
  }

  public function dameContextoCorreoSinEnviar(){
    $sql = "
    SELECT  contexto_correo.*, empresas.razon as nombreEmpresa, claves_cortas.razon_social as nombreEmpresaCorta
    FROM iohanes_14.contexto_correo
    inner join empresas on empresas.id = contexto_correo.id_proveedor
    inner join claves_cortas on claves_cortas.id = contexto_correo.id_empresa
    WHERE contexto_correo.estado = 0
    ";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new ContextoCorreo(
        $row['id'],
        $row['id_empresa'],
        $row['id_proveedor'],
        $row['correo_origen'],
        $row['correo_destino'],
        $row['mensaje'],
        $row['fecha_entrega'],
        $row['fecha_respuesta']
      );
      $item->nombreEmpresa = $row['nombreEmpresa'];
      $item->nombreEmpresaCorta = $row['nombreEmpresaCorta'];
      $items[] = $item;
    }
    return $items;
  }

  public function dameContextoSinReenvio(){
    $sql = "
    SELECT  contexto_correo.*, empresas.razon as nombreEmpresa, claves_cortas.razon_social as nombreEmpresaCorta
    FROM iohanes_14.contexto_correo
    inner join empresas on empresas.id = contexto_correo.id_proveedor
    inner join claves_cortas on claves_cortas.id = contexto_correo.id_empresa
    WHERE contexto_correo.estado = 1
    ";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new ContextoCorreo(
        $row['id'],
        $row['id_empresa'],
        $row['id_proveedor'],
        $row['correo_origen'],
        $row['correo_destino'],
        $row['mensaje'],
        $row['fecha_entrega'],
        $row['fecha_respuesta']
      );
      $item->nombreEmpresa = $row['nombreEmpresa'];
      $item->nombreEmpresaCorta = $row['nombreEmpresaCorta'];
      $items[] = $item;
    }
    return $items;
  }

  public function marcarContextoEnviado($id, $estado){
    $sql = "
    UPDATE iohanes_14.contexto_correo
    SET estado = $estado
    WHERE id = $id
    ";
    $this->ejecutar($sql);
  }

  public function dameReporteTimbres()
  {
    $sql = "
    
    select lt.id, mensaje, uuid, u.nombre as  usuario_timbro, fecha, id_factura, COUNT(id_factura) as conteo  from log_timbrado lt 
inner join usuarios u 
on u.id = lt.usuario_timbro 
group by id_factura 
order by conteo desc
       
   
    ";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new TimbresReporte();
      $item->id = $row['id'];
      $item->id_factura = $row['id_factura'];
      $item->uuid = $row['uuid'];
      $item->usuario_timbro = $row['usuario_timbro'];
      $item->fecha_timbrado = $row['fecha'];
      $item->conteo = $row['conteo'];

      $items[] = $item;
    }
    return $items;
  }

  public function dameFacturasCorreos(){
    $sql = "SELECT fc.*, empresas.razon as razon, e2.razon as razon2 FROM facturas_correo fc
    inner join empresas on empresas.id = fc.empresa_origen
    inner join empresas as e2 on e2.id = fc.empresa_destino
    order by fc.id desc";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new FacturasCorreo(
        $row['id'],
        $row['correo_origen'],
        $row['correo_destino'],
        $row['tamplate'],
        $row['empresa_origen'],
        $row['empresa_destino'],
        $row['fecha_inserta'],
        $row['fecha_envia'],
        $row['fecha_recibe'],
        $row['estado'],
        $row['monto'],
        $row['respuesta']
      );
      $item->nombre_empresa_origen = $row['razon'];
      $item->nombre_empresa_destino = $row['razon2'];
      $items[] = $item;
    }
    return $items;
  }


  public function dameEstadisticasFacturas()
  {
    $sql = "
    SELECT 
    WEEK(fecha) AS semana,
    SUM(CASE WHEN usuario_crea IS NOT NULL THEN 1 ELSE 0 END) AS manuales,
    SUM(CASE WHEN usuario_crea IS NULL THEN 1 ELSE 0 END) AS automaticas
FROM 
    facturas
WHERE 
    fecha >= '2024-01-01'
GROUP BY 
    WEEK(fecha)
ORDER BY 
    WEEK(fecha);
    ";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new EstadisticaFactura();
      $item->semana =  $row['semana'];
      $item->facturasManuales =  number_format($row['manuales'], 2, ".", "");
      $item->facturasAutomaticas = number_format($row['automaticas'], 2, ".", "");
      $items[] = $item;
    }
    return $items;
  }



  public function dameEstadisticasEntradasStpMontos()
  {
    $sql = "
    SELECT 
    WEEK(fecha) AS semana,
    SUM(CASE WHEN cuenta = 117 and deposito > 0 THEN deposito ELSE 0 END) AS suma_montos_EN,
    SUM(CASE WHEN cuenta = 114 and deposito > 0 THEN deposito ELSE 0 END) AS suma_montos_WK,
    SUM(CASE WHEN cuenta = 127 and deposito > 0 THEN deposito ELSE 0 END) AS suma_montos_ZA,
    SUM(CASE WHEN cuenta = 130 and deposito > 0 THEN deposito ELSE 0 END) AS suma_montos_TO
    
FROM 
    captura_edo_cta
WHERE 
    fecha >= '2024-01-01'
GROUP BY 
    WEEK(fecha)
ORDER BY 
    WEEK(fecha);
    ";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new EstadisticasUsoStp();
      $item->semana =  $row['semana'];
      $item->conteoEn =  number_format($row['suma_montos_EN'], 2, ".", "");
      $item->conteoWk = number_format($row['suma_montos_WK'], 2, ".", "");
      $item->conteoZa = number_format($row['suma_montos_ZA'], 2, ".", "");
      $item->conteoTo = number_format($row['suma_montos_TO'], 2, ".", "");
      $items[] = $item;
    }
    return $items;
  }



  public function dameEstadisticasStpMontos()
  {
    $sql = "
    SELECT 
    WEEK(fecha_creacion) AS semana,
    SUM(CASE WHEN folio LIKE '%EN%' THEN monto ELSE 0 END) AS suma_montos_EN,
    SUM(CASE WHEN folio LIKE '%WK%' THEN monto ELSE 0 END) AS suma_montos_WK,
     SUM(CASE WHEN folio LIKE '%ZA%' THEN monto ELSE 0 END) AS suma_montos_ZA,
      SUM(CASE WHEN folio LIKE '%TO%' THEN monto ELSE 0 END) AS suma_montos_TO
FROM 
    pre_ejecuta_plantilla
WHERE 
    fecha_creacion >= '2024-01-01'
GROUP BY 
    WEEK(fecha_creacion)
ORDER BY 
    WEEK(fecha_creacion);
    ";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new EstadisticasUsoStp();
      $item->semana =  $row['semana'];
      $item->conteoEn =  number_format($row['suma_montos_EN'], 2, ".", "");
      $item->conteoWk = number_format($row['suma_montos_WK'], 2, ".", "");
      $item->conteoZa = number_format($row['suma_montos_ZA'], 2, ".", "");
      $item->conteoTo = number_format($row['suma_montos_TO'], 2, ".", "");
      $items[] = $item;
    }
    return $items;
  }


  public function dameEstadisticasEntradasStp()
  {
    $sql = "
    SELECT WEEK(fecha) AS semana, 
    SUM(IF(cuenta = 117, 1, 0)) AS movimientos_con_EN, 
    SUM(IF(cuenta = 114, 1, 0)) AS movimientos_con_WK,
    SUM(IF(cuenta = 127, 1, 0)) AS movimientos_con_ZA,
    SUM(IF(cuenta = 130, 1, 0)) AS movimientos_con_TO
    FROM captura_edo_cta 
    WHERE fecha >= '2024-01-01' 
    GROUP BY WEEK(fecha) 
    ORDER BY WEEK(fecha);
    ";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new EstadisticasUsoStp();
      $item->semana =  $row['semana'];
      $item->conteoEn =  $row['movimientos_con_EN'];
      $item->conteoWk =  $row['movimientos_con_WK'];
      $item->conteoZa =  $row['movimientos_con_ZA'];
      $item->conteoTo =  $row['movimientos_con_TO'];
      $items[] = $item;
    }
    return $items;
  }

  public function dameEstadisticasStp()
  {
    $sql = "SELECT WEEK(fecha_creacion) AS semana, SUM(IF(folio LIKE '%EN%', 1, 0)) AS movimientos_con_EN,  SUM(IF(folio LIKE '%ZA%', 1, 0)) AS movimientos_con_ZA,  SUM(IF(folio LIKE '%TO%', 1, 0)) AS movimientos_con_TO, SUM(IF(folio LIKE '%WK%', 1, 0)) AS movimientos_con_WK FROM pre_ejecuta_plantilla WHERE fecha_creacion >= '2024-01-01' GROUP BY WEEK(fecha_creacion) ORDER BY WEEK(fecha_creacion);";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new EstadisticasUsoStp();
      $item->semana =  $row['semana'];
      $item->conteoEn =  $row['movimientos_con_EN'];
      $item->conteoWk =  $row['movimientos_con_WK'];
      $item->conteoZa =  $row['movimientos_con_ZA'];
      $item->conteoTo =  $row['movimientos_con_TO'];
      $items[] = $item;
    }
    return $items;
  }

  public function dameUltimaDiferencia()
  {
    $sql = "SELECT * FROM `diferencias_detectadas` order by id desc limit 1";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $diferencia = new Diferencias($fila['id'], $fila['monto'], $fila['fecha'], $fila['mensaje']);
    }
    return $diferencia;
  }

  public function dameDiferencias()
  {
    $sql = "SELECT * FROM `diferencias_detectadas` order by id desc";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($fila = mysqli_fetch_array($result)) {
      $items[] = new Diferencias($fila['id'], $fila['monto'], $fila['fecha'], $fila['mensaje']);
    }
    return $items;
  }

  public function dameCatalogoBancos()
  {
    $sql = "SELECT * FROM `stp_cat_bancos`";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = new CatalogoBancoStp($row['id'], $row['cve_id'], $row['nombre_corto'], $row['razon_social_completa'], $row['cve_banxico']);
    }
    return $items;
  }

  public function dameEstadisticasDia($fechaInicia, $fechaFin)
  {
    $sql = "SELECT fecha_banco, sum(saldo_acreditable) FROM `pagos`  where tipo_movimiento = 'Abono por comisión' 
    and fecha_captura <= '$fechaFin' and fecha_captura >= '$fechaInicia'
    group by fecha_banco
    ORDER BY `pagos`.`id` DESC limit 100;";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = new EstadisticaDia($row['fecha_banco'], $row['sum(saldo_acreditable)']);
    }
    return $items;
  }


  public function dameUltimoTipoCambio()
  {
    $sql = 'SELECT * FROM tipo_cambio order by id desc LIMIT 1';
    $result = $this->ejecutar($sql);
    $tipo_cambio = array();
    while ($fila = mysqli_fetch_array($result)) {
      $tipo_cambio = new TipoCambio($fila['id'], $fila['fecha'], $fila['hora'], $fila['tipo_cambio']);
    }
    return $tipo_cambio;
  }

  public function dameEstadisticaXClienteXFecha($fechaInicio, $fechaFin, $cliente)
  {
    $sql = "SELECT 
            YEAR(pagos.fecha_asignacion) AS anio,
            MONTH(pagos.fecha_asignacion) AS mes,
            sum(pagos.saldo_acreditable) as aportacion 
        FROM 
            pagos 
            LEFT JOIN clientes ON pagos.cliente_origen_comision = clientes.id
        WHERE 
            clientes.id = $cliente 
            AND pagos.nombre = '1' 
            AND pagos.tipo_movimiento = 'Abono por comisión' 
            AND pagos.fecha_asignacion < '$fechaFin' 
            AND pagos.fecha_asignacion > '$fechaInicio' 
        GROUP BY 
            YEAR(pagos.fecha_asignacion), MONTH(pagos.fecha_asignacion)
        ORDER BY 
            anio ASC, mes ASC;";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = $row;
    }
    return $items;
  }

  public function dameEstadisticaXClienteXFechaFac($fechaInicio, $fechaFin, $cliente)
  {
    $sql = "SELECT 
            YEAR(pagos.fecha_asignacion) AS anio,
            MONTH(pagos.fecha_asignacion) AS mes,
            sum(pagos.monto) as aportacion 
        FROM 
            pagos 
            LEFT JOIN clientes ON pagos.nombre = clientes.id
        WHERE 
            clientes.id = $cliente 
            AND pagos.tipo_movimiento = 'Deposito' 
            AND pagos.fecha_asignacion <= '$fechaFin' 
            AND pagos.fecha_asignacion >= '$fechaInicio' 
        GROUP BY 
            YEAR(pagos.fecha_asignacion), MONTH(pagos.fecha_asignacion)
        ORDER BY 
            anio ASC, mes ASC;";
    //echo $sql;
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = $row;
    }
    return $items;
  }




  public function dameEstadisticaFactura($fechaInicio, $fechaFin, $cliente)
  {
    $sql = "SELECT 
            YEAR(facturas.fecha) AS anio,
            MONTH(facturas.fecha) AS mes,
            sum(facturas.fecha) as aportacion 
        FROM 
            facturas 
            LEFT JOIN clientes ON facturas.nombre = clientes.id
        WHERE 
            clientes.id = $cliente 
            AND facturas.fecha < '$fechaFin' 
            AND facturas.fecha > '$fechaInicio' 
        GROUP BY 
            YEAR(facturas.fecha), MONTH(facturas.fecha)
        ORDER BY 
            anio ASC, mes ASC;";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = $row;
    }
    return $items;
  }

  public function dameEstadisticasClienteFecha($fechaInicio, $fechaFin)
  {
    $sql = "SELECT clientes.id, clientes.nombre, sum(saldo_acreditable) as aportacion FROM pagos 
    LEFT join clientes on pagos.cliente_origen_comision = clientes.id
    WHERE pagos.nombre = '1' and pagos.tipo_movimiento = 'Abono por comisión' and pagos.fecha_asignacion <= '$fechaFin' and pagos.fecha_asignacion >= '$fechaInicio' 
    GROUP BY clientes.id
    order by aportacion desc;";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = new EstadCliente($row['id'], $row['nombre'], $row['aportacion']);
    }
    return $items;
  }

  public function dameEstadisticasCliente()
  {
    $sql = "SELECT clientes.id, clientes.nombre, sum(saldo_acreditable) as aportacion FROM pagos 
    LEFT join clientes on pagos.cliente_origen_comision = clientes.id
    WHERE pagos.nombre = '1' and pagos.tipo_movimiento = 'Abono por comisión'
    GROUP BY clientes.id
    order by aportacion desc;";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = new EstadCliente($row['id'], $row['nombre'], $row['aportacion']);
    }
    return $items;
  }


  function limpiaCadena($cadena)
  {
    str_replace("'", "", $cadena);
    str_replace('"', "", $cadena);
    str_replace(';', "", $cadena);
    str_replace(',', "", $cadena);
    str_replace('.', "", $cadena);
    str_replace('(', "", $cadena);
    str_replace(')', "", $cadena);
    str_replace('=', "", $cadena);
    str_replace('?', "", $cadena);
    str_replace('¿', "", $cadena);
    str_replace('!', "", $cadena);
    str_replace('¡', "", $cadena);
    str_replace(':', "", $cadena);
    str_replace('#', "", $cadena);
    str_replace('*', "", $cadena);
    str_replace('+', "", $cadena);
    str_replace('-', "", $cadena);
    str_replace('_', "", $cadena);
    str_replace('Ã³', "o", $cadena);
    str_replace('Ã¡', "a", $cadena);
    str_replace('Ã©', "e", $cadena);
    str_replace('Ã­', "i", $cadena);
    str_replace('Ãº', "u", $cadena);
    str_replace('Ã±', "n", $cadena);
    str_replace('Ã', "A", $cadena);
    str_replace('Ã‰', "E", $cadena);
    str_replace('Ã', "I", $cadena);
    str_replace('Ã“', "O", $cadena);
    str_replace('Ãš', "U", $cadena);
    str_replace('Ã‘', "N", $cadena);
    str_replace('Ã¼', "u", $cadena);
    str_replace('Ãœ', "U", $cadena);
    str_replace('Â¿', "", $cadena);
    str_replace('Â¡', "", $cadena);
    str_replace('Â¨', "", $cadena);
    str_replace('ó', "o", $cadena);
    str_replace('á', "a", $cadena);
    str_replace('é', "e", $cadena);
    str_replace('í', "i", $cadena);
    str_replace('ú', "u", $cadena);
    str_replace('ñ', "n", $cadena);
    str_replace('Á', "A", $cadena);
    str_replace('É', "E", $cadena);
    str_replace('Í', "I", $cadena);
    str_replace('Ó', "O", $cadena);
    str_replace('Ú', "U", $cadena);
    str_replace('Ñ', "N", $cadena);
    str_replace('ü', "u", $cadena);
    str_replace('Ü', "U", $cadena);
    //limpia saldo de linea 
    str_replace("\n", "", $cadena);
    str_replace("\r", "", $cadena);
    str_replace("\t", "", $cadena);
    str_replace("\v", "", $cadena);
    str_replace("\f", "", $cadena);
    str_replace("\0", "", $cadena);
    str_replace("\x0B", "", $cadena);



    //acorta la cadena a 20 caracteres
    //$cadena = substr($cadena, 0, 20);

    return $cadena;
  }

  public function dameReporteGastos($fechaInicio, $fechaFin, $cliente)
  {
    $sql = "
    SELECT
    sum(saldo_acreditable) AS saldo,
    descripcion,
    detalle
  FROM pagos
  WHERE
    pagos.fecha_asignacion <= '$fechaFin'
    AND pagos.fecha_asignacion >= '$fechaInicio'
    AND pagos.nombre = $cliente
    AND saldo_acreditable < 0
  GROUP BY descripcion, detalle;
    ";
    echo $sql;
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new EstadTiempo(1, 1, $row['saldo']);
      $item->cadena = utf8_decode($this->limpiaCadena($row['descripcion'] . $row['detalle']));
      $items[] = $item;
    }
    return $items;
  }


  public function dameReporteCliente($fechaInicio, $fechaFin, $cliente)
  {
    $sql = "SELECT
    YEAR(fecha_asignacion) AS anio,
    MONTH(fecha_asignacion) AS mes,
    sum(saldo_acreditable) AS aportacion
  FROM pagos
  WHERE
    pagos.nombre = '1'
    AND pagos.tipo_movimiento = 'Abono por comisión'
    AND pagos.fecha_asignacion < '$fechaFin'
    AND pagos.fecha_asignacion > '$fechaInicio'
    AND pagos.cliente_origen_comision = $cliente
  GROUP BY anio, mes;";
    echo $sql;
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = new EstadTiempo($row['anio'], $row['mes'], $row['aportacion']);
    }
    return $items;
  }

  public function dameUltimos5TiposCambio()
  {
    $sql = 'SELECT * FROM tipo_cambio order by id desc LIMIT 5';
    $result = $this->ejecutar($sql);
    $tipo_cambio = array();
    while ($fila = mysqli_fetch_array($result)) {
      $tipo_cambio[] = new TipoCambio($fila['id'], $fila['fecha'], $fila['hora'], $fila['tipo_cambio']);
    }
    return $tipo_cambio;
  }

  public function dameNombreClientePrincipal()
  {
    $sql = 'SELECT nombre from clientes where id=1';
    $result = $this->ejecutar($sql);

    while ($fila = mysqli_fetch_array($result)) {
      $empresa = $fila['nombre'];
    }
    return $empresa;
  }

  public function dameSaldoAcreditableClientePrincipal()
  {
    $sql = 'SELECT sum(saldo_acreditable) as suma from pagos where nombre=1';
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $suma = $fila['suma'];
    }
    return $suma;
  }

  public function dameMontoEnFila()
  {
    $sql = "select sum(monto) as suma from pre_ejecuta_plantilla where status = 'EJECUTADO' and folio like '10H14DEL%' and estado IS NULL and id_stp IS NOT NULL and fecha_creacion > '2023-11-00' ORDER BY `id` DESC;";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['suma'];
  }

  public function dameMontoEnFilaZac()
  {
    $sql = "select sum(monto) as suma from pre_ejecuta_plantilla where status = 'EJECUTADO' and folio like '10H14ZAC%' and estado IS NULL and id_stp IS NOT NULL and fecha_creacion > '2023-11-00' ORDER BY `id` DESC;";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['suma'];
  }

  public function dameMontoEnFilaWk()
  {
    $sql = "select sum(monto) as suma from pre_ejecuta_plantilla where status = 'EJECUTADO' and folio like '10H14Wk%' and estado IS NULL and id_stp IS NOT NULL and fecha_creacion > '2023-11-00' ORDER BY `id` DESC;";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['suma'];
  }
  public function dameMontoEnFilaEn()
  {
    $sql = "select sum(monto) as suma from pre_ejecuta_plantilla where status = 'EJECUTADO' and folio like '10H14EN%' and estado IS NULL and id_stp IS NOT NULL and fecha_creacion > '2023-11-00' ORDER BY `id` DESC;";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['suma'];
  }


  public function dameSaldoInternos()
  {
    $sql = "select sum(saldo_acreditable) as suma from pagos where nombre='13'";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $suma = $fila['suma'];
    }
    return $suma;
  }

  public function cuentaMovimientosPendientes()
  {
    $sql = "SELECT COUNT(id) AS movimientos FROM pagos WHERE STATUS <>'asignado' and id != 212733";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $movimientos = $fila['movimientos'];
    }
    return $movimientos;
  }

  public function sumaDepositos()
  {
    $sql = "SELECT sum(monto) AS suma,bancos.moneda FROM pagos
    left join captura on (pagos.id_captura=captura.id)
    left join bancos on (bancos.id=captura.`nombre_corto`)
     WHERE STATUS <>'asignado' and tipo_movimiento='Deposito' and bancos.moneda<>'Dolares'";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $suma = $fila['suma'];
    }
    return $suma;
  }

  public function sumaRetiros()
  {
    $sql = "SELECT sum(monto) AS suma,bancos.moneda FROM pagos
    left join captura on (pagos.id_captura=captura.id)
    left join bancos on (bancos.id=captura.`nombre_corto`)
     WHERE STATUS <>'asignado' and tipo_movimiento='Retiro' and bancos.moneda<>'Dolares'";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $suma = $fila['suma'];
    }
    return $suma;
  }

  public function sumaDepositosDolares()
  {
    $sql = "SELECT sum(monto) AS suma,bancos.moneda FROM pagos
    left join captura on (pagos.id_captura=captura.id)
    left join bancos on (bancos.id=captura.`nombre_corto`)
     WHERE STATUS <>'asignado' and tipo_movimiento='Deposito' and bancos.moneda='Dolares'";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $suma = $fila['suma'];
    }
    return $suma;
  }

  public function sumaRetirosDolares()
  {
    $sql = "SELECT sum(monto) AS suma,bancos.moneda FROM pagos
    left join captura on (pagos.id_captura=captura.id)
    left join bancos on (bancos.id=captura.`nombre_corto`)
     WHERE STATUS <>'asignado' and tipo_movimiento='Retiro' and bancos.moneda='Dolares'";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $suma = $fila['suma'];
    }
    return $suma;
  }

  public function damePagosSinReferencia()
  {
    $sql = "SELECT sum(monto) as dif FROM pagos WHERE nombre = 0;";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $dif = $fila['dif'];
    }
    return $dif;
  }

  public function dameEstadosSinCuenta()
  {
    $sql = "SELECT sum(deposito) as depo, sum(retiro) as ret FROM captura_edo_cta WHERE cuenta = 0;";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $depo = $fila['depo'];
      $ret = $fila['ret'];
    }
    return $depo - $ret;
  }

  public function dameMovimientosPedientes()
  {
    $sql = 'select sum(monto) as resto from pagos p where nombre is null';
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $resto = $fila['resto'];
    }



    return $resto;
  }

  public function dameSaldoMovimientosTotal()
  {
    $depositos = $this->sumaDepositos();
    $retiros = $this->sumaRetiros();
    $depositos_dolares = $this->sumaDepositosDolares();
    $retiros_dolares = $this->sumaRetirosDolares();
    $tipo_cambio = $this->dameUltimoTipoCambio()->tipo_cambio;
    $suma = $depositos - $retiros;
    $suma_dolares = ($depositos_dolares - $retiros_dolares);
    $suma_dolares_pesos = $suma_dolares * $tipo_cambio;
    $pagos_sin_ref = $this->damePagosSinReferencia();
    $estados_sin_cuenta = $this->dameEstadosSinCuenta();
    $suma_movimientos = $suma + $suma_dolares_pesos + $pagos_sin_ref + $estados_sin_cuenta;
    return $suma_movimientos;
  }

  public function dameDiferenciasDeSaldo()
  {
    $sql = "SELECT ((SELECT SUM(deposito) FROM captura_edo_cta)-(SELECT SUM(retiro) FROM captura_edo_cta)) - 
    (SELECT SUM(saldo_acreditable) FROM pagos)
    AS resto";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $resto = $fila['resto'];
    }



    return $resto - $this->dameSaldoMovimientosTotal();
  }

  function dameDiferenciasDeSaldoDelment()
  {
    $queryCaptura = 'SELECT ((SELECT SUM(deposito) FROM captura_edo_cta where cuenta = 67)-(SELECT SUM(retiro) FROM captura_edo_cta where cuenta = 67));';
    $queryStp = 'SELECT saldo FROM stp_saldos where id = (SELECT MAX(id) FROM stp_saldos);';

    $resultCaptura = $this->ejecutar($queryCaptura);
    $resultStp = $this->ejecutar($queryStp);

    $filaCaptura = mysqli_fetch_array($resultCaptura);
    $filaStp = mysqli_fetch_array($resultStp);
    //defecto de nacimiento de la cuenta en donde no se reporto este saldo. 
    $resto = $filaCaptura[0] - $filaStp[0];
    return $resto;
  }


  function dameDiferenciasDeSaldoZac()
  {
    $queryCaptura = 'SELECT ((SELECT SUM(deposito) FROM captura_edo_cta where cuenta = 127)-(SELECT SUM(retiro) FROM captura_edo_cta where cuenta = 127));';
    $queryStp = 'SELECT saldo FROM stp_saldos_zac where id = (SELECT MAX(id) FROM stp_saldos_zac);';

    $resultCaptura = $this->ejecutar($queryCaptura);
    $resultStp = $this->ejecutar($queryStp);

    $filaCaptura = mysqli_fetch_array($resultCaptura);
    $filaStp = mysqli_fetch_array($resultStp);
    //defecto de nacimiento de la cuenta en donde no se reporto este saldo. 
    $resto = $filaCaptura[0] - $filaStp[0];
    return $resto;
  }

    function dameDiferenciasDeSaldoKul()
  {
    $queryCaptura = 'SELECT ((SELECT SUM(deposito) FROM captura_edo_cta where cuenta = 141)-(SELECT SUM(retiro) FROM captura_edo_cta where cuenta = 141));';
    $queryStp = 'SELECT saldo FROM stp_saldos_kul where id = (SELECT MAX(id) FROM stp_saldos_kul);';

    $resultCaptura = $this->ejecutar($queryCaptura);
    $resultStp = $this->ejecutar($queryStp);

    $filaCaptura = mysqli_fetch_array($resultCaptura);
    $filaStp = mysqli_fetch_array($resultStp);
    //defecto de nacimiento de la cuenta en donde no se reporto este saldo. 
    $resto = $filaCaptura[0] - $filaStp[0];
    return $resto;
  }



  function dameDiferenciasDeSaldoEnclenci()
  {
    $queryCaptura = 'SELECT ((SELECT SUM(deposito) FROM captura_edo_cta where cuenta = 117)-(SELECT SUM(retiro) FROM captura_edo_cta where cuenta = 117));';
    $queryStp = 'SELECT saldo FROM stp_saldos_en where id = (SELECT MAX(id) FROM stp_saldos_en);';

    $resultCaptura = $this->ejecutar($queryCaptura);
    $resultStp = $this->ejecutar($queryStp);

    $filaCaptura = mysqli_fetch_array($resultCaptura);
    $filaStp = mysqli_fetch_array($resultStp);

    $resto = $filaCaptura[0] - $filaStp[0];
    return $resto;
  }


  function dameDiferenciasDeSaldoTokidoki()
  {
    $queryCaptura = 'SELECT ((SELECT SUM(deposito) FROM captura_edo_cta where cuenta = 130)-(SELECT SUM(retiro) FROM captura_edo_cta where cuenta = 130));';
    $queryStp = 'SELECT saldo FROM stp_saldos_toki where id = (SELECT MAX(id) FROM stp_saldos_toki);';

    $resultCaptura = $this->ejecutar($queryCaptura);
    $resultStp = $this->ejecutar($queryStp);

    $filaCaptura = mysqli_fetch_array($resultCaptura);
    $filaStp = mysqli_fetch_array($resultStp);

    $resto = $filaCaptura[0] - $filaStp[0];
    return $resto;
  }


  function dameDiferenciaConsReporte()
  {
    $sql = "SELECT (select sum(suma) from (select sum(monto) as suma from stp_his_api where fecha_ingresa > '2023-12-13' group by id_op) as t1) - (select sum(monto) from pre_ejecuta_plantilla where fecha_creacion > '2023-12-13' and cep like '%https://www.banxico%') as suma;";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $resto = $fila['suma'];
    }
    return $resto;
  }

  function dameDiferenciasDeSaldoWk()
  {
    $queryCaptura = 'SELECT ((SELECT SUM(deposito) FROM captura_edo_cta where cuenta = 114)-(SELECT SUM(retiro) FROM captura_edo_cta where cuenta = 114));';
    $queryStp = 'SELECT saldo FROM stp_saldos_wk where id = (SELECT MAX(id) FROM stp_saldos_wk);';

    $resultCaptura = $this->ejecutar($queryCaptura);
    $resultStp = $this->ejecutar($queryStp);

    $filaCaptura = mysqli_fetch_array($resultCaptura);
    $filaStp = mysqli_fetch_array($resultStp);

    $resto = $filaCaptura[0] - $filaStp[0];
    return $resto;
  }


  public function dameSaldosStp()
  {
    $sql = "SELECT saldo from stp_saldos order by id desc limit 1;";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {

      $saldos = $fila['saldo'];
    }
    return $saldos;
  }

  public function dameSaldosStpZac()
  {
    $sql = "SELECT saldo from stp_saldos_zac order by id desc limit 1;";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {

      $saldos = $fila['saldo'];
    }
    return $saldos;
  }

   public function dameSaldosStpKulindra()
  {
    $sql = "SELECT saldo from stp_saldos_kul order by id desc limit 1;";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {

      $saldos = $fila['saldo'];
    }
    return $saldos;
  }

  public function dameSaldosStpWk()
  {
    $sql = "SELECT saldo from stp_saldos_wk order by id desc limit 1;";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {

      $saldos = $fila['saldo'];
    }
    return $saldos;
  }

  public function dameSaldosStpEn()
  {
    $sql = "SELECT saldo from stp_saldos_en order by id desc limit 1;";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {

      $saldos = $fila['saldo'];
    }
    return $saldos;
  }

  public function dameSaldosStpTo()
  {
    $sql = "SELECT saldo from stp_saldos_toki order by id desc limit 1;";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {

      $saldos = $fila['saldo'];
    }
    return $saldos;
  }

  public function dameOperacionesPendientesStp()
  {
    $sql = "SELECT cargos_pendientes FROM stp_saldos WHERE id=(SELECT MAX(id) FROM stp_saldos)";
    $result = $this->ejecutar($sql);
    while ($fila = mysqli_fetch_array($result)) {
      $saldos = $fila['cargos_pendientes'];
    }
    return $saldos;
  }

  public function aplicaIva($id)
  {
    $sql = "SELECT aplica_iva FROM `conceptos` WHERE id = $id";
    $row = $this->ejecutar($sql);
    $row = mysqli_fetch_array($row);
    return $row['aplica_iva'];
  }

  public function damePrecioSinIva($id)
  {
    $sql = "SELECT precio FROM `conceptos` WHERE id = $id";
    $row = $this->ejecutar($sql);
    $row = mysqli_fetch_array($row);
    return $row['precio'];
  }

  public function dameClientes()
  {
    $sql = "SELECT id, nombre FROM `clientes` ORDER BY nombre ASC";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = new ClienteUtil($row['nombre'], $row['id']);
    }
    return $items;
  }
  public function dameCliente($id)
  {
    $sql = "SELECT cliente FROM `usuarios` WHERE id = $id";
    $result = $this->ejecutar($sql);
    $row = mysqli_fetch_array($result);
    return $row['cliente'];
  }
  public function cuentaFacturasPpdPorCliente($id)
  {
    $sql = "SELECT count(*) AS numrows FROM `facturas_complementos` WHERE metodo_pago = 2 and nombre = '.$id.' AND id NOT IN (SELECT id_complemento FROM `facturar_rel_complementos` WHERE restante = 0)";
    $row = $this->ejecutar($sql);
    $row = mysqli_fetch_array($row);
    return $row['numrows'];
  }

  public function dameClientePorPago($id)
  {
    $sql = "SELECT clientes.id, clientes.nombre, clientes.correo FROM pagos INNER JOIN clientes ON (pagos.destino_traspaso = clientes.id) WHERE pagos.id = $id";
    $row = $this->ejecutar($sql);
    $row = mysqli_fetch_array($row);
    return $row['id'];
  }

  public function dameCorreoCliente($id)
  {
    $sql = "SELECT correo FROM `clientes` WHERE id = $id";
    $row = $this->ejecutar($sql);
    $row = mysqli_fetch_array($row);
    return $row['correo'];
  }

  public function dameCuentas()
  {
    $sql = "SELECT id,nombre_corto FROM bancos order by nombre_corto";
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $items[] = new CuentasUtil($row['id'], $row['nombre_corto']);
    }
    return $items;
  }

  public function dameSumaEmpresas()
  {
    $sql = "SELECT (sum(deposito) - SUM(retiro)) as total FROM `captura_edo_cta` inner join bancos on bancos.id = captura_edo_cta.cuenta where bancos.status_banco = 'AC';";
    $result = $this->ejecutar($sql);
    $row = mysqli_fetch_array($result);
    return $row['total'];
  }
}
