<?php
include_once('../../../conectorBDS14.php');

class Grupo
{
  //SELECT `id`, `nombre`, `color`, `cliente_padre`, `usuario_inserta` FROM `grupo` WHERE 1
  public $id;
  public $nombre;
  public $color;
  public $cliente_padre;
  public $usuario_inserta;
  public $cuenta_salida;
  public $conteo_cuentas;
  public $suma_montos;

  function __construct($id, $nombre, $color, $cliente_padre, $usuario_inserta, $cuenta_salida)
  {
    $this->id = $id;
    $this->nombre = $nombre;
    $this->color = $color;
    $this->cliente_padre = $cliente_padre;
    $this->usuario_inserta = $usuario_inserta;
    $this->cuenta_salida = $cuenta_salida;
  }
}

class AdministradorGrupos extends conectorS14
{

  public function dameGrupos()
  {
    $sql = "SELECT * FROM grupo";
    $result = $this->ejecutar($sql);
    $grupos = array();
    while ($row = mysqli_fetch_array($result)) {
      $grupo = new Grupo($row['id'], $row['nombre'], $row['color'], $row['cliente_padre'], $row['usuario_inserta'], $row['cuenta_salida']);
      $grupo->conteo_cuentas = $this->cuentaClientes($grupo->id);
      $grupo->suma_montos = $this->dameSaldosGrupos($grupo->id);

      array_push($grupos, $grupo);
    }
    return $grupos;
  }

  public function dameGrupo($id)
  {
    $sql = "SELECT * FROM grupo WHERE id = '$id'";
    $result = $this->ejecutar($sql);
    while ($row = mysqli_fetch_array($result)) {
      $grupo = new Grupo($row['id'], $row['nombre'], $row['color'], $row['cliente_padre'], $row['usuario_inserta'], $row['cuenta_salida']);
      $grupo->conteo_cuentas = $this->cuentaClientes($grupo->id);
      $grupo->suma_montos = $this->dameSaldosGrupos($grupo->id);
    }
    return $grupo;
  }

  public function dameSaldosGrupos($grupo)
  {
    $sql = "SELECT sum(saldo_acreditable) as saldo FROM `pagos`
    where nombre in (select id from clientes where grupo = $grupo);";
    $result = $this->ejecutar($sql);
    $row = mysqli_fetch_array($result);
    return $row['saldo'];
  }

  public function cuentaClientes($id_grupo)
  {
    $sql = "SELECT COUNT(*) AS cuenta FROM clientes WHERE grupo = '$id_grupo'";
    $result = $this->ejecutar($sql);
    $row = mysqli_fetch_array($result);
    return $row['cuenta'];
  }

  public function agregaGrupo($nombre, $color, $cliente_padre, $usuario_inserta)
  {
    $sql = "INSERT INTO grupo (nombre, color, cliente_padre, usuario_inserta) VALUES ('$nombre', '$color', '$cliente_padre', '$usuario_inserta')";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function modificarGrupo($nombre, $color, $cliente_padre, $usuario_inserta, $id)
  {
    $sql = "UPDATE grupo SET nombre = '$nombre', color = '$color', cliente_padre = '$cliente_padre', usuario_inserta = '$usuario_inserta' WHERE id = '$id'";
    $result = $this->ejecutar($sql);
    return $result;
  }



  public function eliminarGrupo($id)
  {
    $sql = "DELETE FROM grupo WHERE id = '$id'";
    $result = $this->ejecutar($sql);
    $sqlClientes = "UPDATE clientes SET grupo = 0, lidera = 0 WHERE grupo = '$id'";
    $resultClientes = $this->ejecutar($sqlClientes);
    return $result;
  }

  public function asignarCuentaSalida($id_grupo, $id_cuenta, $usuario_inserta)
  {
    $sql = "UPDATE grupo SET cuenta_salida = '$id_cuenta', ultimo_asigno = '$usuario_inserta' WHERE id = '$id_grupo'";
    $result = $this->ejecutar($sql);
    return $result;
  }
}
