<?php
include_once('../../../conectorBDS14.php');

class Concepto
{
  public $id;
  public $concepto;
  public $clave_sat;
  public $clave_producto;
  public $clave_unidad_medida;
  public $precio_min;
  public $precio_max;
  public $razon;
  public $unidades_max;
  public $facturable_auto;
  public $aplica_iva;
  public $objeto_impuesto;
  public $impuesto;
  public $nombreEmpresa;
  public $botonRuta;
  public $cantidad;
  public $precioUnitario;

  public function __construct($id, $concepto, $clave_sat, $clave_producto, $clave_unidad_medida, $precio_min, $precio_max, $razon, $unidades_max, $facturable_auto, $aplica_iva, $objeto_impuesto, $impuesto, $nombreEmpresa)
  {
    $this->id = $id;
    $this->concepto = $concepto;
    $this->clave_sat = $clave_sat;
    $this->clave_producto = $clave_producto;
    $this->clave_unidad_medida = $clave_unidad_medida;
    $this->precio_min = $precio_min;
    $this->precio_max = $precio_max;
    $this->razon = $razon;
    $this->unidades_max = $unidades_max;
    $this->facturable_auto = $facturable_auto;
    $this->aplica_iva = $aplica_iva;
    $this->objeto_impuesto = $objeto_impuesto;
    $this->impuesto = $impuesto;
    $this->nombreEmpresa = $nombreEmpresa;
  }
}


class ConceptoEsp
{
  //SELECT id, nombre, clave_sat, aplica_iva FROM iohanes_14.conceptos_compra;
  public $id;
  public $nombre;
  public $clave_sat;
  public $aplica_iva;

  public function __construct($id, $nombre, $clave_sat, $aplica_iva)
  {
    $this->id = $id;
    $this->nombre = $nombre;
    $this->clave_sat = $clave_sat;
    $this->aplica_iva = $aplica_iva;
  }
}

class AdministradorConceptos extends conectorS14
{

  public function procesarCadenas($cadena)
  {
    $cadena = str_replace('á', 'a', $cadena);
    $cadena = str_replace('é', 'e', $cadena);
    $cadena = str_replace('í', 'i', $cadena);
    $cadena = str_replace('ó', 'o', $cadena);
    $cadena = str_replace('ú', 'u', $cadena);
    $cadena = str_replace('Á', 'A', $cadena);
    $cadena = str_replace('É', 'E', $cadena);
    $cadena = str_replace('Í', 'I', $cadena);
    $cadena = str_replace('Ó', 'O', $cadena);
    $cadena = str_replace('Ú', 'U', $cadena);
    $cadena = str_replace('"', '', $cadena);
    $cadena = str_replace("'", '', $cadena);


    return $cadena;
  }
  public function insertarConcepto($concepto, $clave_sat, $clave_producto, $clave_unidad_medida, $precio_min, $precio_max, $razon, $unidades_max, $facturable_auto, $aplica_iva, $objeto_impuesto, $impuesto)
  {
    $sql = "INSERT INTO conceptos (concepto, clave_sat, clave_producto, clave_unidad_medida, precio_min, precio_max, razon, unidades_max, facturable_auto, aplica_iva, objeto_impuesto, impuesto) VALUES ('$concepto', '$clave_sat', '$clave_producto', '$clave_unidad_medida', '$precio_min', '$precio_max', '$razon', '$unidades_max', '$facturable_auto', '$aplica_iva', '$objeto_impuesto', '$impuesto')";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function insertarConceptoCompra($nombre, $clave_sat, $aplica_iva, $empresa)
  {
    $sql = "INSERT INTO conceptos_compra (nombre, clave_sat, aplica_iva, id_empresa) VALUES ('$nombre', '$clave_sat', '$aplica_iva', '$empresa')";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function eliminarConceptoIva($clave_sat)
  {
    $sql = "delete from conceptos_compra where clave_sat = '$clave_sat'";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function eliminarConcepto($id)
  {
    $sql = "delete from conceptos where id = $id";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function modificarConcepto($id, $concepto, $clave_sat, $clave_producto, $clave_unidad_medida, $precio_min, $precio_max, $razon, $unidades_max, $facturable_auto, $aplica_iva, $objeto_impuesto, $impuesto)
  {
    $sql = "UPDATE conceptos SET concepto = '$concepto', clave_sat = '$clave_sat', clave_producto = '$clave_producto', clave_unidad_medida = '$clave_unidad_medida', precio_min = '$precio_min', precio_max = '$precio_max', razon = '$razon', unidades_max = '$unidades_max', facturable_auto = '$facturable_auto', aplica_iva = '$aplica_iva', objeto_impuesto = '$objeto_impuesto', impuesto = '$impuesto' WHERE id = '$id'";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function dameConcepto($id)
  {
    $sql = "select e.razon as empresaNom, c.* from conceptos c 
    inner join empresas e 
    on e.id  = c.razon
    where c.id = $id";
    $result = $this->ejecutar($sql);
    $concepto = mysqli_fetch_array($result);
    $concepto = new Concepto($concepto['id'], $concepto['concepto'], $concepto['clave_sat'], $concepto['clave_producto'], $concepto['clave_unidad_medida'], $concepto['precio_min'], $concepto['precio_max'], $concepto['razon'], $concepto['unidades_max'], $concepto['facturable_auto'], $concepto['aplica_iva'], $concepto['objeto_impuesto'], $concepto['impuesto'], $concepto['empresaNom']);
    return $concepto;
  }

  public function dameConceptosEspCat($empresa)
  {
    $sql = "select id, concepto, clave_sat, aplica_iva from iohanes_14.conceptos c 
            where clave_sat not in (
            select clave_sat from iohanes_14.conceptos_compra cc where cc.id_empresa = $empresa
            )
            group by clave_sat order by concepto asc;
            ";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new ConceptoEsp($fila['id'], $this->procesarCadenas($fila['concepto']), $fila['clave_sat'], $fila['aplica_iva']);
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }

  function dameConceptosCompra($empresa)
  {
    $sql = "select * from conceptos_compra where id_empresa = $empresa";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new ConceptoEsp($fila['id'], $this->procesarCadenas($fila['nombre']), $fila['clave_sat'], $fila['aplica_iva']);
      array_push($conceptos, $concepto);
    }

    return $conceptos;
  }

  function eliminarConceptosCompra($clave_sat, $empresa){
    $sql = "delete from conceptos_compra where clave_sat = '$clave_sat' and id_empresa = '$empresa'";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function dameConceptosPorFactura($factura)
  {
    $sql = '
    SELECT conceptos.*, detalle_factura.cantidad, detalle_factura.precio_con_iva, detalle_factura.concepto as cfo FROM `conceptos`
    inner join detalle_factura
    on detalle_factura.id_producto = conceptos.id

    where detalle_factura.id_factura = ' . $factura . ';
    ';
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new Concepto($fila['id'], $fila['cfo'], $fila['clave_sat'], $fila['clave_producto'], $fila['clave_unidad_medida'], $fila['precio_min'], $fila['precio_max'], $fila['razon'], $fila['unidades_max'], $fila['facturable_auto'], $fila['aplica_iva'], $fila['objeto_impuesto'], $fila['impuesto'], "");
      $concepto->cantidad = $fila['cantidad'];
      $concepto->precioUnitario = $fila['precio_con_iva'];
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }

  public function dameConceptosPorRazon($razon)
  {
    $sql = "select e.razon as empresaNom, c.* from conceptos c 
    inner join empresas e 
    on e.id  = c.razon
    where c.razon = $razon order by e.razon asc";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new Concepto($fila['id'], $fila['concepto'], $fila['clave_sat'], $fila['clave_producto'], $fila['clave_unidad_medida'], $fila['precio_min'], $fila['precio_max'], $fila['razon'], $fila['unidades_max'], $fila['facturable_auto'], $fila['aplica_iva'], $fila['objeto_impuesto'], $fila['impuesto'], $fila['empresaNom']);
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }

  public function dameConceptosPorRazonAlgoritmo($razon)
  {
    $sql = "select e.razon as empresaNom, c.* from conceptos c 
    inner join empresas e 
    on e.id  = c.razon
    where c.razon = $razon and facturable_auto = 'Si' order by e.razon asc";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new Concepto($fila['id'], $fila['concepto'], $fila['clave_sat'], $fila['clave_producto'], $fila['clave_unidad_medida'], $fila['precio_min'], $fila['precio_max'], $fila['razon'], $fila['unidades_max'], $fila['facturable_auto'], $fila['aplica_iva'], $fila['objeto_impuesto'], $fila['impuesto'], $fila['empresaNom']);
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }

  public function dameConceptosPorRazonFactura($razon)
  {
    $sql = "select e.razon as empresaNom, c.* from conceptos c 
    inner join empresas e 
    on e.id  = c.razon
    where c.razon = $razon order by e.razon asc";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new Concepto($fila['id'], $fila['concepto'], $fila['clave_sat'], $fila['clave_producto'], $fila['clave_unidad_medida'], $fila['precio_min'], $fila['precio_max'], $fila['razon'], $fila['unidades_max'], $fila['facturable_auto'], $fila['aplica_iva'], $fila['objeto_impuesto'], $fila['impuesto'], $fila['empresaNom']);
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }

  public function dameConceptos()
  {
    $sql = "select e.razon as empresaNom, c.* from conceptos c 
    inner join empresas e 
    on e.id  = c.razon order by e.razon asc";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new Concepto($fila['id'], $fila['concepto'], $fila['clave_sat'], $fila['clave_producto'], $fila['clave_unidad_medida'], $fila['precio_min'], $fila['precio_max'], $fila['razon'], $fila['unidades_max'], $fila['facturable_auto'], $fila['aplica_iva'], $fila['objeto_impuesto'], $fila['impuesto'], $fila['empresaNom']);
      $concepto->botonRuta = '<a href="cat-conceptos-form.php?id=' . $fila['id'] . '"> <div class="circle long">
                                <p>Ver</p>
                              </div> </a>';
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }

  public function dameConceptosPre(){
    $sql = "select e.razon as empresaNom, c.* from conceptos_pre_ingreso c 
    inner join empresas e 
    on e.id  = c.razon order by e.razon asc";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new Concepto($fila['id'], $fila['concepto'], $fila['clave_sat'], $fila['clave_producto'], $fila['clave_unidad_medida'], $fila['precio_min'], $fila['precio_max'], $fila['razon'], $fila['unidades_max'], $fila['facturable_auto'], $fila['aplica_iva'], $fila['objeto_impuesto'], $fila['impuesto'], $fila['empresaNom']);
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }

  public function eliminarPreConcepto($id)
  {
    $sql = "DELETE FROM conceptos_pre_ingreso WHERE id = $id";
    $this->ejecutar($sql);
  }

  public function dameConceptoPre($id)
  {
    $sql = "select e.razon as empresaNom, c.* from conceptos_pre_ingreso c 
    inner join empresas e 
    on e.id  = c.razon
    where c.id = $id";
    $result = $this->ejecutar($sql);
    $concepto = mysqli_fetch_array($result);
    $concepto = new Concepto($concepto['id'], $concepto['concepto'], $concepto['clave_sat'], $concepto['clave_producto'], $concepto['clave_unidad_medida'], $concepto['precio_min'], $concepto['precio_max'], $concepto['razon'], $concepto['unidades_max'], $concepto['facturable_auto'], $concepto['aplica_iva'], $concepto['objeto_impuesto'], $concepto['impuesto'], $concepto['empresaNom']);
    return $concepto;
  }

  public function dameConceptosIa()
  {
    $sql = "select e.razon as empresaNom, c.* from conceptos_auto c 
    inner join empresas e 
    on e.id  = c.razon order by e.razon asc";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new Concepto($fila['id'], $fila['concepto'], $fila['clave_sat'], $fila['clave_producto'], $fila['clave_unidad_medida'], $fila['precio_min'], $fila['precio_max'], $fila['razon'], $fila['unidades_max'], $fila['facturable_auto'], $fila['aplica_iva'], $fila['objeto_impuesto'], $fila['impuesto'], $fila['empresaNom']);
      $concepto->botonRuta = '<a href="cat-conceptos-form.php?id=' . $fila['id'] . '"> <div class="circle long">
                                <p>Ver</p>
                              </div> </a>';
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }

  public function dameConceptosClaveSatRazon($clave_sat, $razon)
  {
    $sql = "select e.razon as empresaNom, c.* from conceptos c 
    inner join empresas e 
    on e.id  = c.razon
    where c.clave_sat = '$clave_sat' and c.razon = $razon order by e.razon asc";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new Concepto($fila['id'], $fila['concepto'], $fila['clave_sat'], $fila['clave_producto'], $fila['clave_unidad_medida'], $fila['precio_min'], $fila['precio_max'], $fila['razon'], $fila['unidades_max'], $fila['facturable_auto'], $fila['aplica_iva'], $fila['objeto_impuesto'], $fila['impuesto'], $fila['empresaNom']);
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }

  public function cuentaConceptos()
  {
    $sql = "SELECT COUNT(*) AS cuenta FROM conceptos";
    $result = $this->ejecutar($sql);
    $cuenta = mysqli_fetch_array($result);
    $cuenta = $cuenta['cuenta'];
    return $cuenta;
  }
  public function cuentaConceptosSinIva()
  {
    $sql = "SELECT COUNT(*) AS cuenta FROM conceptos WHERE aplica_iva = 'no'";
    $result = $this->ejecutar($sql);
    $cuenta = mysqli_fetch_array($result);
    $cuenta = $cuenta['cuenta'];
    return $cuenta;
  }

  public function cuentaConceptosConIva()
  {
    $sql = "SELECT COUNT(*) AS cuenta FROM conceptos WHERE aplica_iva = 'si'";
    $result = $this->ejecutar($sql);
    $cuenta = mysqli_fetch_array($result);
    $cuenta = $cuenta['cuenta'];
    return $cuenta;
  }


  public function dameConceptosCruzados($empresaEmite, $empresaRecibe)
  {
    $sql = "SELECT cd.*
        FROM conceptos_depu cd
        WHERE razon = $empresaEmite and activo = 1
        AND cd.clave_sat IN (SELECT clave_sat FROM conceptos_compra cc WHERE cc.id_empresa = $empresaRecibe) LIMIT 8";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new Concepto($fila['id'], $fila['concepto'], $fila['clave_sat'], $fila['clave_producto'], $fila['clave_unidad_medida'], $fila['precio_min'], $fila['precio_max'], $fila['razon'], $fila['unidades_max'], $fila['facturable_auto'], $fila['aplica_iva'], $fila['objeto_impuesto'], $fila['impuesto'], $fila['empresaNom']);
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }

   public function dameConceptosEsp($empresaEmite, $empresaRecibe)
  {
    $sql = "SELECT cd.*
        FROM conceptos cd
        WHERE id in (4432,
4431,
4430,
4429,
4428,
4427,
4426,
4425,
4424,
4423,
4422,
4421,
4420,
4419,
4418,
4417,
4416,
4415,
4396,
4395,
4394,
4393,
4392)";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new Concepto($fila['id'], $fila['concepto'], $fila['clave_sat'], $fila['clave_producto'], $fila['clave_unidad_medida'], $fila['precio_min'], $fila['precio_max'], $fila['razon'], $fila['unidades_max'], $fila['facturable_auto'], $fila['aplica_iva'], $fila['objeto_impuesto'], $fila['impuesto'], $fila['empresaNom']);
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }
}
