<?php
include_once('../../../conectorBDS14.php');

class PPD
{
    public $id;
    public $nombre;
    public $metodoPago;
    public $moneda;
    public $formaDePago;
    public $estatus;
    public $totalFactura;
    public $empresa;
    public $tipoComprobante;
    public $usoCfdi;
    public $numeroCertificado;
    public $fechaTimbrado;
    public $certificadoSat;
    public $fechaPagado;
    public $complementos;
    public $monto;
    public $saldo;
    public $restante;
    public $token;
    public $accion;


    public function __construct($id, $nombre, $metodoPago, $moneda, $formaDePago, $estatus, $totalFactura, $empresa, $tipoComprobante, $usoCfdi, $numeroCertificado, $fechaTimbrado, $certificadoSat, $fechaPagado, $monto)
    {
        $this->id = $id;
        $this->nombre = $nombre;
        $this->metodoPago = $metodoPago;
        $this->moneda = $moneda;
        $this->formaDePago = $formaDePago;
        $this->estatus = $estatus;
        $this->totalFactura = $totalFactura;
        $this->empresa = $empresa;
        $this->tipoComprobante = $tipoComprobante;
        $this->usoCfdi = $usoCfdi;
        $this->numeroCertificado = $numeroCertificado;
        $this->fechaTimbrado = $fechaTimbrado;
        $this->certificadoSat = $certificadoSat;
        $this->fechaPagado = $fechaPagado;
        $this->monto = $monto;
    }

    public function calculaRestante()
    {
        $total = 0;
        foreach ($this->complementos as $complemento) {
            $total += $complemento->monto;
        }
        $this->restante = $this->totalFactura - $total;
    }
}

class ComplementoLista
{
    public $id;
    public $uuid_rel;
    public $monto;
    public $id_complemento;
    public $num_pago;
    public $factura;
    public $saldo;
    public $restante;
    public $folio;
    public $serie;
    public $token;

    public function __construct($id, $id_complemento, $uuid_rel, $monto, $num_pago , $factura, $saldo, $restante,$folio,$serie)
    {
        $this->id = $id;
        $this->id_complemento = $id_complemento;
        $this->uuid_rel = $uuid_rel;
        $this->monto = $monto;
        $this->num_pago = $num_pago;
        $this->factura = $factura;
        $this->saldo = $saldo;
        $this->restante = $restante;
        $this->folio = $folio;
        $this->serie = $serie;
    }
}



class Complemento
{
    public $id;
    public $metodo_pago;
    public $forma_pago;
    public $razon;
    public $total_factura;
    public $status_pago;
    public $nombre;
    public $token;
    public $uuid;
    public $status;
    public $fecha_timbrado;
    public $rfc_timbra;
    public $folio;
    public $serie;

    public function __construct()
    {
    }
}


class Correos{
    public $correo1;
    public $correo2;
    public $correo3;
}



class AdministradorPPD extends conectorS14
{


    public function eliminarComplemento($id){
        $query = "DELETE FROM facturas_complementos where id = $id";
        $this->ejecutar($query);
        $query = "DELETE FROM facturar_rel_complementos where id_complemento = $id";
        $this->ejecutar($query);
    }

    public function dameCorreos($id){
        $sql = "SELECT clientes.correo, clientes.correo2, clientes.correo3 FROM `facturas_complementos`
        left join clientes on clientes.id = facturas_complementos.nombre
        where facturas_complementos.id = $id;";
        $result = $this->ejecutar($sql);
    
        while ($row = mysqli_fetch_array($result)) {
            $correo = new Correos();
            $correo->correo1 = $row['correo1'];
            $correo->correo2 = $row['correo2'];
            $correo->correo3 = $row['correo3'];
        }

        return $correo;
    }


    public function dameComplementosPago()
    {
        $sql = "SELECT facturas_complementos.id,facturas_complementos.folio, facturas_complementos.serie, metodos_pago.metodo_pago,formas_pago.forma_pago,empresas.razon,facturas_complementos.total_factura,facturas_complementos.status_pago,clientes.nombre,facturas_complementos.token,facturas_complementos.uuid,facturas_complementos.status,facturas_complementos.fecha_timbrado,claves_cortas.rfc as rfc_timbra FROM facturas_complementos LEFT join metodos_pago on (facturas_complementos.metodo_pago=metodos_pago.id) LEFT join formas_pago on (facturas_complementos.forma_pago=formas_pago.id) LEFT join empresas on (facturas_complementos.razon=empresas.id) LEFT join clientes on (facturas_complementos.nombre=clientes.id) left join claves_cortas on (claves_cortas.id=facturas_complementos.id_clave_corta) order by facturas_complementos.id desc limit 3000 ";
        $result = $this->ejecutar($sql);
        $complementos = array();
        while ($row = mysqli_fetch_array($result)) {
            $complemento = new Complemento();
            $complemento->id = $row['id'];
            $complemento->metodo_pago = $row['metodo_pago'];
            $complemento->forma_pago = $row['forma_pago'];
            $complemento->razon = $row['razon'];
            $complemento->total_factura = $row['total_factura'];
            $complemento->status_pago = $row['status_pago'];
            $complemento->nombre = $row['nombre'];
            $complemento->token = $row['token'];
            $complemento->uuid = $row['uuid'];
            $complemento->status = $row['status'];
            $complemento->fecha_timbrado = $row['fecha_timbrado'];
            $complemento->rfc_timbra = $row['rfc_timbra'];
            
            $complemento->folio = $row['folio'];
            $complemento->serie = $row['serie'];
            $complementos[] = $complemento;
        }

        return $complementos;
    }


    public function dameComplementosPagoFecha($inicio, $fin){
        $sql = "SELECT facturas_complementos.id,facturas_complementos.folio, facturas_complementos.serie, metodos_pago.metodo_pago,formas_pago.forma_pago,empresas.razon,facturas_complementos.total_factura,facturas_complementos.status_pago,clientes.nombre,facturas_complementos.token,facturas_complementos.uuid,facturas_complementos.status,facturas_complementos.fecha_timbrado,claves_cortas.rfc as rfc_timbra FROM facturas_complementos LEFT join metodos_pago on (facturas_complementos.metodo_pago=metodos_pago.id) LEFT join formas_pago on (facturas_complementos.forma_pago=formas_pago.id) LEFT join empresas on (facturas_complementos.razon=empresas.id) LEFT join clientes on (facturas_complementos.nombre=clientes.id) left join claves_cortas on (claves_cortas.id=facturas_complementos.id_clave_corta) where facturas_complementos.fecha_timbrado BETWEEN '$inicio' AND '$fin' order by facturas_complementos.id desc limit 1000 ";
        $result = $this->ejecutar($sql);
        $complementos = array();
        while ($row = mysqli_fetch_array($result)) {
            $complemento = new Complemento();
            $complemento->id = $row['id'];
            $complemento->metodo_pago = $row['metodo_pago'];
            $complemento->forma_pago = $row['forma_pago'];
            $complemento->razon = $row['razon'];
            $complemento->total_factura = $row['total_factura'];
            $complemento->status_pago = $row['status_pago'];
            $complemento->nombre = $row['nombre'];
            $complemento->token = $row['token'];
            $complemento->uuid = $row['uuid'];
            $complemento->status = $row['status'];
            $complemento->fecha_timbrado = $row['fecha_timbrado'];
            $complemento->rfc_timbra = $row['rfc_timbra'];
            
            $complemento->folio = $row['folio'];
            $complemento->serie = $row['serie'];
            $complementos[] = $complemento;
        }
        return $complementos;
    }

    public function dameComplementosPagoHoy(){
        $sql = "SELECT facturas_complementos.id,facturas_complementos.folio, facturas_complementos.serie, metodos_pago.metodo_pago,formas_pago.forma_pago,empresas.razon,facturas_complementos.total_factura,facturas_complementos.status_pago,clientes.nombre,facturas_complementos.token,facturas_complementos.uuid,facturas_complementos.status,facturas_complementos.fecha_timbrado,claves_cortas.rfc as rfc_timbra FROM facturas_complementos LEFT join metodos_pago on (facturas_complementos.metodo_pago=metodos_pago.id) LEFT join formas_pago on (facturas_complementos.forma_pago=formas_pago.id) LEFT join empresas on (facturas_complementos.razon=empresas.id) LEFT join clientes on (facturas_complementos.nombre=clientes.id) left join claves_cortas on (claves_cortas.id=facturas_complementos.id_clave_corta) where facturas_complementos.fecha_timbrado = CURDATE() order by facturas_complementos.id desc limit 2000 ";
        $result = $this->ejecutar($sql);
        $complementos = array();
        while ($row = mysqli_fetch_array($result)) {
            $complemento = new Complemento();
            $complemento->id = $row['id'];
            $complemento->metodo_pago = $row['metodo_pago'];
            $complemento->forma_pago = $row['forma_pago'];
            $complemento->razon = $row['razon'];
            $complemento->total_factura = $row['total_factura'];
            $complemento->status_pago = $row['status_pago'];
            $complemento->nombre = $row['nombre'];
            $complemento->token = $row['token'];
            $complemento->uuid = $row['uuid'];
            $complemento->status = $row['status'];
            $complemento->fecha_timbrado = $row['fecha_timbrado'];
            $complemento->rfc_timbra = $row['rfc_timbra'];
            
            $complemento->folio = $row['folio'];
            $complemento->serie = $row['serie'];
            $complementos[] = $complemento;

        }
        return $complementos;
    }

    public function dameComplemento($id)
    {
        $sql = "SELECT facturas_complementos.id,metodos_pago.metodo_pago,formas_pago.forma_pago,empresas.razon,facturas_complementos.total_factura,facturas_complementos.status_pago,clientes.nombre,facturas_complementos.token,facturas_complementos.uuid,facturas_complementos.status,facturas_complementos.fecha_timbrado,claves_cortas.rfc as rfc_timbra FROM facturas_complementos LEFT join metodos_pago on (facturas_complementos.metodo_pago=metodos_pago.id) LEFT join formas_pago on (facturas_complementos.forma_pago=formas_pago.id) LEFT join empresas on (facturas_complementos.razon=empresas.id) LEFT join clientes on (facturas_complementos.nombre=clientes.id) left join claves_cortas on (claves_cortas.id=facturas_complementos.id_clave_corta)
            where facturas_complementos.id = $id
         order by facturas_complementos.id desc ";
        $result = $this->ejecutar($sql);
        while ($row = mysqli_fetch_array($result)) {
            $complemento = new Complemento();
            $complemento->id = $row['id'];
            $complemento->metodo_pago = $row['metodo_pago'];
            $complemento->forma_pago = $row['forma_pago'];
            $complemento->razon = $row['razon'];
            $complemento->total_factura = $row['total_factura'];
            $complemento->status_pago = $row['status_pago'];
            $complemento->nombre = $row['nombre'];
            $complemento->token = $row['token'];
            $complemento->uuid = $row['uuid'];
            $complemento->status = $row['status'];
            $complemento->fecha_timbrado = $row['fecha_timbrado'];
            $complemento->rfc_timbra = $row['rfc_timbra'];
        }

        return $complemento;
    }

    public function insertaComplementoRel($idFactura, $idComplemento, $monto, $numPago, $saldo, $restante, $uuid_rel, $folio, $serie)
    {
        $query = "INSERT INTO facturar_rel_complementos (id_factura, id_complemento, monto, num_pago, saldo, restante, uuid_rel, folio, serie) VALUES ('$idFactura', '$idComplemento', '$monto', '$numPago', '$saldo', '$restante', '$uuid_rel', '$folio', '$serie')";
       
        $this->ejecutar($query);
    }


    public function insertaComplemento($nombre, $metodo_pago, $moneda, $forma_pago, $status_pago, $total_factura, $razon, $tipo_factura, $uso_cfdi, $num_certificado, $fecha_timbrado, $num_certificado_sat, $fecha_pago, $token, $id_clave_corta, $folio, $serie, $pago, $fechaC, $tipo)
    {
        $query = "INSERT INTO facturas_complementos (nombre, metodo_pago, moneda, forma_pago, status_pago, total_factura, razon, tipo_factura, uso_cfdi, num_certificado, num_certificado_sat, token, id_clave_corta, folio, serie, id_pago, fecha_pago, cadena) VALUES ('$nombre', '$metodo_pago', '$moneda', '$forma_pago', '$status_pago', '$total_factura', '$razon', '$tipo_factura', '$uso_cfdi', '$num_certificado',  '$num_certificado_sat', '$token', '$id_clave_corta', '$folio', '$serie', '$pago', '$fechaC', '$tipo')";
       //echo $query;
        $this->ejecutar($query);
        $id = $this->ultimoId();
        return $id;
    }

    public function ultimoId()
    {
        $query = "SELECT MAX(id) FROM facturas_complementos";
        $result = $this->ejecutar($query);
        $row = $result->fetch_assoc();
        return $row['MAX(id)'];
    }

    public function cuentaComplementos($id)
    {
        $query = "SELECT COUNT(*) FROM facturar_rel_complementos WHERE id_factura = '$id'";
        $result = $this->ejecutar($query);
        $row = $result->fetch_assoc();
        return $row['COUNT(*)'];
    }

    public function dameToken($id)
    {
        $query = "SELECT token FROM `facturas_complementos` WHERE id = $id";
        $result = $this->ejecutar($query);
        $row = mysqli_fetch_array($result);
        return $row['token'];
    }

    public function dameComplementos($id)
    {
        $query = "SELECT * FROM facturar_rel_complementos WHERE id_factura = $id";
        $result = $this->ejecutar($query);
        $complementos = array();
        while ($row = mysqli_fetch_array($result)) {
            $complemento = new Complemento($row['id'], $row['monto'], $row['id_complemento'], $row['num_pago'], $row['id_factura'], $row['saldo'], $row['restante']);
            $complemento->token = $this->dameToken($row['id_complemento']);
            array_push($complementos, $complemento);
        }
        return $complementos;
    }
    public function damePPDs()
    {
        $query = "
        SELECT facturas.id, metodos_pago.metodo_pago, facturas.fecha, facturas.nombre, facturas.moneda, facturas.forma_pago, facturas.status_pago, facturas.total_factura, facturas.empresa, facturas.estatus_cert, facturas.certificado, facturas.cadena, facturas.id_factura, empresas.razon, facturas.tipo_factura, facturas.total_sin_iva, facturas.total_iva, facturas.empresa_destino, facturas.token, facturas.tipo_comprobante, facturas.uso_cfdi, facturas.num_certificado, facturas.certificado_fact, facturas.uuid, facturas.fecha_timbrado, facturas.hora_timbrado, facturas.sello_cfd, facturas.num_certificado_sat, facturas.sello_sat, facturas.complemento, facturas.id_pago, facturas.requiere_complemento, facturas.factura_manual, facturas.id_clave_corta, facturas.xml_firmado, facturas.status, facturas.enviado, facturas.cuadrado, facturas.id_captura, facturas.status_error
        FROM facturas
                INNER JOIN metodos_pago
                ON facturas.metodo_pago = metodos_pago.id
                INNER JOIN empresas
                ON facturas.razon = empresas.id
                WHERE facturas.forma_pago = 23
                ORDER BY facturas.id ASC
        ";
        $result = $this->ejecutar($query);
        $ppds = array();
        while ($row = mysqli_fetch_array($result)) {
            $ppd = new PPD($row['id'], $row['nombre'], $row['metodo_pago'], $row['moneda'], $row['forma_pago'], $row['status_pago'], $row['total_factura'], $row['razon'], $row['tipo_factura'], $row['uso_cfdi'], $row['num_certificado'], $row['fecha_timbrado'], $row['num_certificado_sat'], $row['fecha_pago'], 0);
            $ppd->complementos = $this->dameComplementos($row['id']);
            $ppd->token = $row['token'];
            $ppd->accion =  "<a href=''>COMPLEMENTO</a>";
            $ppd->calculaRestante();

            array_push($ppds, $ppd);
        }
        return $ppds;
    }

    public function cuentaPpds()
    {
        $query = "SELECT COUNT(*) FROM facturas WHERE forma_pago = 23";
        $result = $this->ejecutar($query);
        $row = $result->fetch_assoc();
        return $row['COUNT(*)'];
    }

    public function paginacionPPDs($pagina)
    {
        $query = "
        SELECT facturas.id, metodos_pago.metodo_pago, facturas.fecha, facturas.nombre, facturas.moneda, facturas.forma_pago, facturas.status_pago, facturas.total_factura, facturas.empresa, facturas.estatus_cert, facturas.certificado, facturas.cadena, facturas.id_factura, empresas.razon, facturas.tipo_factura, facturas.total_sin_iva, facturas.total_iva, facturas.empresa_destino, facturas.token, facturas.tipo_comprobante, facturas.uso_cfdi, facturas.num_certificado, facturas.certificado_fact, facturas.uuid, facturas.fecha_timbrado, facturas.hora_timbrado, facturas.sello_cfd, facturas.num_certificado_sat, facturas.sello_sat, facturas.complemento, facturas.id_pago, facturas.requiere_complemento, facturas.factura_manual, facturas.id_clave_corta, facturas.xml_firmado, facturas.status, facturas.enviado, facturas.cuadrado, facturas.id_captura, facturas.status_error
        FROM facturas
                INNER JOIN metodos_pago
                ON facturas.metodo_pago = metodos_pago.id
                INNER JOIN empresas
                ON facturas.razon = empresas.id
                WHERE facturas.forma_pago = 23
                ORDER BY facturas.id DESC
                LIMIT 30 OFFSET " . ($pagina - 1) * 30 . ";";
        $result = $this->ejecutar($query);
        $ppds = array();
        while ($row = mysqli_fetch_array($result)) {
            $ppd = new PPD($row['id'], $row['nombre'], $row['metodo_pago'], $row['moneda'], $row['forma_pago'], $row['status_pago'], $row['total_factura'], $row['razon'], $row['tipo_factura'], $row['uso_cfdi'], $row['num_certificado'], $row['fecha_timbrado'], $row['num_certificado_sat'], $row['fecha_pago'], 0);
            $ppd->complementos = $this->dameComplementos($row['id']);
            $ppd->token = $row['token'];

            $ppd->calculaRestante();

            array_push($ppds, $ppd);
        }
        return $ppds;
    }


    public function damePPD($id)
    {
        $query = "
        SELECT facturas.id, metodos_pago.metodo_pago, facturas.fecha, facturas.nombre, facturas.moneda, facturas.forma_pago, facturas.status_pago, facturas.total_factura, facturas.empresa, facturas.estatus_cert, facturas.certificado, facturas.cadena, facturas.id_factura, empresas.razon, facturas.tipo_factura, facturas.total_sin_iva, facturas.total_iva, facturas.empresa_destino, facturas.token, facturas.tipo_comprobante, facturas.uso_cfdi, facturas.num_certificado, facturas.certificado_fact, facturas.uuid, facturas.fecha_timbrado, facturas.hora_timbrado, facturas.sello_cfd, facturas.num_certificado_sat, facturas.sello_sat, facturas.complemento, facturas.id_pago, facturas.requiere_complemento, facturas.factura_manual, facturas.id_clave_corta, facturas.xml_firmado, facturas.status, facturas.enviado, facturas.cuadrado, facturas.id_captura, facturas.status_error
        FROM facturas
        INNER JOIN metodos_pago
        ON facturas.metodo_pago = metodos_pago.id
        INNER JOIN empresas
        ON facturas.razon = empresas.id
        WHERE facturas.forma_pago = 23
        AND facturas.id = '$id'";
        $result = $this->ejecutar($query);
        $ppds = array();
        while ($row = mysqli_fetch_array($result)) {
            $ppd = new PPD($row['id'], $row['nombre'], $row['metodo_pago'], $row['moneda'], $row['forma_pago'], $row['status_pago'], $row['total_factura'], $row['razon'], $row['tipo_factura'], $row['uso_cfdi'], $row['num_certificado'], $row['fecha_timbrado'], $row['num_certificado_sat'], $row['fecha_pago'], 0);

            $ppd->complementos = $this->dameComplementos($row['id']);

            $ppd->token = $row['token'];

            $ppd->calculaRestante();
            array_push($ppds, $ppd);
        }
        return $ppds;
    }

    public function dameComplementosDePago()
    {
    }

    public function dameFacturas($id){
        $query= "SELECT id, id_complemento, uuid_rel, monto, num_pago, id_factura, saldo, restante, folio, serie FROM facturar_rel_complementos WHERE id_complemento =$id";
        $result=$this->ejecutar($query);
        $facturas = array();
        while ($row = mysqli_fetch_array($result)) {
            $factura = new ComplementoLista($row[''], $row[''], $row['uuid_rel'], $row['monto'],$row['num_pago'], $row['id_factura'], $row['saldo'], $row['restante'], $row['folio'], $row['serie']);
            array_push($facturas, $factura);
        }
        return $facturas;
    }
}
