<?php
include_once 'adminFacturasSEC.php';
include_once 'notificadorFlex.php';
$conector = new conectorS14();
$qery = "SELECT * FROM facturas_correo WHERE estado = 1";
$resultado = $conector->ejecutar($qery);
$adminFacturas = new AdministradorFacturas();
//meter el resultado en una variable


$asuntos = [
    'Factura generada correctamente',
    'Tu factura está lista',
    'Factura emitida con éxito',
    'Factura disponible para descarga',
    'Factura lista para ser consultada',
    'Factura emitida y lista para ti',
    'Se generó tu factura',
    'Factura procesada correctamente',
    'Factura lista para descargar',
    'Factura electrónica generada',
    'Factura lista en tu cuenta',
    'Factura emitida exitosamente',
    'Factura lista para su descarga',
    'Tu factura ha sido emitida',
    'Factura lista para ser descargada',
    'Factura disponible en el sistema',
    'Factura creada y lista para ti',
    'Factura disponible para su consulta',
    'Factura lista para ser enviada',
    'Factura lista para tu revisión',
    'Factura generada y lista para envío',
    'Factura generada para su descarga',
    'Factura emitida para ti',
    'Factura disponible para revisión',
    'Factura lista para ser descargada',
    'Factura lista y disponible',
    'Factura electrónica lista',
    'Factura lista para enviar',
    'Factura generada y lista',
    'Factura emitida en el sistema',
    'Factura lista para tu uso',
    'Factura procesada y disponible',
    'Factura generada y disponible',
    'Factura lista para impresión',
    'Factura emitida y disponible',
    'Factura lista para ser consultada',
    'Factura generada con éxito',
    'Factura emitida y lista para descarga',
    'Factura lista para revisión',
    'Factura lista para consultar',
    'Factura lista para descarga inmediata',
    'Factura electrónica emitida',
    'Factura procesada correctamente',
    'Factura generada para tu revisión',
    'Factura lista para enviar por correo',
    'Factura generada y enviada',
    'Factura lista para descarga segura',
    'Factura lista para ser procesada',
    'Factura generada en el sistema'
];



$hoy = date('Y-m-d H:i:s');

if ($resultado) {

    //recorrer el resultado
    while ($fila = mysqli_fetch_array($resultado)) {

        //comparar fecha_envia con la hora actual solo en dias y minuto y hora no segundos 
        $horaEnvio = $fila['fecha_recibe'];



        if (strtotime($horaEnvio) <= strtotime($hoy)) {


            if ($fila['correo_origen'] != 'NA' && $fila['correo_destino'] != 'NA' && $fila['tamplate'] != '') {


                $factura = $adminFacturas->dameFacturaMontoEmpresa(number_format($fila['monto'], 2, '.', ''), $fila['empresa_origen']);


                if ($factura->sello_cdfi != '' && $factura->uuid != '') {
                    echo "No se pudo generar la factura para el monto: " . $fila['monto'] . " de la empresa: " . $fila['empresa_origen'] . "<br>";
                    continue;
                }


                $pdf = ('xml/pdf/factura-' . $factura[0]->uuid . '.pdf');


                $xml = ('xml/firmados/XML-factura-' . $factura[0]->id . '.xml');

                echo json_encode($factura);

                echo "<br><br><br>";

                echo "Enviando correo a " . $fila['correo_origen'] . "<br>";
                echo "Desde " . $fila['correo_destino'] . "<br>";
                echo "Con plantilla: " . $mensajes[array_rand($mensajes)] . "<br>";
                echo "La hora de envío es: " . $fila['fecha_envia'] . "<br>";
                echo "La hora de recepción es: " . $fila['fecha_recibe'] . "<br>";
                $mail_destino = $fila['correo_destino'];
                echo "el XML es: " . $xml . "<br>";
                echo "el PDF es: " . $pdf . "<br>";

                $nombre_destino = 'Factura';
                $asunto = $asuntos[array_rand($asuntos)];
                $mensaje = $fila['respuesta'];
                $attachment = [];
                $attachment_name = [];
                $mail_oculto = [];
                $correo_origen = $fila['correo_origen'];
                if (file_exists($pdf)) {
                    $attachment[] = $pdf;
                    $attachment_name[] = 'Factura-' . $factura[0]->uuid . '.pdf';
                } else {
                    echo "El archivo PDF no existe: " . $pdf . "<br>";
                }
                if (file_exists($xml)) {
                    $attachment[] = $xml;
                    $attachment_name[] = 'XML-factura-' . $factura[0]->id . '.xml';
                } else {
                    echo "El archivo XML no existe: " . $xml . "<br>";
                }

                echo "EL contenido del correo es: " . $mensaje . "<br>";


                echo '<br> ';
                enviarMailChimp($mail_destino, $nombre_destino, $asunto, $mensaje, $attachment, $attachment_name, $mail_oculto, $correo_origen);
            }
            //cambia el estado del correo a 1
            $query = "UPDATE facturas_correo SET estado = 2 WHERE id = " . $fila['id'];
            echo $qery;
            $resultado = $conector->ejecutar($query);
                break; // Salir del bucle después de enviar el correo

            
        } else {
            echo "No es la hora de envío, no se enviará el correo.<br>";
        }
    }
} else {
    echo "No hay correos por enviar.";
}



function enviarMailChimp($email, $nombre, $asunto, $mensaje, $attachment = [], $attachment_name = [], $mail_oculto = [], $correo_origen = '')
{
    $apiKey = 'md-N-ItQ7kjJI47Vv3jmGH5-A';

    $adjuntos = array();
    foreach ($attachment as $key => $value) {
        $adjuntos[] = [
            'type' => 'application/pdf',
            'name' => $attachment_name[$key],
            'content' => base64_encode(file_get_contents($value))
        ];
    }

    $postData = [
        'key' => $apiKey,
        'message' => [
            'from_email' => $correo_origen,
            'to' => [
                ['email' => $email, 'type' => 'to']
            ],
            'subject' => $asunto,
            'html' => $mensaje,

            'attachments' => $adjuntos
        ]
    ];

    $ch = curl_init('https://mandrillapp.com/api/1.0/messages/send.json');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    echo $response;
}