<?php
include_once('adminUtil.php');
$adminUtil = new AdministradorUtil();
$conector = new conectorS14();
//meter el resultado en una variable


$asuntos = [
    'Seguimiento',
    'Opiniones',
    'Servicio al cliente',
    'Consulta sobre su pedido'
];

$asuntosRespuesta = [
    'Re: Seguimiento',
    'Re: Opiniones',
    'Re: Servicio al cliente',
    'Re: Consulta sobre su pedido'
];

$hoy = date('Y-m-d H:i:s');


$facturasSinEnviar = $adminUtil->dameContextoCorreoSinEnviar();
$facturasSinResponder = $adminUtil->dameContextoSinReenvio();

foreach ($facturasSinEnviar as $fila) {
    $separado = separarCorreoRespuesta($fila->mensaje);
    if ($fila->fecha_entrega < $hoy) {
        // Si la fecha de entrega es anterior a hoy y no hay respuesta, enviar correo
        $asunto = $asuntos[array_rand($asuntos)];
        echo "Enviado mensaje a {$fila->correo_destino} con asunto: $asunto <br>";
        echo "Mensaje: <br> {$separado['correo']} <br>";

        $correo_origen = $fila->correo_origen;
        $nombre = $fila->nombreEmpresa;
        $mensaje = $separado['correo'];

        enviarMailChimp($fila->correo_destino, $nombre, $asunto, $mensaje, [], [], [], $correo_origen);
        $adminUtil->marcarContextoEnviado($fila->id, 1);
    }
}


foreach ($facturasSinResponder as $fila) {
    $separado = separarCorreoRespuesta($fila->mensaje);
    if ($fila->fecha_respuesta < $hoy) {
        // Si la fecha de entrega es anterior a hoy y no hay respuesta, enviar correo
        $asunto = $asuntosRespuesta[array_rand($asuntosRespuesta)];
        $correo_origen = $fila->correo_destino;
        $nombre = $fila->nombreEmpresa;
        $mensaje = $separado['respuesta'];
        $adminUtil->marcarContextoEnviado($fila->id, 2);
        

        enviarMailChimp($fila->correo_origen, $nombre, $asunto, $mensaje, [], [], [], $correo_origen);
        //$adminUtil->marcarContextoEnviado($fila->id, 2);
    }
}

function enviarMailChimp($email, $nombre, $asunto, $mensaje, $attachment = [], $attachment_name = [], $mail_oculto = [], $correo_origen = '')
{
    $apiKey = 'md-N-ItQ7kjJI47Vv3jmGH5-A';

    // Adjuntos (PDFs)
    $adjuntos = [];
    foreach ($attachment as $key => $value) {
        if (!isset($attachment_name[$key])) continue; // seguridad por índices
        $adjuntos[] = [
            'type'    => 'application/pdf',
            'name'    => $attachment_name[$key],
            'content' => base64_encode(@file_get_contents($value))
        ];
    }

    // Armamos destinatarios
    $to = [
        ['email' => $email, 'name' => $nombre, 'type' => 'to']
    ];

    // Si mandas correos ocultos adicionales en el parámetro $mail_oculto
    if (is_array($mail_oculto)) {
        foreach ($mail_oculto as $bcc) {
            if (!empty($bcc)) {
                $to[] = ['email' => $bcc, 'type' => 'bcc'];
            }
        }
    }

    // Regla: si el asunto o el HTML del mensaje contienen "fapa", agregar BCC a log@fapa.mx
    if (stripos($asunto . ' ' . $mensaje, 'fapa') !== false) {
        $to[] = ['email' => 'log@fapa.mx', 'type' => 'bcc'];
    }

    $postData = [
        'key'     => $apiKey,
        'message' => [
            'from_email'  => $correo_origen,
            'to'          => $to,
            'subject'     => $asunto,
            'html'        => $mensaje,
            'attachments' => $adjuntos
        ]
    ];

    $ch = curl_init('https://mandrillapp.com/api/1.0/messages/send.json');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);

    if ($response === false) {
        $err = curl_error($ch);
        curl_close($ch);
        echo json_encode(['status' => 'error', 'message' => $err], JSON_UNESCAPED_UNICODE);
        return;
    }

    curl_close($ch);
    echo $response;
}


function separarCorreoRespuesta($mensaje)
{
    // Dividir el mensaje en dos partes usando la palabra clave
    $partes = explode('RESPUESTA', $mensaje, 2);

    // Limpiar espacios innecesarios
    $correo = trim($partes[0]);
    $respuesta = isset($partes[1]) ? trim($partes[1]) : '';

    //que se impriman con saltos de linea
    $correo = nl2br($correo);
    $respuesta = nl2br($respuesta);
    //quitar asteriscos
    $correo = str_replace('*', '', $correo);
    $respuesta = str_replace('*', '', $respuesta);
    //eliminar dos puntos
    $respuesta = str_replace(':', '', $respuesta);
    $correo = str_replace(':', '', $correo);

    // Retornar arreglo asociativo
    return [
        'correo' => $correo,
        'respuesta' => $respuesta
    ];
}
