<?php 
session_start();
include "adminProveedores.php";
include "adminEmpresas.php";

$accion = $_POST['accion'];

$casoAgregar = "agregar";
$casoModificar = "modificar";
$casoEliminar = "eliminar";
$casoReporte = "reporte";
$casoReporteDisp = "reporteDisp";



function agregarProveedor(){
    $adminProveedores = new AdministradorProveedores();
    $id_empresa = $_POST['id_empresa'];
    $id_proveedor = $_POST['id_proveedor'];
    $porcentaje_sugerido = $_POST['porcentaje_sugerido'];
    $adminProveedores->creaProveedor( $id_empresa, $id_proveedor, $porcentaje_sugerido);
    $mensaje = array();
    $mensaje['mensaje'] = "Proveedor agregado";
    $mensaje['status'] = "success";
    $mensaje['submensaje']='exito';
    echo json_encode($mensaje);
}
function eliminarProveedor(){
    $id=$_POST['id'];
    $adminProveedores= new AdministradorProveedores();
    $adminProveedores->eliminarProveedor($id);
    $mensaje=array ();
    $mensaje['status']='success';
    $mensaje['mensaje']='El proveedor se ha eliminado con exito';
    $mensaje['submensaje']='exito';
    echo json_encode($mensaje);

}
function modificarProveedor(){
    $adminProveedores = new AdministradorProveedores();
    $id = $_POST['id'];
    $id_proveedor = $_POST['id_proveedor'];
    $id_empresa = $_POST['id_empresa'];
    $porcentaje_sugerido = $_POST['porcentaje_sugerido'];
    $adminProveedores->actualizarProveedor($id, $id_empresa , $id_proveedor, $porcentaje_sugerido);
    $mensaje['mensaje'] = "Proveedor modificado";
    $mensaje['status'] = "success";
    $mensaje['submensaje']='exito';
    echo json_encode($mensaje);
}

function reporte(){
    $adminProveedores = new AdministradorProveedores();
    $adminEmpresas = new AdminEmpresas();
    $empresa = $adminEmpresas->dameEmpresaLite($_POST['id']);
    $reporte = $adminProveedores->dameCalculadora($empresa->rfc, $_POST['dinero']);
    $total = 0;
    $porcentajeTotal = 0;
    $indiceUltimo = 0;
    for($i=0; $i<(count($reporte) -1); $i++){
        $total += $reporte[$i]->total;
        $porcentajeTotal += $reporte[$i]->porcentaje_calculado;
        $indiceUltimo = $i;
    }
    $reporte[$indiceUltimo+1]->total = $_POST['dinero'] - $total;
    $reporte[$indiceUltimo+1]->porcentaje_calculado = 100 - $porcentajeTotal;


    echo json_encode($reporte);
}

function reporteDisp(){
    $monto = $_POST['monto'];
    $unidades = $_POST['unidades'];
   // Calcular el monto base y la variación permitida
   $montoBase = $monto / $unidades;
   $variacion = 0.05 * $montoBase;
   
   // Crear un array para almacenar los montos y los porcentajes
   $montos = array();
   $porcentajes = array();
   
   // Inicializar la suma total de los montos generados
   $sumaMontos = 0;

   // Generar montos con variación aleatoria
   for ($i = 0; $i < $unidades; $i++) {
       if ($i == $unidades - 1) {
           // Asegurar que el último monto ajuste la suma total
           $montos[$i] = $monto - $sumaMontos;
       } else {
           $montoRandom = $montoBase + mt_rand(-$variacion * 100, $variacion * 100) / 100;
           $montos[$i] = round($montoRandom, 2); // Redondear a 2 decimales
           $sumaMontos += $montos[$i];
       }
       // Calcular el porcentaje usado para este monto
       $porcentajes[$i] = round(($montos[$i] / $montoBase - 1) * 100, 2);
   }
   
   // Ajustar los montos para que sumen exactamente el monto dado
   $diferencia = $monto - array_sum($montos);
   $montos[0] += $diferencia;

   // Actualizar el porcentaje del primer monto después del ajuste
   $porcentajes[0] = round(($montos[0] / $montoBase - 1) * 100, 2);

   // Crear el resultado final con índices y porcentajes
   $resultado = array();
   $total = 0;
   $porcentajesT = 0;
   foreach ($montos as $indice => $monto) {
       $resultado[] = array(
           'nombre' => $indice + 1,
           'monto' => $monto,
           'porcentaje' => $porcentajes[$indice],
           'sub_montos' => subDividirMontos($monto)

       );
         $total += $monto;
            $porcentajesT += $porcentajes[$indice];
   }
    $resultado[] = array(
         'nombre' => 'Total',
         'monto' => $total,
         'porcentaje' => $porcentajesT
    );
   
   echo json_encode($resultado);
}



function subDividirMontos($monto){
        $items = $_POST['cuentas'];
        $items = explode(",", $items);

        // Calcular el número de unidades
        $unidades = count($items);
    
        // Calcular el monto base y la variación permitida
        $montoBase = $monto / $unidades;
        $variacion = 0.4 * $montoBase;
        
        // Crear un array para almacenar los montos y los porcentajes
        $montos = array();
        $porcentajes = array();
        
        // Inicializar la suma total de los montos generados
        $sumaMontos = 0;
    
        // Generar montos con variación aleatoria
        for ($i = 0; $i < $unidades; $i++) {
            if ($i == $unidades - 1) {
                // Asegurar que el último monto ajuste la suma total
                $montos[$i] = $monto - $sumaMontos;
            } else {
                $montoRandom = $montoBase + mt_rand(-$variacion * 100, $variacion * 100) / 100;
                $montos[$i] = round($montoRandom, 2); // Redondear a 2 decimales
                $sumaMontos += $montos[$i];
            }
            // Calcular el porcentaje usado para este monto
            $porcentajes[$i] = round(($montos[$i] / $montoBase - 1) * 100, 2);
        }
        
        // Ajustar los montos para que sumen exactamente el monto dado
        $diferencia = $monto - array_sum($montos);
        $montos[0] += $diferencia;
    
        // Actualizar el porcentaje del primer monto después del ajuste
        $porcentajes[0] = round(($montos[0] / $montoBase - 1) * 100, 2);
    
        // Crear el resultado final con los nombres y montos
        $resultado = array();
        $total = 0;
        $porcentajesT = 0;
        foreach ($items as $indice => $nombre) {
            $resultado[] = array(
                'nombre' => $nombre,
                'monto' => $montos[$indice],
                'porcentaje' => $porcentajes[$indice]
            );
            $total += $montos[$indice];
            $porcentajesT += $porcentajes[$indice];
        }
        
        // Agregar el total al resultado
        // $resultado[] = array(
        //     'nombre' => 'Total',
        //     'monto' => $total,
        //     'porcentaje' => $porcentajesT
        // );

        return $resultado;
}



switch($accion){
    case $casoAgregar: agregarProveedor();
    break;
    case $casoEliminar: eliminarProveedor();
    break;
    case $casoModificar: modificarProveedor();
    break;
    case $casoReporte: reporte();
    break;
    case $casoReporteDisp: reporteDisp();
    break;
}

