<?php
function convertHtmlToText($html) {
  // Elimina las etiquetas HTML y convierte las entidades HTML a caracteres
  $text = strip_tags($html);
  $text = html_entity_decode($text, ENT_QUOTES | ENT_HTML5, 'UTF-8');

  // Quita los espacios en blanco múltiples y los reemplaza con un solo espacio
  $text = preg_replace('/\s+/', ' ', $text);
  return $text;
}

function getEmails($hostname, $username, $password) {
  // Conéctate al servidor IMAP
  $inbox = imap_open($hostname, $username, $password) or die('Cannot connect to mail server: ' . imap_last_error());

  // Número de correos a obtener (ajusta según tus necesidades)
  $numMessages = 10;
  
  // Obtén los correos electrónicos
  $emails = imap_search($inbox, 'ALL');
  
  if($emails) {
      // Ordenar los correos más recientes primero
      rsort($emails);

      // Inicializar el array para los correos formateados
      $formattedEmails = [];
      
      // Limitar a los primeros $numMessages correos
      $emails = array_slice($emails, 0, $numMessages);
      
      foreach($emails as $email_number) {
          $overview = imap_fetch_overview($inbox, $email_number, 0);
          $structure = imap_fetchstructure($inbox, $email_number);
          $plainMessage = '';

          if(isset($structure->parts) && count($structure->parts)) {
              foreach($structure->parts as $i => $part) {
                  if($part->type == 0) {
                      $partBody = imap_fetchbody($inbox, $email_number, $i + 1);
                      if(strtolower($part->subtype) == 'plain') {
                          $plainMessage .= $partBody;
                      } elseif(strtolower($part->subtype) == 'html') {
                          $plainMessage .= convertHtmlToText($partBody);
                      }
                  }
              }
          } else {
              // Para correos no multipart
              $messageBody = imap_body($inbox, $email_number);
              if($structure->subtype == 'PLAIN') {
                  $plainMessage = $messageBody;
              } elseif($structure->subtype == 'HTML') {
                  $plainMessage = convertHtmlToText($messageBody);
              }
          }

          // Decodificar mensaje si está en base64 o quoted-printable
          if ($structure->encoding == 3) {
              $plainMessage = base64_decode($plainMessage);
          } elseif ($structure->encoding == 4) {
              $plainMessage = quoted_printable_decode($plainMessage);
          }

          // Agregar el correo al array formateado
          $formattedEmails[] = [
              'id' => $email_number,
              'path' => 'profile-15.jpeg',
              'firstName' => 'Unknown', // Esto debería ser extraído del remitente
              'lastName' => 'Unknown', // Esto debería ser extraído del remitente
              'email' => $overview[0]->from,
              'date' => new DateTime($overview[0]->date),
              'time' => date('h:i A', strtotime($overview[0]->date)),
              'title' => $overview[0]->subject,
              'displayDescription' => substr($plainMessage, 0, 100),
              'type' => 'inbox',
              'isImportant' => false,
              'isStar' => false,
              'group' => 'social',
              'isUnread' => $overview[0]->seen ? false : true,
              'attachments' => [], // No manejamos adjuntos en esta versión
              'description' => nl2br($plainMessage), // Convierte saltos de línea a <br> para mantener formato en HTML
          ];
      }
  }
  
  // Cierra la conexión IMAP
  imap_close($inbox);

  return $formattedEmails;
}

// Uso de la función
$hostname = '{mail.sistema16.com:993/imap/ssl}INBOX';
$username = 'asielv2@10h.mx';
$password = '+u?j8#O46wAr';

//echo var_dump(getEmails($hostname, $username, $password));
?>