<?php

include_once('../../conectorBDS14.php');



//INSERT INTO `pagos`(`id`, `nombre`, `monto`, `factura`, `empresa`, `status`, `fecha_asignacion`, `fecha_operacion`, `hora_operacion`, `fecha_captura`, `tipo_movimiento`, `saldo_acreditable`, `banco`, `saldo`, `usuario_registra`, `id_factura`, `fecha_banco`, `detalle`, `nombre_corto`, `tipo_captura`, `descripcion`, `descripcion_detallada`, `id_captura`, `cliente_origen_comision`, `origen_traspaso`, `destino_traspaso`, `id_captura_edo_cta`, `tipo_factura`, `notificado`)


class MovimientoStp
{
  //INSERT INTO `pre_ejecuta_plantilla`(`id`, `plantilla`, `cliente`, `nombre`, `tarjeta`, `clabe`, `institucion`, `monto`, `fecha_creacion`, `fecha_ejecucion`, `status`, `status_banxico`, `id_stp`, `folio`, `estado`, `causa_devolucion`, `time_liquidacion`, `status_pre`, `consulta_cep`, `cep`, `espera_liquidacion`)
  public $id;
  public $plantilla;
  public $cliente;
  public $nombre;
  public $tarjeta;
  public $clabe;
  public $institucion;
  public $monto;
  public $fecha_creacion;
  public $fecha_ejecucion;
  public $status;
  public $status_banxico;
  public $id_stp;
  public $folio;
  public $estado;
  public $causa_devolucion;
  public $time_liquidacion;
  public $status_pre;
  public $consulta_cep;
  public $cep;
  public $espera_liquidacion;
  public $accion;
  public $status_notificado;
  public $concepto;
  public $existeEnHistorial;
  public $resultadoSTP;

  public function __construct($id, $plantilla, $cliente, $nombre, $tarjeta, $clabe, $institucion, $monto, $fecha_creacion, $fecha_ejecucion, $status, $status_banxico, $id_stp, $folio, $estado, $causa_devolucion, $time_liquidacion, $status_pre, $consulta_cep, $cep, $espera_liquidacion)
  {
    $this->id = $id;
    $this->plantilla = $plantilla;
    $this->cliente = $cliente;
    $this->nombre = $nombre;
    $this->tarjeta = $tarjeta;
    $this->clabe = $clabe;
    $this->institucion = $institucion;
    $this->monto = $monto;
    $this->fecha_creacion = $fecha_creacion;
    $this->fecha_ejecucion = $fecha_ejecucion;
    $this->status = $status;
    $this->status_banxico = $status_banxico;
    $this->id_stp = $id_stp;
    $this->folio = $folio;
    $this->estado = $estado;
    $this->causa_devolucion = $causa_devolucion;
    $this->time_liquidacion = $time_liquidacion;
    $this->status_pre = $status_pre;
    $this->consulta_cep = $consulta_cep;
    $this->cep = $cep;
    $this->espera_liquidacion = $espera_liquidacion;
  }
}

class MovStpConsig
{
  //SELECT `id`, `numero_op`, `clave_rastreo`, `concepto_pago`, `cuenta_beneficiario`, `cuenta_ordenante`, `empresa`, `estado`, `fecha_op`, `monto`, `nombre_beneficiario`, `nombre_ordenante`, `cep`, `id_op`, `fecha_ingresa` FROM `stp_his_api`
  public $id;
  public $numero_op;
  public $clave_rastreo;
  public $concepto_pago;
  public $cuenta_beneficiario;
  public $cuenta_ordenante;
  public $empresa;
  public $estado;
  public $fecha_op;
  public $monto;
  public $nombre_beneficiario;
  public $nombre_ordenante;
  public $cep;
  public $id_op;
  public $fecha_ingresa;


  public function __construct($id, $numero_op, $clave_rastreo, $concepto_pago, $cuenta_beneficiario, $cuenta_ordenante, $empresa, $estado, $fecha_op, $monto, $nombre_beneficiario, $nombre_ordenante, $cep, $id_op, $fecha_ingresa)
  {
    $this->id = $id;
    $this->numero_op = $numero_op;
    $this->clave_rastreo = $clave_rastreo;
    $this->concepto_pago = $concepto_pago;
    $this->cuenta_beneficiario = $cuenta_beneficiario;
    $this->cuenta_ordenante = $cuenta_ordenante;
    $this->empresa = $empresa;
    $this->estado = $estado;
    $this->fecha_op = $fecha_op;
    $this->monto = $monto;
    $this->nombre_beneficiario = $nombre_beneficiario;
    $this->nombre_ordenante = $nombre_ordenante;
    $this->cep = $cep;
    $this->id_op = $id_op;
    $this->fecha_ingresa = $fecha_ingresa;
  }
}


class Pago
{
  public $id;
  public $nombre;
  public $monto;
  public $factura;
  public $empresa;
  public $status;
  public $fecha_asignacion;
  public $fecha_operacion;
  public $hora_operacion;
  public $fecha_captura;
  public $tipo_movimiento;
  public $saldo_acreditable;
  public $banco;
  public $saldo;
  public $usuario_registra;
  public $id_factura;
  public $fecha_banco;
  public $detalle;
  public $nombre_corto;
  public $tipo_captura;
  public $descripcion;
  public $descripcion_detallada;
  public $id_captura;
  public $cliente_origen_comision;
  public $origen_traspaso;
  public $destino_traspaso;
  public $id_captura_edo_cta;
  public $tipo_factura;
  public $notificado;
  public $nombreEmpresa;
  public $bancoNombreCorto;
  public $clienteOrigenComisionNombre;
  public $nombreCliente;
  public $clienteAsignado;
  public $fechaAsignacionRaw;
  public $uuid_factura;
  public $total_factura;
  public $certificado_factura;
  public $usuario_asigna;
  public $suma_muerte;
  public $idCliente;
  public $uuid;
  public $token;
  public $folio;
  public $serie;
  public $total_iva;
  public $restante;
  public $folios_asociados;


  public function __construct($id, $nombre, $monto, $factura, $empresa, $status, $fecha_asignacion, $fecha_operacion, $hora_operacion, $fecha_captura, $tipo_movimiento, $saldo_acreditable, $banco, $saldo, $usuario_registra, $id_factura, $fecha_banco, $detalle, $nombre_corto, $tipo_captura, $descripcion, $descripcion_detallada, $id_captura, $cliente_origen_comision, $origen_traspaso, $destino_traspaso, $id_captura_edo_cta, $tipo_factura, $notificado)
  {
    $this->id = $id;
    $this->nombre = $nombre;
    $this->monto = $monto;
    $this->factura = $factura;
    $this->empresa = $empresa;
    $this->status = $status;
    $this->fecha_asignacion = $fecha_asignacion;
    $this->fecha_operacion = $fecha_operacion;
    $this->hora_operacion = $hora_operacion;
    $this->fecha_captura = $fecha_captura;
    $this->tipo_movimiento = $tipo_movimiento;
    $this->saldo_acreditable = $saldo_acreditable;
    $this->banco = $banco;
    $this->saldo = $saldo;
    $this->usuario_registra = $usuario_registra;
    $this->id_factura = $id_factura;
    $this->fecha_banco = $fecha_banco;
    $this->detalle = $detalle;
    $this->nombre_corto = $nombre_corto;
    $this->tipo_captura = $tipo_captura;
    $this->descripcion = $descripcion;
    $this->descripcion_detallada = $descripcion_detallada;
    $this->id_captura = $id_captura;
    $this->cliente_origen_comision = $cliente_origen_comision;
    $this->origen_traspaso = $origen_traspaso;
    $this->destino_traspaso = $destino_traspaso;
    $this->id_captura_edo_cta = $id_captura_edo_cta;
    $this->tipo_factura = $tipo_factura;
    $this->notificado = $notificado;
  }
}


class CapturaEdo
{
  //SELECT `id`, `id_captura`, `fecha_operacion`, `hora_operacion`, `fecha`, `referencia`, `descripcion`, `cod_transac`, `sucursal`, `deposito`, `retiro`, `saldo`, `movimiento`, `descrip_det`, `cheque`, `referencia_interb`, `tipo_movimiento`, `fecha_sistema`, `asignado`, `cliente_asignado`, `facturado`, `cuenta` FROM `captura_edo_cta` WHERE 1
  public $id;
  public $id_captura;
  public $fecha_operacion;
  public $hora_operacion;
  public $fecha;
  public $referencia;
  public $descripcion;
  public $cod_transac;
  public $sucursal;
  public $deposito;
  public $retiro;
  public $saldo;
  public $movimiento;
  public $descrip_det;
  public $cheque;
  public $referencia_interb;
  public $tipo_movimiento;
  public $fecha_sistema;
  public $asignado;
  public $cliente_asignado;
  public $facturado;
  public $cuenta;
  public $id_pago;

  public function __construct($id, $id_captura, $fecha_operacion, $hora_operacion, $fecha, $referencia, $descripcion, $cod_transac, $sucursal, $deposito, $retiro, $saldo, $movimiento, $descrip_det, $cheque, $referencia_interb, $tipo_movimiento, $fecha_sistema, $asignado, $cliente_asignado, $facturado, $cuenta)
  {
    $this->id = $id;
    $this->id_captura = $id_captura;
    $this->fecha_operacion = $fecha_operacion;
    $this->hora_operacion = $hora_operacion;
    $this->fecha = $fecha;
    $this->referencia = $referencia;
    $this->descripcion = $descripcion;
    $this->cod_transac = $cod_transac;
    $this->sucursal = $sucursal;
    $this->deposito = $deposito;
    $this->retiro = $retiro;
    $this->saldo = $saldo;
    $this->movimiento = $movimiento;
    $this->descrip_det = $descrip_det;
    $this->cheque = $cheque;
    $this->referencia_interb = $referencia_interb;
    $this->tipo_movimiento = $tipo_movimiento;
    $this->fecha_sistema = $fecha_sistema;
    $this->asignado = $asignado;
    $this->cliente_asignado = $cliente_asignado;
    $this->facturado = $facturado;
    $this->cuenta = $cuenta;
  }
}


class RelacionPago
{
  public $id;
  public $id_pago;
  public $id_retiro;

  public function __construct($id, $id_pago, $id_retiro)
  {
    $this->id = $id;
    $this->id_pago = $id_pago;
    $this->id_retiro = $id_retiro;
  }
}


class Ajuste{
  public $id;
  public $monto;
  public $id_usuario;
  public $fecha_inserta;
  public $notificado;
  public function __construct($id, $monto, $id_usuario, $fecha_inserta, $notificado){
    $this->id = $id;
    $this->monto = $monto;
    $this->id_usuario = $id_usuario;
    $this->fecha_inserta = $fecha_inserta;
    $this->notificado = $notificado;
  }
}
//SELECT id, monto, id_usuario, fecha_inserta, notificado FROM iohanes_14.alertas_ajuste;



class AdministradorPagos extends conectorS14
{


  public function fechaComoCadena($fecha)
  {
    $dia = substr($fecha, 8, 2);
    $mes = substr($fecha, 5, 2);
    $anio = substr($fecha, 0, 4);

    switch ($mes) {
      case "01":
        $mes = 'Enero';
        break;
      case "02":
        $mes = 'Febrero';
        break;
      case "03":
        $mes = 'Marzo';
        break;
      case  "04":
        $mes = 'Abril';
        break;
      case "05":
        $mes = 'Mayo';
        break;
      case "06":
        $mes = 'Junio';
        break;
      case "07":
        $mes = 'Julio';
        break;
      case "08":
        $mes = 'Agosto';
        break;
      case "09":
        $mes = 'Septiembre';
        break;
      case "10":
        $mes = 'Octubre';
        break;
      case "11":
        $mes = 'Noviembre';
        break;
      case "12":
        $mes = 'Diciembre';
        break;
      default:
        $mes = "NA";
        $dia = "NA";
        $anio = "NA";
    }
    return $dia . '/' . $mes . '/' . $anio;
  }




  public function eliminaCapturaMan($captura)
  {
    $capturaId = intval($captura);
    if ($capturaId > 0) {
      $sql1 = "DELETE FROM `captura` WHERE id = $capturaId";
      $sql2 = "DELETE FROM `pagos` WHERE id_captura = $capturaId";
      $sql3 = "DELETE FROM `captura_edo_cta` WHERE id_captura = $capturaId";
      $result1 = $this->ejecutar($sql1);
      $result2 = $this->ejecutar($sql2);
      $result3 = $this->ejecutar($sql3);
      return 1;
    } else {
      return 0;
    }
  }

  public function damePagosCapMan()
  {
    $sql = "SELECT pagos.*, empresas.razon as empresa_nom, bancos.nombre_corto as banco_nombre FROM pagos 
    inner join empresas
    on empresas.id = pagos.empresa
    inner join captura
    on captura.id = pagos.id_captura
    inner join bancos
    on bancos.id = captura.nombre_corto
    where tipo_captura = 'Manual' and pagos.banco != '99' order by pagos.id desc limit 1000;";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreEmpresa = $fila['empresa_nom'];
      $pago->nombre_corto = $fila['banco_nombre'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function dameCapturasEdo()
  {
    $sql = "SELECT * FROM captura_edo_cta order by id desc limit 10000 ";
    $result = $this->ejecutar($sql);
    $capturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $captura = new CapturaEdo($fila['id'], $fila['id_captura'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha'], $fila['referencia'], $fila['descripcion'], $fila['cod_transac'], $fila['sucursal'], $fila['deposito'], $fila['retiro'], $fila['saldo'], $fila['movimiento'], $fila['descrip_det'], $fila['cheque'], $fila['referencia_interb'], $fila['tipo_movimiento'], $fila['fecha_sistema'], $fila['asignado'], $fila['cliente_asignado'], $fila['facturado'], $fila['cuenta']);
      array_push($capturas, $captura);
    }
    return $capturas;
  }

  public function dameAjustesNoNotificados()
  {
    $sql = "SELECT * FROM `alertas_ajuste` where notificado = 0 order by id desc limit 1000";
    $result = $this->ejecutar($sql);
    $ajustes = array();
    while ($fila = mysqli_fetch_array($result)) {
      $ajuste = new Ajuste($fila['id'], $fila['monto'], $fila['id_usuario'], $fila['fecha_inserta'], $fila['notificado']);
      array_push($ajustes, $ajuste);
    }
    return $ajustes;
  }

  public function dameAjustesNoNotificadosUsuario($id_usuario)
  {
    $sql = "SELECT * FROM `alertas_ajuste` where notificado = 0 and id_usuario = $id_usuario order by id desc limit 1000";
    $result = $this->ejecutar($sql);
    $ajustes = array();
    while ($fila = mysqli_fetch_array($result)) {
      $ajuste = new Ajuste($fila['id'], $fila['monto'], $fila['id_usuario'], $fila['fecha_inserta'], $fila['notificado']);
      array_push($ajustes, $ajuste);
    }
    return $ajustes;
  }

  public function marcarNotificadoAjuste($id)
  {
    $sql = "UPDATE alertas_ajuste SET notificado = 1 WHERE id = $id";
    $result = $this->ejecutar($sql);
    return $result;
  }


  public function dameConsiliacion()
  {
    $sql = "SELECT * FROM `stp_his_api` order by id desc limit 1000";
    $result = $this->ejecutar($sql);
    $consiliaciones = array();
    while ($fila = mysqli_fetch_array($result)) {
      $consiliacion = new MovStpConsig($fila['id'], $fila['numero_op'], $fila['clave_rastreo'], $fila['concepto_pago'], $fila['cuenta_beneficiario'], $fila['cuenta_ordenante'], $fila['empresa'], $fila['estado'], $fila['fecha_op'], $fila['monto'], $fila['nombre_beneficiario'], $fila['nombre_ordenante'], $fila['cep'], $fila['id_op'], $fila['fecha_ingresa']);
      array_push($consiliaciones, $consiliacion);
    }
    return $consiliaciones;
  }



  public function guardarDescripcionDetallada($id, $descripcion)
  {
    $sql = "UPDATE pagos SET descripcion_detallada = '$descripcion' WHERE id = '$id'";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function insertaRelacionPago($id_pago, $id_retiro, $monto)
  {
    $sql = "INSERT INTO `rel_retiro_pago`(`id_pago`, `id_retiro`, `monto`) VALUES ('$id_pago','$id_retiro', '$monto')";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function dameRelacionPago()
  {
    $sql = "SELECT * FROM `rel_retiro_pago`";
    $result = $this->ejecutar($sql);
    $relaciones = array();
    while ($fila = mysqli_fetch_array($result)) {
      $relacion = new RelacionPago($fila['id'], $fila['id_pago'], $fila['id_retiro']);
      array_push($relaciones, $relacion);
    }
    return $relaciones;
  }



  public function insertaTraspaso($monto, $cliente_origen, $cliente_destino, $detalle, $usuario_registra)
  {
    $fecha_captura = date("Y-m-d");
    $hora = date("H:i:s");
    $banco = "Manual";
    $status = "asignado";
    $saldo_recibe = $this->dameSaldoCliente($cliente_destino);
    $saldo_recibe = $saldo_recibe + $monto;
    $saldo_envia = $this->dameSaldoCliente($cliente_origen);
    $saldo_envia = $saldo_envia - $monto;
    $monto_envia_c = -$monto;
    $usuario_registra = intval($usuario_registra);

    $query_recibe = "INSERT INTO pagos (nombre,monto,factura,empresa,status,fecha_asignacion,fecha_captura,tipo_movimiento,saldo_acreditable,banco,saldo,usuario_registra,fecha_banco,
		detalle,nombre_corto,tipo_captura,descripcion,origen_traspaso,destino_traspaso,cliente_origen_comision) VALUES 
		($cliente_destino,'$monto','NA','99','$status','$fecha_captura','$fecha_captura','Deposito','$monto',99,'$saldo_recibe','$usuario_registra','$fecha_captura',
		'$detalle','99','Manual','Traspaso','$cliente_origen','$cliente_destino','$cliente_origen')";

    $query_envia = "INSERT INTO pagos (nombre,monto,factura,empresa,status,fecha_asignacion,fecha_captura,tipo_movimiento,saldo_acreditable,banco,saldo,usuario_registra,fecha_banco,
		detalle,nombre_corto,tipo_captura,descripcion,origen_traspaso,destino_traspaso,cliente_origen_comision) VALUES 
		($cliente_origen,'$monto_envia_c','NA','99','$status','$fecha_captura','$fecha_captura','Retiro','$monto_envia_c',99,'$saldo_envia','$usuario_registra','$fecha_captura',
		'$detalle','99','Manual','Traspaso','$cliente_origen','$cliente_destino','$cliente_destino')";

    $result_recibe = $this->ejecutar($query_recibe);
    $result_envia = $this->ejecutar($query_envia);
    return 1;
  }


  public function dameSaldoCliente($cliente)
  {
    $sql = "select sum(saldo_acreditable) as suma from pagos where nombre='$cliente'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['suma'];
  }


  public function dameReportePorCuenta($cuenta)
  {
    $sql = "SELECT captura_edo_cta.* FROM captura_edo_cta 
    where cuenta=$cuenta order by id desc limit 1000;";
    $result = $this->ejecutar($sql);
    $capturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $captura = new CapturaEdo($fila['id'], $fila['id_captura'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha'], $fila['referencia'], $fila['descripcion'], $fila['cod_transac'], $fila['sucursal'], $fila['deposito'], $fila['retiro'], $fila['saldo'], $fila['movimiento'], $fila['descrip_det'], $fila['cheque'], $fila['referencia_interb'], $fila['tipo_movimiento'], $fila['fecha_sistema'], $fila['asignado'], $fila['cliente_asignado'], $fila['facturado'], $fila['cuenta']);
      $captura->id_pago = $fila['pago_id'];
      array_push($capturas, $captura);
    }
    return $capturas;
  }


  public function dameReportePorCuentaFechas($cuenta, $fechaInicio, $fechaFin)
  {
    $sql = "SELECT captura_edo_cta.* FROM captura_edo_cta 
    where cuenta=$cuenta and fecha <= '$fechaFin' and fecha >= '$fechaInicio' order by fecha asc limit 1000;";
    $result = $this->ejecutar($sql);
    $capturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $captura = new CapturaEdo($fila['id'], $fila['id_captura'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha'], $fila['referencia'], $fila['descripcion'], $fila['cod_transac'], $fila['sucursal'], $fila['deposito'], $fila['retiro'], $fila['saldo'], $fila['movimiento'], $fila['descrip_det'], $fila['cheque'], $fila['referencia_interb'], $fila['tipo_movimiento'], $fila['fecha_sistema'], $fila['asignado'], $fila['cliente_asignado'], $fila['facturado'], $fila['cuenta']);
      $captura->id_pago = $fila['pago_id'];
      array_push($capturas, $captura);
    }
    return $capturas;
  }
  public function dameReportePorCuentaPagos($cuenta)
  {
    $sql = "SELECT * FROM pagos where empresa = $cuenta order by id desc limit 10000 ";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      array_push($pagos, $pago);
    }
    return $pagos;
  }


  public function dameReportePorCuentaFechasU($cuenta, $fechaInicio, $fechaFin)
  {
    $sql = "SELECT captura_edo_cta.* FROM captura_edo_cta 
    where cuenta=$cuenta and fecha <= '$fechaFin' and fecha >= '$fechaInicio' order by fecha asc;";
    $result = $this->ejecutar($sql);
    $capturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $captura = new CapturaEdo($fila['id'], $fila['id_captura'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha'], $fila['referencia'], $fila['descripcion'], $fila['cod_transac'], $fila['sucursal'], $fila['deposito'], $fila['retiro'], $fila['saldo'], $fila['movimiento'], $fila['descrip_det'], $fila['cheque'], $fila['referencia_interb'], $fila['tipo_movimiento'], $fila['fecha_sistema'], $fila['asignado'], $fila['cliente_asignado'], $fila['facturado'], $fila['cuenta']);
      $captura->id_pago = $fila['pago_id'];
      array_push($capturas, $captura);
    }
    return $capturas;
  }


  public function agregarPago($nombre,  $monto, $factura, $empresa, $status, $fecha_asignacion, $fecha_operacion, $hora_operacion, $fecha_captura, $tipo_movimiento, $saldo_acreditable, $banco, $saldo, $usuario_registra, $id_factura, $fecha_banco, $detalle, $nombre_corto, $tipo_captura, $descripcion, $descripcion_detallada, $id_captura, $cliente_origen_comision, $origen_traspaso, $destino_traspaso, $id_captura_edo_cta, $tipo_factura, $notificado)
  {
    $sql = "INSERT INTO pagos (nombre,  monto, factura, empresa, status, fecha_asignacion, fecha_operacion, hora_operacion, fecha_captura, tipo_movimiento, saldo_acreditable, banco, saldo, usuario_registra, id_factura, fecha_banco, detalle, nombre_corto, tipo_captura, descripcion, descripcion_detallada, id_captura, cliente_origen_comision, origen_traspaso, destino_traspaso, id_captura_edo_cta, tipo_factura, notificado) VALUES ('$nombre',  '$monto', '$factura', '$empresa', '$status', '$fecha_asignacion', '$fecha_operacion', '$hora_operacion', '$fecha_captura', '$tipo_movimiento', '$saldo_acreditable', '$banco', '$saldo', '$usuario_registra', '$id_factura', '$fecha_banco', '$detalle', '$nombre_corto', '$tipo_captura', '$descripcion', '$descripcion_detallada', '$id_captura', '$cliente_origen_comision', '$origen_traspaso', '$destino_traspaso', '$id_captura_edo_cta', '$tipo_factura', '$notificado')";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function eliminarPago($id)
  {
    $sql = "DELETE FROM pagos WHERE id = '$id'";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function asignarFactura($factura, $id)
  {
    $sql = "UPDATE pagos SET id_factura = '$factura' WHERE id = '$id'";
    $result = $this->ejecutar($sql);
    return $result;
  }

  public function damePago($id)
  {
    $sql = "select bancos.nombre_corto,pagos.nombre as id_cliente,pagos.monto,empresas.razon,empresas.id as id_razon,
    pagos.`saldo_acreditable`,pagos.fecha_banco,pagos.detalle,
    pagos.descripcion,pagos.`descripcion_detallada`,pagos.`id_captura`,pagos.id, pagos.empresa, clientes.nombre as nombre_cliente, pagos.fecha_captura, pagos.fecha_banco, pagos.status, pagos.tipo_movimiento, pagos.fecha_asignacion, pagos.fecha_operacion
    from pagos 
    left join captura on (pagos.`id_captura`=captura.id) 
    left join bancos on (bancos.id=captura.`nombre_corto`) 
    left join empresas on (empresas.id=captura.`razon`) 
    inner join clientes on (clientes.id = pagos.nombre)
    where 
    pagos.id='$id'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['razon'], $fila['status'], $this->fechaComoCadena($fila['fecha_asignacion']), $this->fechaComoCadena($fila['fecha_operacion']), $fila['hora_operacion'], $this->fechaComoCadena($fila['fecha_captura']), $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['nombre_corto'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
    $pago->nombreEmpresa = $fila['razon'];
    $pago->nombreCliente = $fila['nombre_cliente'];
    $pago->idCliente  = $fila['id_cliente'];
    return $pago;
  }


  public function dameReporteFacturas()
  {
    $sql = "select bancos.nombre_corto,pagos.monto,empresas.razon,empresas.id as id_razon,
    pagos.`saldo_acreditable`,pagos.fecha_banco,pagos.detalle,
    pagos.descripcion,pagos.`descripcion_detallada`,pagos.`id_captura`,pagos.id, pagos.empresa, clientes.nombre as nombre_cliente, 		pagos.fecha_captura, pagos.fecha_banco, pagos.status, pagos.tipo_movimiento, pagos.fecha_asignacion, pagos.fecha_operacion,
    pagos.id_factura, facturas.uuid, facturas.num_certificado, facturas.total_factura
    from pagos 
    left join captura on (pagos.`id_captura`=captura.id) 
    left join bancos on (bancos.id=captura.`nombre_corto`) 
    left join empresas on (empresas.id=captura.`razon`) 
    inner join clientes on (clientes.id = pagos.nombre)
    inner join facturas
	on facturas.id = pagos.id_factura;";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreEmpresa = $fila['razon'];
      $pago->bancoNombreCorto = $fila['nombre_corto'];
      $pago->uuid_factura = $fila['uuid'];
      $pago->total_factura = $fila['total_factura'];
      $pago->certificado_factura = $fila['num_certificado'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function damePagos()
  {
    $sql = "SELECT * FROM pagos order by id desc limit 10000 ";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function damePagosInternos()
  {
    $inicioMesAcual = date("Y-m-01");
    //menos 10 dias 
    $inicioMesAcual = date("Y-m-d", strtotime($inicioMesAcual . "-10 days"));

    $sql = "select bancos.nombre_corto,pagos.monto,empresas.razon,empresas.id as id_razon,
    pagos.`saldo_acreditable`,pagos.fecha_banco,pagos.detalle,
    pagos.descripcion,pagos.`descripcion_detallada`,pagos.`id_captura`,pagos.id, pagos.empresa
    from pagos 
    left join captura on (pagos.`id_captura`=captura.id) 
    left join bancos on (bancos.id=captura.`nombre_corto`) 
    left join empresas on (empresas.id=captura.`razon`) 
    where  nombre = 13 and fecha_asignacion >= '$inicioMesAcual' and tipo_movimiento = 'Deposito' order by id desc;";


    //$sql = "SELECT * FROM pagos where nombre = 13 and fecha_asignacion >= '$inicioMesAcual' and tipo_movimiento = 'Deposito' order by id desc";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreCliente = $fila['nombreCliente'];
      $pago->nombreEmpresa = $fila['razon'];
      $pago->clienteAsignado = $fila['cliente_asignado'];
      $pago->nombreCliente = $fila['nomb_origen_traspaso'];
      $pago->bancoNombreCorto = $fila['nombre_corto'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function damePagosClienteHoy($cliente)
  {
    $fecha = date("Y-m-d");
    //$fecha = "2023-07-07";
    $sql = "SELECT * FROM pagos where nombre='$cliente' and fecha_asignacion='$fecha' order by id desc limit 10000 ";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function damePagosTraspaso()
  {
    //$sql = "SELECT pagos.id,pagos.monto,pagos.detalle,empresas.razon,bancos.nombre_corto,fecha_asignacion,clientes.nombre as cliente_asignado, (SELECT nombre FROM clientes WHERE id=origen_traspaso) AS nomb_origen_traspaso, (SELECT nombre FROM clientes WHERE id=destino_traspaso) AS nomb_destino_traspaso,origen_traspaso,destino_traspaso FROM pagos left join empresas on (empresas.id=pagos.empresa) LEFT JOIN bancos ON (pagos.nombre_corto=bancos.id) left join clientes on (clientes.id=pagos.nombre) where tipo_captura='Manual' and descripcion='Traspaso' and tipo_movimiento='Deposito' order by pagos.id desc limit 1000;";
    //echo $sql;
    $sql = "SELECT 
    pagos.id,
    pagos.monto,
    pagos.detalle,
    empresas.razon,
    bancos.nombre_corto,
    pagos.fecha_asignacion,
    clientes.nombre AS cliente_asignado,
    (SELECT nombre FROM clientes WHERE clientes.id = pagos.origen_traspaso) AS nomb_origen_traspaso,
    (SELECT nombre FROM clientes WHERE clientes.id = pagos.destino_traspaso) AS nomb_destino_traspaso,
    pagos.origen_traspaso,
    pagos.destino_traspaso
FROM pagos
LEFT JOIN empresas ON empresas.id = pagos.empresa
LEFT JOIN bancos ON pagos.nombre_corto = bancos.id
LEFT JOIN clientes ON clientes.id = pagos.nombre
WHERE pagos.tipo_captura = 'Manual' 
    AND pagos.descripcion = 'Traspaso' 
    AND pagos.tipo_movimiento = 'Deposito'
    AND pagos.fecha_asignacion >= DATE_SUB(CURDATE(), INTERVAL 365 DAY)
    
ORDER BY pagos.id DESC limit 3000;";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_operacion']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreCliente = $fila['nombreCliente'];
      $pago->nombreEmpresa = $fila['nombreEmpresa'];
      $pago->clienteAsignado = $fila['cliente_asignado'];
      $pago->nombreCliente = $fila['nomb_origen_traspaso'];



      array_push($pagos, $pago);
    }
    return $pagos;
  }


  public function damePagosTraspasoBusqueda($criterio)
  {
    $sql = "SELECT pagos.id,pagos.monto,pagos.detalle,empresas.razon,bancos.nombre_corto,fecha_asignacion,clientes.nombre as cliente_asignado, (SELECT nombre FROM clientes WHERE id=origen_traspaso) AS nomb_origen_traspaso, (SELECT nombre FROM clientes WHERE id=destino_traspaso) AS nomb_destino_traspaso,origen_traspaso,destino_traspaso FROM pagos left join empresas on (empresas.id=pagos.empresa) LEFT JOIN bancos ON (pagos.nombre_corto=bancos.id) left join clientes on (clientes.id=pagos.nombre) where tipo_captura='Manual' and descripcion='Traspaso' and tipo_movimiento='Deposito' and (pagos.id = '$criterio' or pagos.monto = '$criterio') limit 10000;";
    //echo $sql;
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_operacion']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreCliente = $fila['nombreCliente'];
      $pago->nombreEmpresa = $fila['nombreEmpresa'];
      $pago->clienteAsignado = $fila['cliente_asignado'];
      $pago->nombreCliente = $fila['nomb_origen_traspaso'];



      array_push($pagos, $pago);
    }
    return $pagos;
  }


  public function eliminarTraspaso($id)
  {
    $sql = "DELETE FROM pagos WHERE id='$id'";
    $this->ejecutar($sql);
    $idSec = $id + 1;
    $sql = "DELETE FROM pagos WHERE id='$idSec'";
    $this->ejecutar($sql);
  }

  function damePagosPorCliente($cliente)
  {
    $sql = "select bancos.nombre_corto,pagos.monto,empresas.razon,empresas.id as id_razon,
    pagos.`saldo_acreditable`,pagos.fecha_banco,pagos.detalle,
    pagos.descripcion,pagos.`descripcion_detallada`,pagos.`id_captura`,pagos.id, pagos.empresa
    from pagos 
    left join captura on (pagos.`id_captura`=captura.id) 
    left join bancos on (bancos.id=captura.`nombre_corto`) 
    left join empresas on (empresas.id=captura.`razon`) 
    where nombre='$cliente' and tipo_movimiento<>'Retiro' and pagos.id_factura=0 and factura='Sin Facturar';";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreEmpresa = $fila['razon'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }


  function damePagosPorClienteTodo($cliente)
  {
    $sql = "select bancos.nombre_corto,pagos.monto,empresas.razon,empresas.id as id_razon,
    pagos.`saldo_acreditable`,pagos.fecha_banco,pagos.detalle,
    pagos.descripcion,pagos.`descripcion_detallada`,pagos.`id_captura`,pagos.id, pagos.empresa
    from pagos 
    left join captura on (pagos.`id_captura`=captura.id) 
    left join bancos on (bancos.id=captura.`nombre_corto`) 
    left join empresas on (empresas.id=captura.`razon`) 
    where nombre='$cliente'  and pagos.id_factura=0 and  tipo_movimiento<>'Retiro';";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['empresa'], $fila['status'], $fila['fecha_asignacion'], $fila['fecha_operacion'], $fila['hora_operacion'], $fila['fecha_captura'], $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], $fila['fecha_banco'], $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreEmpresa = $fila['razon'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }



  public function dameReporte($cliente, $fecha, $fecha_mes)
  {
    $sql = "
    select empresas.razon, empresas.id as id_empresa, bancos.nombre_corto as nombre_corto_b,clientes.nombre as cliente_origen,pagos.*, captura_edo_cta.referencia, captura_edo_cta.retiro, captura_edo_cta.deposito from pagos 
    left join clientes on (clientes.id=pagos.cliente_origen_comision) 
    left join captura on (captura.id=pagos.id_captura) 
    left join bancos on (bancos.id=captura.nombre_corto) 
    left join captura_edo_cta on captura_edo_cta.id_captura = pagos.id_captura and (pagos.monto = captura_edo_cta.deposito or pagos.monto = captura_edo_cta.retiro)
    left JOIN empresas ON (empresas.id=captura.razon) 
    where pagos.nombre='$cliente' and saldo_acreditable<>0 and fecha_asignacion>='$fecha_mes' and fecha_asignacion<='$fecha' GROUP by pagos.id order by fecha_asignacion DESC limit 500;
    
    ";
    //echo $sql;
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], "$" . number_format($fila['monto'], 2), $fila['factura'], $fila['id_empresa'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_operacion']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], ($fila['saldo_acreditable']), $fila['banco'], "$" . number_format($fila['saldo'], 2), $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'] . "{" . $fila['referencia'] . "}", $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreEmpresa = $fila['razon'];
      $pago->bancoNombreCorto = $fila['nombre_corto_b'];
      $pago->clienteOrigenComisionNombre = $fila['cliente_origen'];
      $pago->fechaAsignacionRaw = $this->fechaComoCadena($fila['fecha_asignacion']);
      array_push($pagos, $pago);
    }
    return $pagos;
  }


  public function dameReporteExel($cliente, $fecha, $fecha_mes)
  {
    $sql = "
    select empresas.razon, empresas.id as id_empresa, bancos.nombre_corto as nombre_corto_b,clientes.nombre as cliente_origen,pagos.*, captura_edo_cta.referencia, captura_edo_cta.retiro, captura_edo_cta.deposito from pagos 
    left join clientes on (clientes.id=pagos.cliente_origen_comision) 
    left join captura on (captura.id=pagos.id_captura) 
    left join bancos on (bancos.id=captura.nombre_corto) 
    left join captura_edo_cta on captura_edo_cta.id_captura = pagos.id_captura and (pagos.monto = captura_edo_cta.deposito or pagos.monto = captura_edo_cta.retiro)
    left JOIN empresas ON (empresas.id=captura.razon) 
    where pagos.nombre='$cliente' and saldo_acreditable<>0 and fecha_asignacion>='$fecha_mes' and fecha_asignacion<='$fecha' GROUP by pagos.id order by fecha_asignacion DESC;
    
    ";
    //echo $sql;
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], "$" . number_format($fila['monto'], 2), $fila['factura'], $fila['id_empresa'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_operacion']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], ($fila['saldo_acreditable']), $fila['banco'], "$" . number_format($fila['saldo'], 2), $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'] . "{" . $fila['referencia'] . "}", $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreEmpresa = $fila['razon'];
      $pago->bancoNombreCorto = $fila['nombre_corto_b'];
      $pago->clienteOrigenComisionNombre = $fila['cliente_origen'];
      $pago->fechaAsignacionRaw = $this->fechaComoCadena($fila['fecha_asignacion']);
      array_push($pagos, $pago);
    }
    return $pagos;
  }



  public function dameReporteConta($cliente, $fecha, $fecha_mes)
  {
    $palabrasReservadas = array();
    $palabrasReservadas[] = "traspaso";
    $palabrasReservadas[] = "impuesto";
    $palabrasReservadas[] = "sat";
    $palabrasReservadas[] = "sipare";
    $palabrasReservadas[] = "nomina";

    $sql = "
    select empresas.razon, empresas.id as id_empresa, bancos.nombre_corto as nombre_corto_b,clientes.nombre as cliente_origen,pagos.*, captura_edo_cta.referencia, captura_edo_cta.retiro, captura_edo_cta.deposito 
    from pagos 
    inner join clientes on (clientes.id=pagos.cliente_origen_comision) 
    inner join captura on (captura.id=pagos.id_captura) 
    left join bancos on (bancos.id=captura.nombre_corto) 
    left join facturas on facturas.id_pago = pagos.id
    left join captura_edo_cta on captura_edo_cta.id_captura = pagos.id_captura and (pagos.monto = captura_edo_cta.deposito or pagos.monto = captura_edo_cta.retiro)
    left JOIN empresas ON (empresas.id=captura.razon) 
    where facturas.id_pago is null and pagos.tipo_movimiento = 'Deposito' and  pagos.nombre='$cliente' and saldo_acreditable<>0 and fecha_asignacion>='$fecha_mes' and fecha_asignacion<='$fecha' GROUP by pagos.id order by fecha_asignacion DESC limit 100;
    
    ";
    //echo $sql;
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $valido = true;
      foreach ($palabrasReservadas as $p) {
        $cadenaCompleta = "ESTO ES UN SEPARADOR " . $fila['detalle'] . $fila['descripcion'] . $fila['descripcion_detallada'];
        $cadenaCompleta = strtolower($cadenaCompleta);
        $posicion = strpos($cadenaCompleta, $p);
        if ($posicion) {
          $valido = false;
        }
      }

      if($valido){
        $pago = new Pago($fila['id'], $fila['nombre'], "$" . number_format($fila['monto'], 2), $fila['factura'], $fila['id_empresa'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_operacion']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], ($fila['saldo_acreditable']), $fila['banco'], "$" . number_format($fila['saldo'], 2), $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'] . "{" . $fila['referencia'] . "}", $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
        $pago->nombreEmpresa = $fila['razon'];
        $pago->bancoNombreCorto = $fila['nombre_corto_b'];
        $pago->clienteOrigenComisionNombre = $fila['cliente_origen'];
        $pago->fechaAsignacionRaw = $this->fechaComoCadena($fila['fecha_asignacion']);
        array_push($pagos, $pago);
      }

 
    }
    return $pagos;
  }



  public function dameReporteContaBuscado($cliente, $busqueda)
  {
    $palabrasReservadas = array();
    $palabrasReservadas[] = "traspaso";
    $palabrasReservadas[] = "impuesto";
    $palabrasReservadas[] = "sat";
    $palabrasReservadas[] = "sipare";
    $palabrasReservadas[] = "nomina";

    $busquedaNumero = str_replace(',', '', $busqueda);
    $busquedaNumero = str_replace('$', '', $busquedaNumero);
    $busquedaNumero = str_replace(' ', '', $busquedaNumero);
    $busquedaNumero = floatval($busquedaNumero);




    $sql = "
    select empresas.razon, empresas.id as id_empresa, bancos.nombre_corto as nombre_corto_b,clientes.nombre as cliente_origen,pagos.*, captura_edo_cta.referencia, captura_edo_cta.retiro, captura_edo_cta.deposito 
    from pagos 
    left join clientes on (clientes.id=pagos.cliente_origen_comision) 
    left join captura on (captura.id=pagos.id_captura) 
    left join bancos on (bancos.id=captura.nombre_corto) 
    left join facturas on facturas.id_pago = pagos.id
    left join captura_edo_cta on captura_edo_cta.id_captura = pagos.id_captura and (pagos.monto = captura_edo_cta.deposito or pagos.monto = captura_edo_cta.retiro)
    left JOIN empresas ON (empresas.id=captura.razon) 
    where pagos.tipo_movimiento = 'Deposito' and  pagos.nombre='$cliente' and saldo_acreditable<>0 and (pagos.monto = $busquedaNumero or pagos.saldo_acreditable = $busquedaNumero) GROUP by pagos.id order by fecha_asignacion DESC limit 100;
    
    ";
    //echo $sql;
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $valido = true;
      foreach ($palabrasReservadas as $p) {
        $cadenaCompleta = "ESTO ES UN SEPARADOR " . $fila['detalle'] . $fila['descripcion'] . $fila['descripcion_detallada'];
        $cadenaCompleta = strtolower($cadenaCompleta);
        $posicion = strpos($cadenaCompleta, $p);
        if ($posicion) {
          $valido = false;
        }
      }

      if($valido){
        $pago = new Pago($fila['id'], $fila['nombre'], "$" . number_format($fila['monto'], 2), $fila['factura'], $fila['id_empresa'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_operacion']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], ($fila['saldo_acreditable']), $fila['banco'], "$" . number_format($fila['saldo'], 2), $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'] . "{" . $fila['referencia'] . "}", $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
        $pago->nombreEmpresa = $fila['razon'];
        $pago->bancoNombreCorto = $fila['nombre_corto_b'];
        $pago->clienteOrigenComisionNombre = $fila['cliente_origen'];
        $pago->fechaAsignacionRaw = $this->fechaComoCadena($fila['fecha_asignacion']);
        array_push($pagos, $pago);
      }

 
    }
    return $pagos;
  }




  public function dameReporteConta14($fecha, $fecha_mes)
  {
    $sql = "
    select empresas.razon, empresas.id as id_empresa, bancos.nombre_corto as nombre_corto_b,clientes.nombre as cliente_origen,pagos.*, captura_edo_cta.referencia, captura_edo_cta.retiro, captura_edo_cta.deposito, facturas.uuid, facturas.token, facturas.folio, facturas.serie, facturas.total_iva, facturas.id as id_factura_r from pagos 
    left join clientes on (clientes.id=pagos.nombre) 
    left join captura on (captura.id=pagos.id_captura) 
    left join bancos on (bancos.id=captura.nombre_corto) 
    left join captura_edo_cta on captura_edo_cta.id_captura = pagos.id_captura and (pagos.monto = captura_edo_cta.deposito or pagos.monto = captura_edo_cta.retiro) and pagos.saldo = captura_edo_cta.saldo
    LEFT JOIN empresas ON (empresas.id=captura.razon) 
    inner join facturas on facturas.id_pago = pagos.id
    where saldo_acreditable<>0 and fecha_asignacion>='$fecha_mes' and fecha_asignacion<='$fecha' GROUP by pagos.id order by fecha_asignacion DESC limit 1000; ";
    //echo $sql;
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['id_empresa'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_operacion']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], ($fila['saldo_acreditable']), $fila['banco'], "$" . number_format($fila['saldo'], 2), $fila['usuario_registra'], $fila['id_factura_r'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'] . "{" . $fila['referencia'] . "}", $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->nombreEmpresa = $fila['razon'];
      $pago->bancoNombreCorto = $fila['nombre_corto_b'];
      $pago->clienteOrigenComisionNombre = $fila['cliente_origen'];
      $pago->fechaAsignacionRaw = $this->fechaComoCadena($fila['fecha_asignacion']);
      $pago->uuid = $fila['uuid'];
      $pago->token = $fila['token'];
      $pago->folio = $fila['folio'];
      $pago->serie = $fila['serie'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function cuentaPagos()
  {
    $sql = "SELECT COUNT(*) AS total FROM pagos";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['total'];
  }

  public function cuentaPagosAsignados()
  {
    $sql = "SELECT COUNT(*) AS total FROM pagos WHERE nombre != null or nombre != ''";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['total'];
  }

  public function damePagosAsignados()
  {
    $sql = "SELECT pagos.*, empresas.razon, clientes.nombre as nombreC, usuarios.nombre as nombre_asigna FROM `pagos`
    inner join empresas
    on pagos.empresa = empresas.id
    left join clientes 
    on clientes.id = pagos.nombre
    left join usuarios 
    on usuarios.id = pagos.usuario_asigna_fac
    WHERE status ='asignado' and pagos.tipo_movimiento != 'Abono por comisión' and pagos.banco != 'STP' and pagos.banco != '99' group by pagos.id order by id desc limit 500;";

    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['razon'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_operacion']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->fechaAsignacionRaw = $fila['fecha_asignacion'];
      $pago->nombreCliente = $fila['nombreC'];
      $pago->usuario_asigna = $fila['nombre_asigna'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function damePagosReporte()
  {
    $sql = "SELECT pagos.*, empresas.razon, clientes.nombre as nombreC, usuarios.nombre as nombre_asigna, captura.fecha as f_cap, captura.hora as h_cap FROM `pagos`
    inner join empresas
    on pagos.empresa = empresas.id
    left join clientes 
    on clientes.id = pagos.nombre
    left join usuarios 
    on usuarios.id = pagos.usuario_asigna_fac
    left join captura 
    on captura.id = pagos.id_captura
    WHERE pagos.tipo_movimiento != 'Abono por comisión' and pagos.banco != 'STP' and pagos.banco != '99' group by pagos.id order by id desc limit 500;";

    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['razon'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_operacion']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->fechaAsignacionRaw = $fila['fecha_asignacion'];
      $pago->nombreCliente = $fila['nombreC'];
      $pago->usuario_asigna = $fila['nombre_asigna'];
      $pago->fecha_captura = $fila['f_cap'];
      $pago->hora_operacion = $fila['h_cap'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function damePagosAsignadosClienteD()
  {
    $sql = "SELECT pagos.*, empresas.razon, clientes.nombre as nombreC, usuarios.nombre as nombre_asigna FROM `pagos`
    inner join empresas
    on pagos.empresa = empresas.id
    left join clientes 
    on clientes.id = pagos.nombre
    left join usuarios 
    on usuarios.id = pagos.usuario_asigna_fac
    WHERE status ='asignado' and pagos.nombre = 115 and pagos.tipo_movimiento  = 'Retiro'
    and pagos.id not in (select id_retiro from rel_retiro_pago)
    group by pagos.id order by id desc;";

    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['razon'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_operacion']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->fechaAsignacionRaw = $fila['fecha_asignacion'];
      $pago->nombreCliente = $fila['nombreC'];
      $pago->usuario_asigna = $fila['nombre_asigna'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function damePagosAsignadosCliente()
  {
    $sql = "SELECT pagos.*, empresas.razon, clientes.nombre as nombreC, usuarios.nombre as nombre_asigna, sum(rel_retiro_pago.monto) as suma_pagos FROM `pagos`
    inner join empresas
    on pagos.empresa = empresas.id
    left join clientes 
    on clientes.id = pagos.nombre
    left join usuarios 
    on usuarios.id = pagos.usuario_asigna_fac
    left join rel_retiro_pago
    on rel_retiro_pago.id_pago = pagos.id
    WHERE status ='asignado' and pagos.nombre = 115 and pagos.tipo_movimiento  != 'Retiro' group by pagos.id order by suma_pagos desc;";

    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['razon'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_operacion']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->fechaAsignacionRaw = $fila['fecha_asignacion'];
      $pago->nombreCliente = $fila['nombreC'];
      $pago->usuario_asigna = $fila['nombre_asigna'];
      $pago->suma_muerte = $fila['suma_pagos'];

      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function damePagosBuscados($busqueda)
  {
    $busqueda = str_replace(",", "", $busqueda);
    $busqueda = str_replace("$", "", $busqueda);
    $busqueda = str_replace(" ", "", $busqueda);
    $sql = "SELECT pagos.*, empresas.razon, clientes.nombre as nombreC, usuarios.nombre as nombre_asigna FROM `pagos`
    inner join empresas
    on pagos.empresa = empresas.id
    left join clientes 
    on clientes.id = pagos.nombre
     left join usuarios 
    on usuarios.id = pagos.usuario_asigna_fac
    WHERE status ='asignado' and (monto = $busqueda or pagos.id = $busqueda or pagos.id = $busqueda) and pagos.tipo_movimiento != 'Abono por comisión' and pagos.banco != 'STP' and pagos.banco != '99'  order by id desc limit 1000;";
    //echo $sql;


    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['razon'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_operacion']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->fechaAsignacionRaw = $fila['fecha_asignacion'];
      $pago->nombreCliente = $fila['nombreC'];
      $pago->usuario_asigna = $fila['nombre_asigna'];
      
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function damePagosPorMonto($monto)
  {
    $sql = "SELECT pagos.*, empresas.razon, clientes.nombre as nombreC FROM `pagos`
    inner join empresas
    on pagos.empresa = empresas.id
    left join clientes 
    on clientes.id = pagos.nombre
    WHERE monto = $monto and pagos.tipo_movimiento = 'Deposito' order by id asc limit 1000;";
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], ($fila['monto']), $fila['factura'], $fila['razon'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_operacion']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'], $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->fechaAsignacionRaw = $fila['fecha_asignacion'];
      $pago->nombreCliente = $fila['nombreC'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function cuentaPagosSinAsignar()
  {
    $sql = "SELECT COUNT(*) AS total FROM pagos WHERE status <>'asignado' ";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['total'];
  }

  public function damePagosSinAsignar()
  {
    // $sql = "SELECT pagos.*, empresas.razon FROM `pagos`
    // inner join empresas
    // on pagos.empresa = empresas.id
    // WHERE status <>'asignado' order by id desc limit 10000;";


    $sql = "select empresas.razon,bancos.nombre_corto as nombre_corto_b,clientes.nombre as cliente_origen,pagos.*, captura_edo_cta.referencia, captura_edo_cta.retiro, captura_edo_cta.deposito 
    from pagos 
    left join clientes on (clientes.id=pagos.cliente_origen_comision) 
    left join captura on (captura.id=pagos.id_captura) 
    left join bancos on (bancos.id=captura.nombre_corto) 
    left join captura_edo_cta on captura_edo_cta.id_captura = pagos.id_captura and (pagos.monto = captura_edo_cta.deposito or pagos.monto = captura_edo_cta.retiro)
    LEFT JOIN empresas ON (empresas.id=captura.razon) 
    WHERE pagos.nombre = 0 or pagos.nombre = '' or pagos.nombre is null GROUP by pagos.id order by pagos.id desc";

    //echo $sql;
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['razon'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_captura']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'] . "{" . $fila['referencia'] . "}", $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      array_push($pagos, $pago);
    }
    return $pagos;
  }


    public function damePagosSinAsignarNotificarCliente($cliente)
  {
    // $sql = "SELECT pagos.*, empresas.razon FROM `pagos`
    // inner join empresas
    // on pagos.empresa = empresas.id
    // WHERE status <>'asignado' order by id desc limit 10000;";


    $sql = "select * from pagos where nombre = $cliente and notificado_whats = 0";

    //echo $sql;
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['razon'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_captura']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'] . "{" . $fila['referencia'] . "}", $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      array_push($pagos, $pago);
    }
    return $pagos;
  }

  public function marcaNotificado($id)
  {
    $sql = "update pagos set notificado_whats = 1 where id = $id";
    $this->ejecutar($sql);
  }


  public function damePagosConCuenta()
  {
    // $sql = "SELECT pagos.*, empresas.razon FROM `pagos`
    // inner join empresas
    // on pagos.empresa = empresas.id
    // WHERE status <>'asignado' order by id desc limit 10000;";


    $sql = "select empresas.razon,bancos.nombre_corto as nombre_corto_b,clientes.nombre as cliente_origen,pagos.*, captura_edo_cta.referencia, captura_edo_cta.retiro, captura_edo_cta.deposito, sum(relacion_factura_pago.monto_factura - pagos.monto) as restante, count(relacion_factura_pago.id) as folios_contados
    from pagos 
    left join clientes on (clientes.id=pagos.cliente_origen_comision) 
    inner join captura on (captura.id=pagos.id_captura) 
    inner join bancos on (bancos.id=captura.nombre_corto) 
    inner join captura_edo_cta on captura_edo_cta.id_captura = pagos.id_captura and (pagos.monto = captura_edo_cta.deposito or pagos.monto = captura_edo_cta.retiro)
    inner JOIN empresas ON (empresas.id=captura.razon) 
    inner join relacion_factura_pago ON relacion_factura_pago.id_pago = pagos.id
  GROUP by pagos.id order by pagos.id desc limit 1000;";

    //echo $sql;
    $result = $this->ejecutar($sql);
    $pagos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $pago = new Pago($fila['id'], $fila['nombre'], $fila['monto'], $fila['factura'], $fila['razon'], $fila['status'], ($fila['fecha_asignacion']), ($fila['fecha_operacion']), $fila['hora_operacion'], ($fila['fecha_captura']), $fila['tipo_movimiento'], $fila['saldo_acreditable'], $fila['banco'], $fila['saldo'], $fila['usuario_registra'], $fila['id_factura'], ($fila['fecha_banco']), $fila['detalle'], $fila['nombre_corto'], $fila['tipo_captura'], $fila['descripcion'] . "{" . $fila['referencia'] . "}", $fila['descripcion_detallada'], $fila['id_captura'], $fila['cliente_origen_comision'], $fila['origen_traspaso'], $fila['destino_traspaso'], $fila['id_captura_edo_cta'], $fila['tipo_factura'], $fila['notificado']);
      $pago->restante = $fila['restante'];
      $pago->folios_asociados = $fila['folios_contados'];
      array_push($pagos, $pago);
    }
    return $pagos;
  }


  public function dameMovimientosStp()
  {
    $hoy = date('Y-m-d');
    $sql = "SELECT clientes.nombre as cnombre, pre_ejecuta_plantilla.* FROM `pre_ejecuta_plantilla` 
    left join clientes 
    on clientes.id = pre_ejecuta_plantilla.cliente 

    order by id desc limit 500";
    $result = $this->ejecutar($sql);
    $movimientos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $movimiento = new MovimientoStp($fila['id'], $fila['plantilla'], $fila['cnombre'], $fila['nombre'], $fila['tarjeta'], $fila['clabe'], $fila['institucion'], $fila['monto'], $fila['fecha_creacion'], $fila['fecha_ejecucion'], $fila['status'], $fila['status_banxico'], $fila['id_stp'], $fila['folio'], $fila['estado'], $fila['causa_devolucion'], $fila['time_liquidacion'], $fila['status_pre'], $fila['consulta_cep'], $fila['cep'], $fila['espera_liquidacion']);
      $movimiento->status_notificado = $fila['status_notificado'];
      if ($fila['cep'] != null && $fila['cep'] != '') {
        $movimiento->accion = '
        <a href="' . $fila['cep'] . '" target="_blanck"> <div class="circle long">
        <img src="media/banjico.png" alt="..." class="img-thumbnail" style="height: 20px;">
      </div> </a>
        
        ';
      } else {
        $movimiento->accion = 'No Valido';
      }


      array_push($movimientos, $movimiento);
    }
    return $movimientos;
  }

  public function dameMovimientoStp($monto, $fecha, $cliente)
  {
    if ($cliente != 0) {
      $sql = "SELECT clientes.nombre as cnombre, pre_ejecuta_plantilla.* FROM `pre_ejecuta_plantilla` 
      left join clientes 
      on clientes.id = pre_ejecuta_plantilla.cliente where monto = $monto and fecha_creacion like '%$fecha%' and cliente = $cliente order by id desc limit 1000";
    } else {
      $sql = "SELECT clientes.nombre as cnombre, pre_ejecuta_plantilla.* FROM `pre_ejecuta_plantilla` 
      left join clientes 
      on clientes.id = pre_ejecuta_plantilla.cliente where monto = $monto and fecha_creacion like '%$fecha%' order by id desc limit 1000";
    }

    //echo $sql;

    $result = $this->ejecutar($sql);
    $movimientos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $movimiento = new MovimientoStp($fila['id'], $fila['plantilla'], $fila['cnombre'], $fila['nombre'], $fila['tarjeta'], $fila['clabe'], $fila['institucion'], $fila['monto'], $fila['fecha_creacion'], $fila['fecha_ejecucion'], $fila['status'], $fila['status_banxico'], $fila['id_stp'], $fila['folio'], $fila['estado'], $fila['causa_devolucion'], $fila['time_liquidacion'], $fila['status_pre'], $fila['consulta_cep'], $fila['cep'], $fila['espera_liquidacion']);
      $movimiento->status_notificado = $fila['status_notificado'];
      $movimiento->concepto = $fila['concepto'];
      $movimiento->resultadoSTP = $this->consultaStp($fila['folio']);
      if ($this->existeHistorial($fila['folio'])) {
        $movimiento->existeEnHistorial = "Si";
      } else {
        $movimiento->existeEnHistorial = "No";
      }
      if ($fila['cep'] != null && $fila['cep'] != '') {
        $movimiento->accion = '
        <a href="' . $fila['cep'] . '" target="_blanck"> <div class="circle long">
        <img src="media/banjico.png" alt="..." class="img-thumbnail" style="height: 20px;">
      </div> </a>
        
        ';
      } else {
        $movimiento->accion = 'No Valido';
      }
      array_push($movimientos, $movimiento);
    }
    return $movimientos;
  }

  public function existeHistorial($folio)
  {
    $sql = "SELECT * FROM `stp_his_api` where clave_rastreo = '$folio'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    if ($fila['id'] != null) {
      return true;
    } else {
      return false;
    }
  }
  public function consultaStp($folio)
  {


    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => 'http://54.183.68.206/api/consultaOrden.php?folio=' . $folio . '&llave=10hkeySpecial',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    return $response;
  }
}
