<?php

include_once('../../conectorBDS14.php');

class Bitacora
{
  public $id;
  public $usuario;
  public $hora;
  public $fecha;
  public $accion;
  public $monto;
  public $empresa;

  function __construct($id, $usuario, $hora, $fecha, $accion, $monto, $empresa)
  {
    $this->id = $id;
    $this->usuario = $usuario;
    $this->hora = $hora;
    $this->fecha = $fecha;
    $this->accion = $accion;
    $this->monto = $monto;
    $this->empresa = $empresa;
  }
}

class ReporteProd
{
  public $usuario;
  public $entradas;

  function __construct($usuario, $entradas)
  {
    $this->usuario = $usuario;
    $this->entradas = $entradas;
  }
}


class AdminBitacora extends conectorS14
{
  public function fechaComoCadena($fecha)
  {
    $dia = substr($fecha, 8, 2);
    $mes = substr($fecha, 5, 2);
    $anio = substr($fecha, 0, 4);

    switch ($mes) {
      case "01":
        $mes = 'Enero';
        break;
      case "02":
        $mes = 'Febrero';
        break;
      case "03":
        $mes = 'Marzo';
        break;
      case  "04":
        $mes = 'Abril';
        break;
      case "05":
        $mes = 'Mayo';
        break;
      case "06":
        $mes = 'Junio';
        break;
      case "07":
        $mes = 'Julio';
        break;
      case "08":
        $mes = 'Agosto';
        break;
      case "09":
        $mes = 'Septiembre';
        break;
      case "10":
        $mes = 'Octubre';
        break;
      case "11":
        $mes = 'Noviembre';
        break;
      case "12":
        $mes = 'Diciembre';
        break;
      default:
        $mes = "NA";
    }
    return $dia . '/' . $mes . '/' . $anio;
  }
  public function insertaBitacora($usuario_registra, $hora_registra, $fecha_registra, $accion, $monto, $empresa, $cliente, $cliente_destino)
  {

    $sql = 'INSERT INTO bitacora (usuario_registra, hora_registra, fecha_registra, accion, monto, empresa, cliente, cliente_destino) 
    values ("' . $usuario_registra . '","' . $hora_registra . '","' . $fecha_registra . '","' . $accion . '","' . $monto . '","' . $empresa . '","' . $cliente . '","' . $cliente_destino . '");';
    $this->ejecutar($sql);
  }

  public function dameBitacoras()
  {
    $sql = 'SELECT b.id, b.hora_registra, b.fecha_registra, b.accion, b.monto, b.cliente, b.cliente, b.cliente_destino, e.razon, u.nombre FROM bitacora b inner join usuarios u
    on u.id = b.usuario_registra
    inner join empresas e
    on e.id = b.empresa';
    $result = $this->ejecutar($sql);
    $bitacoras = array();
    while ($fila = mysqli_fetch_array($result)) {
      $bitacora = new Bitacora($fila['id'], $fila['nombre'], $fila['hora_registra'], $fila['fecha_registra'], $fila['accion'], $fila['monto'], $fila['razon']);
      array_push($bitacoras, $bitacora);
    }
    return $bitacoras;
  }
  public function dameBitacora($id)
  {
    $sql = 'SELECT b.id, b.hora_registra, b.fecha_registra, b.accion, b.monto, b.cliente, b.cliente, b.cliente_destino, e.razon, u.nombre FROM bitacora b inner join usuarios u
    on u.id = b.usuario_registra
    inner join empresas e
    on e.id = b.empresa where b.id = ' . $id . '';
    $result = $this->ejecutar($sql);
    $bitacoras = array();
    while ($fila = mysqli_fetch_array($result)) {
      $bitacora = new Bitacora($fila['id'], $fila['nombre'], $fila['hora_registra'], $fila['fecha_registra'], $fila['accion'], $fila['monto'], $fila['razon']);
      array_push($bitacoras, $bitacora);
    }
    return $bitacoras;
  }
  public function dameBitacorasPaginacion($pagina)
  {
    $sql = 'SELECT b.id, b.hora_registra, b.fecha_registra, b.accion, b.monto, b.cliente, b.cliente, b.cliente_destino, e.razon, u.nombre, u.email FROM bitacora b inner join usuarios u
    on u.id = b.usuario_registra
    inner join empresas e
    on e.id = b.empresa order by b.id desc LIMIT 20 OFFSET ' . (($pagina - 1) * 20) . '';
    $result = $this->ejecutar($sql);
    $bitacoras = array();
    while ($fila = mysqli_fetch_array($result)) {
      $bitacora = new Bitacora($fila['id'], $fila['nombre'], $fila['hora_registra'], $this->fechaComoCadena($fila['fecha_registra']), $fila['accion'], $fila['monto'], $fila['razon']);
      array_push($bitacoras, $bitacora);
    }
    return $bitacoras;
  }

  public function cuentaBitacoras()
  {
    $sql = 'SELECT count(*) as total FROM bitacora where fecha_registra > DATE_SUB(NOW(), INTERVAL 1 MONTH)';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['total'];
  }

  public function dameReporteProd()
  {
    $cuentaEntradas = 0;
    $sql = 'SELECT u.nombre, count(u.nombre) as movimientos FROM bitacora b inner join usuarios u
    on u.id = b.usuario_registra
    inner join empresas e
    on e.id = b.empresa
    where b.fecha_registra > DATE_SUB(NOW(), INTERVAL 1 MONTH)
    GROUP by u.nombre
    order by movimientos desc limit 5';
    $result = $this->ejecutar($sql);
    $reportes = array();
    while ($fila = mysqli_fetch_array($result)) {
      $reporte = new ReporteProd($fila['nombre'], $fila['movimientos']);
      $cuentaEntradas += $fila['movimientos'];
      array_push($reportes, $reporte);
    }
    array_push($reportes, new ReporteProd("Otros", ($this->cuentaBitacoras() - $cuentaEntradas)));
    return $reportes;
  }
}
