<?php
include_once('../../conectorBDS14.php');


class Banco
{

  public $id;
  public $razon;
  public $banco;
  public $numero_cuenta;
  public $clabe_interbancaria;
  public $nombre_corto;
  public $moneda;
  public $color;
  public $texto;
  public $fecha_inicial;
  public $saldo_inicial;
  public $alerta;
  public $status_banco;
  public $limite_superior;
  public $limite_inferior;
  public $empresaNombre;
  public $botonRuta;

  function __construct($id, $razon, $banco, $numero_cuenta, $clabe_interbancaria, $nombre_corto, $moneda, $color, $texto, $fecha_inicial, $saldo_inicial, $alerta, $status_banco, $limite_superior, $limite_inferior, $empresaNombre)
  {
    $this->id = $id;
    $this->razon = $razon;
    $this->banco = $banco;
    $this->numero_cuenta = $numero_cuenta;
    $this->clabe_interbancaria = $clabe_interbancaria;
    $this->nombre_corto = $nombre_corto;
    $this->moneda = $moneda;
    $this->color = $color;
    $this->texto = $texto;
    $this->fecha_inicial = $fecha_inicial;
    $this->saldo_inicial = $saldo_inicial;
    $this->alerta = $alerta;
    $this->status_banco = $status_banco;
    $this->limite_superior = $limite_superior;
    $this->limite_inferior = $limite_inferior;
    $this->empresaNombre = $empresaNombre;
  }
}

class BancoTop
{
  public $banco;
  public $conteo;

  function __construct($banco, $conteo)
  {
    $this->banco = $banco;
    $this->conteo = $conteo;
  }
}


class AdministradorBanco extends conectorS14
{
  public function nuevoBanco($razon, $banco, $numero_cuenta, $clabe_interbancaria, $nombre_corto, $moneda, $color, $texto, $fecha_inicial, $saldo_inicial, $alerta, $status_banco, $limite_superior, $limite_inferior)
  {
    $sql = 'INSERT INTO bancos (razon, banco, numero_cuenta, clabe_interbancaria, nombre_corto, moneda, color, texto, fecha_inicial, saldo_inicial, alerta, status_banco, limite_superior, limite_inferior) VALUES ("' . $razon . '", "' . $banco . '", "' . $numero_cuenta . '", "' . $clabe_interbancaria . '", "' . $nombre_corto . '", "' . $moneda . '", "' . $color . '", "' . $texto . '", "' . $fecha_inicial . '", "' . $saldo_inicial . '", "' . $alerta . '", "' . $status_banco . '", "' . $limite_superior . '", "' . $limite_inferior . '");';
    $this->ejecutar($sql);
  }

  public function modificarBanco($razon, $banco, $numero_cuenta, $clabe_interbancaria, $nombre_corto, $moneda, $color, $texto, $fecha_inicial, $saldo_inicial, $alerta, $status_banco, $limite_superior, $limite_inferior, $id)
  {
    $sql = 'UPDATE bancos SET razon = "' . $razon . '", banco = "' . $banco . '", numero_cuenta = "' . $numero_cuenta . '", clabe_interbancaria = "' . $clabe_interbancaria . '", nombre_corto = "' . $nombre_corto . '", moneda = "' . $moneda . '", color = "' . $color . '", texto = "' . $texto . '", fecha_inicial = "' . $fecha_inicial . '", saldo_inicial = "' . $saldo_inicial . '", alerta = "' . $alerta . '", status_banco = "' . $status_banco . '", limite_superior = "' . $limite_superior . '", limite_inferior = "' . $limite_inferior . '" WHERE id = ' . $id . ';';
    $this->ejecutar($sql);
  }

  public function dameBancos()
  {
    $sql = 'select e.razon as empresaNombre, b.* from bancos b
    inner join empresas e 
    on e.id  = b.razon ';
    $resultado = $this->ejecutar($sql);
    $bancos = array();
    while ($fila = mysqli_fetch_array($resultado)) {
      switch ($fila['banco']) {
        case "BBVA":
          $color = "color:#7EBEE0;";
          break;
        case "Bancomer":
          $color = "color:#7EBEE0;";
          break;
        case "Bancomer-0":
          $color = "color:#7EBEE0;";
          break;
        case "SANTANDER":
          $color = "color:#E12020;";
          $colorTx = "color:white;";
          break;
        case "Santander":
          $color = "color:#E12020;";
          $colorTx = "color:white;";
          break;
        case "BAJIO":
          $color = "color:#DA69EE;";
          break;
        case "BanBajio-0":
          $color = "color:#DA69EE;";
          break;
        case "BanBajio":
          $color = "color:#DA69EE;";
          break;
        case "MIFEL":
          $color = "color:#070E54;";
          $colorTx = "color:white;";
          break;
        case "Mifel":
          $color = "color:#070E54;";
          $colorTx = "color:white;";
          break;
        case "BASE":
          $color = "color:#D9A608;";
          break;
        case "Base":
          $color = "color:#D9A608;";
          break;
        case "SCOTIABANK":
          $color = "color:#7A0505;";
          $colorTx = "color:white;";
          break;
        case "Banorte":
          $color = "color:#CA7070;";
          break;
      }
      $banco = new Banco($fila['id'], $fila['razon'], "<p style='$color'>" . $fila['banco'] . "</p>", $fila['numero_cuenta'], $fila['clabe_interbancaria'], $fila['nombre_corto'], $fila['moneda'], $fila['color'], $fila['texto'], $fila['fecha_inicial'], $fila['saldo_inicial'], $fila['alerta'], $fila['status_banco'], $fila['limite_superior'], $fila['limite_inferior'], $fila['empresaNombre']);
      $banco->botonRuta = '<a href="cat-bancos-form.php?id=' . $fila['id'] . '"> <div class="circle long">
      <p>Ver</p>
    </div> </a>';
      array_push($bancos, $banco);
    }
    return $bancos;
  }

  public function dameBancosFondeadora()
  {
    $sql = 'select e.razon as empresaNombre, b.* from bancos b
    inner join empresas e 
    on e.id  = b.razon 
    where b.nombre_corto like "%fondeadora%"';
    $resultado = $this->ejecutar($sql);
    $bancos = array();
    while ($fila = mysqli_fetch_array($resultado)) {
   
      $banco = new Banco($fila['id'], $fila['razon'], $fila['banco'], $fila['numero_cuenta'], $fila['clabe_interbancaria'], $fila['nombre_corto'], $fila['moneda'], $fila['color'], $fila['texto'], $fila['fecha_inicial'], $fila['saldo_inicial'], $fila['alerta'], $fila['status_banco'], $fila['limite_superior'], $fila['limite_inferior'], $fila['empresaNombre']);
      array_push($bancos, $banco);
    }
    return $bancos;
  }

  public function dameBancosPorRazon($razon)
  {
    $sql = 'select e.razon as empresaNombre, b.* from bancos b
    inner join empresas e 
    on e.id  = b.razon 
    where b.razon = "' . $razon . '"';
    $resultado = $this->ejecutar($sql);
    $bancos = array();
    while ($fila = mysqli_fetch_array($resultado)) {
      $banco = new Banco($fila['id'], $fila['razon'], $fila['banco'], $fila['numero_cuenta'], $fila['clabe_interbancaria'], $fila['nombre_corto'], $fila['moneda'], $fila['color'], $fila['texto'], $fila['fecha_inicial'], $fila['saldo_inicial'], $fila['alerta'], $fila['status_banco'], $fila['limite_superior'], $fila['limite_inferior'], $fila['empresaNombre']);
      array_push($bancos, $banco);
    }
    return $bancos;
  }

  public function dameBanco($id)
  {
    $sql = 'select e.razon as empresaNombre, b.* from bancos b
    inner join empresas e 
    on e.id  = b.razon 
    where b.id = ' . $id . ';';
    $resultado = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($resultado);
    $banco = new Banco($fila['id'], $fila['razon'], $fila['banco'], $fila['numero_cuenta'], $fila['clabe_interbancaria'], $fila['nombre_corto'], $fila['moneda'], $fila['color'], $fila['texto'], $fila['fecha_inicial'], $fila['saldo_inicial'], $fila['alerta'], $fila['status_banco'], $fila['limite_superior'], $fila['limite_inferior'], $fila['empresaNombre']);
    return $banco;
  }

  public function dameTop5bancos()
  {
    $sql = 'select banco,  count(banco) as conteo from bancos b  group by banco order by conteo desc 
    ;';
    $resultado = $this->ejecutar($sql);
    $bancos = array();
    while ($fila = mysqli_fetch_array($resultado)) {
      $banco = new BancoTop($fila['banco'], $fila['conteo']);
      array_push($bancos, $banco);
    }
    return $bancos;
  }

  public function cuentaBancos()
  {
    $sql = 'select count(*) as total from bancos;';
    $resultado = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($resultado);
    return $fila['total'];
  }
}
